/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.configuration.command;

import com.sap.engine.frame.core.configuration.admin.ConfigurationHandlerFactoryExtension;
import com.sap.engine.frame.core.configuration.admin.Controller;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.configuration.ConfigurationRuntimeInterface;
import com.sap.engine.services.configuration.command.AbstractCommand;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public class CacheCommand
extends AbstractCommand {
    private static final String NAME = "cache";
    private static final String DESCRIPTION = "Shows information about the current cache state";
    private static final String USAGE = "Usage: cache [options]\n\nwhere options include:\n    -l -list     List all currently cached configurations\n    -r -hitrate  the hitrate of the cache in percent\n    -c -clear    clears the cache\n";
    private ConfigurationHandlerFactoryExtension m_factory = this.getConfigurationRuntime().getConfigurationContext();

    public CacheCommand(ConfigurationRuntimeInterface runtime) {
        super(runtime);
    }

    public String getUsage() {
        return USAGE;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public void exec(Environment environment, InputStream input, OutputStream output, String[] params) {
        PrintStream out = new PrintStream(output);
        if (params.length != 1) {
            out.println(this.getUsage());
            return;
        }
        if (params[0].equalsIgnoreCase("-list") || params[0].equalsIgnoreCase("-l")) {
            this.displayCacheList(output);
        } else if (params[0].equalsIgnoreCase("-hitrate") || params[0].equalsIgnoreCase("-r")) {
            this.displayCacheHitRate(output);
        } else if (params[0].equalsIgnoreCase("-clear") || params[0].equalsIgnoreCase("-c")) {
            this.clearCache(output);
        } else {
            out.println(this.getUsage());
        }
    }

    public String getName() {
        return NAME;
    }

    private void displayCacheList(OutputStream os) {
        PrintStream out = new PrintStream(os);
        Controller controller = null;
        try {
            controller = this.m_factory.getConfigurationController();
            String[] cachedConfigs = controller.listCache();
            if (cachedConfigs.length == 0) {
                out.println("Cache is empty");
            }
            out.println();
            out.println("Cached configurations:");
            out.println("**********************");
            int i = 0;
            while (i < cachedConfigs.length) {
                int index = 0;
                String str = cachedConfigs[i];
                while (index != -1) {
                    index = str.indexOf("/");
                    if (index == -1) continue;
                    out.print(" ");
                    str = str.substring(index + 1);
                }
                out.println(cachedConfigs[i]);
                ++i;
            }
            out.println();
            out.println("Number of cached configurations: " + cachedConfigs.length);
            out.println();
        }
        catch (Exception e) {
            this.displayException(out, e);
        }
    }

    private void displayCacheHitRate(OutputStream os) {
        PrintStream out = new PrintStream(os);
        Controller controller = null;
        try {
            controller = this.m_factory.getConfigurationController();
            out.println();
            out.println("Current hitrate: " + controller.getCacheHitRate() + "%");
            out.println();
        }
        catch (Exception e) {
            this.displayException(out, e);
        }
    }

    private void clearCache(OutputStream os) {
        PrintStream out = new PrintStream(os);
        Controller controller = null;
        try {
            controller = this.m_factory.getConfigurationController();
            controller.clearCache();
            out.println();
            out.println("Cache cleared !");
            out.println();
        }
        catch (Exception e) {
            this.displayException(out, e);
        }
    }
}

