/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.configuration.command;

import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.locking.Util;
import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.configuration.ConfigurationRuntimeInterface;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public abstract class AbstractCommand
implements Command {
    protected static final Util UTIL = new Util();
    private static String GROUP = "configuration";
    private ConfigurationRuntimeInterface _configurationRuntimeInterface;

    public AbstractCommand(ConfigurationRuntimeInterface configurationRuntimeInterface) {
        this._configurationRuntimeInterface = configurationRuntimeInterface;
    }

    protected ConfigurationRuntimeInterface getConfigurationRuntime() {
        return this._configurationRuntimeInterface;
    }

    public abstract String getUsage();

    public abstract String getDescription();

    public String getHelpMessage() {
        return "\n" + this.getDescription() + "\n" + this.getUsage();
    }

    public String getGroup() {
        return GROUP;
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }

    protected void displayException(PrintStream out, Exception e) {
        out.println("Error:");
        if (e instanceof ConfigurationException) {
            out.println(e.getMessage());
            out.println("See log for details\n");
        } else {
            out.println(e.getMessage() + "\n");
            e.printStackTrace(out);
            out.println();
        }
    }

    public static String getPrintableValue(Object value) {
        if (value instanceof byte[]) {
            return AbstractCommand.getPrintableText((byte[])value);
        }
        if (value instanceof String) {
            return '\"' + value.toString() + '\"';
        }
        return value.toString();
    }

    public static String getPrintableValueClass(Object value) {
        if (value instanceof byte[]) {
            return "byte[]";
        }
        String classname = value.getClass().getName();
        int index = classname.lastIndexOf(46);
        if (index > 0) {
            return classname.substring(index + 1);
        }
        return classname;
    }

    public static String getPrintableText(byte[] binary) {
        String str = new String(binary);
        if (UTIL.isStringReadable(str)) {
            return str;
        }
        StringBuffer result = new StringBuffer(binary.length * 2 + 2);
        result.append("0x");
        result.append(UTIL.convertByteArrayToString(binary));
        return result.toString();
    }

    public abstract String getName();

    public abstract void exec(Environment var1, InputStream var2, OutputStream var3, String[] var4);
}

