/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.configuration.appconfiguration.impl;

import com.sap.engine.frame.core.configuration.ConfigMetaData;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.InconsistentReadException;
import com.sap.engine.frame.core.configuration.InvalidValueException;
import com.sap.engine.frame.core.configuration.NameAlreadyExistsException;
import com.sap.engine.frame.core.configuration.NameNotFoundException;
import com.sap.engine.frame.core.configuration.NoWriteAccessException;
import com.sap.engine.frame.core.configuration.addons.PropertySheet;
import com.sap.engine.services.configuration.appconfiguration.ApplicationConfigurationHandler;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ConfigurationWrapper
implements Configuration {
    private Configuration m_wrapped;
    private int m_rootPathLength;
    private ApplicationConfigurationHandler m_appHandler;

    public ConfigurationWrapper(Configuration wrapped, int rootPathLength, ApplicationConfigurationHandler appHandler) {
        this.m_wrapped = wrapped;
        this.m_appHandler = appHandler;
        this.m_rootPathLength = rootPathLength;
    }

    public boolean isValid() {
        return this.m_wrapped.isValid();
    }

    public long getId() {
        return this.m_wrapped.getId();
    }

    public String getPath() {
        if (this.m_wrapped.getPath().length() != this.m_rootPathLength) {
            return this.m_wrapped.getPath().substring(this.m_rootPathLength + 1);
        }
        return "";
    }

    public Configuration getOpenRoot() {
        return new ConfigurationWrapper(this.m_wrapped.getOpenRoot(), this.m_rootPathLength, this.m_appHandler);
    }

    public void close() throws ConfigurationException {
        this.m_appHandler.closeConfiguration(this.m_wrapped.getOpenRoot());
    }

    public void setCacheMode(int mode) throws ConfigurationException, NoWriteAccessException {
        this.m_wrapped.setCacheMode(mode);
    }

    public int getCacheMode() throws ConfigurationException {
        return this.m_wrapped.getCacheMode();
    }

    public ConfigMetaData getMetaData() throws ConfigurationException {
        return this.m_wrapped.getMetaData();
    }

    public int getConfigurationType() throws ConfigurationException {
        return this.m_wrapped.getConfigurationType();
    }

    public Configuration createSubConfiguration(String name) throws ConfigurationException, NameAlreadyExistsException, NoWriteAccessException {
        return new ConfigurationWrapper(this.m_wrapped.createSubConfiguration(name), this.m_rootPathLength, this.m_appHandler);
    }

    private Map convertToWrapper(Map map) {
        HashMap result = new HashMap();
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            result.put(entry.getKey(), new ConfigurationWrapper((Configuration)entry.getValue(), this.m_rootPathLength, this.m_appHandler));
        }
        return result;
    }

    public Map createSubConfigurations(String[] names) throws ConfigurationException, NameAlreadyExistsException, NoWriteAccessException {
        return this.convertToWrapper(this.m_wrapped.createSubConfigurations(names));
    }

    public Configuration createSubConfiguration(String name, int type) throws ConfigurationException, NameAlreadyExistsException, NoWriteAccessException {
        return new ConfigurationWrapper(this.m_wrapped.createSubConfiguration(name, type), this.m_rootPathLength, this.m_appHandler);
    }

    public Map createSubConfigurations(String[] names, int type) throws ConfigurationException, NameAlreadyExistsException, NoWriteAccessException {
        return this.convertToWrapper(this.m_wrapped.createSubConfigurations(names, type));
    }

    public Configuration createSubConfigurationHierachy(String relPath) throws ConfigurationException, NoWriteAccessException {
        return new ConfigurationWrapper(this.m_wrapped.createSubConfigurationHierachy(relPath), this.m_rootPathLength, this.m_appHandler);
    }

    public boolean existsSubConfiguration(String name) throws ConfigurationException, InconsistentReadException {
        return this.m_wrapped.existsSubConfiguration(name);
    }

    public Configuration getSubConfiguration(String relativePath) throws ConfigurationException, NameNotFoundException, InconsistentReadException {
        return new ConfigurationWrapper(this.m_wrapped.getSubConfiguration(relativePath), this.m_rootPathLength, this.m_appHandler);
    }

    public Map getSubConfigurations(String[] names) throws ConfigurationException, NameNotFoundException, InconsistentReadException {
        return this.convertToWrapper(this.m_wrapped.getSubConfigurations(names));
    }

    public Map getAllSubConfigurations() throws ConfigurationException, InconsistentReadException {
        return this.convertToWrapper(this.m_wrapped.getAllSubConfigurations());
    }

    public String[] getAllSubConfigurationNames() throws ConfigurationException, InconsistentReadException {
        return this.m_wrapped.getAllSubConfigurationNames();
    }

    public ConfigMetaData[] getAllSubConfigurationMetaData() throws ConfigurationException, InconsistentReadException {
        return this.m_wrapped.getAllSubConfigurationMetaData();
    }

    public void deleteConfiguration(String name) throws ConfigurationException, NameNotFoundException, NoWriteAccessException {
        this.m_wrapped.deleteConfiguration(name);
    }

    public void deleteConfiguration() throws ConfigurationException, NoWriteAccessException {
        this.m_wrapped.deleteConfiguration();
    }

    public void deleteSubConfigurations(String[] names) throws ConfigurationException, NoWriteAccessException {
        this.m_wrapped.deleteSubConfigurations(names);
    }

    public void deleteAllSubConfigurations() throws ConfigurationException, NoWriteAccessException {
        this.m_wrapped.deleteAllSubConfigurations();
    }

    public void addConfigEntry(String name, Object value) throws ConfigurationException, NameAlreadyExistsException, NoWriteAccessException, InvalidValueException {
        this.m_wrapped.addConfigEntry(name, value);
    }

    public void addConfigEntries(Map list) throws ConfigurationException, NameAlreadyExistsException, NoWriteAccessException, InvalidValueException {
        this.m_wrapped.addConfigEntries(list);
    }

    public boolean existsConfigEntry(String name) throws ConfigurationException, InconsistentReadException {
        return this.m_wrapped.existsConfigEntry(name);
    }

    public void modifyConfigEntry(String name, Object value) throws ConfigurationException, NameNotFoundException, NoWriteAccessException, InvalidValueException {
        this.m_wrapped.modifyConfigEntry(name, value);
    }

    public void modifyConfigEntry(String name, Object value, boolean createIfNotExist) throws ConfigurationException, NameNotFoundException, NoWriteAccessException, InvalidValueException {
        this.m_wrapped.modifyConfigEntry(name, value, createIfNotExist);
    }

    public void modifyConfigEntries(Map list) throws ConfigurationException, NoWriteAccessException, InvalidValueException {
        this.m_wrapped.modifyConfigEntries(list);
    }

    public Object getConfigEntry(String name) throws ConfigurationException, NameNotFoundException, InconsistentReadException {
        return this.m_wrapped.getConfigEntry(name);
    }

    public Map getConfigEntries(String[] names) throws ConfigurationException, InconsistentReadException {
        return this.m_wrapped.getConfigEntries(names);
    }

    public Map getAllConfigEntries() throws ConfigurationException, InconsistentReadException {
        return this.m_wrapped.getAllConfigEntries();
    }

    public String[] getAllConfigEntryNames() throws ConfigurationException, InconsistentReadException {
        return this.m_wrapped.getAllConfigEntryNames();
    }

    public void deleteConfigEntry(String name) throws ConfigurationException, NameNotFoundException, NoWriteAccessException {
        this.m_wrapped.deleteConfigEntry(name);
    }

    public void deleteConfigEntries(String[] names) throws ConfigurationException, NoWriteAccessException {
        this.m_wrapped.deleteConfigEntries(names);
    }

    public void deleteAllConfigEntries() throws ConfigurationException, NoWriteAccessException {
        this.m_wrapped.deleteAllConfigEntries();
    }

    public void addFileAsStream(String name, InputStream stream) throws ConfigurationException, NameAlreadyExistsException, NoWriteAccessException {
        this.m_wrapped.addFileAsStream(name, stream);
    }

    public void addFileEntryByKey(String key, File file) throws ConfigurationException, NameAlreadyExistsException, NoWriteAccessException {
        this.m_wrapped.addFileEntryByKey(key, file);
    }

    public void addFileEntry(File file) throws ConfigurationException, NameAlreadyExistsException, NoWriteAccessException {
        this.m_wrapped.addFileEntry(file);
    }

    public void addFileEntries(File[] list) throws ConfigurationException, NameAlreadyExistsException, NoWriteAccessException {
        this.m_wrapped.addFileEntries(list);
    }

    public void addFileEntriesByKey(Map list) throws ConfigurationException, NameAlreadyExistsException, NoWriteAccessException {
        this.m_wrapped.addFileEntriesByKey(list);
    }

    public void updateFile(File file) throws ConfigurationException, NameNotFoundException, NoWriteAccessException {
        this.m_wrapped.updateFile(file);
    }

    public void updateFile(File file, boolean createIfNotExist) throws ConfigurationException, NameNotFoundException, NoWriteAccessException {
        this.m_wrapped.updateFile(file, createIfNotExist);
    }

    public void updateFileByKey(String key, File file) throws ConfigurationException, NameNotFoundException, NoWriteAccessException {
        this.m_wrapped.updateFileByKey(key, file);
    }

    public void updateFileByKey(String key, File file, boolean createIfNotExist) throws ConfigurationException, NoWriteAccessException {
        this.m_wrapped.updateFileByKey(key, file, createIfNotExist);
    }

    public boolean existsFile(String name) throws ConfigurationException, InconsistentReadException {
        return this.m_wrapped.existsFile(name);
    }

    public void updateFileAsStream(String name, InputStream stream) throws ConfigurationException, NameNotFoundException, NoWriteAccessException {
        this.m_wrapped.updateFileAsStream(name, stream);
    }

    public void updateFileAsStream(String name, InputStream stream, boolean createIfNotExist) throws ConfigurationException, NameNotFoundException, NoWriteAccessException {
        this.m_wrapped.updateFileAsStream(name, stream, createIfNotExist);
    }

    public void updateFiles(File[] files) throws ConfigurationException, NoWriteAccessException {
        this.m_wrapped.updateFiles(files);
    }

    public void updateFilesByKey(Map list) throws ConfigurationException, NoWriteAccessException {
        this.m_wrapped.updateFilesByKey(list);
    }

    public InputStream getFile(String name) throws ConfigurationException, NameNotFoundException, InconsistentReadException {
        return this.m_wrapped.getFile(name);
    }

    public Map getFileEntries(String[] names) throws ConfigurationException, NameNotFoundException, InconsistentReadException {
        return this.m_wrapped.getFileEntries(names);
    }

    public String[] getAllFileEntryNames() throws ConfigurationException, InconsistentReadException {
        return this.m_wrapped.getAllFileEntryNames();
    }

    public Map getAllFileEntries() throws ConfigurationException, InconsistentReadException {
        return this.m_wrapped.getAllFileEntries();
    }

    public void deleteFile(String file) throws ConfigurationException, NameNotFoundException, NoWriteAccessException {
        this.m_wrapped.deleteFile(file);
    }

    public void deleteFiles(String[] files) throws ConfigurationException, NoWriteAccessException {
        this.m_wrapped.deleteFiles(files);
    }

    public void deleteAllFiles() throws ConfigurationException, NoWriteAccessException {
        this.m_wrapped.deleteAllFiles();
    }

    public PropertySheet getPropertySheetInterface() throws ConfigurationException {
        return this.m_wrapped.getPropertySheetInterface();
    }

    public String toString() {
        return this.getPath();
    }

    public Configuration getWrapped() {
        return this.m_wrapped;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ConfigurationWrapper) {
            return this.m_wrapped.equals(((ConfigurationWrapper)obj).m_wrapped);
        }
        return false;
    }

    public int hashCode() {
        return this.m_wrapped.hashCode();
    }

    public void export(String destinationPath) throws InconsistentReadException, ConfigurationException {
        this.m_wrapped.export(destinationPath);
    }

    public void importAsSubConfiguration(String sourcePath) throws NoWriteAccessException, NameAlreadyExistsException, ConfigurationException {
        this.m_wrapped.importAsSubConfiguration(sourcePath);
    }

    public void importContent(String sourcePath) throws NoWriteAccessException, NameAlreadyExistsException, ConfigurationException {
        this.m_wrapped.importContent(sourcePath);
    }
}

