/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.configuration.appconfiguration.impl;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationChangedListener;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.services.configuration.appconfiguration.ApplicationConfigurationHandler;
import com.sap.engine.services.configuration.appconfiguration.impl.ApplicationConfigHandlerFactoryImpl;
import com.sap.engine.services.configuration.appconfiguration.impl.ConfigurationWrapper;
import java.util.AbstractCollection;
import java.util.HashSet;

public class ApplicationConfigurationHandlerImpl
implements ApplicationConfigurationHandler {
    private String m_configPath;
    private String m_appContext;
    private ConfigurationHandler m_handler;
    private HashSet m_openConfigs = new HashSet();
    private ApplicationConfigHandlerFactoryImpl m_appFactory;
    private int m_configPathLength;

    public ApplicationConfigurationHandlerImpl(ApplicationConfigHandlerFactoryImpl appFactory) throws ConfigurationException {
        this.m_appFactory = appFactory;
        this.m_appContext = this.m_appFactory.getApplicationContext();
        this.m_configPath = this.m_appFactory.getAppConfigPath(this.m_appContext);
        this.m_configPathLength = this.m_configPath.length();
        this.m_handler = this.m_appFactory.getCoreConfigurationContext().getConfigurationHandler();
    }

    public synchronized Configuration openRootConfiguration(int accessMode) throws ConfigurationException {
        Configuration cfg = this.m_handler.openConfiguration(this.m_configPath, accessMode);
        this.m_appFactory.registerOpenedConfiguration(cfg, this.m_appContext);
        this.m_openConfigs.add(cfg);
        return new ConfigurationWrapper(cfg, this.m_configPathLength, this);
    }

    public synchronized Configuration openSubConfiguration(String path, int accessMode) throws ConfigurationException {
        Configuration cfg = this.m_handler.openConfiguration(this.m_configPath + "/" + path, accessMode);
        this.m_appFactory.registerOpenedConfiguration(cfg, this.m_appContext);
        this.m_openConfigs.add(cfg);
        return new ConfigurationWrapper(cfg, this.m_configPathLength, this);
    }

    public void commit() throws ConfigurationException {
        this.m_handler.commit();
    }

    public void rollback() throws ConfigurationException {
        this.m_handler.rollback();
    }

    public synchronized void closeAllConfigurations() throws ConfigurationException {
        Configuration[] allOpen = ((AbstractCollection)this.m_openConfigs).toArray(new Configuration[0]);
        int i = 0;
        while (i < allOpen.length) {
            this.m_handler.closeConfiguration(allOpen[i]);
            this.m_appFactory.unRegisterOpenedConfiguration(allOpen[i], this.m_appContext);
            this.m_openConfigs.remove(allOpen[i]);
            ++i;
        }
    }

    public synchronized void closeConfiguration(Configuration c) throws ConfigurationException {
        Configuration cfg = c;
        if (c instanceof ConfigurationWrapper) {
            cfg = ((ConfigurationWrapper)c).getWrapped();
        }
        this.m_handler.closeConfiguration(cfg);
        this.m_appFactory.unRegisterOpenedConfiguration(cfg, this.m_appContext);
        this.m_openConfigs.remove(cfg);
    }

    public void addConfigurationChangedListener(ConfigurationChangedListener l, String path) {
        this.m_appFactory.addConfigurationChangedListener(l, path, this.m_appContext);
    }

    public void removeConfigurationChangedListener(ConfigurationChangedListener l, String path) {
        this.m_appFactory.removeConfigurationChangedListener(l, path, this.m_appContext);
    }
}

