/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.configuration;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.ApplicationServiceFrame;
import com.sap.engine.frame.CommunicationServiceContext;
import com.sap.engine.frame.CommunicationServiceFrame;
import com.sap.engine.frame.ServiceContext;
import com.sap.engine.frame.ServiceException;
import com.sap.engine.frame.ServiceRuntimeException;
import com.sap.engine.frame.container.event.ContainerEventListener;
import com.sap.engine.frame.container.registry.ObjectRegistry;
import com.sap.engine.frame.core.configuration.ConfigurationContext;
import com.sap.engine.frame.core.locking.Util;
import com.sap.engine.frame.state.ManagementInterface;
import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.ShellInterface;
import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.engine.services.configuration.ConfigurationRuntimeInterface;
import com.sap.engine.services.configuration.ConfigurationRuntimeInterfaceImpl;
import com.sap.engine.services.configuration.appconfiguration.impl.ApplicationConfigHandlerFactoryImpl;
import com.sap.engine.services.configuration.command.CacheCommand;
import com.sap.engine.services.configuration.command.CallTraceCommand;
import com.sap.engine.services.configuration.command.ConfigurationStatisticCommand;
import com.sap.engine.services.configuration.command.GetConfigFileCommand;
import com.sap.engine.services.configuration.command.GetConfigValueCommand;
import com.sap.engine.services.configuration.command.InternalLocksCommand;
import com.sap.engine.services.configuration.command.ListConfigCommand;
import com.sap.engine.services.configuration.command.MonitorEventCommand;
import com.sap.engine.services.configuration.command.OpenConfigsCommand;
import com.sap.engine.services.configuration.command.StorageStatisticsCommand;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.InitialContext;

public class ConfigurationApplicationFrame
implements CommunicationServiceFrame,
ApplicationServiceFrame,
ContainerEventListener {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$configuration$ConfigurationApplicationFrame == null ? (class$com$sap$engine$services$configuration$ConfigurationApplicationFrame = ConfigurationApplicationFrame.class$("com.sap.engine.services.configuration.ConfigurationApplicationFrame")) : class$com$sap$engine$services$configuration$ConfigurationApplicationFrame));
    private static final Category CATEGORY = LoggingHelper.SYS_SERVER;
    private static final String OWN_NAME = "configuration-service";
    private static final String PROPERTY_TRACELEVEL = "tracelevel";
    private static final Util UTIL = new Util();
    private ServiceContext _serviceContext;
    private ObjectRegistry _objectRegistry;
    private ConfigurationRuntimeInterface _configurationRuntimeInterface;
    private ShellInterface _shellInterface;
    private int _commandId;
    static /* synthetic */ Class class$com$sap$engine$services$configuration$ConfigurationApplicationFrame;

    public ConfigurationRuntimeInterface getRuntimeInterface() {
        return this._configurationRuntimeInterface;
    }

    public void start(CommunicationServiceContext serviceContext) throws ServiceException {
        String METHOD = "<init>(communicationServiceContext)";
        this._serviceContext = serviceContext;
        try {
            this._objectRegistry = serviceContext.getContainerContext().getObjectRegistry();
            ConfigurationContext configurationContext = (ConfigurationContext)this._serviceContext.getCoreContext().getConfigurationHandlerFactory();
            this._configurationRuntimeInterface = new ConfigurationRuntimeInterfaceImpl(configurationContext);
            this.startIndependent();
        }
        catch (Exception e) {
            CATEGORY.fatalT(LOCATION, METHOD, "Can not start {0}. Can not initialize environment. See stacktrace for details.", new Object[]{OWN_NAME});
            LoggingHelper.logThrowable((int)500, (Category)CATEGORY, (Location)LOCATION, (String)METHOD, (Throwable)e);
            try {
                this.stop();
            }
            catch (Exception x) {
                // empty catch block
            }
            throw new ServiceException("kernel_6000", new Object[]{OWN_NAME}, null);
        }
    }

    public void start(ApplicationServiceContext serviceContext) throws ServiceException {
        String METHOD = "<init>(applicationServiceContext)";
        this._serviceContext = serviceContext;
        try {
            this._objectRegistry = serviceContext.getContainerContext().getObjectRegistry();
            ConfigurationContext configurationContext = (ConfigurationContext)this._serviceContext.getCoreContext().getConfigurationHandlerFactory();
            this._configurationRuntimeInterface = new ConfigurationRuntimeInterfaceImpl(configurationContext);
            ApplicationConfigHandlerFactoryImpl appconfig = new ApplicationConfigHandlerFactoryImpl(configurationContext, serviceContext);
            try {
                new InitialContext().unbind("ApplicationConfiguration");
            }
            catch (Exception e) {
                // empty catch block
            }
            new InitialContext().bind("ApplicationConfiguration", (Object)appconfig);
            this.startIndependent();
        }
        catch (Exception e) {
            CATEGORY.fatalT(LOCATION, METHOD, "Can not start {0}. Can not initialize environment. See stacktrace for details.", new Object[]{OWN_NAME});
            LoggingHelper.logThrowable((int)500, (Category)CATEGORY, (Location)LOCATION, (String)METHOD, (Throwable)e);
            try {
                this.stop();
            }
            catch (Exception x) {
                // empty catch block
            }
            throw new ServiceException("kernel_6000", new Object[]{OWN_NAME}, null);
        }
    }

    public void stop() {
        String METHOD = "stop()";
        try {
            LOCATION.pathT(METHOD, "begin");
            this._objectRegistry.unregisterInterface();
            this._serviceContext.getServiceState().unregisterContainerEventListener();
            this.unsetShellInterface();
            LOCATION.pathT(METHOD, "success");
        }
        catch (Exception e) {
            CATEGORY.errorT(LOCATION, METHOD, "Can not cleanup {0} correctly when trying to stop it. See stacktrace for details.", new Object[]{OWN_NAME});
            LoggingHelper.logThrowable((int)500, (Category)CATEGORY, (Location)LOCATION, (String)METHOD, (Throwable)e);
            throw new ServiceRuntimeException("kernel_6050", new Object[]{OWN_NAME}, null);
        }
        CATEGORY.infoT(LOCATION, METHOD, "{0} stopped successfully", new Object[]{OWN_NAME});
    }

    public void containerStarted() {
    }

    public void beginContainerStop() {
    }

    public void serviceStarted(String serviceName, Object serviceInterface) {
    }

    public void serviceNotStarted(String serviceName) {
    }

    public void beginServiceStop(String serviceName) {
    }

    public void serviceStopped(String serviceName) {
    }

    public boolean setServiceProperty(String key, String value) {
        Properties currentProperties = this._serviceContext.getServiceState().getProperties();
        Properties properties = (Properties)((Hashtable)currentProperties).clone();
        ((Hashtable)properties).put(key, value);
        return this.parseProperties(properties);
    }

    public boolean setServiceProperties(Properties serviceProperties) {
        return this.parseProperties(serviceProperties);
    }

    public void interfaceAvailable(String interfaceName, Object interfaceImpl) {
        if (interfaceName.equals("shell")) {
            this.setShellInterface((ShellInterface)interfaceImpl);
        }
    }

    public void interfaceNotAvailable(String interfaceName) {
        if (interfaceName.equals("shell")) {
            this.unsetShellInterface();
        }
    }

    public void markForShutdown(long timeout) {
    }

    private void setShellInterface(ShellInterface shellInterface) {
        this._shellInterface = shellInterface;
        Command[] shellcommands = new Command[]{new ListConfigCommand(this._configurationRuntimeInterface), new GetConfigValueCommand(this._configurationRuntimeInterface), new GetConfigFileCommand(this._configurationRuntimeInterface), new OpenConfigsCommand(this._configurationRuntimeInterface), new InternalLocksCommand(this._configurationRuntimeInterface), new CacheCommand(this._configurationRuntimeInterface), new StorageStatisticsCommand(this._configurationRuntimeInterface), new MonitorEventCommand(this._configurationRuntimeInterface), new ConfigurationStatisticCommand(this._configurationRuntimeInterface), new CallTraceCommand(this._configurationRuntimeInterface)};
        this._commandId = this._shellInterface.registerCommands(shellcommands);
    }

    private void unsetShellInterface() {
        if (this._shellInterface != null) {
            this._shellInterface.unregisterCommands(this._commandId);
        }
        this._shellInterface = null;
    }

    private boolean parseProperties(Properties properties) throws IllegalArgumentException {
        boolean propertiesActiveWithoutRestart = true;
        return propertiesActiveWithoutRestart;
    }

    private void startIndependent() throws Exception {
        String METHOD = "startIndependent()";
        LOCATION.pathT(METHOD, "begin");
        Properties properties = this._serviceContext.getServiceState().getProperties();
        this.parseProperties(properties);
        int mask = 192;
        HashSet<String> names = new HashSet<String>(1);
        names.add("shell");
        this._serviceContext.getServiceState().registerContainerEventListener(mask, names, (ContainerEventListener)this);
        this._objectRegistry.registerInterface((Object)this._configurationRuntimeInterface);
        this._serviceContext.getServiceState().registerManagementInterface((ManagementInterface)this._configurationRuntimeInterface);
        LOCATION.pathT(METHOD, "registered in server");
        CATEGORY.infoT(LOCATION, METHOD, "{0} started successfully", new Object[]{OWN_NAME});
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

