/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.ejb.wizard.internal.pages;

import com.tssap.j2ee.ui.ejb.components.IEjbMetaData;
import com.tssap.j2ee.ui.ejb.util.EjbUtil;
import com.tssap.j2ee.util.core.StringUtils;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import org.eclipse.jdt.core.IPackageFragment;

public abstract class EjbWizardUtil {
    private static final TracerI TRACER = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$ejb$wizard$internal$pages$EjbWizardUtil == null ? (class$com$tssap$j2ee$ui$ejb$wizard$internal$pages$EjbWizardUtil = EjbWizardUtil.class$("com.tssap.j2ee.ui.ejb.wizard.internal.pages.EjbWizardUtil")) : class$com$tssap$j2ee$ui$ejb$wizard$internal$pages$EjbWizardUtil));
    private static final String BEAN = "Bean";
    private static final String HOME = "Home";
    private static final String LOCAL = "Local";
    private static final String LOCALHOME = "LocalHome";
    static /* synthetic */ Class class$com$tssap$j2ee$ui$ejb$wizard$internal$pages$EjbWizardUtil;

    public static final void createDefaultEntries(IEjbMetaData ejbData, boolean withClassname, boolean component, boolean local) {
        EjbWizardUtil.createDefaultEntries(ejbData, withClassname, true, component, local);
    }

    public static final void createDefaultEntries(IEjbMetaData ejbData, boolean withClassname, boolean beanClass, boolean component, boolean local) {
        String ejbName = ejbData.getDefaultEjbName();
        if (ejbName == null || ejbName.equals("")) {
            return;
        }
        ejbName = EjbWizardUtil.generatePureEjbDefaultname(ejbName);
        IPackageFragment fragment = ejbData.getBeanPackage();
        String beanName = "";
        String remoteName = "";
        String homeName = "";
        String localName = "";
        String localHomeName = "";
        if (fragment != null && !fragment.getElementName().equals("")) {
            remoteName = beanName = fragment.getElementName();
            homeName = beanName;
            localName = beanName;
            localHomeName = beanName;
            if (withClassname) {
                beanName = EjbWizardUtil.generateFQN(beanName, ejbName, BEAN, false);
                remoteName = EjbWizardUtil.generateFQN(remoteName, ejbName, "", false);
                homeName = EjbWizardUtil.generateFQN(homeName, ejbName, HOME, false);
                localName = EjbWizardUtil.generateFQN(localName, ejbName, LOCAL, false);
                localHomeName = EjbWizardUtil.generateFQN(localHomeName, ejbName, LOCALHOME, false);
            }
        } else if (ejbData.getBeanclassName() != null && ejbData.getBeanclassName().indexOf(".") > 0 && !ejbData.getBeanclassName().endsWith(".java")) {
            String pkg = "";
            try {
                pkg = (String)StringUtils.ClassWithPathString((String)ejbData.getBeanclassName(), (boolean)false).get(StringUtils.PACKAGEPATH);
            }
            catch (Exception e) {
                TRACER.warning("Not able to retrieve package name", (Throwable)e);
            }
            beanName = EjbWizardUtil.generateFQN(pkg, ejbName, BEAN, false);
            remoteName = EjbWizardUtil.generateFQN(pkg, ejbName, "", false);
            homeName = EjbWizardUtil.generateFQN(pkg, ejbName, HOME, false);
            localName = EjbWizardUtil.generateFQN(pkg, ejbName, LOCAL, false);
            localHomeName = EjbWizardUtil.generateFQN(pkg, ejbName, LOCALHOME, false);
        } else {
            beanName = EjbWizardUtil.generateFQN("", ejbName, BEAN, false);
            remoteName = EjbWizardUtil.generateFQN("", ejbName, "", false);
            homeName = EjbWizardUtil.generateFQN("", ejbName, HOME, false);
            localName = EjbWizardUtil.generateFQN("", ejbName, LOCAL, false);
            localHomeName = EjbWizardUtil.generateFQN("", ejbName, LOCALHOME, false);
        }
        if (beanClass) {
            ejbData.setBeanclassName(beanName);
            ejbData.setBeanPackage(fragment);
        }
        if (ejbData.getEjbType() != 3 && component) {
            EjbWizardUtil.setComponentDefaultEntries(ejbData, remoteName, homeName, fragment);
        }
        if (ejbData.getEjbType() != 3 && ejbData.getEjbCompliance() == 1 && local) {
            EjbWizardUtil.setLocalDefaultEntries(ejbData, localName, localHomeName, fragment);
        }
    }

    private static final void setComponentDefaultEntries(IEjbMetaData ejbData, String remote, String home, IPackageFragment fragment) {
        ejbData.setRemoteIFName(remote);
        ejbData.setHomeIFName(home);
        ejbData.setRemoteIFPackage(fragment);
        ejbData.setHomeIFPackage(fragment);
    }

    private static final void setLocalDefaultEntries(IEjbMetaData ejbData, String local, String localHome, IPackageFragment fragment) {
        ejbData.setLocalIFName(local);
        ejbData.setLocalHomeIFName(localHome);
        ejbData.setLocalIFPackage(fragment);
        ejbData.setLocalHomeIFPackage(fragment);
    }

    public static final boolean isEjbNameUnique(IEjbMetaData ejbData) throws Exception {
        String ejbFQN = StringUtils.removeExtension((String)ejbData.getBeanclassName(), (boolean)true);
        return !EjbUtil.doesEjbAlreadyExists(ejbFQN, ejbData.getEjbProjectName());
    }

    private static final String generateFQN(String baseString, String ejbName, String nameExt, boolean withExtension) {
        String withoutExt = null;
        if (!baseString.equals("") && !baseString.endsWith(".")) {
            baseString = baseString + ".";
        }
        withoutExt = nameExt.equals(LOCALHOME) ? baseString + ejbName + LOCALHOME : (nameExt.equals(LOCAL) ? baseString + ejbName + nameExt : baseString + ejbName + nameExt);
        if (withExtension) {
            withoutExt = withoutExt + ".java";
        }
        return withoutExt;
    }

    public static final String generatePureEjbDefaultname(String ejbName) {
        String newName = new String(ejbName);
        if (ejbName.indexOf("java") >= 0) {
            newName = StringUtils.removeExtension((String)ejbName, (boolean)false);
        }
        if (ejbName.endsWith(BEAN)) {
            newName = ejbName.substring(0, ejbName.lastIndexOf(BEAN));
        }
        return newName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

