/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.ejb.wizard.internal.pages;

import com.tssap.j2ee.ui.ejb.model.EjbSourceUtil;
import com.tssap.j2ee.ui.ejb.model.IEjbSourceResolver;
import com.tssap.j2ee.ui.ejb.wizard.internal.pages.EjbResolvePage;
import org.eclipse.jdt.core.IType;

public class EjbResolveIFsPage
extends EjbResolvePage {
    private static final String DEFAULT_TITLE = "Resolve Interfaces";
    private static final String QUALIFIED_TITLE_PREFIX = "Resolve Interfaces for ";

    public EjbResolveIFsPage(IEjbSourceResolver sourceResolver) {
        super(DEFAULT_TITLE, sourceResolver);
        this.setTitle(DEFAULT_TITLE);
        this.setDescription("Choose interfaces for Enterprise Java Bean.");
    }

    protected int getProviderType() {
        return 6;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            String beanName;
            if (this.getPreviousPage() != null) {
                this.getPreviousPage().setVisible(false);
            }
            if (this.getEjbMetaData() != null && (beanName = this.getEjbMetaData().getBeanclassName()) != null && beanName.length() > 0) {
                this.setTitle(QUALIFIED_TITLE_PREFIX + beanName);
            }
            if (this.getTreeViewer() != null) {
                this.getTreeViewer().clearSelection();
                this.getTreeViewer().toggleElements((Object[])this.getPreSelectedTypes());
            }
        } else if (this.getSourceResolver() != null) {
            IType[] remoteIFTypes;
            IType[] localHomeIFTypes;
            IType[] localIFTypes;
            IType[] types = this.getCheckedTypes();
            IType[] homeIFTypes = EjbSourceUtil.getHomeInterfaces(types, this.getSourceResolver(), null);
            if (homeIFTypes != null && homeIFTypes.length > 0) {
                this.getEjbMetaData().setHomeIFName(homeIFTypes[0].getFullyQualifiedName());
            }
            if ((localIFTypes = EjbSourceUtil.getLocalInterfaces(types, this.getSourceResolver(), null)) != null && localIFTypes.length > 0) {
                this.getEjbMetaData().setLocalIFName(localIFTypes[0].getFullyQualifiedName());
            }
            if ((localHomeIFTypes = EjbSourceUtil.getLocalHomeInterfaces(types, this.getSourceResolver(), null)) != null && localHomeIFTypes.length > 0) {
                this.getEjbMetaData().setLocalHomeIFName(localHomeIFTypes[0].getFullyQualifiedName());
            }
            if ((remoteIFTypes = EjbSourceUtil.getRemoteInterfaces(types, this.getSourceResolver(), null)) != null && remoteIFTypes.length > 0) {
                this.getEjbMetaData().setRemoteIFName(remoteIFTypes[0].getFullyQualifiedName());
            }
        }
        super.setVisible(visible);
    }

    protected IType[] getPreSelectedTypes() {
        IType[] ret = this.getSourceResolver().getPossibleRelatedIFByNamingConvention(this.getEjbMetaData().getBeanclassName());
        if (ret == null || ret.length <= 0) {
            ret = super.getPreSelectedTypes();
        }
        return ret;
    }
}

