/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.ejb.wizard.internal.pages;

import com.tssap.j2ee.ui.ejb.model.IEjbSourceResolver;
import com.tssap.j2ee.ui.ejb.wizard.internal.pages.EjbResolvePage;
import org.eclipse.jdt.core.IType;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;

public class EjbResolveClassPage
extends EjbResolvePage {
    private static final String TITLE = "Resolve Bean Class";
    private static final String DESCRIPTION = "Choose class for Enterprise Java Bean.";
    private static final String DESCRIPTION_NO_BEANS_AVAILABLE = "No classes for corrupted Enterprise Java Beans available.";
    private static final String MESSAGE = "Please choose bean class.";
    private static final String MESSAGE_NO_BEANS_AVAILABLE = "No classes for corrupted EJBs available.";
    private SelectionListener treeSelectionListener;

    public EjbResolveClassPage(IEjbSourceResolver sourceResolver) {
        super(TITLE, sourceResolver);
        this.setTitle(TITLE);
        this.updateMessageAndDescription();
    }

    public boolean isPageComplete() {
        boolean ret = super.isPageComplete();
        if (ret) {
            ret = false;
            IType type = this.getFirstCheckedType();
            ret = type != null && this.getSourceResolver().getClassType(type) == 0;
        }
        return ret;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            if (this.getTreeViewer() != null) {
                this.getTreeViewer().clearSelection();
                this.getTreeViewer().toggleElements((Object[])this.getPreSelectedTypes());
                this.getTreeViewer().getCheckboxTreeViewer().getTree().addSelectionListener(this.getTreeSelectionListener());
            }
            this.updateMessageAndDescription();
        } else {
            this.getTreeViewer().getCheckboxTreeViewer().getTree().removeSelectionListener(this.getTreeSelectionListener());
            if (this.getFirstCheckedType() != null) {
                String name = this.getFirstCheckedType().getFullyQualifiedName();
                String oldName = this.getEjbMetaData().getBeanclassName();
                if (oldName == null || !oldName.equals(name)) {
                    this.getEjbMetaData().setBeanclassName(name);
                }
            }
        }
        super.setVisible(visible);
    }

    private SelectionListener getTreeSelectionListener() {
        if (this.treeSelectionListener == null) {
            this.treeSelectionListener = new MyTreeSelectionListener();
        }
        return this.treeSelectionListener;
    }

    protected int getProviderType() {
        return 1;
    }

    protected IType[] getPreSelectedTypes() {
        IType[] ret = null;
        IType[] beansClasses = this.getSourceResolver().getPossibleBeanClasses();
        if (beansClasses.length == 1) {
            ret = beansClasses;
        }
        return ret == null ? super.getPreSelectedTypes() : ret;
    }

    private void updateMessageAndDescription() {
        IType[] possibleBeanClasses = this.getSourceResolver().getPossibleBeanClasses();
        if (this.getFirstCheckedType() != null) {
            String name = this.getFirstCheckedType().getElementName();
            this.setMessage("EJB Name will be " + name + ".", 1);
            this.setDescription(DESCRIPTION);
        } else if (possibleBeanClasses != null && possibleBeanClasses.length > 0) {
            this.setDescription(DESCRIPTION);
            this.setMessage(MESSAGE, 2);
        } else {
            this.setDescription(DESCRIPTION_NO_BEANS_AVAILABLE);
            this.setMessage(MESSAGE_NO_BEANS_AVAILABLE, 1);
        }
    }

    private class MyTreeSelectionListener
    implements SelectionListener {
        private MyTreeSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            EjbResolveClassPage.super.getContainer().updateButtons();
            EjbResolveClassPage.this.updateMessageAndDescription();
        }
    }
}

