/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.ejb.wizard.internal.pages;

import com.tssap.j2ee.ui.ejb.components.IEjbMetaData;
import com.tssap.j2ee.ui.ejb.core.IStatusCallback;
import com.tssap.j2ee.ui.ejb.core.pages.EjbInterfacesPage;
import com.tssap.j2ee.ui.ejb.wizard.internal.pages.IEjbWizardPage;
import com.tssap.j2ee.ui.ejb.wizard.internal.pages.IEjbWizardPageWithStatus;
import com.tssap.util.ui.pane.IGridLayoutPane;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class EjbInterfacePage
extends WizardPage
implements IEjbWizardPageWithStatus,
IStatusCallback {
    private static final String PAGECOMPLETED = "page completed";
    private boolean mAlreadyVisited = false;
    private boolean pageComplete = false;
    private EjbInterfacesPage ifPage = null;

    public EjbInterfacePage(String pageName) {
        super(pageName);
    }

    public EjbInterfacePage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void init(IEjbMetaData ejbData) {
        this.ifPage = new EjbInterfacesPage(ejbData, this);
    }

    public void createControl(Composite parent) {
        IGridLayoutPane layout = this.ifPage.createContent(parent, this.getShell(), (IRunnableContext)this.getWizard().getContainer());
        layout.getComposite().setLayoutData((Object)new GridData(1808));
        this.setControl((Control)layout.getComposite());
        this.updateStatus(this.generateCurrentStatus());
    }

    public void changeUIStatus(Status status) {
        this.pageComplete = status.isOK() || status.getCode() == 1;
        this.setPageComplete(this.pageComplete);
        if (this.pageComplete) {
            this.setErrorMessage(null);
            this.setMessage(status.getMessage());
        } else {
            this.setErrorMessage(status.getMessage());
        }
        if (this.getMethodsPage().wasAlreadyVisited() && status.getCode() == 1 && status.getMessage().equals("Interfaces have been selected/deselected")) {
            this.setMessage(status.getMessage() + " , maybe some ejbmethods have to be changed", 2);
        }
    }

    public Status generateCurrentStatus() {
        return new Status(0, "com.tssap.j2ee.ui", 0, PAGECOMPLETED, null);
    }

    public void updateStatus(Status status) {
        this.changeUIStatus(status);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.updateStatus(this.generateCurrentStatus());
        if (!visible) {
            this.ifPage.leavePage();
            this.updateMethodsPage();
        } else if (!this.wasAlreadyVisited()) {
            this.setAlreadyVisited(true);
        }
    }

    private void updateMethodsPage() {
        IEjbWizardPage methodsPage = this.getMethodsPage();
        if (methodsPage != null) {
            methodsPage.prepareForFinish();
        }
    }

    private IEjbWizardPage getMethodsPage() {
        IEjbWizardPage methodsPage = (IEjbWizardPage)this.getWizard().getPage("EjbMethods");
        return methodsPage;
    }

    public void prepareForFinish() {
        this.ifPage.leavePage();
    }

    public void initializeFields() {
        if (this.ifPage != null) {
            this.ifPage.initializeFields();
        }
    }

    public boolean hasRemoteInterfaces() {
        return this.ifPage.hasRemoteInterfaces();
    }

    public boolean hasLocalInterfaces() {
        return this.ifPage.hasLocalInterFaces();
    }

    public void setAlreadyVisited(boolean b) {
        this.mAlreadyVisited = b;
    }

    public boolean wasAlreadyVisited() {
        return this.mAlreadyVisited;
    }
}

