/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.ejb.wizard.internal.pages;

import com.tssap.j2ee.model.ejb.IClassDataBean;
import com.tssap.j2ee.ui.UIPlugin;
import com.tssap.j2ee.ui.ejb.components.IEjbMetaData;
import com.tssap.j2ee.ui.ejb.wizard.internal.pages.BeanElement;
import com.tssap.j2ee.ui.ejb.wizard.internal.pages.EjbInterfacePage;
import com.tssap.j2ee.ui.ejb.wizard.internal.pages.IEjbWizardPage;
import com.tssap.j2ee.ui.ejb.wizard.internal.pages.MyBeanData;
import com.tssap.j2ee.ui.ejb.wizard.internal.pages.MyJavaElement;
import com.tssap.j2ee.ui.ejb.wizard.internal.pages.TreeElement;
import com.tssap.j2ee.util.jdt.JDTUtils;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class EjbExtensionPage
extends WizardPage
implements IEjbWizardPage {
    private TreeElement treeRootElement;
    private MyTreeLableProvider tlp;
    private MyTreeContentProvider tcp;
    private TreeViewer tvHierarchy;
    private Button butRemove;
    private Button butAddSuperInterface;
    private Button butAddSuperClass;
    private boolean mAlreadyVisited = false;
    private IEjbMetaData ejbData;

    public EjbExtensionPage(String pageName) {
        super(pageName);
    }

    public EjbExtensionPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public IEjbMetaData getEjbData() {
        return this.ejbData;
    }

    private Object getTreeModelRoot() {
        return this.treeRootElement;
    }

    public void createControl(Composite arg0) {
        IGridLayoutPane mainPane = PaneFactory.createGridLayoutPane((Composite)arg0, (int)2);
        IGridLayoutData gridData = mainPane.createGridLayoutData(4, 4, true, true, 2, 1);
        this.tvHierarchy = mainPane.addTreeViewer(false, gridData);
        gridData = mainPane.createGridLayoutData(4, 4, false, false);
        this.butAddSuperClass = mainPane.addPushButton("Add Superclass", gridData);
        mainPane.addPlaceholder();
        gridData = mainPane.createGridLayoutData(4, 4, false, false);
        this.butAddSuperInterface = mainPane.addPushButton("Add Superinterface", gridData);
        mainPane.addPlaceholder();
        gridData = mainPane.createGridLayoutData(4, 4, false, false);
        this.butRemove = mainPane.addPushButton("Remove", gridData);
        mainPane.addPlaceholder();
        this.tcp = new MyTreeContentProvider();
        this.tlp = new MyTreeLableProvider();
        this.tvHierarchy.setContentProvider((IContentProvider)this.tcp);
        this.tvHierarchy.setLabelProvider((IBaseLabelProvider)this.tlp);
        this.tvHierarchy.setInput((Object)"");
        this.butAddSuperClass.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EjbExtensionPage.this.handleAddSuperClass();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.butAddSuperInterface.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EjbExtensionPage.this.handleAddSuperInterface();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.butRemove.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EjbExtensionPage.this.handleRemove();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.tvHierarchy.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                EjbExtensionPage.this.handleTreeSelectionChanged(event);
            }
        });
        this.setControl((Control)mainPane.getComposite());
    }

    private void handleTreeSelectionChanged(SelectionChangedEvent event) {
        this.upDateButtonState();
    }

    private void handleRemove() {
        TreeElement te = this.getSelectedTreeElement();
        TreeElement parent = te.getParent();
        if (parent != null) {
            parent.removeChild(te);
        }
        this.refreshTree();
    }

    private void handleAddSuperInterface() {
        IType type = JDTUtils.chooseEnclosingType((IPackageFragmentRoot[])this.getEjbData().getPackageRoots(), (String[])new String[]{"All_APIs"}, (Shell)this.getShell(), (IRunnableContext)this.getWizard().getContainer(), (int)4, (String)"");
        if (type == null) {
            return;
        }
        TreeElement te = this.getSelectedTreeElement();
        te.addChild(new MyJavaElement(type.getFullyQualifiedName(), 1));
        this.refreshTree();
    }

    private void handleAddSuperClass() {
        IType type = JDTUtils.chooseEnclosingType((IPackageFragmentRoot[])this.getEjbData().getPackageRoots(), (String[])new String[]{"All_APIs"}, (Shell)this.getShell(), (IRunnableContext)this.getWizard().getContainer(), (int)2, (String)"");
        if (type == null) {
            return;
        }
        TreeElement te = this.getSelectedTreeElement();
        te.addChild(new MyJavaElement(type.getFullyQualifiedName(), 2));
        this.refreshTree();
    }

    private void refreshTree() {
        this.tvHierarchy.refresh(true);
        this.tvHierarchy.expandAll();
        this.upDateButtonState();
    }

    private TreeElement getSelectedTreeElement() {
        IStructuredSelection ss;
        Object obj;
        TreeElement ret = null;
        if (this.tvHierarchy.getSelection() instanceof IStructuredSelection && (obj = (ss = (IStructuredSelection)this.tvHierarchy.getSelection()).getFirstElement()) instanceof TreeElement) {
            ret = (TreeElement)obj;
        }
        return ret;
    }

    private void upDateButtonState() {
        int selState = 0;
        TreeElement te = this.getSelectedTreeElement();
        Object selData = null;
        if (te != null) {
            selData = te.getData();
        }
        if (selData != null) {
            if (selData instanceof BeanElement) {
                BeanElement beanEl = (BeanElement)selData;
                if (beanEl.getJavaType() == 1) {
                    selState |= 2;
                } else if (beanEl.getJavaType() == 2) {
                    selState |= 2;
                    boolean hasSuperClass = false;
                    TreeElement[] elChildren = te.getChildren();
                    int i = 0;
                    while (i < elChildren.length && !hasSuperClass) {
                        Object chData = elChildren[i].getData();
                        if (chData instanceof MyJavaElement && ((MyJavaElement)chData).getJavaType() == 2) {
                            hasSuperClass = true;
                        }
                        ++i;
                    }
                    if (!hasSuperClass) {
                        selState |= 1;
                    }
                }
            } else if (selData instanceof MyJavaElement && !this.isUnremovableInterface(te)) {
                selState |= 4;
            }
        }
        this.butAddSuperClass.setEnabled((selState & 1) > 0);
        this.butAddSuperInterface.setEnabled((selState & 2) > 0);
        this.butRemove.setEnabled((selState & 4) > 0);
    }

    private boolean isUnremovableInterface(TreeElement te) {
        boolean ret = false;
        TreeElement parent = te.getParent();
        if (parent != null && parent.getData() instanceof BeanElement) {
            BeanElement be = (BeanElement)parent.getData();
            int beType = be.getBeanType();
            String fullQInterfaceName = ((MyJavaElement)te.getData()).getFullQName();
            switch (beType) {
                case 2: {
                    ret = "javax.ejb.EJBHome".equals(fullQInterfaceName);
                    break;
                }
                case 5: {
                    ret = "javax.ejb.EJBLocalHome".equals(fullQInterfaceName);
                    break;
                }
                case 4: {
                    ret = "javax.ejb.EJBLocalObject".equals(fullQInterfaceName);
                    break;
                }
                case 3: {
                    ret = "javax.ejb.EJBObject".equals(fullQInterfaceName);
                    break;
                }
            }
        }
        return ret;
    }

    public void prepareForFinish() {
        if (this.treeRootElement == null) {
            return;
        }
        TreeElement[] beanParticipantTEs = this.treeRootElement.getChildren();
        int i = 0;
        while (i < beanParticipantTEs.length) {
            Object data = beanParticipantTEs[i].getData();
            if (data instanceof BeanElement) {
                BeanElement be = (BeanElement)data;
                String[] superIFNames = this.getSuperTypeName(beanParticipantTEs[i], 1);
                switch (be.getBeanType()) {
                    case 1: {
                        int j = 0;
                        while (j < superIFNames.length) {
                            this.getEjbData().setBeanInterface(superIFNames[j], null);
                            ++j;
                        }
                        String[] superClassName = this.getSuperTypeName(beanParticipantTEs[i], 2);
                        int j2 = 0;
                        while (j2 < superClassName.length) {
                            this.getEjbData().setBeanSuperclassName(superClassName[j2]);
                            ++j2;
                        }
                        break;
                    }
                    case 2: {
                        int j = 0;
                        while (j < superIFNames.length) {
                            this.getEjbData().setHomeSuperInterface(superIFNames[j], null);
                            ++j;
                        }
                        break;
                    }
                    case 4: {
                        int j = 0;
                        while (j < superIFNames.length) {
                            this.getEjbData().setLocalSuperInterface(superIFNames[j], null);
                            ++j;
                        }
                        break;
                    }
                    case 5: {
                        int j = 0;
                        while (j < superIFNames.length) {
                            this.getEjbData().setLocalHomeSuperInterface(superIFNames[j], null);
                            ++j;
                        }
                        break;
                    }
                    case 3: {
                        int j = 0;
                        while (j < superIFNames.length) {
                            this.getEjbData().setRemoteSuperInterface(superIFNames[j], null);
                            ++j;
                        }
                        break;
                    }
                }
            }
            ++i;
        }
    }

    private String[] getSuperTypeName(TreeElement element, int superType) {
        TreeElement[] superIFTEs = element.getChildren();
        ArrayList<String> al = new ArrayList<String>();
        int i = 0;
        while (i < superIFTEs.length) {
            MyJavaElement je;
            Object data = superIFTEs[i].getData();
            if (data instanceof MyJavaElement && (je = (MyJavaElement)data).getJavaType() == superType) {
                al.add(je.getFullQName());
            }
            ++i;
        }
        return al.toArray(new String[al.size()]);
    }

    public void init(IEjbMetaData ejbData) {
        this.ejbData = ejbData;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            IWizardPage page;
            if (!this.wasAlreadyVisited()) {
                this.setAlreadyVisited(true);
            }
            if ((page = this.getWizard().getPreviousPage((IWizardPage)this)) != null && page instanceof EjbInterfacePage) {
                EjbInterfacePage prevPage = (EjbInterfacePage)page;
                prevPage.prepareForFinish();
            }
            this.createModel();
            this.refreshTree();
        }
        super.setVisible(visible);
    }

    private void createModel() {
        String remoteIFName;
        String homeIFName;
        String localHomeIFName;
        String localIFName;
        TreeElement newTreeRootElement = TreeElement.createRootElement(new MyBeanData(this.getEjbData().getDefaultEjbName()));
        String beanClassName = this.getEjbData().getBeanclassName();
        if (beanClassName != null) {
            TreeElement teBeanClass = newTreeRootElement.addChild(new BeanElement(beanClassName, 2, 1));
            this.addSuperInterfaces(teBeanClass, this.getEjbData().getBeanInterfaces());
        }
        if ((localIFName = this.getEjbData().getLocalIFName()) != null) {
            TreeElement teLocalIF = newTreeRootElement.addChild(new BeanElement(localIFName, 1, 4));
            this.addSuperInterfaces(teLocalIF, this.getEjbData().getLocalSuperInterfaces());
        }
        if ((localHomeIFName = this.getEjbData().getLocalHomeIFName()) != null) {
            TreeElement teLocalomeIF = newTreeRootElement.addChild(new BeanElement(localHomeIFName, 1, 5));
            this.addSuperInterfaces(teLocalomeIF, this.getEjbData().getLocalHomeSuperInterfaces());
        }
        if ((homeIFName = this.getEjbData().getHomeIFName()) != null) {
            TreeElement teHomeIF = newTreeRootElement.addChild(new BeanElement(homeIFName, 1, 2));
            this.addSuperInterfaces(teHomeIF, this.getEjbData().getHomeSuperInterfaces());
        }
        if ((remoteIFName = this.getEjbData().getRemoteIFName()) != null) {
            TreeElement teRemoteIF = newTreeRootElement.addChild(new BeanElement(remoteIFName, 1, 3));
            this.addSuperInterfaces(teRemoteIF, this.getEjbData().getRemoteSuperInterfaces());
        }
        this.mergeTreedata(newTreeRootElement, this.treeRootElement);
        this.treeRootElement = newTreeRootElement;
    }

    private void addSuperInterfaces(TreeElement te, List list) {
        if (list != null) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                String iName;
                Object o = iter.next();
                if (!(o instanceof IClassDataBean) || (iName = ((IClassDataBean)o).getName()) == null) continue;
                te.addChild(new MyJavaElement(iName, 1));
            }
        }
    }

    private void mergeTreedata(TreeElement newTreeRootElement, TreeElement oldRootElement) {
        if (oldRootElement == null) {
            return;
        }
        TreeElement[] newTreeFirstLevelChildren = newTreeRootElement.getChildren();
        int i = 0;
        while (i < newTreeFirstLevelChildren.length) {
            TreeElement oldTreeFirstLevelChild = this.getSameBeanTypeElement(oldRootElement.getChildren(), newTreeFirstLevelChildren[i].getData());
            if (oldTreeFirstLevelChild != null) {
                TreeElement[] oldchs = oldTreeFirstLevelChild.getChildren();
                int j = 0;
                while (j < oldchs.length) {
                    newTreeFirstLevelChildren[i].addChild(oldchs[j].getData());
                    ++j;
                }
            }
            ++i;
        }
    }

    private TreeElement getSameBeanTypeElement(TreeElement[] elements, Object object) {
        TreeElement ret = null;
        if (object instanceof BeanElement) {
            BeanElement be = (BeanElement)object;
            int i = 0;
            while (i < elements.length && ret == null) {
                if (elements[i].getData() instanceof BeanElement && ((BeanElement)elements[i].getData()).getBeanType() == be.getBeanType()) {
                    ret = elements[i];
                }
                ++i;
            }
        }
        return ret;
    }

    public void setAlreadyVisited(boolean b) {
        this.mAlreadyVisited = b;
    }

    public boolean wasAlreadyVisited() {
        return this.mAlreadyVisited;
    }

    public class MyTreeContentProvider
    implements ITreeContentProvider {
        private final Object[] EMPTYAR = new Object[0];

        public Object[] getChildren(Object parentElement) {
            Object[] ret = this.EMPTYAR;
            if (parentElement instanceof TreeElement) {
                TreeElement te = (TreeElement)parentElement;
                ret = te.getChildren();
            }
            return ret;
        }

        public Object getParent(Object element) {
            TreeElement ret = null;
            if (element instanceof TreeElement) {
                TreeElement te = (TreeElement)element;
                ret = te.getParent();
            }
            return ret;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return new Object[]{EjbExtensionPage.this.getTreeModelRoot()};
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class MyTreeLableProvider
    extends LabelProvider {
        private final Image BEAN_IMAGE = UIPlugin.getImage((String)"ejb");
        private final Image INTERFACE_IMAGE = JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.int_obj.gif");
        private final Image CLASS_IMAGE = JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.class_obj.gif");

        public Image getImage(Object element) {
            Image ret = null;
            if (element instanceof TreeElement) {
                TreeElement te = (TreeElement)element;
                if (te.getData() instanceof MyJavaElement) {
                    MyJavaElement je = (MyJavaElement)te.getData();
                    if (je.getJavaType() == 2) {
                        ret = this.CLASS_IMAGE;
                    } else if (je.getJavaType() == 1) {
                        ret = this.INTERFACE_IMAGE;
                    }
                } else if (te.getData() instanceof MyBeanData) {
                    ret = this.BEAN_IMAGE;
                }
            }
            return ret != null ? ret : super.getImage(element);
        }

        public String getText(Object element) {
            String ret = null;
            if (element instanceof TreeElement) {
                TreeElement te = (TreeElement)element;
                if (te.getData() instanceof BeanElement) {
                    BeanElement be = (BeanElement)te.getData();
                    ret = be.getBeanTypeName() + " (" + be.getFullQName() + ")";
                } else if (te.getData() instanceof MyJavaElement) {
                    MyJavaElement je = (MyJavaElement)te.getData();
                    ret = je.getFullQName();
                } else if (te.getData() instanceof MyBeanData) {
                    MyBeanData je = (MyBeanData)te.getData();
                    ret = "Bean: " + je.getName();
                } else {
                    ret = super.getText(te.getData());
                }
            }
            return ret != null ? ret : super.getText(element);
        }
    }
}

