/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.ejb.wizard.internal.pages;

import com.tssap.j2ee.model.ejb.IPersistentField;
import com.tssap.j2ee.ui.core.listener.ButtonEvAdapter;
import com.tssap.j2ee.ui.ejb.components.IEjbMetaData;
import com.tssap.j2ee.ui.ejb.editor.internal.pages.fields.EjbFieldsPage;
import com.tssap.j2ee.ui.ejb.model.EJBConstants;
import com.tssap.j2ee.ui.ejb.model.internal.MissingPersistenceTypeException;
import com.tssap.j2ee.ui.ejb.wizard.internal.EjbMetaDataNoticeable;
import com.tssap.j2ee.ui.ejb.wizard.internal.pages.EjbWizardMethodsPage;
import com.tssap.j2ee.ui.ejb.wizard.internal.pages.IEjbWizardPage;
import com.tssap.j2ee.util.core.StatusWrapper;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.ISimplePane;
import com.tssap.util.ui.pane.PaneFactory;
import com.tssap.util.ui.reuse.IModifiedCallback;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.List;

public class EjbEntityPage
extends WizardPage
implements IEjbWizardPage,
IModifiedCallback {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$ejb$wizard$internal$pages$EjbEntityPage == null ? (class$com$tssap$j2ee$ui$ejb$wizard$internal$pages$EjbEntityPage = EjbEntityPage.class$("com.tssap.j2ee.ui.ejb.wizard.internal.pages.EjbEntityPage")) : class$com$tssap$j2ee$ui$ejb$wizard$internal$pages$EjbEntityPage));
    private static final int SIZING_WIZARD_WIDTH = 500;
    private static final int SIZING_WIZARD_HEIGHT = 500;
    private static final String JAVALANG = "java.lang.";
    private IEjbMetaData ejbData = null;
    private EjbFieldsPage fieldsPage = null;
    private ISimplePane sp = null;
    private Composite composite = null;
    private boolean cmpPersistence = false;
    private IType currentKey = null;
    private String currentKeyFQN = null;
    private InputWidgets inputWidgets = null;
    private HashMap mRelationMapPF_String = null;
    private final int maxColumns = 4;
    private int horizontalSpan = 0;
    private int verticalSpan = 0;
    private boolean simplePK = true;
    private boolean mAlreadyVisited = false;
    private StatusWrapper primKeyStatus = null;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$ejb$wizard$internal$pages$EjbEntityPage;

    public EjbEntityPage(String pageName, String description) {
        super(pageName);
        super.setDescription(description);
    }

    public EjbEntityPage(String pageName, String title, String description, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        super.setDescription(description);
    }

    public void init(IEjbMetaData ejbData) {
        this.ejbData = ejbData;
        this.inputWidgets = new InputWidgets();
        this.mRelationMapPF_String = new HashMap();
        this.primKeyStatus = new StatusWrapper();
        this.primKeyStatus.setOK();
    }

    public void createControl(Composite parent) {
        IGridLayoutPane glp = PaneFactory.createGridLayoutPane((Composite)parent, (int)4);
        glp.getComposite().setLayoutData((Object)new GridData(1808));
        this.inputWidgets.createPersistenceButton(glp);
        glp.addPlaceholder(4, 1);
        this.sp = glp.addSimplePane(true, true);
        this.fieldsPage = new EjbFieldsPage(new EjbMetaDataNoticeable(this.ejbData));
        this.fieldsPage.createPartControl(this.sp.getComposite());
        this.fieldsPage.setModifiedCallback(this);
        this.updateStatus();
        this.setControl((Control)glp.getComposite());
    }

    private String buildFieldString(IPersistentField field) {
        String name = field.getName();
        String type = field.getType();
        if (field.isArray()) {
            name = name + "[" + field.getDimension() + "]";
        }
        String fieldString = type + " " + name;
        return fieldString;
    }

    public boolean updateStatus() {
        if (this.ejbData.isCmp()) {
            StatusWrapper status = this.fieldsPage.validatePageContent();
            if (status.isOK()) {
                this.setPageComplete(true);
                this.setMessage(null);
                this.setErrorMessage(null);
                return true;
            }
            if (status.isWarning()) {
                this.setMessage(status.getMessage(), 2);
                this.setErrorMessage(null);
                this.setPageComplete(true);
                return true;
            }
            if (status.isInfo()) {
                this.setMessage(status.getMessage(), 1);
                this.setErrorMessage(null);
                this.setPageComplete(true);
                return true;
            }
            this.setMessage(status.getMessage(), 3);
            this.setPageComplete(false);
            return false;
        }
        StatusWrapper status = new StatusWrapper();
        this.setPageComplete(true);
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }

    public void dataModified(boolean modified) {
        this.updateStatus();
    }

    public void prepareForFinish() {
        if (this.fieldsPage != null) {
            this.fieldsPage.refresh();
        }
        if (this.ejbData.getEjbType() == 2 && this.ejbData.getPrimaryKey() == null) {
            try {
                this.ejbData.createPrimaryKey();
            }
            catch (MissingPersistenceTypeException e) {
                tracer.error("Not able to generate Default Primarykey", (Throwable)e);
            }
        }
    }

    public void setVisible(boolean visible) {
        if (!visible) {
            this.prepareForFinish();
        } else if (!this.wasAlreadyVisited()) {
            this.setAlreadyVisited(true);
        }
        super.setVisible(visible);
    }

    public boolean isPageComplete() {
        return this.fieldsPage == null || !this.fieldsPage.validatePageContent().isError();
    }

    public void setAlreadyVisited(boolean b) {
        this.mAlreadyVisited = b;
    }

    public boolean wasAlreadyVisited() {
        return this.mAlreadyVisited;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private final class InputWidgets {
        private Button[] cbs = null;
        private Combo mPrimaryKeyText = null;
        private List mFieldsList = null;
        private Button mFieldsEdit = null;
        private Button mFieldsRemove = null;
        private Button mFieldsAdd = null;
        private Button mPrimaryKeyClass = null;
        private Button[] mPersistency = null;
        private IPackageFragment mCurrentKeyPackage = null;
        private IGridLayoutPane tablePane = null;
        private IGridLayoutPane tableButtonsPane = null;

        private InputWidgets() {
        }

        private final void createPersistenceButton(IGridLayoutPane layout) {
            EjbEntityPage.this.horizontalSpan = 4;
            EjbEntityPage.this.verticalSpan = 2;
            Button[] cbs = layout.addHorizontalRadioButtonGroup("Persistence type", EJBConstants.PERSISTENCETYPE.LABELS, layout.createGridLayoutData(4, 4, true, false));
            EjbEntityPage.this.ejbData.setPersistenceType(0);
            int i = 0;
            while (i < cbs.length) {
                cbs[i].addSelectionListener((SelectionListener)new ButtonEvAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Button selectedButton = (Button)e.getSource();
                        if (selectedButton.getSelection()) {
                            this.persistenceChanged(selectedButton);
                            if (EjbEntityPage.this.getNextPage() instanceof EjbWizardMethodsPage) {
                                EjbWizardMethodsPage nextPage = (EjbWizardMethodsPage)EjbEntityPage.this.getNextPage();
                                nextPage.init(EjbEntityPage.this.ejbData);
                                if (nextPage.getMethodsPage() != null) {
                                    nextPage.getMethodsPage().decorateControls();
                                }
                            }
                        }
                    }
                });
                ++i;
            }
        }

        private final void persistenceChanged(Button selectedButton) {
            String text = selectedButton.getText();
            if (text.equals(EJBConstants.PERSISTENCETYPE.LABELS[1])) {
                try {
                    if (EjbEntityPage.this.fieldsPage == null) {
                        throw new Exception("Corrupt Fieldspage");
                    }
                    EjbEntityPage.this.fieldsPage.deselectTree();
                    EjbEntityPage.this.ejbData.setPersistenceType(1);
                    EjbEntityPage.this.ejbData.createPrimaryKey();
                    EjbEntityPage.this.fieldsPage.update(EjbEntityPage.this.ejbData);
                    this.deselectPersistentFields();
                    EjbEntityPage.this.updateStatus();
                }
                catch (Exception e) {
                    tracer.error("Not able to change persistence type", (Throwable)e);
                    EjbEntityPage.this.ejbData.setPersistenceType(0);
                    selectedButton.setSelection(false);
                    return;
                }
            }
            try {
                if (EjbEntityPage.this.fieldsPage == null) {
                    throw new Exception("Corrupt Fieldspage");
                }
                EjbEntityPage.this.fieldsPage.deselectTree();
                EjbEntityPage.this.ejbData.setPersistenceType(0);
                EjbEntityPage.this.ejbData.createPrimaryKey();
                EjbEntityPage.this.fieldsPage.update(EjbEntityPage.this.ejbData);
                EjbEntityPage.this.updateStatus();
            }
            catch (Exception e) {
                tracer.error("Not able to change persistence type", (Throwable)e);
                EjbEntityPage.this.ejbData.setPersistenceType(1);
                selectedButton.setSelection(false);
                return;
            }
        }

        private void deselectPersistentFields() {
            HashMap pfs = EjbEntityPage.this.ejbData.getPersistentFields();
            if (pfs != null && pfs.size() > 0) {
                Iterator it = pfs.values().iterator();
                while (it.hasNext()) {
                    IPersistentField element = (IPersistentField)it.next();
                    element.setPK(false);
                }
            }
        }
    }
}

