/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.ejb.wizard.internal;

import com.tssap.j2ee.ui.ejb.components.IEjbMetaData;
import com.tssap.j2ee.ui.ejb.util.EjbUtil;
import com.tssap.j2ee.util.core.StringUtils;
import com.tssap.selena.model.elements.Entity;
import java.util.HashMap;
import java.util.Iterator;

abstract class EjbCreationFactory {
    private static final String DEFAULTBEAN = "Bean";
    private static final String DEFAULTRIF = "MyDefault";
    private static final String DEFAULTHIF = "Home";
    private static final String DEFAULTLIF = "Local";
    private static final String DEFAULTLHIF = "LocalHome";

    EjbCreationFactory() {
    }

    protected static final void setParameterforMethod(Entity template, HashMap parameter) {
        String[] parameters = new String[parameter.size() * 2];
        Iterator it = parameter.keySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            String parameterType;
            Object parameterName = it.next();
            parameters[i] = parameterType = (String)parameter.get(parameterName);
            parameters[i + 1] = (String)parameterName;
            i += 2;
        }
        template.setObjectPropertyValue("parameterNameArray", (Object)parameters);
    }

    protected static final void setDefaultSourceClasses(IEjbMetaData ejbData, boolean checkForDuplicity) {
        String packageString = ejbData.getBeanPackage().getElementName();
        if (!packageString.equals("")) {
            packageString = packageString + ".";
        }
        String defaultName = null;
        defaultName = ejbData.getDefaultEjbName();
        if (defaultName == null || defaultName.equals("")) {
            defaultName = DEFAULTRIF;
        }
        if (defaultName.endsWith(DEFAULTBEAN)) {
            defaultName = defaultName.substring(0, defaultName.lastIndexOf(DEFAULTBEAN));
        }
        int prefix = 0;
        String ejbName = defaultName + DEFAULTBEAN;
        while (checkForDuplicity && EjbUtil.doesEjbAlreadyExists(packageString + ejbName, ejbData.getEjbProjectName())) {
            ejbName = DEFAULTRIF + String.valueOf(++prefix) + DEFAULTBEAN;
        }
        if (prefix != 0) {
            defaultName = defaultName + String.valueOf(prefix);
        }
        ejbData.setBeanclassName(packageString + defaultName + DEFAULTBEAN);
        ejbData.setRemoteIFName(packageString + defaultName);
        ejbData.setHomeIFName(packageString + defaultName + DEFAULTHIF);
        ejbData.setLocalIFName(packageString + defaultName + DEFAULTLIF);
        ejbData.setLocalHomeIFName(packageString + defaultName + DEFAULTLHIF);
    }

    protected static final void cutExtensionsFromClassNames(IEjbMetaData ejbData) {
        ejbData.setBeanclassName(StringUtils.removeExtension((String)ejbData.getBeanclassName(), (boolean)true));
        ejbData.setRemoteIFName(StringUtils.removeExtension((String)ejbData.getRemoteIFName(), (boolean)true));
        ejbData.setHomeIFName(StringUtils.removeExtension((String)ejbData.getHomeIFName(), (boolean)true));
        ejbData.setLocalIFName(StringUtils.removeExtension((String)ejbData.getLocalIFName(), (boolean)true));
        ejbData.setLocalHomeIFName(StringUtils.removeExtension((String)ejbData.getLocalHomeIFName(), (boolean)true));
    }
}

