/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.ejb.wizard;

import com.tssap.j2ee.model.J2eeProjectManager;
import com.tssap.j2ee.model.ejb.IEjbModule;
import com.tssap.j2ee.model.ejb.IEnterpriseJavaBean;
import com.tssap.j2ee.ui.UIPlugin;
import com.tssap.j2ee.ui.ejb.components.IEjbMetaData;
import com.tssap.j2ee.ui.ejb.components.IEjbMetaDataHolder;
import com.tssap.j2ee.ui.ejb.model.EjbMetaDataFactory;
import com.tssap.j2ee.ui.ejb.model.internal.EjbSourceResolver;
import com.tssap.j2ee.ui.ejb.wizard.internal.pages.EjbResolveClassPage;
import com.tssap.j2ee.ui.ejb.wizard.internal.pages.EjbResolveIFsPage;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class EjbResolver
extends Wizard
implements IEjbMetaDataHolder {
    private IJavaProject javaProject;
    private IEjbMetaData ejbMetaData;

    public EjbResolver(IJavaProject javaProject) {
        this.setJavaProject(javaProject);
        this.setWindowTitle("Resolve Enterprise Java Bean");
        this.setDefaultPageImageDescriptor(UIPlugin.getImageDesc((String)"ejb_large"));
    }

    public EjbResolver(IJavaProject javaProject, IType beanClass) {
        this(javaProject);
        String name = beanClass.getFullyQualifiedName();
        this.getEjbMetaData().setBeanclassName(name);
    }

    public boolean canFinish() {
        boolean ret = false;
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        if (this.getNextPage(currentPage) == null) {
            ret = true;
        }
        return ret;
    }

    public boolean performFinish() {
        IEjbMetaData metaData;
        this.getContainer().getCurrentPage().setVisible(false);
        boolean ret = true;
        if (this.ejbMetaData != null && (metaData = this.getEjbMetaData()) != null && metaData.getBeanclassName() != null) {
            IEnterpriseJavaBean ejb = null;
            IEjbModule ejbPrj = J2eeProjectManager.getEjbModule((String)this.getJavaProject().getElementName());
            IEnterpriseJavaBean[] ejbs = ejbPrj.getEnterpriseBeans();
            int i = 0;
            while (ejb == null && i < ejbs.length) {
                if (ejbs[i].getBeanClass().getFullyQualifiedName().equals(this.getEjbMetaData().getBeanclassName())) {
                    ejb = ejbs[i];
                }
                ++i;
            }
            if (ejb != null) {
                ejb.setHomeInterfaceClass(EjbMetaDataFactory.createClassDataBean(this.getEjbMetaData().getHomeIFName(), null), false);
                ejb.setRemoteInterfaceClass(EjbMetaDataFactory.createClassDataBean(this.getEjbMetaData().getRemoteIFName(), null), false);
                ejb.setLocalHomeInterfaceClass(EjbMetaDataFactory.createClassDataBean(this.getEjbMetaData().getLocalHomeIFName(), null), false);
                ejb.setLocalInterfaceClass(EjbMetaDataFactory.createClassDataBean(this.getEjbMetaData().getLocalIFName(), null), false);
            }
            ret = true;
        }
        return ret;
    }

    public IEjbMetaData getEjbMetaData() {
        if (this.ejbMetaData == null) {
            this.ejbMetaData = EjbMetaDataFactory.createEjbMetaDataBean();
        }
        return this.ejbMetaData;
    }

    public void addPages() {
        String beanClassName;
        super.addPages();
        EjbSourceResolver sourceResolver = new EjbSourceResolver(this.getJavaProject());
        if (this.getEjbMetaData() != null && ((beanClassName = this.getEjbMetaData().getBeanclassName()) == null || beanClassName.length() <= 0)) {
            EjbResolveClassPage classPage = new EjbResolveClassPage(sourceResolver);
            this.addPage((IWizardPage)classPage);
        }
        EjbResolveIFsPage interfacePage = new EjbResolveIFsPage(sourceResolver);
        this.addPage((IWizardPage)interfacePage);
    }

    private void setJavaProject(IJavaProject javaProject) {
        this.javaProject = javaProject;
    }

    protected IJavaProject getJavaProject() {
        return this.javaProject;
    }
}

