/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.ejb.wizard;

import com.tssap.j2ee.ui.UIPlugin;
import com.tssap.j2ee.ui.ejb.components.IEjbMetaData;
import com.tssap.j2ee.ui.ejb.model.EjbMetaDataFactory;
import com.tssap.j2ee.ui.ejb.wizard.internal.EjbPagesFactory;
import com.tssap.j2ee.ui.ejb.wizard.internal.pages.EjbMainpage;
import com.tssap.j2ee.ui.ejb.wizard.internal.pages.IEjbWizardPage;
import com.tssap.j2ee.util.wizard.WizardMsg;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class Ejb
extends Wizard
implements INewWizard {
    private boolean forcePreviousAndNextButtons = false;
    private IStructuredSelection selection;
    private IWorkbench workbench;
    private List allPages = null;
    private EjbMainpage mainPage;
    private IEjbMetaData ejbData;
    private boolean pagesInitialized = false;
    private boolean isMainPage = true;
    private int pageCount = 0;
    private int currentEjbType = -1;
    private int pageIndex = -1;
    private boolean mGenerateDefaultInterfaces = true;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.setWindowTitle(WizardMsg.getString((String)"NewEjb.windowTitle"));
        this.setDefaultPageImageDescriptor(UIPlugin.getImageDesc((String)"ejb_large"));
        this.allPages = new ArrayList();
        this.ejbData = EjbMetaDataFactory.createEjbMetaDataBean();
        this.mainPage = new EjbMainpage(true, "create Ejb");
        this.mainPage.init(selection, this.ejbData);
        this.mainPage.setWizard((IWizard)this);
        this.allPages.add(this.mainPage);
    }

    public IWizardPage getStartingPage() {
        if (this.allPages.size() == 0) {
            return null;
        }
        return (IWizardPage)this.allPages.get(0);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        this.pageIndex = this.allPages.indexOf(page);
        if (this.pageIndex == -1 || !(page instanceof EjbMainpage) && this.pageIndex == this.allPages.size() - 1) {
            return null;
        }
        int newType = this.ejbData.getEjbType();
        boolean generateDefaultIF = this.mainPage.generateDefaultIF();
        if (this.pageIndex == 0 && (this.currentEjbType != newType || generateDefaultIF != this.mGenerateDefaultInterfaces)) {
            this.allPages.clear();
            this.allPages.add(this.mainPage);
            if (newType == 2) {
                this.allPages.addAll(Arrays.asList(EjbPagesFactory.createEntityPages(this.ejbData, this.mainPage.generateDefaultIF())));
            } else if (newType == 3) {
                this.allPages.addAll(Arrays.asList(EjbPagesFactory.createMessageDrivenPages(this.ejbData)));
            } else {
                this.allPages.addAll(Arrays.asList(EjbPagesFactory.createSessionPages(this.ejbData, this.mainPage.generateDefaultIF())));
            }
            this.setWizardToPage();
            this.currentEjbType = newType;
            this.mGenerateDefaultInterfaces = generateDefaultIF;
        }
        if (this.allPages.size() <= 1) {
            return null;
        }
        return (IWizardPage)this.allPages.get(this.allPages.indexOf(page) + 1);
    }

    public boolean performFinish() {
        Iterator it = this.allPages.iterator();
        while (it.hasNext()) {
            ((IEjbWizardPage)it.next()).prepareForFinish();
        }
        return this.mainPage.finish();
    }

    public void setForcePreviousAndNextButtons(boolean b) {
        this.forcePreviousAndNextButtons = b;
    }

    public boolean needsPreviousAndNextButtons() {
        return this.forcePreviousAndNextButtons || this.allPages.size() > 1;
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        int index = this.allPages.indexOf(page);
        if (index == 0 || index == -1) {
            return null;
        }
        return (IWizardPage)this.allPages.get(index - 1);
    }

    public IWizardPage getPage(String name) {
        int i = 0;
        while (i < this.allPages.size()) {
            IWizardPage page = (IWizardPage)this.allPages.get(i);
            String pageName = page.getName();
            if (pageName.equals(name)) {
                return page;
            }
            ++i;
        }
        return null;
    }

    public int getPageCount() {
        return this.allPages.size();
    }

    public IWizardPage[] getPages() {
        return this.allPages.toArray(new IWizardPage[this.allPages.size()]);
    }

    public void dispose() {
        int i = 0;
        while (i < this.allPages.size()) {
            ((IWizardPage)this.allPages.get(i)).dispose();
            ++i;
        }
    }

    public void createPageControls(Composite pageContainer) {
        int i = 0;
        while (i < this.allPages.size()) {
            ((IWizardPage)this.allPages.get(i)).createControl(pageContainer);
            ++i;
        }
    }

    public boolean canFinish() {
        if (this.pageIndex == 0 && !this.mainPage.generateDefaultIF()) {
            return false;
        }
        int i = 0;
        while (i < this.allPages.size()) {
            if (!((IWizardPage)this.allPages.get(i)).isPageComplete()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void addPage(IWizardPage page) {
        this.allPages.add(page);
        page.setWizard((IWizard)this);
    }

    private void setWizardToPage() {
        Iterator it = this.allPages.iterator();
        while (it.hasNext()) {
            ((IWizardPage)it.next()).setWizard((IWizard)this);
        }
    }
}

