/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.ejb.util;

import com.tssap.j2ee.model.J2eeProjectManager;
import com.tssap.j2ee.model.core.EjbUtil;
import com.tssap.j2ee.model.ejb.IBusinessMethod;
import com.tssap.j2ee.model.ejb.IEjbModule;
import com.tssap.j2ee.model.ejb.IEnterpriseJavaBean;
import com.tssap.j2ee.model.ejb.IEntityBean;
import com.tssap.j2ee.model.ejb.IPersistentField;
import com.tssap.j2ee.ui.UIPlugin;
import com.tssap.j2ee.util.core.StatusWrapper;
import com.tssap.j2ee.util.core.StringUtilException;
import com.tssap.j2ee.util.core.StringUtils;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.swt.widgets.Display;

public abstract class EjbUtil {
    private static final String BEAN_PROBLEM_TXT = "Bean problem: ";
    private static TracerI TRACER = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$ejb$util$EjbUtil == null ? (class$com$tssap$j2ee$ui$ejb$util$EjbUtil = EjbUtil.class$("com.tssap.j2ee.ui.ejb.util.EjbUtil")) : class$com$tssap$j2ee$ui$ejb$util$EjbUtil));
    static /* synthetic */ Class class$com$tssap$j2ee$ui$ejb$util$EjbUtil;

    public static IFile[] getSourceFilesForEjb(IEnterpriseJavaBean ejb) throws Exception {
        ArrayList<IFile> allFiles = new ArrayList<IFile>();
        boolean remoteIF = false;
        boolean localIF = false;
        IFile file = null;
        if (ejb == null || ejb.getBeanClass() == null) {
            throw new Exception("Given EJB is corrupt");
        }
        try {
            file = (IFile)ejb.getBeanClass().getUnderlyingResource();
            if (!file.exists()) {
                throw new Exception("No valid Beanclass file found");
            }
        }
        catch (JavaModelException e) {
            throw new Exception("No valid Beanclass file found");
        }
        if (file != null) {
            allFiles.add(file);
        }
        file = null;
        if (ejb.getEjbType() != 2) {
            block26: {
                block25: {
                    try {
                        if (ejb.getRemoteInterfaceClass() != null) {
                            file = (IFile)ejb.getRemoteInterfaceClass().getUnderlyingResource();
                        }
                        if (file == null || !file.exists()) break block25;
                        allFiles.add(file);
                        remoteIF = true;
                        file = null;
                        try {
                            IType homeInterfaceClass = ejb.getHomeInterfaceClass();
                            if (homeInterfaceClass != null) {
                                file = (IFile)ejb.getHomeInterfaceClass().getUnderlyingResource();
                                if (file == null || !file.exists()) {
                                    throw new Exception("No valid home interface class found");
                                }
                            } else {
                                throw new Exception("No valid home interface class found");
                            }
                            allFiles.add(file);
                        }
                        catch (JavaModelException e) {
                            throw new Exception("No valid home interface class found");
                        }
                    }
                    catch (JavaModelException e) {
                        TRACER.warning("Not able to retrieve underlying resource", (Throwable)e);
                    }
                }
                file = null;
                try {
                    if (ejb.getLocalInterfaceClass() != null) {
                        file = (IFile)ejb.getLocalInterfaceClass().getUnderlyingResource();
                    }
                    if (file == null || !file.exists()) break block26;
                    allFiles.add(file);
                    localIF = true;
                    file = null;
                    try {
                        IType localHomeInterfaceClass = ejb.getLocalHomeInterfaceClass();
                        IFile iFile = file = localHomeInterfaceClass != null ? (IFile)localHomeInterfaceClass.getUnderlyingResource() : null;
                        if (file == null || !file.exists()) {
                            throw new Exception("No valid localhome interface class found");
                        }
                        allFiles.add(file);
                    }
                    catch (JavaModelException e) {
                        throw new Exception("No valid localhome interface class found");
                    }
                }
                catch (JavaModelException e) {
                    TRACER.warning("Not able to retrieve underlying resource", (Throwable)e);
                }
            }
            file = null;
            if (!localIF && !remoteIF) {
                throw new Exception("No interface classes found");
            }
            if (ejb.getEjbType() == 0 && ((IEntityBean)ejb).isPKCompoundKey()) {
                try {
                    if (((IEntityBean)ejb).getPrimaryKeyClass() != null && (file = (IFile)((IEntityBean)ejb).getPrimaryKeyClass().getUnderlyingResource()) != null) {
                        allFiles.add(file);
                    }
                }
                catch (JavaModelException e) {
                    TRACER.warning("Not able to retrieve underlying resource to Primarykey class", (Throwable)e);
                }
            }
        }
        return allFiles.toArray(new IFile[0]);
    }

    public static String checkEjb(final IEnterpriseJavaBean enterpriseJavaBean, boolean updateMarkers) {
        String ret = null;
        Exception e = null;
        try {
            EjbUtil.getSourceFilesForEjb(enterpriseJavaBean);
        }
        catch (Exception e2) {
            String errormsg = "Retrieve sourcefiles for Ejb failed";
            e = e2;
            ret = e2.getMessage();
            if (e instanceof NullPointerException) {
                TRACER.warning("Retrieve sourcefiles for Ejb failed: Check Ejb returned invalid Exception", (Throwable)e);
            }
            TRACER.warning("Retrieve sourcefiles for Ejb failed", (Throwable)e2);
        }
        final Exception getFileException = e;
        if (updateMarkers) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    try {
                        IResource beanClassRes = enterpriseJavaBean.getBeanClass().getCompilationUnit().getCorrespondingResource();
                        IMarker[] j2eeMarkers = beanClassRes.findMarkers(UIPlugin.BEAN_PROBLEM_MARKER_ID, false, 0);
                        if (getFileException != null) {
                            if (j2eeMarkers.length > 0) {
                                String msg = EjbUtil.BEAN_PROBLEM_TXT + getFileException.getMessage();
                                if (msg != null && !msg.equals(j2eeMarkers[0].getAttribute("message"))) {
                                    j2eeMarkers[0].setAttribute("message", (Object)(EjbUtil.BEAN_PROBLEM_TXT + getFileException.getMessage()));
                                }
                            } else {
                                IMarker marker = beanClassRes.createMarker(UIPlugin.BEAN_PROBLEM_MARKER_ID);
                                marker.setAttribute("message", (Object)(EjbUtil.BEAN_PROBLEM_TXT + getFileException.getMessage()));
                                marker.setAttribute("lineNumber", 1);
                                marker.setAttribute("severity", 2);
                                marker.setAttribute(UIPlugin.BEAN_PROBLEM_MARKER_BEANNAME_ATTRIB, (Object)enterpriseJavaBean.getEjbName());
                            }
                        } else if (j2eeMarkers.length > 0) {
                            beanClassRes.deleteMarkers(UIPlugin.BEAN_PROBLEM_MARKER_ID, false, 2);
                        }
                    }
                    catch (JavaModelException e) {
                        TRACER.warning("Error in update marker", (Throwable)e);
                    }
                    catch (CoreException e) {
                        TRACER.warning("Error in update marker", (Throwable)e);
                    }
                    catch (Exception e) {
                        TRACER.warning("Error in update marker", (Throwable)e);
                    }
                }
            });
        }
        return ret;
    }

    public static boolean isPKFieldAccessor(IBusinessMethod method, IEntityBean bean) {
        IPersistentField[] fields = bean.getPersistentFields();
        int i = 0;
        while (fields != null && i < fields.length) {
            if (fields[i].isPKField() && (method.getName().equalsIgnoreCase("get" + fields[i].getName()) || method.getName().equalsIgnoreCase("set" + fields[i].getName()))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String isValidAndUniqueEjbName(String fqEjbName, String projectName) {
        StatusWrapper ejbnameStatus = new StatusWrapper();
        String plainEjbName = fqEjbName;
        if (fqEjbName.indexOf(".") > -1) {
            try {
                HashMap map = StringUtils.ClassWithPathString((String)fqEjbName, (boolean)false);
                plainEjbName = (String)map.get(StringUtils.CLASSFILE);
            }
            catch (StringUtilException e) {
                String msg = null;
                msg = JavaConventions.validateIdentifier((String)fqEjbName).getMessage();
                if (msg == null) {
                    msg = "No valid EjbName";
                }
                TRACER.log(4, msg, (Throwable)e);
                return msg;
            }
        }
        EjbUtil.isValidEjbName(plainEjbName, ejbnameStatus);
        if (ejbnameStatus.isOK()) {
            String ejbname = fqEjbName;
            if (!ejbname.endsWith("Bean")) {
                ejbname = ejbname + "Bean";
            }
            if (EjbUtil.doesEjbAlreadyExists(ejbname.toString(), projectName)) {
                return "ejb already exists";
            }
            return null;
        }
        return ejbnameStatus.getMessage();
    }

    public static boolean isValidEjbName(String ejbName, StatusWrapper ejbnameStatus) {
        EjbUtil.checkEjbNameForConvention(ejbName, ejbnameStatus);
        if (!ejbnameStatus.getStatusInfo().isOK()) {
            return false;
        }
        if (ejbName.equals("EJB")) {
            ejbnameStatus.setError("EjbName is discouraged. The EjbName is used as prefix for creation of default Interface names. ");
            return false;
        }
        String fullEjbName = ejbName + "Bean";
        if (fullEjbName.equals("EntityBean") || fullEjbName.equals("SessionBean") || fullEjbName.equals("MessageDrivenBean")) {
            ejbnameStatus.setError("Invalid EjbName, type name is protected");
            return false;
        }
        return true;
    }

    private static void checkEjbNameForConvention(String text, StatusWrapper ejbnameStatus) {
        if (!JavaConventions.validateJavaTypeName((String)text).isOK()) {
            IStatus val = JavaConventions.validateJavaTypeName((String)text);
            if (val.getSeverity() == 4) {
                ejbnameStatus.setError(NewWizardMessages.getFormattedString((String)"NewTypeWizardPage.error.InvalidTypeName", (Object)val.getMessage()));
                return;
            }
            if (val.getSeverity() == 2) {
                ejbnameStatus.setWarning("EjbName is discouraged. The EjbName is used to create default Bean Class name \n and by convention, Java Type names usually start with an uppercase letter.");
                return;
            }
        } else {
            ejbnameStatus.setOK();
        }
    }

    public static boolean doesEjbAlreadyExists(String fqEjbName, String prjName) {
        if (!fqEjbName.endsWith("Bean")) {
            fqEjbName = fqEjbName.concat("Bean");
        }
        IEjbModule[] ejbModules = null;
        ejbModules = prjName == null || prjName.equals("") ? J2eeProjectManager.getEjbModules() : new IEjbModule[]{J2eeProjectManager.getEjbModule((String)prjName)};
        ArrayList<IEnterpriseJavaBean> allEjbs = new ArrayList<IEnterpriseJavaBean>();
        int i = 0;
        while (i < ejbModules.length) {
            allEjbs.addAll(Arrays.asList(ejbModules[i].getEnterpriseBeans()));
            ++i;
        }
        IEnterpriseJavaBean[] allBeans = new IEnterpriseJavaBean[allEjbs.size()];
        allEjbs.toArray(allBeans);
        allEjbs = null;
        ejbModules = null;
        int i2 = 0;
        while (i2 < allBeans.length) {
            if (allBeans[i2].getDefaultEjbName().equalsIgnoreCase(fqEjbName)) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public static String[] getSuperInterfaces(IType file) {
        try {
            return file.getSuperInterfaceNames();
        }
        catch (JavaModelException e) {
            TRACER.log(4, "Retrieving superinterfaces failed", (Throwable)e);
            return null;
        }
    }

    public static boolean isRemoteIF(IType file) {
        return com.tssap.j2ee.model.core.EjbUtil.isEjbInterfaceOfType((int)EjbUtil.INTERFACETYPES.REMOTEINTERFACE, (IType)file);
    }

    public static boolean isHomeIF(IType file) {
        return com.tssap.j2ee.model.core.EjbUtil.isEjbInterfaceOfType((int)EjbUtil.INTERFACETYPES.HOMEINTERFACE, (IType)file);
    }

    public static boolean isLocalIF(IType file) {
        return com.tssap.j2ee.model.core.EjbUtil.isEjbInterfaceOfType((int)EjbUtil.INTERFACETYPES.LOCALINTERFACE, (IType)file);
    }

    public static boolean isLocalHomeIF(IType file) {
        return com.tssap.j2ee.model.core.EjbUtil.isEjbInterfaceOfType((int)EjbUtil.INTERFACETYPES.LOCALHOMEINTERFACE, (IType)file);
    }

    public static boolean isBeanClass(IType file) {
        return com.tssap.j2ee.model.core.EjbUtil.isEjbBeanclass((IType)file);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

