/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.ejb.model.util;

import com.tssap.j2ee.model.IChangeable;
import com.tssap.j2ee.model.IField;
import com.tssap.j2ee.model.IJavaField;
import com.tssap.j2ee.model.IMethodWithUN;
import com.tssap.j2ee.model.ejb.ICMRField;
import com.tssap.j2ee.model.ejb.IClassDataBean;
import com.tssap.j2ee.model.ejb.IEjbRelation;
import com.tssap.j2ee.model.ejb.IEjbRelationRole;
import com.tssap.j2ee.model.ejb.IEntityBean;
import com.tssap.j2ee.model.ejb.IPersistableField;
import com.tssap.j2ee.ui.components.CmrData;
import com.tssap.j2ee.ui.components.CmrRoleData;
import com.tssap.j2ee.ui.components.ICmrData;
import com.tssap.j2ee.ui.components.ICmrRoleData;
import com.tssap.j2ee.ui.ejb.components.fields.IPersistableFieldData;
import com.tssap.j2ee.ui.ejb.model.EjbMetaDataFactory;
import com.tssap.j2ee.ui.ejb.model.MethodFactory;
import com.tssap.j2ee.ui.ejb.model.internal.ClassDataBean;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.reuse.java.IMethodData;
import com.tssap.util.ui.reuse.java.ITypeData;
import com.tssap.util.ui.reuse.java.MethodData;
import com.tssap.util.ui.reuse.java.TypeData;
import java.util.Arrays;
import org.eclipse.jdt.core.ICompilationUnit;

public class ModelDataConverter {
    private static final TracerI TRACER = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$ejb$model$util$ModelDataConverter == null ? (class$com$tssap$j2ee$ui$ejb$model$util$ModelDataConverter = ModelDataConverter.class$("com.tssap.j2ee.ui.ejb.model.util.ModelDataConverter")) : class$com$tssap$j2ee$ui$ejb$model$util$ModelDataConverter));
    static /* synthetic */ Class class$com$tssap$j2ee$ui$ejb$model$util$ModelDataConverter;

    public static IMethodWithUN transformToMethod(IMethodData methodData, int methodType) {
        IMethodWithUN ret = MethodFactory.createMethodsWithUN(methodType)[0];
        ModelDataConverter.syncToMethod(methodData, ret);
        return ret;
    }

    public static IMethodWithUN syncToMethod(IMethodData methodData, IMethodWithUN method) {
        if (method.getName() == null || !method.getName().equals(methodData.getName())) {
            method.setName(methodData.getName());
        }
        if (method.getParameters() == null || !method.getParameters().equals(methodData.getParameters())) {
            method.setParameters(methodData.getParameters());
        }
        StringBuffer returnType = new StringBuffer(methodData.getFullQualifiedTypeName());
        ModelDataConverter.appendArrayBrackets(returnType, methodData.getArrayDimension());
        method.setReturnType(returnType.toString());
        if (!method.isNew()) {
            method.setState(2);
        } else {
            try {
                method.createUniqueName();
            }
            catch (Exception e) {
                TRACER.error("Not able to recreate UniqueName", (Throwable)e);
            }
        }
        return method;
    }

    public static void appendArrayBrackets(StringBuffer typeName, int arrayDim) {
        int j = 0;
        while (j < arrayDim) {
            typeName.append("[]");
            ++j;
        }
    }

    public static IMethodWithUN transformToMethod(IMethodData methodData) {
        IMethodWithUN ret = ModelDataConverter.transformToMethod(methodData, -1);
        return ret;
    }

    public static IMethodData transformToMethodData(IMethodWithUN method) {
        MethodData ret = new MethodData(method.getName());
        ret = ModelDataConverter.syncToMethodData(method, (IMethodData)ret);
        return ret;
    }

    public static IMethodData syncToMethodData(IMethodWithUN method, IMethodData methodData) {
        methodData.setArrayDimension(0);
        if (methodData.getName() == null || !methodData.getName().equals(method.getName())) {
            methodData.setName(method.getName());
        }
        String returnType = method.getReturnType();
        int dim = 0;
        while (returnType.endsWith("[]")) {
            returnType = returnType.substring(0, returnType.lastIndexOf("[]"));
            ++dim;
        }
        methodData.setArrayDimension(dim);
        methodData.setFullQualifiedTypeName(returnType);
        if (methodData.getModifier() != 1) {
            methodData.setModifier(1);
        }
        if (methodData.getParameters() == null || !Arrays.equals(methodData.getParameters(), method.getParameters())) {
            methodData.setParameters(method.getParameters());
        }
        return methodData;
    }

    public static IField syncToField(IPersistableFieldData persistentFieldData, IPersistableField field) {
        if (field.getName() == null || !field.getName().equals(persistentFieldData.getName())) {
            field.setName(persistentFieldData.getName());
        }
        if (field.getType() == null || !field.getType().equals(persistentFieldData.getFullQualifiedTypeName())) {
            field.setType(persistentFieldData.getFullQualifiedTypeName());
        }
        if (!field.isNew()) {
            field.setState(2);
        }
        if (field instanceof IJavaField) {
            ((IJavaField)field).setArrayFlag(persistentFieldData.getArrayDimension() > 0);
            ((IJavaField)field).setDimension(persistentFieldData.getArrayDimension());
        }
        return field;
    }

    public static IPersistableFieldData syncToFieldData(IPersistableField field, IPersistableFieldData persistentFieldData) {
        if (persistentFieldData.getName() == null || !persistentFieldData.getName().equals(field.getName())) {
            persistentFieldData.setName(field.getName());
        }
        if (persistentFieldData.getFullQualifiedTypeName() == null || !persistentFieldData.getFullQualifiedTypeName().equals(field.getType())) {
            persistentFieldData.setFullQualifiedTypeName(field.getType());
        }
        if (field instanceof IJavaField) {
            persistentFieldData.setArrayDimension(((IJavaField)field).getDimension());
        }
        return persistentFieldData;
    }

    public static IClassDataBean syncToClassDataBean(ITypeData typeData, IClassDataBean classDataBean) {
        String fullQualifiedTypeName = typeData.getFullQualifiedTypeName();
        if (classDataBean.getName() == null || !classDataBean.getName().equals(fullQualifiedTypeName)) {
            if (fullQualifiedTypeName.endsWith("[]")) {
                fullQualifiedTypeName = fullQualifiedTypeName.substring(0, fullQualifiedTypeName.indexOf("[]"));
            }
            classDataBean.setName(fullQualifiedTypeName);
        }
        return classDataBean;
    }

    public static ITypeData syncToTypeData(IClassDataBean classDataBean, ITypeData typeData) {
        String fullQualifiedTypeName;
        typeData.setArrayDimension(0);
        String typeString = fullQualifiedTypeName = classDataBean.getName();
        int dim = 0;
        while (typeString.endsWith("[]")) {
            typeString = typeString.substring(0, typeString.lastIndexOf("[]"));
            ++dim;
        }
        typeData.setArrayDimension(dim);
        typeData.setFullQualifiedTypeName(typeString);
        return typeData;
    }

    public static IClassDataBean transformToClassDataBean(ITypeData typeData) {
        ClassDataBean classDataBean = new ClassDataBean();
        if (typeData != null) {
            String fullQualifiedTypeName = typeData.getFullQualifiedTypeName();
            classDataBean.setName(fullQualifiedTypeName);
        }
        return classDataBean;
    }

    public static ITypeData transformToTypeData(IClassDataBean classDataBean) {
        TypeData typeData = new TypeData();
        if (classDataBean != null) {
            String classDataFullQualifiedTypeName = classDataBean.getName();
            typeData.setFullQualifiedTypeName(classDataFullQualifiedTypeName);
        }
        return typeData;
    }

    public static ITypeData syncToTypeData(ICompilationUnit compilationUnit, ITypeData typeData) {
        typeData.setArrayDimension(0);
        String fullQualifiedTypeName = null;
        if (compilationUnit != null && typeData != null) {
            fullQualifiedTypeName = compilationUnit.getParent().getElementName() != null && !compilationUnit.getParent().getElementName().equals("") ? compilationUnit.getParent().getElementName().concat(".").concat(compilationUnit.getElementName()) : compilationUnit.getElementName();
            String typeString = fullQualifiedTypeName;
            int dim = 0;
            while (typeString.endsWith("[]")) {
                typeString = typeString.substring(0, typeString.lastIndexOf("[]"));
                ++dim;
            }
            typeData.setArrayDimension(dim);
            typeData.setFullQualifiedTypeName(typeString);
        }
        return typeData;
    }

    public static ITypeData transformToTypeData(ICompilationUnit compilationUnit, String defaultPackageString) {
        TypeData typeData = new TypeData();
        String fullQualifiedTypeName = null;
        if (compilationUnit != null) {
            fullQualifiedTypeName = compilationUnit.getParent().getElementName() != null && !compilationUnit.getParent().getElementName().equals("") ? compilationUnit.getParent().getElementName().concat(".").concat(compilationUnit.getElementName()) : (defaultPackageString != null ? defaultPackageString.concat(".").concat(compilationUnit.getElementName()) : compilationUnit.getElementName());
            typeData.setFullQualifiedTypeName(fullQualifiedTypeName);
        }
        return typeData;
    }

    public static IEjbRelationRole transformToEjbRelationRole(ICmrRoleData cmrRoleData) {
        IEjbRelationRole ret = EjbMetaDataFactory.createEjbRelationRole();
        ModelDataConverter.syncToEjbRelationRole(cmrRoleData, ret);
        return ret;
    }

    public static ICmrRoleData transformToCmrRoleData(IEjbRelationRole ejbRelationRole) {
        CmrRoleData ret = new CmrRoleData();
        ModelDataConverter.syncToCmrRoleData(ejbRelationRole, (ICmrRoleData)ret);
        return ret;
    }

    public static IEjbRelation transformToEjbRelation(ICmrData cmrData) {
        IEjbRelation ret = EjbMetaDataFactory.createEjbRelation(cmrData.getRelationName());
        ModelDataConverter.syncToEjbRelation(cmrData, ret);
        return ret;
    }

    public static ICmrData transformToCmrData(IEjbRelation ejbRelation) {
        CmrData ret = new CmrData();
        ModelDataConverter.syncToCmrData(ejbRelation, (ICmrData)ret);
        return ret;
    }

    public static IEjbRelationRole syncToEjbRelationRole(ICmrRoleData cmrRoleData, IEjbRelationRole ejbRelationRole) {
        boolean changed = false;
        if (cmrRoleData != null || ejbRelationRole != null) {
            IChangeable changeable;
            ICMRField cmrField;
            int newRelationRoleCardinality;
            int oldRelationRoleCardinality = ejbRelationRole.getCardinality();
            if (oldRelationRoleCardinality != (newRelationRoleCardinality = cmrRoleData.getCardinality())) {
                ejbRelationRole.setCardinality(newRelationRoleCardinality);
                changed = true;
            }
            String oldBeanName = ejbRelationRole.getRoleName();
            String newBeanName = cmrRoleData.getBeanName();
            if (oldBeanName == null || !oldBeanName.equals(newBeanName)) {
                ejbRelationRole.setRoleName(newBeanName);
                changed = true;
            }
            if ((cmrField = ejbRelationRole.getCmrField()) != null) {
                ICMRField changeable2;
                boolean cmrFieldChanged = false;
                String oldCmrFieldName = cmrField.getName();
                String newCmrFieldName = cmrRoleData.getCmrFieldName();
                if (oldCmrFieldName == null || !oldCmrFieldName.equals(newCmrFieldName)) {
                    cmrField.setName(newCmrFieldName);
                    cmrFieldChanged = true;
                }
                String oldCmrFieldType = cmrField.getType();
                String newCmrFieldType = cmrRoleData.getCmrFieldType();
                if (oldCmrFieldType == null || !oldCmrFieldType.equals(newCmrFieldType)) {
                    cmrField.setType(newCmrFieldType);
                    cmrFieldChanged = true;
                }
                if (cmrFieldChanged && cmrField instanceof IChangeable && !(changeable2 = cmrField).isNew()) {
                    changeable2.setState(2);
                }
                boolean bl = changed = changed || cmrFieldChanged;
            }
            if (changed && ejbRelationRole instanceof IChangeable && !(changeable = (IChangeable)ejbRelationRole).isNew()) {
                changeable.setState(2);
            }
        }
        return ejbRelationRole;
    }

    public static IEjbRelation syncToEjbRelation(ICmrData cmrData, IEjbRelation ejbRelation) {
        boolean changed = false;
        IEjbRelationRole role1 = ejbRelation.getRole1();
        IEjbRelationRole role2 = ejbRelation.getRole2();
        if (cmrData != null && ejbRelation != null) {
            IChangeable changeable;
            String oldRelationName = ejbRelation.getRelationName();
            String newRelationName = cmrData.getRelationName();
            if (oldRelationName == null || !oldRelationName.equals(newRelationName)) {
                ejbRelation.setRelationName(newRelationName);
                changed = true;
            }
            String oldRelationDescription = ejbRelation.getRelationDescription();
            String newRelationDescription = cmrData.getRelationDescription();
            if (oldRelationDescription == null || !oldRelationDescription.equals(newRelationDescription)) {
                ejbRelation.setRelationDescription(newRelationDescription);
                changed = true;
            }
            ModelDataConverter.syncToEjbRelationRole(cmrData.getRole1(), role1);
            ModelDataConverter.syncToEjbRelationRole(cmrData.getRole2(), role2);
            changed = true;
            if (changed && ejbRelation instanceof IChangeable && !(changeable = (IChangeable)ejbRelation).isNew()) {
                changeable.setState(2);
            }
        }
        if (TRACER.path()) {
            TRACER.path("syncToEjbRelation(ICmrData, IEjbRelation", "end");
        }
        if (TRACER.info()) {
            TRACER.info("relation name: " + ejbRelation.getRelationName());
            TRACER.info("relation description: " + ejbRelation.getRelationDescription());
            if (role1 != null) {
                TRACER.info("relation 1st role's name: " + role1.getRoleName());
                if (role1.getCmrField() != null) {
                    TRACER.info("relation 1st role's cmr field name: " + role1.getCmrField().getName());
                }
            }
            if (role2 != null) {
                TRACER.info("relation 2nd role's name: " + role2.getRoleName());
                if (role2.getCmrField() != null) {
                    TRACER.info("relation 2nd role's cmr field name: " + role2.getCmrField().getName());
                }
            }
        }
        return ejbRelation;
    }

    public static ICmrRoleData syncToCmrRoleData(IEjbRelationRole ejbRelationRole, ICmrRoleData cmrRoleData) {
        if (ejbRelationRole != null && cmrRoleData != null) {
            cmrRoleData.setCardinality(ejbRelationRole.getCardinality());
            String roleName = ejbRelationRole.getRoleName();
            if (roleName != null) {
                cmrRoleData.setBeanName(roleName);
            } else {
                IEntityBean bean = ejbRelationRole.getBean();
                if (bean != null) {
                    cmrRoleData.setBeanName(bean.getDefaultEjbName());
                }
            }
            ICMRField cmrField = ejbRelationRole.getCmrField();
            if (cmrField != null) {
                cmrRoleData.setCmrFieldName(cmrField.getName());
                cmrRoleData.setCmrFieldType(cmrField.getType());
            }
        }
        return cmrRoleData;
    }

    public static ICmrData syncToCmrData(IEjbRelation ejbRelation, ICmrData cmrData) {
        cmrData.setRelationName(ejbRelation.getRelationName());
        cmrData.setRelationDescription(ejbRelation.getRelationDescription());
        IEjbRelationRole role1 = ejbRelation.getRole1();
        IEjbRelationRole role2 = ejbRelation.getRole2();
        ICmrRoleData roleData1 = cmrData.getRole1();
        ICmrRoleData roleData2 = cmrData.getRole2();
        if (role1 != null && role2 != null && roleData1 != null && roleData2 != null) {
            ModelDataConverter.syncToCmrRoleData(role1, roleData1);
            ModelDataConverter.syncToCmrRoleData(role2, roleData2);
        }
        return cmrData;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

