/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.ejb.model.util;

import com.tssap.j2ee.ui.ejb.model.IEjbSourceResolver;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;

public class BeanClassesCP
extends LabelProvider
implements ITreeContentProvider {
    public static final int BEANS = 1;
    public static final int LOCAL = 2;
    public static final int REMOTE = 4;
    private static final Object[] EMPTY_AR = new Object[0];
    private static TreeFolder FOLDER_LOCAL = new TreeFolder("Local");
    private static TreeFolder FOLDER_LOCAL_COMP = new TreeFolder("Component");
    private static TreeFolder FOLDER_LOCAL_HOME = new TreeFolder("Home");
    private static TreeFolder FOLDER_REMOTE = new TreeFolder("Remote");
    private static TreeFolder FOLDER_REMOTE_COMP = new TreeFolder("Component");
    private static TreeFolder FOLDER_REMOTE_HOME = new TreeFolder("Home");
    private static TreeFolder FOLDER_BEANS = new TreeFolder("Beans");
    public static ArrayList ALL_FOLDER_LIST = new ArrayList<Object>(Arrays.asList(FOLDER_LOCAL, FOLDER_REMOTE, FOLDER_LOCAL_COMP, FOLDER_LOCAL_HOME, FOLDER_REMOTE_COMP, FOLDER_REMOTE_HOME, FOLDER_BEANS));
    private int myType;
    private IEjbSourceResolver myEjbResolver;

    public BeanClassesCP(int type) {
        this.myType = type;
    }

    public Object[] getChildren(Object parentElement) {
        int type = ALL_FOLDER_LIST.indexOf(parentElement);
        Object[] ret = EMPTY_AR;
        switch (type) {
            case 0: {
                ret = new Object[]{FOLDER_LOCAL_COMP, FOLDER_LOCAL_HOME};
                break;
            }
            case 1: {
                ret = new Object[]{FOLDER_REMOTE_HOME, FOLDER_REMOTE_COMP};
                break;
            }
            case 2: {
                ret = this.myEjbResolver.getPossibleLocalInterfaces(null);
                break;
            }
            case 3: {
                ret = this.myEjbResolver.getPossibleLocalHomeInterfaces(null);
                break;
            }
            case 4: {
                ret = this.myEjbResolver.getPossibleRemoteInterfaces(null);
                break;
            }
            case 5: {
                ret = this.myEjbResolver.getPossibleHomeInterfaces(null);
                break;
            }
            case 6: {
                ret = this.myEjbResolver.getPossibleBeanClasses();
                break;
            }
        }
        return ret;
    }

    public Object getParent(Object element) {
        int folderType = ALL_FOLDER_LIST.indexOf(element);
        TreeFolder ret = null;
        if (folderType == 2 || folderType == 3) {
            ret = FOLDER_LOCAL;
        } else if (folderType == 4 || folderType == 5) {
            ret = FOLDER_REMOTE;
        } else if (element instanceof IType) {
            int classType = this.myEjbResolver.getClassType((IType)element);
            switch (classType) {
                case 0: {
                    ret = FOLDER_BEANS;
                    break;
                }
                case 4: {
                    ret = FOLDER_LOCAL_HOME;
                    break;
                }
                case 3: {
                    ret = FOLDER_LOCAL_COMP;
                    break;
                }
                case 1: {
                    ret = FOLDER_REMOTE_COMP;
                    break;
                }
                case 2: {
                    ret = FOLDER_REMOTE_HOME;
                    break;
                }
            }
        }
        return ret;
    }

    public boolean hasChildren(Object element) {
        Object[] childs = this.getChildren(element);
        return childs != null && childs.length > 0;
    }

    public Object[] getElements(Object inputElement) {
        ArrayList<TreeFolder> ret = new ArrayList<TreeFolder>();
        if ((this.myType & 1) > 0) {
            ret.add(FOLDER_BEANS);
        }
        if ((this.myType & 2) > 0) {
            ret.add(FOLDER_LOCAL);
        }
        if ((this.myType & 4) > 0) {
            ret.add(FOLDER_REMOTE);
        }
        return ret.toArray(new Object[ret.size()]);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.myEjbResolver = newInput instanceof IEjbSourceResolver ? (IEjbSourceResolver)newInput : new EmptyEjbSourceResolver();
    }

    public String getText(Object element) {
        String ret = null;
        if (element instanceof IType) {
            ret = ((IType)element).getFullyQualifiedName();
        }
        return ret != null ? ret : super.getText(element);
    }

    private class EmptyEjbSourceResolver
    implements IEjbSourceResolver {
        private IType[] EMPTY_AR = new IType[0];

        private EmptyEjbSourceResolver() {
        }

        public int getClassType(IType clazz) {
            return -1;
        }

        public IType[] getPossibleBeanClasses() {
            return this.EMPTY_AR;
        }

        public IType[] getPossibleHomeInterfaces(IType beanClass) {
            return this.EMPTY_AR;
        }

        public IType[] getPossibleLocalHomeInterfaces(IType beanClass) {
            return this.EMPTY_AR;
        }

        public IType[] getPossibleLocalInterfaces(IType beanClass) {
            return this.EMPTY_AR;
        }

        public IType[] getPossibleRemoteInterfaces(IType beanClass) {
            return this.EMPTY_AR;
        }

        public IType[] getPossibleRelatedIFByNamingConvention(String fqBeanClassName) {
            return this.EMPTY_AR;
        }
    }

    private static class TreeFolder {
        String id;

        public TreeFolder(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public String toString() {
            return this.id;
        }
    }
}

