/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.ejb.model.internal;

import com.tssap.j2ee.model.DeleteFailedException;
import com.tssap.j2ee.model.IMethod;
import com.tssap.j2ee.model.IMethodWithUN;
import com.tssap.util.ui.reuse.java.IParameterData;
import com.tssap.util.ui.reuse.java.ParameterData;

public class Method
implements IMethod {
    protected String mMethodName = null;
    protected String mReturnValue = null;
    protected IParameterData[] mParameters = null;
    protected int mMethodType = -1;

    public Method(int methodType) {
        this.mMethodType = methodType;
        this.mParameters = new IParameterData[0];
    }

    public Method(int methodType, String returnValue, String methodName, IParameterData[] parameters) {
        this.mMethodType = methodType;
        this.setName(methodName);
        this.setReturnType(returnValue);
        this.setParameters(parameters);
    }

    public String getName() {
        return this.mMethodName;
    }

    public IParameterData[] getParameters() {
        return this.mParameters;
    }

    public String getReturnType() {
        return this.mReturnValue;
    }

    public void setName(String methodName) {
        this.mMethodName = methodName;
    }

    public void setParameters(IParameterData[] parameters) {
        this.mParameters = parameters;
    }

    public void setReturnType(String returnValue) {
        this.mReturnValue = returnValue == null || returnValue.equals("") ? "void" : returnValue;
    }

    public void setMethodType(int type) {
        this.mMethodType = type;
    }

    public int getMethodType() {
        return this.mMethodType;
    }

    public String[] getParameterNames() {
        if (this.mParameters != null && this.mParameters.length > 0) {
            String[] allParameterNames = new String[this.mParameters.length];
            int i = 0;
            while (i < this.mParameters.length) {
                allParameterNames[i] = this.mParameters[i].getName();
                ++i;
            }
            return allParameterNames;
        }
        return new String[0];
    }

    public String[] getParameterTypes() {
        if (this.mParameters != null && this.mParameters.length > 0) {
            String[] allParameterTypes = new String[this.mParameters.length];
            int i = 0;
            while (i < this.mParameters.length) {
                allParameterTypes[i] = this.mParameters[i].getFullQualifiedTypeName();
                ++i;
            }
            return allParameterTypes;
        }
        return new String[0];
    }

    public void setParameters(String[] types, String[] names) {
        if (names.length == types.length) {
            this.mParameters = null;
            this.mParameters = new IParameterData[names.length];
            int i = 0;
            while (i < names.length) {
                this.mParameters[i] = new ParameterData();
                this.mParameters[i].setName(names[i]);
                this.mParameters[i].setFullQualifiedTypeName(types[i]);
                ++i;
            }
        }
    }

    public void delete(boolean showConfDialog) throws DeleteFailedException {
    }

    public static boolean equalSignature(IMethodWithUN method1, IMethodWithUN method2) {
        boolean ret = false;
        if (method1.getName().equals(method2.getName())) {
            IParameterData[] params1 = method1.getParameters();
            IParameterData[] params2 = method2.getParameters();
            if (params1 != null && params2 != null && params1.length == params2.length) {
                int paramCount = params1.length;
                int equalsParamCounter = 0;
                int i = 0;
                while (i < paramCount) {
                    String fqtName1 = params1[i].getFullQualifiedTypeName();
                    String fqtName2 = params2[i].getFullQualifiedTypeName();
                    int arrayDim1 = params1[i].getArrayDimension();
                    int arrayDim2 = params2[i].getArrayDimension();
                    if (fqtName1.equals(fqtName2) && arrayDim1 == arrayDim2) {
                        ++equalsParamCounter;
                    }
                    ++i;
                }
                if (equalsParamCounter == paramCount) {
                    ret = true;
                }
            }
        }
        return ret;
    }
}

