/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.ejb.model.internal;

import com.tssap.j2ee.model.IUniqueFieldName;
import com.tssap.j2ee.model.ejb.ICMRField;
import com.tssap.j2ee.model.ejb.IClassDataBean;
import com.tssap.j2ee.model.ejb.IPersistentField;
import com.tssap.j2ee.model.ejb.IPrimaryKey;
import com.tssap.j2ee.ui.ejb.model.EjbMetaDataFactory;
import com.tssap.j2ee.ui.ejb.model.IEntityDataBean;
import com.tssap.j2ee.ui.ejb.model.internal.BMPPrimaryKey;
import com.tssap.j2ee.ui.ejb.model.internal.CMPPrimaryKey;
import com.tssap.j2ee.ui.ejb.model.internal.CMRFieldBean;
import com.tssap.j2ee.ui.ejb.model.internal.MissingPersistenceTypeException;
import com.tssap.j2ee.ui.ejb.model.internal.PersistentFieldBean;
import java.util.HashMap;
import java.util.Iterator;

public class EntityDataBean
implements IEntityDataBean {
    private HashMap mPersistentFields = null;
    private HashMap mCMRFields = null;
    private Boolean mIsCMP = null;
    private boolean mIsReentrant = true;
    private IPrimaryKey mPrimaryKey = null;
    private int mPersistenceType;

    public EntityDataBean(boolean isCMP) {
        this();
        this.setCMP(isCMP);
    }

    public EntityDataBean() {
        this.setCMP(true);
    }

    public int getPersistenceType() {
        if (this.mIsCMP.booleanValue()) {
            return 0;
        }
        return 1;
    }

    public void setPersistenceType(int persistenceType) {
        if (persistenceType == 0) {
            this.setCMP(true);
        } else {
            this.setCMP(false);
        }
    }

    private void setCMP(boolean isCMP) {
        this.mIsCMP = new Boolean(isCMP);
        if (isCMP) {
            if (this.mPersistentFields == null) {
                this.mPersistentFields = new HashMap();
            }
            if (this.mCMRFields == null) {
                this.mCMRFields = new HashMap();
            }
        }
        this.mPrimaryKey = null;
    }

    public HashMap getPersistentFields() {
        return this.mPersistentFields;
    }

    public IPersistentField[] createPersistentFields(int size) {
        return new PersistentFieldBean[size];
    }

    public IPersistentField getPersistentField(String name) {
        Iterator i = this.mPersistentFields.values().iterator();
        IPersistentField pf = null;
        while (i.hasNext()) {
            pf = (IPersistentField)i.next();
            if (pf != null && pf.getName().equals(name)) {
                return pf;
            }
            pf = null;
        }
        return pf;
    }

    public IPersistentField getPersistentField(String name, String type, boolean isArray, int dimension) {
        IPersistentField pf = this.getPersistentField(name);
        if (pf == null) {
            pf = new PersistentFieldBean(name, type, isArray, dimension);
            this.mPersistentFields.put(pf.getUniqueName(), pf);
        }
        return pf;
    }

    public void setPersistentFields(HashMap fields) {
        this.mPersistentFields.putAll(fields);
    }

    public void setPersistentField(String name, String type, boolean isArray, int dimension) {
        IPersistentField bean = this.getPersistentField(name);
        if (bean == null) {
            bean = new PersistentFieldBean(name, type, isArray, dimension);
            this.mPersistentFields.put(bean.getUniqueName(), bean);
        } else {
            bean.setType(type);
            bean.setArrayFlag(isArray);
            bean.setDimension(dimension);
        }
    }

    public void removePersistentField(IPersistentField pf) {
        Object ret = this.mPersistentFields.remove(pf.getUniqueName());
        if (ret == null) {
            this.removePersistentField(pf.getName());
        }
    }

    public void removePersistentField(String name) {
        IPersistentField field = this.getPersistentField(name);
        if (field != null) {
            this.mPersistentFields.remove(field.getUniqueName());
        }
    }

    public void removePersistentFields() {
        if (this.mPersistentFields != null) {
            this.mPersistentFields = new HashMap();
        }
    }

    public IPrimaryKey getPrimaryKey() {
        return this.mPrimaryKey;
    }

    public boolean isReentrant() {
        return this.mIsReentrant;
    }

    public void setReentrant(boolean mIsReentrant) {
        this.mIsReentrant = mIsReentrant;
    }

    public ICMRField[] createCMRFields(int size) {
        return new CMRFieldBean[size];
    }

    public ICMRField getCMRField(String name, String type) {
        ICMRField pf = this.getCMRField(name);
        if (pf == null) {
            pf = new CMRFieldBean(name, type);
            this.mCMRFields.put(name, pf);
        }
        return pf;
    }

    public ICMRField getCMRField(String name) {
        Iterator i = this.mCMRFields.values().iterator();
        ICMRField pf = null;
        while (i.hasNext()) {
            pf = (ICMRField)i.next();
            if (pf != null && pf.getName().equals(name)) {
                return pf;
            }
            pf = null;
        }
        return pf;
    }

    public HashMap getCMRFields() {
        return this.mCMRFields;
    }

    public void removeCMRField(ICMRField pf) {
        Object ret = this.mCMRFields.remove(pf.getUniqueName());
        if (ret == null) {
            this.removeCMRField(pf.getName());
        }
    }

    public void removeCMRField(String name) {
        ICMRField field = this.getCMRField(name);
        if (field != null) {
            this.mCMRFields.remove(field.getUniqueName());
        }
    }

    public void setCMRField(String name, String type) {
        ICMRField bean = this.getCMRField(name);
        if (bean == null) {
            bean = new CMRFieldBean(name, type);
            this.mCMRFields.put(bean.getUniqueName(), bean);
        } else {
            bean.setType(type);
        }
    }

    public void setCMRFields(HashMap fields) {
        this.mCMRFields.putAll(fields);
    }

    public void setCMRField(ICMRField field) {
        this.mCMRFields.put(field.getUniqueName(), field);
    }

    public void setPersistentField(IPersistentField field) {
        this.mPersistentFields.put(field.getUniqueName(), field);
    }

    public IPrimaryKey createPrimaryKey() throws MissingPersistenceTypeException {
        if (this.mIsCMP == null) {
            throw new MissingPersistenceTypeException();
        }
        this.mPrimaryKey = this.mIsCMP != false ? new CMPPrimaryKey() : new BMPPrimaryKey(EjbMetaDataFactory.createClassDataBean("java.lang.String", null));
        return this.mPrimaryKey;
    }

    public IPrimaryKey createPrimaryKey(IClassDataBean primaryKeyClass, IPersistentField[] fields) {
        this.mPrimaryKey = new CMPPrimaryKey(primaryKeyClass, fields);
        return this.mPrimaryKey;
    }

    public IPrimaryKey createPrimaryKey(IClassDataBean primaryKeyClass) throws MissingPersistenceTypeException {
        if (this.mIsCMP == null) {
            throw new MissingPersistenceTypeException();
        }
        this.mPrimaryKey = this.mIsCMP != false ? new CMPPrimaryKey(primaryKeyClass) : new BMPPrimaryKey(primaryKeyClass);
        return this.mPrimaryKey;
    }

    public IPrimaryKey createPrimaryKey(IPersistentField pkfield) {
        this.mPrimaryKey = new CMPPrimaryKey(pkfield);
        return this.mPrimaryKey;
    }

    public IPersistentField getPersistentField(IUniqueFieldName name) {
        return (IPersistentField)this.mPersistentFields.get(name);
    }

    public ICMRField getCMRField(IUniqueFieldName name) {
        return (ICMRField)this.mCMRFields.get(name);
    }
}

