/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.ejb.model.internal;

import com.tssap.j2ee.model.J2eeProjectManager;
import com.tssap.j2ee.model.ejb.IEnterpriseJavaBean;
import com.tssap.j2ee.ui.ejb.model.IEjbSourceResolver;
import com.tssap.j2ee.ui.ejb.util.EjbUtil;
import com.tssap.j2ee.util.core.StringUtilException;
import com.tssap.j2ee.util.core.StringUtils;
import com.tssap.j2ee.util.jdt.JDTUtils;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class EjbSourceResolver
implements IEjbSourceResolver {
    private static final TracerI TRACER = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$ejb$model$internal$EjbSourceResolver == null ? (class$com$tssap$j2ee$ui$ejb$model$internal$EjbSourceResolver = EjbSourceResolver.class$("com.tssap.j2ee.ui.ejb.model.internal.EjbSourceResolver")) : class$com$tssap$j2ee$ui$ejb$model$internal$EjbSourceResolver));
    private IType[] mRemoteIF = null;
    private IType[] mHomeIF = null;
    private IType[] mLocalIF = null;
    private IType[] mLocalHomeIF = null;
    private IType[] mBeanClasses = null;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$ejb$model$internal$EjbSourceResolver;

    public EjbSourceResolver(IJavaProject prj) {
        ArrayList<IType> remoteIF = new ArrayList<IType>();
        ArrayList<IType> homeIF = new ArrayList<IType>();
        ArrayList<IType> localIF = new ArrayList<IType>();
        ArrayList<IType> localHomeIF = new ArrayList<IType>();
        ArrayList<IType> beanClasses = new ArrayList<IType>();
        IPackageFragment[] allPackages = JDTUtils.getAllPackages((IJavaProject)prj);
        int i = 0;
        while (i < allPackages.length) {
            block14: {
                ICompilationUnit[] javaFiles = null;
                try {
                    javaFiles = allPackages[i].getCompilationUnits();
                }
                catch (JavaModelException e) {
                    TRACER.log(4, "Problems retrieving compilation units from package", (Throwable)e);
                    break block14;
                }
                if (javaFiles != null) {
                    int j = 0;
                    while (j < javaFiles.length) {
                        IType type = javaFiles[j].getType(StringUtils.removeExtension((String)javaFiles[j].getElementName(), (boolean)false));
                        if (EjbUtil.isBeanClass(type)) {
                            beanClasses.add(type);
                        } else if (EjbUtil.isRemoteIF(type)) {
                            remoteIF.add(type);
                        } else if (EjbUtil.isHomeIF(type)) {
                            homeIF.add(type);
                        } else if (EjbUtil.isLocalIF(type)) {
                            localIF.add(type);
                        } else if (EjbUtil.isLocalHomeIF(type)) {
                            localHomeIF.add(type);
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        this.removeStillRecognizedEjbClassFiles(remoteIF, homeIF, beanClasses, localIF, localHomeIF, prj);
        this.mBeanClasses = new IType[beanClasses.size()];
        this.mBeanClasses = beanClasses.toArray(new IType[0]);
        this.mRemoteIF = new IType[remoteIF.size()];
        this.mRemoteIF = remoteIF.toArray(new IType[0]);
        this.mHomeIF = new IType[homeIF.size()];
        this.mHomeIF = homeIF.toArray(new IType[0]);
        this.mLocalIF = new IType[localIF.size()];
        this.mLocalIF = localIF.toArray(new IType[0]);
        this.mLocalHomeIF = new IType[localHomeIF.size()];
        this.mLocalHomeIF = localHomeIF.toArray(new IType[0]);
    }

    public IType[] getPossibleBeanClasses() {
        return this.mBeanClasses;
    }

    public int getClassType(IType classFile) {
        if (EjbUtil.isBeanClass(classFile)) {
            return 0;
        }
        if (EjbUtil.isRemoteIF(classFile)) {
            return 1;
        }
        if (EjbUtil.isLocalIF(classFile)) {
            return 3;
        }
        if (EjbUtil.isHomeIF(classFile)) {
            return 2;
        }
        if (EjbUtil.isLocalHomeIF(classFile)) {
            return 4;
        }
        return -1;
    }

    public IType[] getPossibleRemoteInterfaces(IType beanClass) {
        return this.mRemoteIF;
    }

    public IType[] getPossibleHomeInterfaces(IType beanClass) {
        return this.mHomeIF;
    }

    public IType[] getPossibleLocalInterfaces(IType beanClass) {
        return this.mLocalIF;
    }

    public IType[] getPossibleLocalHomeInterfaces(IType beanClass) {
        return this.mLocalHomeIF;
    }

    private void removeStillRecognizedEjbClassFiles(List rIF, List hIF, List bCl, List lIF, List lhIF, IJavaProject prj) {
        IEnterpriseJavaBean[] allEjbs = J2eeProjectManager.getEjbModule((String)prj.getElementName()).getEnterpriseBeans();
        int i = 0;
        while (i < allEjbs.length) {
            if (allEjbs[i].getEjbType() == 2) {
                if (allEjbs[i].getBeanClass() != null) {
                    bCl.remove(allEjbs[i].getBeanClass());
                }
            } else {
                IType homeIF = allEjbs[i].getHomeInterfaceClass();
                IType remoteIF = allEjbs[i].getRemoteInterfaceClass();
                IType localIF = allEjbs[i].getLocalInterfaceClass();
                IType localHomeIF = allEjbs[i].getLocalHomeInterfaceClass();
                IType beanClass = allEjbs[i].getBeanClass();
                if (beanClass != null) {
                    boolean remote = false;
                    boolean local = false;
                    if (homeIF != null && remoteIF != null) {
                        remote = true;
                    }
                    if (localHomeIF != null && localIF != null) {
                        local = true;
                    }
                    if (remote && local || remote && localHomeIF == null && localIF == null || local && homeIF == null && remoteIF == null) {
                        bCl.remove(beanClass);
                        if (homeIF != null) {
                            hIF.remove(homeIF);
                        }
                        if (remoteIF != null) {
                            rIF.remove(remoteIF);
                        }
                        if (localIF != null) {
                            lIF.remove(localIF);
                        }
                        if (localHomeIF != null) {
                            lhIF.remove(localHomeIF);
                        }
                    }
                }
            }
            ++i;
        }
        System.out.println();
    }

    public IType[] getPossibleRelatedIFByNamingConvention(String fqBeanClassName) {
        String ejbPrefix;
        if (fqBeanClassName == null || fqBeanClassName.equals("")) {
            return new IType[0];
        }
        ArrayList<IType> possibleIFs = new ArrayList<IType>();
        if (fqBeanClassName.indexOf(46) > -1) {
            try {
                ejbPrefix = (String)StringUtils.ClassWithPathString((String)fqBeanClassName, (boolean)false).get(StringUtils.CLASSFILE);
            }
            catch (StringUtilException e) {
                TRACER.error("Not possible to retrieve beanclass name", (Throwable)e);
                return new IType[0];
            }
        } else {
            ejbPrefix = fqBeanClassName;
        }
        if (ejbPrefix.lastIndexOf("Bean") > -1) {
            ejbPrefix = ejbPrefix.substring(0, ejbPrefix.lastIndexOf("Bean"));
        }
        int i = 0;
        while (i < this.mRemoteIF.length) {
            if (this.mRemoteIF[i].getElementName().equals(ejbPrefix) || this.mRemoteIF[i].getElementName().equals(ejbPrefix + "Remote")) {
                possibleIFs.add(this.mRemoteIF[i]);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.mLocalIF.length) {
            if (this.mLocalIF[i2].getElementName().equals(ejbPrefix) || this.mLocalIF[i2].getElementName().equals(ejbPrefix + "Local")) {
                possibleIFs.add(this.mLocalIF[i2]);
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.mHomeIF.length) {
            if (this.mHomeIF[i3].getElementName().equals(ejbPrefix + "RemoteHome") || this.mHomeIF[i3].getElementName().equals(ejbPrefix + "Home")) {
                possibleIFs.add(this.mHomeIF[i3]);
            }
            ++i3;
        }
        int i4 = 0;
        while (i4 < this.mLocalHomeIF.length) {
            if (this.mLocalHomeIF[i4].getElementName().equals(ejbPrefix + "LocalHome") || this.mLocalHomeIF[i4].getElementName().equals(ejbPrefix + "Home")) {
                possibleIFs.add(this.mLocalHomeIF[i4]);
            }
            ++i4;
        }
        return possibleIFs.toArray(new IType[possibleIFs.size()]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

