/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.ejb.model.internal;

import com.tssap.j2ee.model.IMethodWithUN;
import com.tssap.j2ee.ui.ejb.model.IBusinessMethod;
import com.tssap.j2ee.ui.ejb.model.IBusinessMethodBean;
import com.tssap.j2ee.ui.ejb.model.MethodFactory;
import com.tssap.util.ui.reuse.java.IParameterData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public abstract class BusinessMethodsBean
implements IBusinessMethodBean {
    private List mBusinessMethods = new ArrayList();

    public List getBusinessMethods() {
        return this.mBusinessMethods;
    }

    public IBusinessMethod getBusinessMethod(String name, IParameterData[] parameters) {
        Iterator it = this.getBusinessMethods().iterator();
        while (it.hasNext()) {
            IBusinessMethod method = (IBusinessMethod)it.next();
            if (!method.getName().equals(name) || !method.getParameters().equals(parameters)) continue;
            return method;
        }
        return null;
    }

    public IMethodWithUN getBusinessMethodWithUN(String name, IParameterData[] parameters) {
        Iterator it = this.getBusinessMethods().iterator();
        while (it.hasNext()) {
            IMethodWithUN method;
            Object tmp = it.next();
            if (!(tmp instanceof IMethodWithUN) || !(method = (IMethodWithUN)tmp).getName().equals(name) || !method.getParameters().equals(parameters)) continue;
            return method;
        }
        return null;
    }

    public void setBusinessMethod(String name, String returnValue, IParameterData[] parameters) {
        boolean isNew = false;
        IBusinessMethod newMethod = this.getBusinessMethod(name, parameters);
        if (newMethod == null) {
            newMethod = MethodFactory.createBusinessMethod();
            newMethod.setName(name);
            isNew = true;
        }
        newMethod.setReturnType(returnValue);
        newMethod.setParameters(parameters);
        if (isNew) {
            this.mBusinessMethods.add(newMethod);
        }
    }

    public void setBusinessMethod(IBusinessMethod method) {
        boolean isNew = false;
        IBusinessMethod newMethod = this.getBusinessMethod(method.getName(), method.getParameters());
        if (newMethod == null) {
            newMethod = method;
            isNew = true;
        }
        newMethod.setReturnType(method.getReturnType());
        newMethod.setParameters(method.getParameters());
        if (isNew) {
            this.mBusinessMethods.add(newMethod);
        }
    }

    public void setBusinessMethods(IBusinessMethod[] bms) {
        this.mBusinessMethods.addAll(Arrays.asList(bms));
    }

    public void setBusinessMethodWithUN(String name, String returnValue, IParameterData[] parameters) {
        boolean isNew = false;
        IMethodWithUN newMethod = this.getBusinessMethodWithUN(name, parameters);
        if (newMethod == null) {
            newMethod = MethodFactory.createBusinessMethodWithUN(returnValue, name, parameters);
            newMethod.setName(name);
            isNew = true;
        }
        newMethod.setReturnType(returnValue);
        newMethod.setParameters(parameters);
        if (isNew) {
            this.mBusinessMethods.add(newMethod);
        }
    }

    public void setBusinessMethodWithUN(IBusinessMethod bm) {
        IMethodWithUN newMethod;
        boolean isNew = false;
        String name = bm.getName();
        String returnValue = bm.getReturnType();
        IParameterData[] parameters = bm.getParameters();
        if (this.getBusinessMethod(name, parameters) != null) {
            this.removeBusinessMethod(bm);
        }
        if ((newMethod = this.getBusinessMethodWithUN(name, parameters)) == null) {
            newMethod = MethodFactory.createBusinessMethodWithUN(returnValue, name, parameters);
            newMethod.setName(name);
            isNew = true;
        }
        newMethod.setReturnType(returnValue);
        newMethod.setParameters(parameters);
        if (isNew) {
            this.mBusinessMethods.add(newMethod);
        }
    }

    public void setBusinessMethodsWithUN(IMethodWithUN[] bms) {
        this.mBusinessMethods.addAll(Arrays.asList(bms));
    }

    public void setBusinessMethodWithUN(IMethodWithUN method) {
        boolean isNew = false;
        IMethodWithUN newMethod = this.getBusinessMethodWithUN(method.getName(), method.getParameters());
        if (newMethod == null) {
            newMethod = method;
            isNew = true;
        }
        newMethod.setReturnType(method.getReturnType());
        newMethod.setParameters(method.getParameters());
        if (isNew) {
            this.mBusinessMethods.add(newMethod);
        }
    }

    public void removeBusinessMethodWithUN(IMethodWithUN bm) {
        this.mBusinessMethods.remove(bm);
    }

    public void removeBusinessMethod(IBusinessMethod bm) {
        this.mBusinessMethods.remove(bm);
    }

    public void removeBusinessMethodWithUN(String name, String returnValue, IParameterData[] parameters) {
        Iterator it = this.mBusinessMethods.iterator();
        while (it.hasNext()) {
            Object bm = it.next();
            if (!(bm instanceof IMethodWithUN) || !((IMethodWithUN)bm).getName().equals(name) || !((IMethodWithUN)bm).getParameters().equals(parameters)) continue;
            this.mBusinessMethods.remove(bm);
            break;
        }
    }

    public void removeBusinessMethod(String name) {
        Iterator it = this.mBusinessMethods.iterator();
        while (it.hasNext()) {
            IBusinessMethod bm = (IBusinessMethod)it.next();
            if (!bm.getName().equals(name)) continue;
            this.mBusinessMethods.remove(bm);
            break;
        }
    }
}

