/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.ejb.external;

import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.ejb.IClassDataBean;
import com.tssap.j2ee.model.ejb.IEjbProject;
import com.tssap.j2ee.model.ejb.IEnterpriseJavaBean;
import com.tssap.j2ee.model.ejb.IEntityBean;
import com.tssap.j2ee.model.ejb.IMessageDrivenBean;
import com.tssap.j2ee.model.ejb.IPersistentField;
import com.tssap.j2ee.model.ejb.ISessionBean;
import com.tssap.j2ee.ui.ejb.components.IEjbMetaData;
import com.tssap.j2ee.ui.ejb.external.EjbCreationException;
import com.tssap.j2ee.ui.ejb.external.EjbMethodCreationException;
import com.tssap.j2ee.ui.ejb.external.PersistentFieldCreationException;
import com.tssap.j2ee.ui.ejb.external.PrimaryKeyCreationException;
import com.tssap.j2ee.ui.ejb.model.EjbMetaDataFactory;
import com.tssap.j2ee.ui.ejb.model.internal.MissingPersistenceTypeException;
import com.tssap.j2ee.ui.ejb.wizard.internal.CreationFactorySemanticAPI;
import com.tssap.j2ee.util.core.StringUtilException;
import com.tssap.j2ee.util.core.StringUtils;
import com.tssap.j2ee.util.jdt.JDTUtils;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.reuse.java.IParameterData;
import com.tssap.util.ui.reuse.java.ParameterData;
import java.util.ArrayList;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;

public final class EjbFactory {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$ejb$external$EjbFactory == null ? (class$com$tssap$j2ee$ui$ejb$external$EjbFactory = EjbFactory.class$("com.tssap.j2ee.ui.ejb.external.EjbFactory")) : class$com$tssap$j2ee$ui$ejb$external$EjbFactory));
    private static final int COMPOUNDKEY = 0;
    private static final int SIMPLEKEY = 1;
    private static final int BMPKEY = 2;
    private static final int UNKNOWNKEY = 3;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$ejb$external$EjbFactory;

    public static final IEntityBean createEntityBean(String fqEjbName, IEjbProject prj, String fqPrimaryKeyClass, String[] primaryKeyFieldNames, String[] primaryKeyFieldTypes, boolean isCMP, boolean remoteIF, boolean localIF) throws EjbCreationException {
        IEjbMetaData ejbData = EjbFactory.doCommonEjbStuff(prj, fqEjbName, remoteIF, localIF);
        try {
            return EjbFactory.createEntityBean(ejbData, prj, fqEjbName, fqPrimaryKeyClass, primaryKeyFieldNames, primaryKeyFieldTypes, isCMP);
        }
        catch (PrimaryKeyCreationException e) {
            throw new EjbCreationException("Creation of EntityBean failed", (Throwable)((Object)e));
        }
    }

    public static final IEntityBean createEntityBean(String fqEjbName, IEjbProject prj, String fqPrimaryKeyClass, String[] primaryKeyFieldNames, String[] primaryKeyFieldTypes, boolean isCMP) throws EjbCreationException {
        return EjbFactory.createEntityBean(fqEjbName, prj, fqPrimaryKeyClass, primaryKeyFieldNames, primaryKeyFieldTypes, isCMP, true, true);
    }

    public static final ISessionBean createSessionBean(String fqEjbName, IEjbProject prj, boolean isStateful, boolean remote, boolean local) throws EjbCreationException {
        IEjbMetaData ejbData = EjbFactory.doCommonEjbStuff(prj, fqEjbName, remote, local);
        return EjbFactory.createSessionBean(ejbData, prj, fqEjbName, isStateful);
    }

    public static final ISessionBean createSessionBean(String fqEjbName, IEjbProject prj, boolean isStateful) throws EjbCreationException {
        return EjbFactory.createSessionBean(fqEjbName, prj, isStateful, true, true);
    }

    public static final IMessageDrivenBean createMessageDrivenBean(String fqEjbName, IEjbProject prj) throws EjbCreationException {
        IEjbMetaData ejbData = EjbFactory.doCommonEjbStuff(prj, fqEjbName, false, false);
        IMessageDrivenBean messageB = null;
        try {
            messageB = (IMessageDrivenBean)CreationFactorySemanticAPI.createMessageDrivenBean(ejbData);
            CreationFactorySemanticAPI.createEjbMethod((IEnterpriseJavaBean)messageB, 3);
        }
        catch (Exception e) {
            throw new EjbCreationException("Creation of MessageDrivenBean failed", e);
        }
        return messageB;
    }

    public static final IParameterData createParameterDataBean(String name, String fqType) {
        return EjbFactory.createParameterDataBean(name, fqType, 0, false);
    }

    public static final IParameterData createParameterDataBean(String name, String fqType, boolean isModifiedFinal) {
        return EjbFactory.createParameterDataBean(name, fqType, 0, isModifiedFinal);
    }

    public static final IParameterData createParameterDataBean(String name, String fqType, int arrayDimension) {
        return EjbFactory.createParameterDataBean(name, fqType, arrayDimension, false);
    }

    public static final IParameterData createParameterDataBean(String name, String fqType, int arrayDimension, boolean isModifiedFinal) {
        ParameterData data = new ParameterData(name, fqType, arrayDimension);
        if (isModifiedFinal) {
            data.setModifier(32);
        }
        return data;
    }

    public static final void addPersistentField(IEntityBean ejb, String fieldName, String fqType) throws PersistentFieldCreationException {
        try {
            ejb.createPersistentField(fieldName, fqType);
        }
        catch (J2eeCreateException e) {
            throw new PersistentFieldCreationException("Creation of Persistentfield failed", e);
        }
    }

    public static final void addEjbMethod(IEnterpriseJavaBean ejb, String returnvalue, String methodName, IParameterData[] parameter) throws EjbMethodCreationException {
        ArrayList<String> parameterNames = new ArrayList<String>(parameter.length);
        ArrayList<String> parameterTypes = new ArrayList<String>(parameter.length);
        int i = 0;
        while (i < parameter.length) {
            IParameterData data = parameter[i];
            parameterNames.add(data.getName());
            StringBuffer completeType = new StringBuffer();
            if (data.hasModifier(32)) {
                completeType.append("final ");
            }
            completeType.append(data.getFullQualifiedTypeName() + " ");
            if (data.getArrayDimension() > 0) {
                int j = 0;
                while (j < data.getArrayDimension()) {
                    completeType.append("[]");
                    ++j;
                }
            }
            parameterTypes.add(completeType.toString());
            ++i;
        }
        try {
            ejb.createMethod(methodName, parameterTypes.toArray(new String[0]), parameterNames.toArray(new String[0]), returnvalue);
        }
        catch (J2eeCreateException e) {
            throw new EjbMethodCreationException("Creation of EjbMethod failed", e);
        }
        catch (Exception e1) {
            throw new EjbMethodCreationException("Creation of EjbMethod failed, wrong parameter data");
        }
    }

    private static IEjbMetaData doCommonEjbStuff(IEjbProject ejbproject, String fqEjbName, boolean remote, boolean local) throws EjbCreationException {
        IEjbMetaData ejbData = EjbMetaDataFactory.createEjbMetaDataBean();
        ejbData.setEjbProjectName(ejbproject.getName());
        String pkgPath = null;
        String ejbName = null;
        try {
            pkgPath = (String)StringUtils.ClassWithPathString((String)fqEjbName, (boolean)false).get(StringUtils.PACKAGEPATH);
            ejbName = (String)StringUtils.ClassWithPathString((String)fqEjbName, (boolean)false).get(StringUtils.CLASSFILE);
            ejbData.setDefaultEjbName(ejbName);
        }
        catch (StringUtilException e1) {
            throw new EjbCreationException("Creation of EnterpriseJavaBean failed, package couldn`t be resolved", e1);
        }
        IPackageFragment frag = JDTUtils.getPackageFragmentByName((IJavaProject)ejbproject.getJavaProject(), (String)pkgPath);
        if (frag == null || !frag.exists()) {
            throw new EjbCreationException("Creation of EnterpriseJavaBean failed, package couldn`t be resolved");
        }
        ejbData.setBeanPackage(frag);
        ejbData.setBeanclassName(pkgPath + "." + ejbName + "Bean");
        if (remote) {
            ejbData.setRemoteIFName(pkgPath + "." + ejbName);
            ejbData.setHomeIFName(pkgPath + "." + ejbName + "Home");
        }
        if (local) {
            ejbData.setLocalIFName(pkgPath + "." + ejbName + "Local");
            ejbData.setLocalHomeIFName(pkgPath + "." + ejbName + "LocalHome");
        }
        return ejbData;
    }

    private static IEntityBean createEntityBean(IEjbMetaData metaData, IEjbProject ejbproject, String fqEjbName, String fqPrimaryKeyClass, String[] primaryKeyFieldNames, String[] primaryKeyFieldTypes, boolean isCMP) throws EjbCreationException, PrimaryKeyCreationException {
        if (isCMP) {
            metaData.setPersistenceType(0);
        } else {
            metaData.setPersistenceType(1);
        }
        int pkKeyType = EjbFactory.checkForPKType(isCMP, fqPrimaryKeyClass, primaryKeyFieldNames, primaryKeyFieldTypes);
        if (pkKeyType == 0) {
            EjbFactory.createCompoundKey(metaData, fqPrimaryKeyClass, primaryKeyFieldNames, primaryKeyFieldTypes);
        } else if (pkKeyType == 1) {
            EjbFactory.createSimpleKey(metaData, primaryKeyFieldNames[0], primaryKeyFieldTypes[0]);
        } else if (pkKeyType == 2) {
            EjbFactory.createCompoundKey(metaData, fqPrimaryKeyClass, null, null);
        } else if (pkKeyType == 3) {
            EjbFactory.createCompoundKey(metaData, null, null, null);
        }
        IEntityBean entityB = null;
        try {
            entityB = (IEntityBean)CreationFactorySemanticAPI.createEntityBean(metaData);
            entityB.setCMP(isCMP);
            if (pkKeyType == 0) {
                EjbFactory.addPKFields(entityB, primaryKeyFieldNames, primaryKeyFieldTypes);
            }
            CreationFactorySemanticAPI.createEjbMethod((IEnterpriseJavaBean)entityB, 4);
            CreationFactorySemanticAPI.createEjbMethod((IEnterpriseJavaBean)entityB, 3);
        }
        catch (Exception e) {
            throw new EjbCreationException("Creation of EntityBean failed", e);
        }
        return entityB;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int checkForPKType(boolean isCMP, String fqPrimaryKeyClass, String[] primaryKeyFieldNames, String[] primaryKeyFieldTypes) throws PrimaryKeyCreationException {
        if (isCMP) {
            if (primaryKeyFieldNames == null || primaryKeyFieldTypes == null || primaryKeyFieldNames.length <= 0) return 3;
            if (primaryKeyFieldNames.length != primaryKeyFieldTypes.length) {
                throw new PrimaryKeyCreationException("Inconsistent number of key names and types");
            }
            if (fqPrimaryKeyClass != null) {
                return 0;
            }
            if (primaryKeyFieldNames.length != 1) return 3;
            return 1;
        }
        if (fqPrimaryKeyClass == null) return 3;
        return 2;
    }

    private static ISessionBean createSessionBean(IEjbMetaData metaData, IEjbProject ejbproject, String fqEjbName, boolean isStateful) throws EjbCreationException {
        ISessionBean sessionB = null;
        try {
            sessionB = (ISessionBean)CreationFactorySemanticAPI.createSessionBean(metaData, isStateful);
            CreationFactorySemanticAPI.createEjbMethod((IEnterpriseJavaBean)sessionB, 3);
        }
        catch (Exception e) {
            throw new EjbCreationException("Creation of SessionBean failed", e);
        }
        return sessionB;
    }

    private static void createSimpleKey(IEjbMetaData metaData, String fieldName, String fieldType) {
        IPersistentField field = EjbFactory.addPersistentField(metaData, fieldName, fieldType);
        field.setPK(true);
        metaData.createPrimaryKey(field);
    }

    private static void createCompoundKey(IEjbMetaData metaData, String fqPrimaryKeyClass, String[] primaryKeyFieldNames, String[] primaryKeyFieldTypes) throws PrimaryKeyCreationException {
        try {
            if (fqPrimaryKeyClass != null) {
                IClassDataBean compoundClass = EjbMetaDataFactory.createClassDataBean();
                compoundClass.setName(fqPrimaryKeyClass);
                metaData.createPrimaryKey(compoundClass);
            } else {
                metaData.createPrimaryKey();
            }
        }
        catch (MissingPersistenceTypeException e) {
            throw new PrimaryKeyCreationException("Creation of PrimaryKey failed", e);
        }
    }

    private static void addPKFields(IEntityBean bean, String[] primaryKeyFieldNames, String[] primaryKeyFieldTypes) throws PrimaryKeyCreationException {
        try {
            int i = 0;
            while (i < primaryKeyFieldNames.length) {
                String type = primaryKeyFieldTypes[i];
                String name = primaryKeyFieldNames[i];
                IPersistentField field = bean.createPersistentField(name, type);
                field.setPK(true);
                ++i;
            }
        }
        catch (J2eeCreateException e) {
            throw new PrimaryKeyCreationException("Creation of PKfields failed", e);
        }
    }

    private static IPersistentField addPersistentField(IEjbMetaData metaData, String fieldName, String fieldType) {
        IPersistentField field = EjbMetaDataFactory.createPersistentField(fieldName, fieldType, false, 0);
        metaData.setPersistentField(field);
        return field;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

