/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.ejb.editor.internal.pages.methods;

import com.tssap.j2ee.model.IMethodWithUN;
import com.tssap.j2ee.ui.ejb.components.EjbEditorComponent;
import com.tssap.j2ee.ui.ejb.components.IEjbMetaData;
import com.tssap.j2ee.ui.ejb.components.IEjbMetaDataNoticeable;
import com.tssap.j2ee.ui.ejb.components.methods.EjbMethodsComponent;
import com.tssap.j2ee.ui.ejb.editor.internal.pages.EjbEditorPageWithTreeSelector;
import com.tssap.j2ee.ui.ejb.model.internal.Method;
import com.tssap.j2ee.util.core.StatusWrapper;
import com.tssap.util.ui.reuse.ObjectEditorComponentUtil;

public class EjbMethodsPage
extends EjbEditorPageWithTreeSelector {
    private static final String PAGE_NAME = "Methods";
    private EjbMethodsComponent ejbMethodsComponent;

    public EjbMethodsPage(IEjbMetaDataNoticeable noticeable) {
        super(noticeable, PAGE_NAME);
    }

    public String getPageName() {
        return PAGE_NAME;
    }

    public void decorateControls() {
        this.getEjbEditorComponent().decorateControls();
        super.decorateControls();
    }

    public StatusWrapper validatePageContent() {
        StatusWrapper status = new StatusWrapper();
        IEjbMetaData metaData = this.getEjbEditorComponent().getNoticeable().getEjbMetaData();
        this.checkMethodSignature(metaData.getCreateMethods(), status);
        this.checkMethodSignature(metaData.getFinderMethods(), status);
        this.checkMethodSignature(metaData.getSelectMethods(), status);
        this.checkMethodSignature(metaData.getHomeMethods(), status);
        this.checkMethodSignature(metaData.getBusinessMethods().toArray(new IMethodWithUN[0]), status);
        if (status.getStatusInfo().isOK() && this.getEjbMethodsComponent().getTreeSelectorEditorComponent() != null && this.getEjbMethodsComponent().getTreeSelectorEditorComponent().okToLeave() != null) {
            String problemText = this.getEjbMethodsComponent().getTreeSelectorEditorComponent().okToLeave();
            int msgPrefixIndex = ObjectEditorComponentUtil.getMsgPrefixIndex((String)problemText);
            if (msgPrefixIndex < ObjectEditorComponentUtil.CHANGE_MSG_PREFIXES.length) {
                problemText = ObjectEditorComponentUtil.removeMsgPrefix((String)problemText);
            }
            status = msgPrefixIndex == 0 ? new StatusWrapper(1, problemText) : (msgPrefixIndex == 1 ? new StatusWrapper(2, problemText) : new StatusWrapper(4, problemText));
        }
        return status;
    }

    protected EjbMethodsComponent getEjbMethodsComponent() {
        if (this.ejbMethodsComponent == null) {
            this.ejbMethodsComponent = new EjbMethodsComponent();
        }
        return this.ejbMethodsComponent;
    }

    protected EjbEditorComponent getEjbEditorComponent() {
        return this.getEjbMethodsComponent();
    }

    private void checkMethodSignature(IMethodWithUN[] methods, StatusWrapper status) {
        int i = 0;
        while (i < methods.length) {
            IMethodWithUN element1 = methods[i];
            int j = 0;
            while (j < methods.length) {
                if (i != j && MethodSignatureComparator.compare(element1, methods[j]) == 0) {
                    status.setError("There are two Methods with the same signature");
                    return;
                }
                ++j;
            }
            ++i;
        }
    }

    private static class MethodSignatureComparator {
        private MethodSignatureComparator() {
        }

        public static int compare(Object o1, Object o2) {
            if (!(o1 instanceof IMethodWithUN) || !(o2 instanceof IMethodWithUN)) {
                throw new ClassCastException("No valid types");
            }
            IMethodWithUN method1 = (IMethodWithUN)o1;
            IMethodWithUN method2 = (IMethodWithUN)o2;
            if (Method.equalSignature(method1, method2)) {
                return 0;
            }
            return -1;
        }
    }
}

