/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.ejb.editor.internal;

import com.tssap.j2ee.model.DefaultUniquePropertyBean;
import com.tssap.j2ee.model.IChangeable;
import com.tssap.j2ee.model.IMethodWithUN;
import com.tssap.j2ee.model.IUniqueFieldName;
import com.tssap.j2ee.model.IUniqueMethodName;
import com.tssap.j2ee.model.IUniqueNameAware;
import com.tssap.j2ee.model.ejb.IEjbRelation;
import com.tssap.j2ee.model.ejb.IPersistentField;
import com.tssap.j2ee.ui.ejb.components.IEjbMetaData;
import com.tssap.j2ee.ui.ejb.editor.CorruptEjbRelationException;
import com.tssap.j2ee.ui.ejb.editor.CorruptMethodException;
import com.tssap.j2ee.ui.ejb.editor.CorruptPersistentFieldException;
import com.tssap.j2ee.ui.ejb.model.util.ModelDataConverter;
import com.tssap.j2ee.util.core.StringUtils;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.reuse.java.IParameterData;
import java.util.ArrayList;
import java.util.HashMap;

abstract class UpdateEjbEntity {
    private static final TracerI TRACER = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$ejb$editor$internal$UpdateEjbEntity == null ? (class$com$tssap$j2ee$ui$ejb$editor$internal$UpdateEjbEntity = UpdateEjbEntity.class$("com.tssap.j2ee.ui.ejb.editor.internal.UpdateEjbEntity")) : class$com$tssap$j2ee$ui$ejb$editor$internal$UpdateEjbEntity));
    private IEjbMetaData mEjbData = null;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$ejb$editor$internal$UpdateEjbEntity;

    UpdateEjbEntity() {
    }

    public final boolean update(IEjbMetaData data, int ejbType) {
        this.mEjbData = data;
        try {
            IMethodWithUN[] mBMList = data.getBusinessMethods().toArray(new IMethodWithUN[0]);
            this.updateMethods(mBMList, 2);
            mBMList = null;
            if (ejbType == 0) {
                HashMap mFieldMap = data.getPersistentFields();
                this.updateFields(mFieldMap);
            }
            IMethodWithUN[] mCMList = data.getCreateMethods();
            this.updateMethods(mCMList, 3);
            mCMList = null;
            if (ejbType == 0) {
                IMethodWithUN[] mFMList = data.getFinderMethods();
                this.updateMethods(mFMList, 4);
                mFMList = null;
                IMethodWithUN[] mHMList = data.getHomeMethods();
                this.updateMethods(mHMList, 1);
                mHMList = null;
                if (data.isCmp()) {
                    IMethodWithUN[] mSMList = data.getSelectMethods();
                    this.updateMethods(mSMList, 5);
                    mSMList = null;
                }
                IEjbRelation[] relations = data.getEjbRelations();
                this.updateEjbRelation(relations);
            }
        }
        catch (CorruptPersistentFieldException e) {
            TRACER.error("update()", "Not able to update PersistentFields", (Throwable)((Object)e));
            return false;
        }
        catch (CorruptMethodException cme) {
            TRACER.error("update()", "Not able to update Methods", (Throwable)((Object)cme));
            return false;
        }
        catch (CorruptEjbRelationException cre) {
            TRACER.error("update()", "Not able to update EjbRelations", (Throwable)((Object)cre));
            return false;
        }
        return true;
    }

    private final void updateEjbRelation(IEjbRelation[] relation) throws CorruptEjbRelationException {
        int i = 0;
        while (i < relation.length) {
            if (relation[i] instanceof IChangeable && relation[i] instanceof IUniqueNameAware && !((IChangeable)relation[i]).isUnchanged()) {
                if (((IChangeable)relation[i]).isDeleted()) {
                    this.deleteEjbRelation(((DefaultUniquePropertyBean)((IUniqueNameAware)relation[i]).getUniqueName()).getName());
                } else if (((IChangeable)relation[i]).isNew()) {
                    try {
                        this.createEjbRelation(relation[i]);
                    }
                    catch (CorruptEjbRelationException e) {
                        throw new CorruptEjbRelationException("Couldn`t create EjbRealtion: " + relation[i].getRelationName());
                    }
                } else {
                    this.updateEjbRelation(((DefaultUniquePropertyBean)((IUniqueNameAware)relation[i]).getUniqueName()).getName(), relation[i]);
                }
                try {
                    ((IUniqueNameAware)relation[i]).createUniqueName();
                }
                catch (Exception e) {
                    throw new CorruptEjbRelationException("Couldn`t update Metadata for EjbRealtion: " + relation[i].getRelationName());
                }
                ((IChangeable)relation[i]).setState(1);
            }
            ++i;
        }
    }

    private final void updateMethods(IMethodWithUN[] methodList, int methodType) throws CorruptMethodException {
        ArrayList<IMethodWithUN> methodListToRemove = new ArrayList<IMethodWithUN>();
        ArrayList<IMethodWithUN> otherOnes = new ArrayList<IMethodWithUN>();
        int i = 0;
        while (i < methodList.length) {
            if (methodList[i].isDeleted()) {
                methodListToRemove.add(methodList[i]);
            } else {
                otherOnes.add(methodList[i]);
            }
            ++i;
        }
        this.doUpdateMethods(methodListToRemove.toArray(new IMethodWithUN[0]), methodType);
        this.doUpdateMethods(otherOnes.toArray(new IMethodWithUN[0]), methodType);
    }

    private final void doUpdateMethods(IMethodWithUN[] methodList, int methodType) throws CorruptMethodException {
        int i = 0;
        while (i < methodList.length) {
            IParameterData[] parameters = methodList[i].getParameters();
            if (parameters == null) {
                parameters = new IParameterData[]{};
            }
            String[] parameterTypes = new String[parameters.length];
            String[] parameterNames = new String[parameters.length];
            int j = 0;
            while (j < parameters.length) {
                parameterNames[j] = parameters[j].getName();
                StringBuffer buff = new StringBuffer(parameters[j].getFullQualifiedTypeName());
                ModelDataConverter.appendArrayBrackets(buff, parameters[j].getArrayDimension());
                parameterTypes[j] = buff.toString();
                ++j;
            }
            String returnValue = methodList[i].getReturnType();
            String methodName = methodList[i].getName();
            if ((this.mEjbData.isWizardBean() || (this.mEjbData.getEjbType() != 3 && this.mEjbData.getEjbType() != 1 || !methodName.equals("ejbCreate")) && !methodName.equals("ejbFindByPrimaryKey")) && !methodList[i].isUnchanged()) {
                if (methodList[i].isDeleted()) {
                    String[] uniqueNameParameterTypes = this.getParameterTypesFromUniqueName((IUniqueMethodName)methodList[i].getUniqueName());
                    this.deleteMethod(((IUniqueMethodName)methodList[i].getUniqueName()).getMethodName(), uniqueNameParameterTypes, methodType);
                    this.deleteFromEjbMetaData(methodList[i]);
                } else {
                    if (methodList[i].isNew()) {
                        this.createMethod(returnValue, methodName, parameterNames, parameterTypes, methodType);
                    } else if (methodList[i].isChanged()) {
                        this.updateMethod((IUniqueMethodName)methodList[i].getUniqueName(), returnValue, methodName, parameterNames, parameterTypes, methodType);
                    }
                    try {
                        methodList[i].createUniqueName();
                    }
                    catch (Exception e) {
                        throw new CorruptMethodException("Couldn`t update Metadata for Method: " + methodList[i].getName());
                    }
                }
                methodList[i].setState(1);
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void updateFields(HashMap fieldMap) throws CorruptPersistentFieldException {
        it = fieldMap.keySet().iterator();
        while (it.hasNext()) {
            tmpField = (IPersistentField)fieldMap.get(it.next());
            if (tmpField.isUnchanged()) continue;
            name = tmpField.getName();
            if (tmpField.isDeleted()) {
                this.deleteField(((IUniqueFieldName)tmpField.getUniqueName()).getFieldName());
                continue;
            }
            type = tmpField.getType();
            if (tmpField.isArray()) {
                arrayDimension = tmpField.getDimension();
                type = StringUtils.appendArrayBrackets((String)type, (int)arrayDimension);
            }
            if (tmpField.isNew()) {
                try {
                    this.createField(name, type);
                }
                catch (CorruptPersistentFieldException e) {
                    UpdateEjbEntity.TRACER.log(4, "No field created", (Throwable)e);
                    if (tmpField.isPKField()) ** GOTO lbl22
                    throw e;
                }
            } else {
                this.updateField((IUniqueFieldName)tmpField.getUniqueName(), name, type);
            }
lbl22:
            // 3 sources

            try {
                tmpField.createUniqueName();
            }
            catch (Exception e) {
                throw new CorruptPersistentFieldException("Couldn`t update Metadata for Field: " + tmpField.getName());
            }
            tmpField.setState(1);
        }
    }

    private void deleteFromEjbMetaData(IMethodWithUN method) {
    }

    private IEjbMetaData getEjbMetaData() {
        return this.mEjbData;
    }

    protected String[] getParameterTypesFromUniqueName(IUniqueMethodName uniqueMethodName) {
        IParameterData[] uniqueNameParameterData = uniqueMethodName.getParameters();
        String[] uniqueNameParameterTypes = new String[uniqueNameParameterData.length];
        int j = 0;
        while (j < uniqueNameParameterData.length) {
            StringBuffer buff = new StringBuffer(uniqueNameParameterData[j].getFullQualifiedTypeName());
            ModelDataConverter.appendArrayBrackets(buff, uniqueNameParameterData[j].getArrayDimension());
            uniqueNameParameterTypes[j] = buff.toString();
            ++j;
        }
        return uniqueNameParameterTypes;
    }

    protected String[] getParameterNamesFromUniqueName(IUniqueMethodName uniqueMethodName) {
        IParameterData[] uniqueNameParameterData = uniqueMethodName.getParameters();
        String[] uniqueNameParameterNames = new String[uniqueNameParameterData.length];
        int j = 0;
        while (j < uniqueNameParameterData.length) {
            uniqueNameParameterNames[j] = uniqueNameParameterData[j].getName();
            ++j;
        }
        return uniqueNameParameterNames;
    }

    protected abstract void deleteMethod(String var1, String[] var2, int var3) throws CorruptMethodException;

    protected abstract void deleteField(String var1) throws CorruptPersistentFieldException;

    protected abstract void deleteEjbRelation(String var1) throws CorruptEjbRelationException;

    protected abstract void updateMethod(IUniqueMethodName var1, String var2, String var3, String[] var4, String[] var5, int var6) throws CorruptMethodException;

    protected abstract void updateField(IUniqueFieldName var1, String var2, String var3) throws CorruptPersistentFieldException;

    protected abstract void updateEjbRelation(String var1, IEjbRelation var2) throws CorruptEjbRelationException;

    protected abstract void createMethod(String var1, String var2, String[] var3, String[] var4, int var5) throws CorruptMethodException;

    protected abstract void createField(String var1, String var2) throws CorruptPersistentFieldException;

    protected abstract void createEjbRelation(IEjbRelation var1) throws CorruptEjbRelationException;

    protected abstract void updatePrimaryKey(IEjbMetaData var1);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

