/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.ejb.editor;

import com.tssap.j2ee.model.IChangeable;
import com.tssap.j2ee.model.IMethod;
import com.tssap.j2ee.model.IMethodWithUN;
import com.tssap.j2ee.model.IUniquePropertyBeanName;
import com.tssap.j2ee.model.J2eeElementManager;
import com.tssap.j2ee.model.ejb.IBusinessMethodCapableEjb;
import com.tssap.j2ee.model.ejb.ICMP_PrimaryKey;
import com.tssap.j2ee.model.ejb.ICMRField;
import com.tssap.j2ee.model.ejb.IEjbRelation;
import com.tssap.j2ee.model.ejb.IEjbRelationRole;
import com.tssap.j2ee.model.ejb.IEnterpriseJavaBean;
import com.tssap.j2ee.model.ejb.IEntityBean;
import com.tssap.j2ee.model.ejb.IPersistableField;
import com.tssap.j2ee.model.ejb.IPersistentField;
import com.tssap.j2ee.model.ejb.ISessionBean;
import com.tssap.j2ee.ui.ejb.components.IEjbMetaData;
import com.tssap.j2ee.ui.ejb.editor.IEjbEditorInput;
import com.tssap.j2ee.ui.ejb.editor.internal.EjbEditorInputWrapper;
import com.tssap.j2ee.ui.ejb.model.EjbMetaDataFactory;
import com.tssap.j2ee.ui.ejb.model.IBusinessMethod;
import com.tssap.j2ee.ui.ejb.model.MethodFactory;
import com.tssap.j2ee.ui.ejb.model.internal.CMRFieldBean;
import com.tssap.j2ee.ui.ejb.model.internal.FieldBean;
import com.tssap.j2ee.ui.ejb.model.internal.MissingPersistenceTypeException;
import com.tssap.j2ee.ui.ejb.model.internal.PersistentFieldBean;
import com.tssap.j2ee.util.core.StringUtils;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.reuse.java.IParameterData;
import com.tssap.util.ui.reuse.java.ParameterData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;

public class EjbEditorInput
implements IEjbEditorInput,
IPersistableElement,
IAdaptable {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$ejb$editor$EjbEditorInput == null ? (class$com$tssap$j2ee$ui$ejb$editor$EjbEditorInput = EjbEditorInput.class$("com.tssap.j2ee.ui.ejb.editor.EjbEditorInput")) : class$com$tssap$j2ee$ui$ejb$editor$EjbEditorInput));
    private static final String EDITORINPUT_FACTORY_ID = "com.tssap.j2ee.ui.ejb.EjbEditorInputFactory";
    public static final String PERSKEY_BEANNAME = "BeanName";
    public static final String PERSKEY_PROJECTNAME = "ProjectName";
    private IEjbMetaData ejbMetaData = EjbMetaDataFactory.createEjbMetaDataBean();
    private Entity selectedEjbEntity = null;
    private int ejbType;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$ejb$editor$EjbEditorInput;
    static /* synthetic */ Class class$org$eclipse$ui$IEditorInput;

    public EjbEditorInput(Element selection) throws Exception {
        this.ejbMetaData.setWizardBeanFlag(false);
        if (selection != null) {
            this.initializeEjbMetaData(selection);
        }
    }

    public IEjbMetaData getEjbMetaData() {
        return this.ejbMetaData;
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public boolean equals(Object obj) {
        IFile f;
        boolean ret = false;
        EjbEditorInput input = null;
        if (obj instanceof EjbEditorInputWrapper) {
            input = (EjbEditorInput)((EjbEditorInputWrapper)obj).getWrappedInput();
        } else if (obj instanceof EjbEditorInput) {
            input = (EjbEditorInput)obj;
        }
        if (input != null && ((f = this.getFile()) == null && input == null || f != null && f.equals((Object)input.getFile()))) {
            ret = true;
        }
        return ret;
    }

    public int hashCode() {
        IFile f = this.getFile();
        return f != null ? f.hashCode() * 17 : 0;
    }

    public String getName() {
        return this.selectedEjbEntity.getPropertyValue("$name");
    }

    public IPersistableElement getPersistable() {
        return this;
    }

    public IFile getFile() {
        IFile ret = null;
        IResource res = J2eeElementManager.getResourceToElement((Element)this.getEntity());
        if (res instanceof IFile) {
            ret = (IFile)res;
        }
        return ret;
    }

    public IStorage getStorage() throws CoreException {
        return this.getFile();
    }

    public String getToolTipText() {
        String ret = null;
        if (this.getEjbMetaData() != null) {
            String projectName = this.getEjbMetaData().getEjbProjectName();
            String beanName = this.getEjbMetaData().getDefaultEjbName();
            ret = projectName + ": " + beanName;
        }
        if (ret == null) {
            ret = this.getName();
        }
        return ret;
    }

    public Object getAdapter(Class adapter) {
        EjbEditorInput ret = null;
        if (adapter.isAssignableFrom(class$org$eclipse$ui$IEditorInput == null ? (class$org$eclipse$ui$IEditorInput = EjbEditorInput.class$("org.eclipse.ui.IEditorInput")) : class$org$eclipse$ui$IEditorInput)) {
            ret = this;
        }
        return ret;
    }

    private void initializeEjbMetaData(Element selection) throws Exception {
        if (J2eeElementManager.isEnterpriseJavaBean((Element)selection)) {
            this.selectedEjbEntity = (Entity)selection;
            this.ejbMetaData.setEjbType(3);
            IEnterpriseJavaBean ejb = J2eeElementManager.getEnterpriseJavaBean((Element)selection);
            this.ejbMetaData.setEjbProjectName(ejb.getEJBProject().getName());
            int ejbType = ejb.getEjbType();
            this.ejbMetaData.setBeanclassName(ejb.getBeanClass().getFullyQualifiedName());
            this.initializeCreateMethods(this.selectedEjbEntity);
            if (ejbType == 2 || ejbType == 1) {
                if (ejb.getTransactionType() == 1) {
                    this.ejbMetaData.setEjbTransactionType(1);
                } else {
                    this.ejbMetaData.setEjbTransactionType(0);
                }
            }
            if (ejbType != 2) {
                if (ejbType == 1) {
                    if (((ISessionBean)ejb).isStateful()) {
                        this.ejbMetaData.setEjbType(0);
                    } else {
                        this.ejbMetaData.setEjbType(1);
                    }
                }
                if (ejb.getRemoteInterfaceClass() != null) {
                    this.ejbMetaData.setRemoteIFName(ejb.getRemoteInterfaceClass().getFullyQualifiedName());
                    this.ejbMetaData.setHomeIFName(ejb.getHomeInterfaceClass().getFullyQualifiedName());
                }
                if (ejb.getLocalInterfaceClass() != null) {
                    this.ejbMetaData.setLocalIFName(ejb.getLocalInterfaceClass().getFullyQualifiedName());
                    this.ejbMetaData.setLocalHomeIFName(ejb.getLocalHomeInterfaceClass().getFullyQualifiedName());
                }
                this.initializeBusinessMethods(this.selectedEjbEntity);
                if (ejbType == 0) {
                    this.ejbMetaData.setEjbType(2);
                    this.ejbMetaData.setPersistenceType(((IEntityBean)ejb).isCMP() ? 0 : 1);
                    this.ejbMetaData.setReentrant(((IEntityBean)ejb).isReentrant());
                    this.initializeSelectMethods(this.selectedEjbEntity);
                    this.initializeFinderMethods(this.selectedEjbEntity);
                    this.initializeHomeMethods(this.selectedEjbEntity);
                    this.initializeFields(this.selectedEjbEntity);
                    this.initializeEjbRelations(this.selectedEjbEntity);
                    this.setParticipantRelations();
                }
            }
            this.ejbMetaData.setDefaultEjbName(this.selectedEjbEntity.getPropertyValue("$name"));
        }
    }

    private final IMethodWithUN[] initializeMethods(IMethod[] semanticMethods, int type) {
        if (semanticMethods == null) {
            return null;
        }
        IMethodWithUN[] bms = type == 2 ? MethodFactory.createBusinessMethodsWithUN(semanticMethods.length) : MethodFactory.createMethodsWithUN(semanticMethods.length);
        int i = 0;
        while (i < semanticMethods.length) {
            if (semanticMethods[i] != null) {
                String[] parameterNames = semanticMethods[i].getParameterNames();
                String[] parameterTypes = semanticMethods[i].getParameterTypes();
                ParameterData[] parameters = new ParameterData[parameterNames.length];
                int p = 0;
                while (p < parameterNames.length) {
                    parameters[p] = new ParameterData();
                    parameters[p].setName(parameterNames[p]);
                    String parameterType = StringUtils.removeExtension((String)parameterTypes[p], (boolean)true);
                    int dim = 0;
                    while (parameterType.endsWith("[]")) {
                        parameterType = parameterType.substring(0, parameterType.lastIndexOf("[]"));
                        ++dim;
                    }
                    parameters[p].setFullQualifiedTypeName(parameterType);
                    parameters[p].setArrayDimension(dim);
                    ++p;
                }
                bms[i] = type == 2 ? MethodFactory.createBusinessMethodWithUN(StringUtils.removeExtension((String)semanticMethods[i].getReturnType(), (boolean)true), semanticMethods[i].getName(), (IParameterData[])parameters) : MethodFactory.createMethodWithUN(type, StringUtils.removeExtension((String)semanticMethods[i].getReturnType(), (boolean)true), semanticMethods[i].getName(), (IParameterData[])parameters);
                bms[i].setState(1);
                if (type == 2 && bms[i] instanceof IBusinessMethod) {
                    ((IBusinessMethod)bms[i]).propagateToLocalIF(((com.tssap.j2ee.model.ejb.IBusinessMethod)semanticMethods[i]).isLocalExposed());
                    ((IBusinessMethod)bms[i]).propagateToRemoteIF(((com.tssap.j2ee.model.ejb.IBusinessMethod)semanticMethods[i]).isRemoteExposed());
                }
            }
            ++i;
        }
        return bms;
    }

    private void initializeBusinessMethods(Entity ejb) {
        IMethodWithUN[] bms = this.initializeMethods((IMethod[])((IBusinessMethodCapableEjb)J2eeElementManager.getEnterpriseJavaBean((Element)ejb)).getBusinessMethods(), 2);
        if (bms != null && bms.length > 0) {
            this.ejbMetaData.setBusinessMethodsWithUN(bms);
        }
    }

    private void initializeCreateMethods(Entity ejb) {
        IMethodWithUN[] bms = this.initializeMethods((IMethod[])J2eeElementManager.getEnterpriseJavaBean((Element)ejb).getEJBMethods(3), 3);
        if (bms != null && bms.length > 0) {
            this.ejbMetaData.setCreateMethods(bms);
        }
    }

    private void initializeFinderMethods(Entity ejb) {
        IMethodWithUN[] bms = this.initializeMethods((IMethod[])J2eeElementManager.getEnterpriseJavaBean((Element)ejb).getEJBMethods(4), 4);
        if (bms != null && bms.length > 0) {
            this.ejbMetaData.setFinderMethods(bms);
        }
    }

    private void initializeSelectMethods(Entity ejb) {
        IMethodWithUN[] bms = this.initializeMethods((IMethod[])J2eeElementManager.getEnterpriseJavaBean((Element)ejb).getEJBMethods(5), 5);
        if (bms != null && bms.length > 0) {
            this.ejbMetaData.setSelectMethods(bms);
        }
    }

    private void initializeHomeMethods(Entity ejb) {
        IMethodWithUN[] bms = this.initializeMethods((IMethod[])J2eeElementManager.getEnterpriseJavaBean((Element)ejb).getEJBMethods(1), 1);
        if (bms != null && bms.length > 0) {
            this.ejbMetaData.setHomeMethods(bms);
        }
    }

    private void initializeFields(Entity ejb) throws Exception {
        this.initializePrimaryKeyClass(ejb);
        this.initializePersistentFields(ejb);
    }

    private void initializePrimaryKeyClass(Entity ejb) throws Exception {
        IType primaryKeyClass = null;
        IEntityBean entityBean = (IEntityBean)J2eeElementManager.getEnterpriseJavaBean((Element)ejb);
        if (entityBean.isPKCompoundKey() || !entityBean.isCMP()) {
            primaryKeyClass = entityBean.getPrimaryKeyClass();
        }
        if (primaryKeyClass != null) {
            try {
                this.ejbMetaData.createPrimaryKey(EjbMetaDataFactory.createClassDataBean(StringUtils.removeExtension((String)primaryKeyClass.getFullyQualifiedName(), (boolean)true), primaryKeyClass.getPackageFragment()));
            }
            catch (MissingPersistenceTypeException e) {
                tracer.error("Not able to create PrimaryKey");
                throw e;
            }
        }
    }

    private void initializePersistentFields(Entity ejb) {
        IPersistentField[] all_fields = ((IEntityBean)J2eeElementManager.getEnterpriseJavaBean((Element)ejb)).getPersistentFields();
        ArrayList<IPersistentField> persistentFields = new ArrayList<IPersistentField>();
        ArrayList<IPersistentField> cmrFields = new ArrayList<IPersistentField>();
        int i = 0;
        while (i < all_fields.length) {
            if (all_fields[i].isCMRField()) {
                cmrFields.add(all_fields[i]);
            } else {
                persistentFields.add(all_fields[i]);
            }
            ++i;
        }
        IPersistentField[] p_fields = persistentFields.toArray(new IPersistentField[0]);
        IPersistableField[] cmr_Fields = cmrFields.toArray(new IPersistableField[0]);
        if (p_fields == null) {
            return;
        }
        HashMap<IUniquePropertyBeanName, IPersistentField> pfMap = new HashMap<IUniquePropertyBeanName, IPersistentField>(p_fields.length);
        int i2 = 0;
        while (i2 < p_fields.length) {
            String type = StringUtils.removeExtension((String)p_fields[i2].getType(), (boolean)true);
            boolean isArray = false;
            int dimension = 0;
            if (type.endsWith("[]")) {
                isArray = true;
                dimension = EjbEditorInput.getArrayDimension(type);
                type = EjbEditorInput.getTypeNameWithoutArrayBrackets(type);
            }
            IPersistentField pf = EjbMetaDataFactory.createPersistentField(null, p_fields[i2].getName(), type, isArray, dimension);
            pf.setState(1);
            pfMap.put(pf.getUniqueName(), pf);
            if (p_fields[i2].isPKField()) {
                if (this.ejbMetaData.getPrimaryKey() != null && this.ejbMetaData.getPrimaryKey() instanceof ICMP_PrimaryKey) {
                    ((ICMP_PrimaryKey)this.ejbMetaData.getPrimaryKey()).setField(pf);
                } else {
                    this.ejbMetaData.createPrimaryKey(pf);
                }
            }
            ++i2;
        }
        if (pfMap.size() > 0) {
            this.ejbMetaData.setPersistentFields(pfMap);
        }
        if (cmr_Fields != null && cmr_Fields.length > 0) {
            this.initializeCMRFields(cmr_Fields);
        }
    }

    private void initializeCMRFields(IPersistableField[] fields) {
        HashMap<IUniquePropertyBeanName, ICMRField> cmrMap = new HashMap<IUniquePropertyBeanName, ICMRField>(fields.length);
        int i = 0;
        while (i < fields.length) {
            ICMRField cmr = EjbMetaDataFactory.createCMRField(fields[i].getName(), fields[i].getType());
            cmr.setState(1);
            cmrMap.put(cmr.getUniqueName(), cmr);
            ++i;
        }
        if (cmrMap.size() > 0) {
            this.ejbMetaData.setCMRFields(cmrMap);
        }
    }

    private void initializeEjbRelations(Entity ejb) {
        IEntityBean entityBean = (IEntityBean)J2eeElementManager.getEnterpriseJavaBean((Element)ejb);
        IEjbRelation[] selenaRelations = entityBean.getEJBProject().getEjbRelations(entityBean);
        int i = 0;
        while (i < selenaRelations.length) {
            IEjbRelationRole selenaRole1 = selenaRelations[i].getRole1();
            IEjbRelationRole selenaRole2 = selenaRelations[i].getRole2();
            IEjbRelation metaDataRelation = EjbMetaDataFactory.createEjbRelation(selenaRelations[i].getRelationName());
            ((IChangeable)metaDataRelation).setState(1);
            metaDataRelation.setRelationDescription(selenaRelations[i].getRelationDescription());
            if (metaDataRelation != null) {
                IEjbRelationRole metaDataRole1 = EjbMetaDataFactory.createEjbRelationRole();
                ((IChangeable)metaDataRole1).setState(1);
                metaDataRole1.setCardinality(selenaRole1.getCardinality());
                metaDataRole1.setBean(selenaRole1.getBean());
                if (selenaRole1.getCmrField() != null) {
                    ICMRField cmrField1 = EjbMetaDataFactory.createCMRField(selenaRole1.getCmrField().getName(), selenaRole1.getCmrField().getType());
                    cmrField1.setState(1);
                    metaDataRole1.setCmrField(cmrField1);
                }
                IEjbRelationRole metaDataRole2 = EjbMetaDataFactory.createEjbRelationRole();
                ((IChangeable)metaDataRole2).setState(1);
                metaDataRole2.setCardinality(selenaRole2.getCardinality());
                metaDataRole2.setBean(selenaRole2.getBean());
                if (selenaRole2.getCmrField() != null) {
                    ICMRField cmrField2 = EjbMetaDataFactory.createCMRField(selenaRole2.getCmrField().getName(), selenaRole2.getCmrField().getType());
                    cmrField2.setState(1);
                    metaDataRole2.setCmrField(cmrField2);
                }
                metaDataRelation.setRole1(metaDataRole1);
                metaDataRelation.setRole2(metaDataRole2);
            }
            this.ejbMetaData.setEjbRelation(metaDataRelation);
            ++i;
        }
    }

    public Entity getEntity() {
        return this.selectedEjbEntity;
    }

    public String getFactoryId() {
        return EDITORINPUT_FACTORY_ID;
    }

    public void saveState(IMemento memento) {
        if (this.ejbMetaData != null) {
            String prjName = this.ejbMetaData.getEjbProjectName();
            String beanName = this.ejbMetaData.getBeanclassName();
            memento.putString(PERSKEY_PROJECTNAME, prjName);
            memento.putString(PERSKEY_BEANNAME, beanName);
        }
    }

    private void setParticipantRelations() {
        IBusinessMethod bMethod;
        boolean hasParticipants;
        Iterator it;
        ArrayList<IBusinessMethod> bms;
        FieldBean element;
        List businessMethods = this.ejbMetaData.getBusinessMethods();
        Iterator persistentFields = this.ejbMetaData.getPersistentFields().values().iterator();
        Iterator cmrFields = this.ejbMetaData.getCMRFields().values().iterator();
        while (persistentFields.hasNext()) {
            element = (PersistentFieldBean)persistentFields.next();
            bms = new ArrayList<IBusinessMethod>();
            it = businessMethods.iterator();
            hasParticipants = false;
            while (it.hasNext()) {
                bMethod = (IBusinessMethod)it.next();
                if (!bMethod.getName().equalsIgnoreCase("get" + element.getName()) && !bMethod.getName().equalsIgnoreCase("set" + element.getName())) continue;
                bMethod.setAsParticipant(element);
                bms.add(bMethod);
                if (bms.size() != 2) continue;
                hasParticipants = true;
                break;
            }
            if (!hasParticipants) continue;
            element.setAllParticipatingMethods(bms.toArray(new IBusinessMethod[0]));
        }
        while (cmrFields.hasNext()) {
            element = (CMRFieldBean)cmrFields.next();
            bms = new ArrayList();
            it = businessMethods.iterator();
            hasParticipants = false;
            while (it.hasNext()) {
                bMethod = (IBusinessMethod)it.next();
                if (!bMethod.getName().equalsIgnoreCase("get" + element.getName()) && !bMethod.getName().equalsIgnoreCase("set" + element.getName())) continue;
                bMethod.setAsParticipant(element);
                bms.add(bMethod);
                if (bms.size() != 2) continue;
                hasParticipants = true;
                break;
            }
            if (!hasParticipants) continue;
            element.setAllParticipatingMethods(bms.toArray(new IBusinessMethod[0]));
        }
    }

    private static int getArrayDimension(String typeWithArrayBrackets) {
        int dim = 0;
        if (typeWithArrayBrackets != null && !typeWithArrayBrackets.equals("") && typeWithArrayBrackets.endsWith("[]")) {
            String arrayBrackets = typeWithArrayBrackets.substring(typeWithArrayBrackets.indexOf("[]"), typeWithArrayBrackets.length());
            dim = arrayBrackets.length() / 2;
        } else {
            tracer.error("getTypeArrayDimension(String)", "Wrong input parameter.");
        }
        return dim;
    }

    private static String getTypeNameWithoutArrayBrackets(String typeWithArrayBrackets) {
        String type = null;
        if (typeWithArrayBrackets != null && !typeWithArrayBrackets.equals("")) {
            type = typeWithArrayBrackets.substring(0, typeWithArrayBrackets.indexOf("[]"));
        }
        return type;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

