/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.ejb.editor;

import com.tssap.j2ee.model.IChangeable;
import com.tssap.j2ee.model.IJ2eeProject;
import com.tssap.j2ee.model.J2eeElementManager;
import com.tssap.j2ee.model.ejb.IEjbRelation;
import com.tssap.j2ee.model.ejb.IEnterpriseJavaBean;
import com.tssap.j2ee.model.ejb.IEntityBean;
import com.tssap.j2ee.model.ejbjar.IEjbAssemblyProject;
import com.tssap.j2ee.ui.UIPlugin;
import com.tssap.j2ee.ui.ejb.components.IEjbMetaData;
import com.tssap.j2ee.ui.ejb.components.IEjbMetaDataExchange;
import com.tssap.j2ee.ui.ejb.editor.EjbEditorInput;
import com.tssap.j2ee.ui.ejb.editor.IEjbEditor;
import com.tssap.j2ee.ui.ejb.editor.IEjbEditorInput;
import com.tssap.j2ee.ui.ejb.editor.MultiPageCompilationUnitEditor;
import com.tssap.j2ee.ui.ejb.editor.internal.EjbEditorInputWrapper;
import com.tssap.j2ee.ui.ejb.editor.internal.EjbMetaDataWrapper;
import com.tssap.j2ee.ui.ejb.editor.internal.IPropertyChangeCheckable;
import com.tssap.j2ee.ui.ejb.editor.internal.PropertyChangeCheckablePage;
import com.tssap.j2ee.ui.ejb.editor.internal.UpdateSelenaEntity;
import com.tssap.j2ee.ui.ejb.editor.internal.pages.EjbEditorBeanCorruptedPage;
import com.tssap.j2ee.ui.ejb.editor.internal.pages.EjbEditorPage;
import com.tssap.j2ee.ui.ejb.editor.internal.pages.EjbEditorPageWithTreeSelector;
import com.tssap.j2ee.ui.ejb.editor.internal.pages.OverviewPage;
import com.tssap.j2ee.ui.ejb.editor.internal.pages.cmr.EjbCmrPage;
import com.tssap.j2ee.ui.ejb.editor.internal.pages.fields.EjbFieldsPage;
import com.tssap.j2ee.ui.ejb.editor.internal.pages.methods.EjbMethodsPage;
import com.tssap.j2ee.ui.ejb.util.EjbUtil;
import com.tssap.j2ee.ui.util.vcs.dtr.DTRUtils;
import com.tssap.j2ee.util.file.FileStateUtil;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.ModelDeltaNode;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.update.diagram.DispatchedTreeDeltaListener;
import com.tssap.selena.model.update.hierarchy.DeltaDispatcher;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.IEditable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;

public class EjbEditor
extends MultiPageEditorPart
implements IResourceChangeListener,
IPropertyChangeListener,
DispatchedTreeDeltaListener,
IPropertyListener,
IEjbEditor {
    public static final int OVERVIEW_PAGE = 4;
    public static final int METHODS_PAGE = 5;
    public static final int FIELDS_PAGE = 6;
    public static final int PERSISTENT_FIELD_PAGE = 7;
    public static final int CMR_PAGE = 8;
    public static final int METHODS_PAGE_INDEX = 1;
    public static final int FIELDS_PAGE_INDEX = 2;
    private static final int[] BMP_BEAN_SEMANTIC_PAGES = new int[]{4, 5, 6};
    private static final int[] CMP_BEAN_SEMANTIC_PAGES = new int[]{4, 5, 6, 8};
    private static final int[] STATELESS_SESSION_BEAN_SEMANTIC_PAGES = new int[]{4, 5};
    private static final int[] STATEFUL_SESSION_BEAN_SEMANTIC_PAGES = new int[]{4, 5};
    private static final int[] MESSAGE_DRIVEN_BEAN_SEMANTIC_PAGES = new int[]{4, 5};
    private static final String OVERVIEWPAGETITLE = "Overview";
    private static final String BEANCLASSPAGETITLE = "Bean";
    public static final String EJBEDITOR_ID = "com.tssap.j2ee.ui.editor.ejbeditor";
    private static TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$ejb$editor$EjbEditor == null ? (class$com$tssap$j2ee$ui$ejb$editor$EjbEditor = EjbEditor.class$("com.tssap.j2ee.ui.ejb.editor.EjbEditor")) : class$com$tssap$j2ee$ui$ejb$editor$EjbEditor));
    private IEjbMetaDataExchange ejbMetaDataExchange;
    private IEnterpriseJavaBean ejb = null;
    private int currentPageIndex = 0;
    private IEditorPart[] semanticEditorParts = new IEditorPart[0];
    private IEditorPart[] sourceEditorParts = new IEditorPart[0];
    private DeltaDispatcher deltaDispatcher = null;
    private IEditorPart mBeanClassEditor = null;
    private boolean saveMode = false;
    private int errorPageIndex = -1;
    private int preErrorPageIndex = -1;
    private EjbEditorBeanCorruptedPage errorPage;
    private boolean mIsEditable = true;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$ejb$editor$EjbEditor;

    public IEditorInput getEditorInput() {
        IEditorInput input = super.getEditorInput();
        return input instanceof EjbEditorInputWrapper ? ((EjbEditorInputWrapper)input).getWrappedInput() : new EjbEditorInputWrapper((EjbEditorInput)input);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof IEjbEditorInput)) {
            throw new PartInitException("Invalid Input");
        }
        IEjbEditorInput ejbEditorInput = (IEjbEditorInput)input;
        super.init(site, input);
        this.initializeEjbData(ejbEditorInput);
        this.registerListener();
    }

    private void registerListener() {
        this.deltaDispatcher = DeltaDispatcher.getInstance((UniqueName)this.ejb.getSelenaEntity().getModel().getUniqueName());
        this.deltaDispatcher.registerListener((Element)this.ejb.getSelenaEntity(), (DispatchedTreeDeltaListener)this);
        UIPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 2);
    }

    protected void createPages() {
        this.createSemanticPages();
        Vector<IEditorPart> vec = new Vector<IEditorPart>();
        try {
            this.mBeanClassEditor = this.openSourceFileInEditor(this.getEjb().getBeanClass(), BEANCLASSPAGETITLE);
            this.mBeanClassEditor.addPropertyListener((IPropertyListener)this);
            vec.add(this.mBeanClassEditor);
        }
        catch (Exception e) {
            tracer.error("createPages()", "Not able to open Beanclass Sourcefile", (Throwable)e);
            return;
        }
        IEditorPart[] parts = vec.toArray(this.sourceEditorParts);
        this.setSourceEditorParts(parts);
        this.updateEditableBehavior();
    }

    private MultiPageCompilationUnitEditor openSourceFileInEditor(IType source, String title) throws Exception {
        MultiPageCompilationUnitEditor ret = null;
        ret = new MultiPageCompilationUnitEditor();
        int index = this.addPage((IEditorPart)ret, (IEditorInput)new FileEditorInput((IFile)source.getResource()));
        this.setPageText(index, title);
        return ret;
    }

    private boolean isEditable() {
        ArrayList<IFile> participants = new ArrayList<IFile>();
        this.mIsEditable = false;
        try {
            participants.add(this.ejb.getEjbModule().getDescriptorLocation());
            participants.addAll(Arrays.asList(EjbUtil.getSourceFilesForEjb(this.ejb)));
            if (participants.size() > 0 && FileStateUtil.allFilesWritable((IResource[])participants.toArray(new IFile[0]))) {
                this.mIsEditable = true;
            }
        }
        catch (Exception e) {
            tracer.log(4, "check for ejb participants file state failed", (Throwable)e);
            try {
                this.mIsEditable = this.ejb.getBeanClass().getResource().isReadOnly();
            }
            catch (RuntimeException e1) {
                tracer.log(4, "check for beanclass filestate failed", (Throwable)e1);
            }
        }
        return this.mIsEditable;
    }

    public void doSave(IProgressMonitor monitor) {
        this.refreshSemanticEditorParts();
        IEditorPart[] semanticEditorParts = this.getSemanticEditorParts();
        this.saveMode = true;
        if (semanticEditorParts != null) {
            int i = 0;
            while (i < semanticEditorParts.length) {
                if (semanticEditorParts[i] != null && semanticEditorParts[i] instanceof EjbEditorPageWithTreeSelector) {
                    if (((EjbEditorPageWithTreeSelector)semanticEditorParts[i]).validatePageContent().isError()) {
                        MessageDialog.openError((Shell)UIPlugin.getShell(), (String)"Save Editor", (String)("Invalid Content on " + semanticEditorParts[i].getTitle() + " [ page ]" + ", please correct before saving. ==> " + ((EjbEditorPageWithTreeSelector)semanticEditorParts[i]).validatePageContent().getMessage()));
                        this.setDirtyFlag(true);
                        if (semanticEditorParts[i] instanceof EjbMethodsPage) {
                            this.setActivePage(1);
                        } else if (semanticEditorParts[i] instanceof EjbFieldsPage) {
                            this.setActivePage(2);
                        }
                        this.saveMode = false;
                        return;
                    }
                    if (((EjbEditorPageWithTreeSelector)semanticEditorParts[i]).validatePageContent().isWarning()) {
                        boolean doSave = MessageDialog.openQuestion((Shell)UIPlugin.getShell(), (String)"Save Editor", (String)("The entries on [ " + semanticEditorParts[i].getTitle() + " ] page can lead to compilation problems.\nReason: " + ((EjbEditorPageWithTreeSelector)semanticEditorParts[i]).validatePageContent().getMessage() + "\nDo you really want to save?"));
                        if (!doSave) {
                            this.setDirtyFlag(true);
                            this.saveMode = false;
                            return;
                        }
                        this.setDirtyFlag(false);
                        this.saveMode = true;
                    }
                    if (semanticEditorParts[i] instanceof EjbCmrPage && this.ejb instanceof IEntityBean && !this.checkFilestateForRelationUpdate()) {
                        this.setDirtyFlag(true);
                        this.saveMode = false;
                        return;
                    }
                }
                ++i;
            }
        }
        if (this.areMethodPagesDirty() && !this.saveSemanticData()) {
            this.saveMode = false;
            return;
        }
        if (this.areSourceEditorsDirty()) {
            this.saveSourceEditors(monitor);
        }
        this.saveMode = false;
    }

    private boolean checkFilestateForRelationUpdate() {
        IEjbRelation[] allRelations = this.ejbMetaDataExchange.getEjbMetaData().getEjbRelations();
        boolean updateRelations = false;
        int j = 0;
        while (j < allRelations.length) {
            IEjbRelation relation = allRelations[j];
            if (relation instanceof IChangeable && !((IChangeable)relation).isUnchanged()) {
                updateRelations = true;
                break;
            }
            ++j;
        }
        if (updateRelations) {
            ArrayList<IFile> relatedEjbJarFiles = new ArrayList<IFile>();
            IJ2eeProject[] j2eeProjects = this.ejb.getEJBProject().getReferencingProjects();
            int j2 = 0;
            while (j2 < j2eeProjects.length) {
                IEjbAssemblyProject ejbAss;
                if (j2eeProjects[j2] instanceof IEjbAssemblyProject && (ejbAss = (IEjbAssemblyProject)j2eeProjects[j2]).getReferencedEjb(this.ejb.getEjbName()) != null) {
                    relatedEjbJarFiles.add(ejbAss.getDescriptorLocation());
                    IFile persistentXML = (IFile)ejbAss.getProject().findMember("META-INF/persistent.xml");
                    IFile engineXML = (IFile)ejbAss.getProject().findMember("META-INF/ejb-j2ee-engine.xml");
                    if (persistentXML != null && persistentXML.exists() && engineXML != null && engineXML.exists()) {
                        relatedEjbJarFiles.add(engineXML);
                        relatedEjbJarFiles.add(persistentXML);
                    }
                }
                ++j2;
            }
            if (relatedEjbJarFiles.size() > 0) {
                return DTRUtils.fileStateCheck((IFile[])relatedEjbJarFiles.toArray(new IFile[0]), (String)"Save EjbRelations", (IProject)this.ejb.getEJBProject().getProject());
            }
        }
        return true;
    }

    private boolean saveSemanticData() {
        this.refreshSemanticEditorParts();
        IEditorPart[] semanticEditorParts = this.getSemanticEditorParts();
        boolean ret = new UpdateSelenaEntity().update(this.getEjbMetaData(), ((IEjbEditorInput)this.getEditorInput()).getEntity());
        int i = 0;
        while (ret && i < semanticEditorParts.length) {
            if (semanticEditorParts[i] != null && semanticEditorParts[i] instanceof IPropertyChangeCheckable) {
                ((IPropertyChangeCheckable)semanticEditorParts[i]).setDirty(false);
            }
            ++i;
        }
        return ret;
    }

    private IEditorPart[] refreshSemanticEditorParts() {
        IEditorPart[] semanticEditorParts = this.getSemanticEditorParts();
        int i = 0;
        while (i < semanticEditorParts.length) {
            if (semanticEditorParts[i] != null && semanticEditorParts[i] instanceof PropertyChangeCheckablePage) {
                ((PropertyChangeCheckablePage)semanticEditorParts[i]).refresh();
            }
            ++i;
        }
        return semanticEditorParts;
    }

    private void saveSourceEditors(IProgressMonitor monitor) {
        IEditorPart[] sourceFileEditorParts = this.getSourceFileEditorParts();
        int i = 0;
        while (i < sourceFileEditorParts.length) {
            if (sourceFileEditorParts[i] != null && sourceFileEditorParts[i].isDirty()) {
                sourceFileEditorParts[i].doSave(monitor);
            }
            try {
                ((IFileEditorInput)sourceFileEditorParts[i].getEditorInput()).getFile().refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                tracer.warning("refresh for source editor failed", (Throwable)e);
            }
            ++i;
        }
    }

    private IEditorPart[] getSourceFileEditorParts() {
        return this.sourceEditorParts;
    }

    private IEditorPart[] getSemanticEditorParts() {
        return this.semanticEditorParts;
    }

    public void doSaveAs() {
    }

    public void gotoMarker(IMarker marker) {
        this.setActivePage(0);
        this.getEditor(0).gotoMarker(marker);
    }

    private boolean areMethodPagesDirty() {
        IEditorPart[] methodAndFileEditorParts = this.getSemanticEditorParts();
        boolean ret = false;
        if (methodAndFileEditorParts != null) {
            int i = 0;
            while (!ret && i < methodAndFileEditorParts.length) {
                if (methodAndFileEditorParts[i] != null && methodAndFileEditorParts[i].isDirty()) {
                    ret = true;
                }
                ++i;
            }
        }
        return ret;
    }

    private boolean areSourceEditorsDirty() {
        IEditorPart[] sourceFileEditorParts = this.getSourceFileEditorParts();
        int i = 0;
        while (i < sourceFileEditorParts.length) {
            if (sourceFileEditorParts[i] != null && sourceFileEditorParts[i].isDirty()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.firePropertyChange(257);
    }

    private void createSemanticPages() {
        int[] pageIndices = this.calculatePageIndices();
        Vector<IEditorPart> vec = new Vector<IEditorPart>();
        int i = 0;
        while (i < pageIndices.length) {
            int index = pageIndices[i];
            IEditorPart editorPart = this.createSemanticPage(index);
            vec.add(editorPart);
            ++i;
        }
        IEditorPart[] parts = vec.toArray(this.semanticEditorParts);
        this.setSemanticEditorParts(parts);
    }

    private int[] calculatePageIndices() {
        int beanType = this.getBeanType();
        int persistenceType = this.getPersistenceType();
        int[] pageIndices = new int[]{};
        if (beanType == 3) {
            pageIndices = MESSAGE_DRIVEN_BEAN_SEMANTIC_PAGES;
        } else if (beanType == 1) {
            pageIndices = STATELESS_SESSION_BEAN_SEMANTIC_PAGES;
        } else if (beanType == 0) {
            pageIndices = STATEFUL_SESSION_BEAN_SEMANTIC_PAGES;
        } else if (beanType == 2) {
            if (persistenceType == 1) {
                pageIndices = BMP_BEAN_SEMANTIC_PAGES;
            } else if (persistenceType == 0) {
                pageIndices = CMP_BEAN_SEMANTIC_PAGES;
            }
        }
        return pageIndices;
    }

    public void propertyChanged(Object source, int propId) {
        this.firePropertyChange(257);
    }

    private void setEjb(IEnterpriseJavaBean ejb) {
        this.ejb = ejb;
    }

    private IEnterpriseJavaBean getEjb() {
        return this.ejb;
    }

    private void setEjbMetaData(IEjbMetaData ejbMetaData) {
        if (this.ejbMetaDataExchange == null) {
            this.ejbMetaDataExchange = new EjbMetaDataWrapper(ejbMetaData);
        } else {
            this.ejbMetaDataExchange.setEjbMetaData(ejbMetaData);
        }
    }

    public IEjbMetaData getEjbMetaData() {
        IEjbMetaData ret = null;
        if (this.ejbMetaDataExchange instanceof IEjbMetaData) {
            ret = (IEjbMetaData)((Object)this.ejbMetaDataExchange);
        }
        return ret;
    }

    private IEditorPart createSemanticPage(int page) {
        EjbEditorPage ret = null;
        String pageTitle = "";
        try {
            switch (page) {
                case 4: {
                    pageTitle = OVERVIEWPAGETITLE;
                    ret = new OverviewPage(this, pageTitle);
                    break;
                }
                case 6: {
                    pageTitle = "Fields";
                    ret = new EjbFieldsPage(this);
                    break;
                }
                case 5: {
                    pageTitle = "Methods";
                    ret = new EjbMethodsPage(this);
                    break;
                }
                case 8: {
                    pageTitle = "Relations";
                    ret = new EjbCmrPage(this);
                    break;
                }
                default: {
                    tracer.log(4, "Wrong page specified");
                    break;
                }
            }
        }
        catch (RuntimeException e) {
            tracer.error("createMethodsPage()", "Not able to create Method or Field Page for Editor", (Throwable)e);
            return ret;
        }
        Composite composite = new Composite(this.getContainer(), 0);
        composite.setLayout((Layout)new FillLayout());
        int index = this.addPage((Control)composite);
        this.setPageText(index, pageTitle);
        ret.createPartControl(composite);
        return ret;
    }

    private int getBeanType() {
        int ret = this.getEjbMetaData().getEjbType();
        return ret;
    }

    private int getPersistenceType() {
        int ret = this.getEjbMetaData().getPersistenceType();
        return ret;
    }

    protected void pageChange(int newPageIndex) {
        if (this.errorPageIndex != -1 && !this.isPageAllowedOnError(newPageIndex)) {
            this.setActivePage(this.getCurrentPageIndex());
            MessageDialog.openInformation((Shell)this.getSite().getShell(), (String)"Ejb Editor", (String)"The underlying bean is corrupt. Please repair the bean first.");
            return;
        }
        if (this.isDirty()) {
            if (!MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)"Ejb Editor", (String)"Do you want to save your changes?\n Otherwise pages cannot be changed, to keep consistency")) {
                this.setActivePage(this.getCurrentPageIndex());
                return;
            }
            this.doSave((IProgressMonitor)new NullProgressMonitor());
        }
        IEditorPart[] semanticEditorParts = this.getSemanticEditorParts();
        if (!this.isDirty()) {
            int indx = this.getCurrentPageIndex();
            IEditorPart editorPart = null;
            if (indx >= 0 && indx <= this.getPageCount()) {
                if (this.getEditor(indx) != null) {
                    editorPart = this.getEditor(indx);
                } else if (indx < semanticEditorParts.length) {
                    editorPart = semanticEditorParts[indx];
                }
                if (editorPart instanceof EjbEditorPageWithTreeSelector) {
                    ((EjbEditorPageWithTreeSelector)editorPart).deselectTree();
                }
            }
            super.pageChange(newPageIndex);
            this.setCurrentPageIndex(newPageIndex);
        }
    }

    private boolean isPageAllowedOnError(int newPageIndex) {
        boolean ret = newPageIndex == this.errorPageIndex;
        ret = newPageIndex == this.getPageIndex(4) || newPageIndex == this.errorPageIndex || newPageIndex == this.calculatePageIndices().length;
        return ret;
    }

    private int getPageIndex(int pageType) {
        int[] pageIndices = this.calculatePageIndices();
        int pageIndex = Arrays.binarySearch(pageIndices, pageType);
        return pageIndex;
    }

    private void setCurrentPageIndex(int previousPageIndex) {
        this.currentPageIndex = previousPageIndex;
    }

    private int getCurrentPageIndex() {
        return this.currentPageIndex;
    }

    public void setDirtyFlag(boolean isDirty) {
        this.firePropertyChange(257);
    }

    public void activateOverviewPage() {
        int[] pageIndices = this.calculatePageIndices();
        int pageIndex = Arrays.binarySearch(pageIndices, 4);
        if (pageIndex >= 0) {
            this.setActivePage(pageIndex);
        }
    }

    public void activateMethodsPage() {
        int[] pageIndices = this.calculatePageIndices();
        int pageIndex = Arrays.binarySearch(pageIndices, 5);
        if (pageIndex >= 0) {
            this.setActivePage(pageIndex);
        }
    }

    public void activateFieldsPage() {
        int[] pageIndices = this.calculatePageIndices();
        int pageIndex = Arrays.binarySearch(pageIndices, 6);
        if (pageIndex >= 0) {
            this.setActivePage(pageIndex);
        }
    }

    public void activateRelationsPage() {
        int[] pageIndices = this.calculatePageIndices();
        int pageIndex = Arrays.binarySearch(pageIndices, 8);
        if (pageIndex >= 0) {
            this.setActivePage(pageIndex);
        }
    }

    public boolean isDirty() {
        boolean ret = super.isDirty();
        ret = ret || this.areMethodPagesDirty();
        return ret;
    }

    public void setSemanticEditorParts(IEditorPart[] methodAndFileEditorParts) {
        this.semanticEditorParts = methodAndFileEditorParts;
    }

    public void setSourceEditorParts(IEditorPart[] sourceEditorParts) {
        this.sourceEditorParts = sourceEditorParts;
    }

    private void updateSemanticPages() {
        IEnterpriseJavaBean bean = J2eeElementManager.getEnterpriseJavaBean((Element)this.ejb.getSelenaEntity());
        String beanOk = EjbUtil.checkEjb(bean, false);
        if (beanOk != null) {
            this.createErrorPage(beanOk);
            return;
        }
        this.removeErrorPage();
        try {
            this.setEjbMetaData(new EjbEditorInput((Element)this.ejb.getSelenaEntity()).getEjbMetaData());
        }
        catch (Exception e1) {
            tracer.error("update semantic pages failed", (Throwable)e1);
            this.createErrorPage("Not able to update EJB");
            return;
        }
        this.setTitle(this.getEjbMetaData().getDefaultEjbName());
        IEditorPart[] editors = this.getSemanticEditorParts();
        int i = 0;
        while (i < editors.length) {
            if (editors[i] instanceof EjbEditorPage) {
                try {
                    ((EjbEditorPage)editors[i]).update(this.getEjbMetaData());
                }
                catch (SWTException e) {
                    tracer.warning("updateSemanticPages()", "Error on updating page \"" + editors[i].getTitle() + "\"", (Throwable)e);
                }
            }
            ++i;
        }
    }

    protected void updateEditableBehavior() {
        boolean editable = this.isEditable();
        this.setEditable(editable);
    }

    private void setEditable(boolean editable) {
        IEditorPart[] editors = this.getSemanticEditorParts();
        int i = 0;
        while (i < editors.length) {
            if (editors[i] instanceof IEditable) {
                ((IEditable)editors[i]).setEditable(editable);
            }
            ++i;
        }
    }

    private void removeErrorPage() {
        if (this.errorPage != null) {
            int index = this.errorPageIndex;
            this.errorPageIndex = -1;
            this.setActivePage(0);
            this.removePage(index);
            this.errorPage = null;
            this.setActivePage(this.preErrorPageIndex >= 0 ? this.preErrorPageIndex : 0);
            this.setCurrentPageIndex(this.getActivePage());
        }
    }

    private void createErrorPage(String beanOk) {
        if (this.errorPage == null) {
            this.preErrorPageIndex = this.getActivePage();
            this.errorPage = new EjbEditorBeanCorruptedPage(beanOk);
            this.errorPageIndex = this.addPage(this.errorPage.createPartControl(this.getContainer()));
            this.setPageText(this.errorPageIndex, "Error");
            if (!this.isPageAllowedOnError(this.preErrorPageIndex)) {
                this.setActivePage(this.errorPageIndex);
                this.setCurrentPageIndex(this.errorPageIndex);
            }
        } else {
            this.errorPage.setMsgTxt(beanOk);
        }
    }

    public void modelChanged(ModelDeltaNode changeEvent) {
        if (changeEvent.isDeleted()) {
            this.disposeEditor(true);
        } else if (changeEvent.isChanged() || changeEvent.changedChildren().hasMoreElements()) {
            if (this.saveMode || !this.isDirty()) {
                this.updateSemanticPages();
            } else if (MessageDialog.openQuestion((Shell)UIPlugin.getShell(), (String)"Ejb changed", (String)"Ejb has been changed, do you want to load the changes")) {
                this.updateSemanticPages();
            }
        }
    }

    public void disposeEditor(boolean showDiag) {
        this.removeListener();
        if (showDiag) {
            MessageDialog.openWarning((Shell)UIPlugin.getShell(), (String)"Close EjbEditor", (String)"Ejb has been deleted or renamed, editor will be closed");
        }
        if (this.getSite() != null && this.getSite().getPage() != null) {
            this.getSite().getPage().closeEditor((IEditorPart)this, true);
        }
    }

    private void initializeEjbData(IEjbEditorInput input) {
        IEnterpriseJavaBean ejb = J2eeElementManager.getEnterpriseJavaBean((Element)input.getEntity());
        this.setEjb(ejb);
        IEjbMetaData ejbMetaData = input.getEjbMetaData();
        this.setEjbMetaData(ejbMetaData);
        this.setTitle(ejbMetaData.getDefaultEjbName());
    }

    public void dispatchingChainCorrupted(ModelDeltaNode arg0) {
    }

    public void dispose() {
        this.removeListener();
        super.dispose();
    }

    private void removeListener() {
        if (this.ejb != null && this.ejb.getSelenaEntity() != null) {
            this.deltaDispatcher.removeListener(this.ejb.getSelenaEntity().getUniqueName(), (DispatchedTreeDeltaListener)this);
        }
        if (this.mBeanClassEditor != null) {
            this.mBeanClassEditor.removePropertyListener((IPropertyListener)this);
        }
        UIPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public void setFocus() {
        try {
            if (this.ejb == null || this.ejb.getEJBProject() == null) {
                MessageDialog.openWarning((Shell)UIPlugin.getShell(), (String)"Close EjbEditor", (String)"EjbProject has been deleted or renamed, please close the editor");
                this.setEditable(false);
                return;
            }
        }
        catch (Exception e) {
            tracer.log(4, "EjbProject has been deleted or renamed", (Throwable)e);
            MessageDialog.openWarning((Shell)UIPlugin.getShell(), (String)"Close EjbEditor", (String)"EjbProject has been deleted or renamed, please close the editor");
            this.setEditable(false);
            return;
        }
        super.setFocus();
        boolean formerEditable = this.mIsEditable;
        if (formerEditable == this.isEditable()) {
            return;
        }
        this.updateEditableBehavior();
    }

    public static TracerI getTracer() {
        return tracer;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getResource().equals((Object)this.getEjb().getEJBProject().getProject())) {
            Display display = this.getSite().getShell().getDisplay();
            EjbEditor thisEditor = this;
            display.syncExec(new Runnable((IEditorPart)thisEditor){
                private final /* synthetic */ IEditorPart val$thisEditor;
                {
                    this.val$thisEditor = val$thisEditor;
                }

                public void run() {
                    EjbEditor.this.getSite().getPage().closeEditor(this.val$thisEditor, false);
                }
            });
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

