/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.ejb.core.pages;

import com.tssap.j2ee.ui.core.listener.ButtonEvAdapter;
import com.tssap.j2ee.ui.ejb.components.IEjbMetaData;
import com.tssap.j2ee.ui.ejb.core.IStatusCallback;
import com.tssap.j2ee.ui.ejb.core.pages.EJBInterfaceEventHandler;
import com.tssap.j2ee.ui.ejb.wizard.internal.pages.EjbWizardUtil;
import com.tssap.j2ee.ui.util.UILayerUtils;
import com.tssap.j2ee.util.core.StatusWrapper;
import com.tssap.j2ee.util.core.StringUtilException;
import com.tssap.j2ee.util.core.StringUtils;
import com.tssap.j2ee.util.jdt.JDTUtils;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public final class EjbInterfacesPage {
    private static final TracerI TRACER = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$ejb$core$pages$EjbInterfacesPage == null ? (class$com$tssap$j2ee$ui$ejb$core$pages$EjbInterfacesPage = EjbInterfacesPage.class$("com.tssap.j2ee.ui.ejb.core.pages.EjbInterfacesPage")) : class$com$tssap$j2ee$ui$ejb$core$pages$EjbInterfacesPage));
    public static final String INTERFACES_SELECTION = "Interfaces have been selected/deselected";
    private IStatusCallback statusCallback = null;
    private EJBInterfaceEventHandler eventHandler = null;
    private Status pageComplete = null;
    private IEjbMetaData ejbData;
    private Shell shell = null;
    private IRunnableContext ctx = null;
    private StatusWrapper beanclassStatus = null;
    private StatusWrapper remoteifStatus = null;
    private StatusWrapper homeifStatus = null;
    private StatusWrapper localifStatus = null;
    private StatusWrapper localHomeifStatus = null;
    private String originalBeanClassName = null;
    private IJavaElement currentBean = null;
    private IJavaElement currentRemoteIF = null;
    private IJavaElement currentHomeIF = null;
    private IJavaElement currentLocalIF = null;
    private IJavaElement currentLocalHomeIF = null;
    private IGridLayoutPane layout = null;
    private int horizontalSpan = 4;
    private int verticalSpan = 1;
    private Text mBeanClassText = null;
    private Text mRemoteIFText = null;
    private Text mHomeIFText = null;
    private Text mLocalIFText = null;
    private Text mLocalHomeIFText = null;
    private Label mRemoteIFLabel = null;
    private Label mHomeIFLabel = null;
    private Label mLocalHomeIFLabel = null;
    private Label mLocalIFLabel = null;
    private Button mBeanClassBrowse = null;
    private Button mRemoteIFBrowse = null;
    private Button mHomeIFBrowse = null;
    private Button mLocalHomeIFBrowse = null;
    private Button mLocalIFBrowse = null;
    private Button mBeanClassClass = null;
    private Button mRemoteIFClass = null;
    private Button mHomeIFClass = null;
    private Button mLocalIFClass = null;
    private Button mLocalHomeIFClass = null;
    private Button mComponentIFCheckbox = null;
    private Button mLocalIFCheckbox = null;
    private IPackageFragmentRoot[] pkgRoots = null;
    private IJavaProject jPrj = null;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$ejb$core$pages$EjbInterfacesPage;

    public EjbInterfacesPage(IEjbMetaData ejbData, IStatusCallback statusCallback) {
        this.ejbData = ejbData;
        this.statusCallback = statusCallback;
        this.originalBeanClassName = ejbData.getBeanclassName();
        if (this.originalBeanClassName != null && this.originalBeanClassName.lastIndexOf(".java") < 0) {
            this.originalBeanClassName = this.originalBeanClassName + ".java";
        }
        this.eventHandler = new EJBInterfaceEventHandler(this);
        this.pkgRoots = ejbData.getPackageRoots();
        if (this.pkgRoots == null) {
            try {
                this.jPrj = ejbData.getBeanPackage().getJavaProject();
                if (this.jPrj != null) {
                    this.pkgRoots = this.jPrj.getPackageFragmentRoots();
                }
            }
            catch (JavaModelException e) {
                TRACER.error("", (Throwable)e);
            }
        }
        if (ejbData.getBeanclassName() == null) {
            EjbWizardUtil.createDefaultEntries(ejbData, true, true, true);
        }
    }

    public IGridLayoutPane createContent(Composite parent, Shell parentShell, IRunnableContext ctx) {
        this.shell = parentShell;
        this.ctx = ctx;
        this.layout = PaneFactory.createGridLayoutPane((Composite)parent, (int)this.horizontalSpan);
        this.beanclassStatus = new StatusWrapper(0, "initialized with defaultentries");
        this.remoteifStatus = new StatusWrapper(0, "initialized with defaultentries");
        this.homeifStatus = new StatusWrapper(0, "initialized with defaultentries");
        this.localifStatus = new StatusWrapper(0, "initialized with defaultentries");
        this.localHomeifStatus = new StatusWrapper(0, "initialized with defaultentries");
        this.createBeanclassnameW();
        this.horizontalSpan = 4;
        this.layout.addPlaceholder(this.horizontalSpan, this.verticalSpan);
        this.layout.addHorizontalSeparator();
        this.layout.addPlaceholder(this.horizontalSpan, this.verticalSpan);
        this.createComponentIFCheckbox();
        this.horizontalSpan = 4;
        this.layout.addPlaceholder(this.horizontalSpan, this.verticalSpan);
        this.createRemoteifnameW();
        this.createHomeifnameW();
        this.eventHandler.componentCheckboxChanged(this.mComponentIFCheckbox.getSelection());
        if (this.ejbData.getEjbCompliance() == 1) {
            this.horizontalSpan = 4;
            this.layout.addPlaceholder(this.horizontalSpan, this.verticalSpan);
            this.layout.addHorizontalSeparator();
            this.layout.addPlaceholder(this.horizontalSpan, this.verticalSpan);
            this.createLocalIFCheckbox();
            this.horizontalSpan = 4;
            this.layout.addPlaceholder(this.horizontalSpan, this.verticalSpan);
            this.createLocalIfnameW();
            this.createLocalHomeifnameW();
            this.eventHandler.localCheckboxChanged(this.mLocalIFCheckbox.getSelection());
        }
        this.initializeFields();
        return this.layout;
    }

    private final void createBeanclassnameW() {
        this.horizontalSpan = 1;
        this.mBeanClassText = (Text)UILayerUtils.createLabelAndTextfield((IGridLayoutPane)this.layout, (int)4, (int)this.horizontalSpan, (boolean)false, (String)"Bean class:")[1];
        this.mBeanClassText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IType classC;
                String text = ((Text)e.getSource()).getText();
                if (text == null || text.equals("") || !JavaConventions.validateJavaTypeName((String)text).isOK()) {
                    EjbInterfacesPage.this.beanclassStatus.setError("Beanclass: No valid JavaType");
                    EjbInterfacesPage.this.doStatusUpdate(EjbInterfacesPage.this.generateCurrentStatus());
                    return;
                }
                if (text.equals(EjbInterfacesPage.this.ejbData.getBeanclassName())) {
                    EjbInterfacesPage.this.beanclassStatus.setOK();
                    EjbInterfacesPage.this.doStatusUpdate(EjbInterfacesPage.this.generateCurrentStatus());
                    return;
                }
                if (text.equals(EjbInterfacesPage.this.ejbData.getRemoteIFName()) || text.equals(EjbInterfacesPage.this.ejbData.getHomeIFName()) || text.equals(EjbInterfacesPage.this.ejbData.getLocalIFName()) || text.equals(EjbInterfacesPage.this.ejbData.getLocalHomeIFName())) {
                    EjbInterfacesPage.this.beanclassStatus.setError("Beanclass: It's not possible to use same class for different ejb participants");
                    EjbInterfacesPage.this.doStatusUpdate(EjbInterfacesPage.this.generateCurrentStatus());
                    return;
                }
                if (EjbInterfacesPage.this.currentBean != null && text.endsWith(EjbInterfacesPage.this.currentBean.getElementName()) && text.startsWith(EjbInterfacesPage.this.currentBean.getParent().getElementName())) {
                    EjbInterfacesPage.this.beanclassStatus.setOK();
                    EjbInterfacesPage.this.doStatusUpdate(EjbInterfacesPage.this.generateCurrentStatus());
                    return;
                }
                if (text.lastIndexOf(".java") < 0) {
                    text = text + ".java";
                }
                if ((classC = JDTUtils.findJavaClass((String)text, (IJavaProject)EjbInterfacesPage.this.ejbData.getBeanPackage().getJavaProject(), (boolean)true, (boolean)false)) == null) {
                    String className = null;
                    try {
                        className = (String)StringUtils.ClassWithPathString((String)text, (boolean)true).get("CLASS");
                    }
                    catch (StringUtilException sue) {
                        String msg = "Beanclass: No valid JavaType";
                        TRACER.error(msg, (Throwable)sue);
                        EjbInterfacesPage.this.beanclassStatus.setError(msg);
                        ErrorDialog.openError((Shell)EjbInterfacesPage.this.shell, (String)"ERROR", (String)msg, (IStatus)EjbInterfacesPage.this.beanclassStatus.getStatusInfo());
                        EjbInterfacesPage.this.doStatusUpdate(EjbInterfacesPage.this.generateCurrentStatus());
                        return;
                    }
                    EjbInterfacesPage.this.eventHandler.beanclassChanged(className, text, EjbInterfacesPage.this.beanclassStatus);
                } else if (text.equals(EjbInterfacesPage.this.originalBeanClassName)) {
                    EjbInterfacesPage.this.eventHandler.beanclassChanged((IJavaElement)classC, 0, EjbInterfacesPage.this.beanclassStatus);
                } else {
                    EjbInterfacesPage.this.beanclassStatus.setError("BeanClass already exists, only rename possible");
                    ErrorDialog.openError((Shell)EjbInterfacesPage.this.shell, (String)"ERROR", (String)"", (IStatus)EjbInterfacesPage.this.beanclassStatus.getStatusInfo());
                    EjbInterfacesPage.this.doStatusUpdate(EjbInterfacesPage.this.generateCurrentStatus());
                    return;
                }
                EjbInterfacesPage.this.doStatusUpdate(EjbInterfacesPage.this.generateCurrentStatus());
            }
        });
        this.mBeanClassBrowse = UILayerUtils.createBrowseButton((IGridLayoutPane)this.layout, (int)1, (String)"Package");
        this.mBeanClassBrowse.addSelectionListener((SelectionListener)new ButtonEvAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IPackageFragment fragment = JDTUtils.choosePackageFromDialog((Shell)EjbInterfacesPage.this.getShell(), (IJavaProject)EjbInterfacesPage.this.ejbData.getBeanPackage().getJavaProject(), (IPackageFragment)EjbInterfacesPage.this.ejbData.getBeanPackage(), (boolean)true);
                if (fragment == null) {
                    return;
                }
                StringBuffer fqn = EjbInterfacesPage.this.createFQName(fragment, false);
                EjbInterfacesPage.this.mBeanClassText.setText(fqn.toString());
                EjbInterfacesPage.this.beanclassStatus.setOK();
                EjbInterfacesPage.this.doStatusUpdate(EjbInterfacesPage.this.generateCurrentStatus());
                EjbInterfacesPage.this.mBeanClassText.setFocus();
            }
        });
        this.mBeanClassClass = UILayerUtils.createBrowseButton((IGridLayoutPane)this.layout, (int)1, (String)"Class");
        this.mBeanClassClass.addSelectionListener((SelectionListener)new ButtonEvAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IType type = JDTUtils.chooseEnclosingType((IPackageFragmentRoot[])EjbInterfacesPage.this.pkgRoots, null, (Shell)EjbInterfacesPage.this.shell, (IRunnableContext)EjbInterfacesPage.this.ctx, (int)2, (IJavaElement)EjbInterfacesPage.this.currentBean);
                if (type == null) {
                    return;
                }
                EjbInterfacesPage.this.eventHandler.beanclassChanged((IJavaElement)type, 0, EjbInterfacesPage.this.beanclassStatus);
                EjbInterfacesPage.this.setBeanClassText(EjbInterfacesPage.this.ejbData.getBeanclassName());
                EjbInterfacesPage.this.doStatusUpdate(EjbInterfacesPage.this.generateCurrentStatus());
            }
        });
        this.mBeanClassClass.setEnabled(false);
    }

    private final void createRemoteifnameW() {
        this.horizontalSpan = 1;
        Object[] LuT = UILayerUtils.createLabelAndTextfield((IGridLayoutPane)this.layout, (int)4, (int)this.horizontalSpan, (boolean)false, (String)"Remote interface:");
        this.mRemoteIFText = (Text)LuT[1];
        this.mRemoteIFLabel = (Label)LuT[0];
        this.mRemoteIFText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IType classC;
                String text = ((Text)e.getSource()).getText();
                if (text == null || text.equals("") || !JavaConventions.validateJavaTypeName((String)text).isOK()) {
                    EjbInterfacesPage.this.remoteifStatus.setError("Remote Interface: No valid JavaType");
                    EjbInterfacesPage.this.doStatusUpdate(EjbInterfacesPage.this.generateCurrentStatus());
                    return;
                }
                if (text.equals(EjbInterfacesPage.this.ejbData.getRemoteIFName())) {
                    EjbInterfacesPage.this.remoteifStatus.setOK();
                    EjbInterfacesPage.this.doStatusUpdate(EjbInterfacesPage.this.generateCurrentStatus());
                    return;
                }
                if (text.equals(EjbInterfacesPage.this.ejbData.getBeanclassName()) || text.equals(EjbInterfacesPage.this.ejbData.getHomeIFName()) || text.equals(EjbInterfacesPage.this.ejbData.getLocalIFName()) || text.equals(EjbInterfacesPage.this.ejbData.getLocalHomeIFName())) {
                    EjbInterfacesPage.this.remoteifStatus.setError("Remote Interface: It's not possible to use same class for different ejb participants");
                    EjbInterfacesPage.this.doStatusUpdate(EjbInterfacesPage.this.generateCurrentStatus());
                    return;
                }
                if (EjbInterfacesPage.this.currentRemoteIF != null && text.endsWith(EjbInterfacesPage.this.currentRemoteIF.getElementName()) && text.startsWith(EjbInterfacesPage.this.currentRemoteIF.getParent().getElementName())) {
                    EjbInterfacesPage.this.remoteifStatus.setOK();
                    EjbInterfacesPage.this.doStatusUpdate(EjbInterfacesPage.this.generateCurrentStatus());
                    return;
                }
                if (text.lastIndexOf(".java") < 0) {
                    text = text + ".java";
                }
                if ((classC = JDTUtils.findJavaClass((String)text, (IJavaProject)EjbInterfacesPage.this.ejbData.getBeanPackage().getJavaProject(), (boolean)false, (boolean)true)) == null) {
                    EjbInterfacesPage.this.eventHandler.remoteIFChanged(text, EjbInterfacesPage.this.remoteifStatus);
                } else {
                    EjbInterfacesPage.this.eventHandler.remoteifChanged((IJavaElement)classC, 0, EjbInterfacesPage.this.remoteifStatus);
                }
                EjbInterfacesPage.this.doStatusUpdate(EjbInterfacesPage.this.generateCurrentStatus());
            }
        });
        this.mRemoteIFBrowse = UILayerUtils.createBrowseButton((IGridLayoutPane)this.layout, (int)1, (String)"Package");
        this.mRemoteIFBrowse.addSelectionListener((SelectionListener)new ButtonEvAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IPackageFragment fragment = JDTUtils.choosePackageFromDialog((Shell)EjbInterfacesPage.this.getShell(), (IJavaProject)EjbInterfacesPage.this.ejbData.getBeanPackage().getJavaProject(), (IPackageFragment)EjbInterfacesPage.this.ejbData.getBeanPackage(), (boolean)true);
                if (fragment == null) {
                    return;
                }
                StringBuffer fqn = EjbInterfacesPage.this.createFQName(fragment, true);
                EjbInterfacesPage.this.mRemoteIFText.setText(fqn.toString());
                EjbInterfacesPage.this.remoteifStatus.setOK();
                EjbInterfacesPage.this.doStatusUpdate(EjbInterfacesPage.this.generateCurrentStatus());
                EjbInterfacesPage.this.mRemoteIFText.setFocus();
            }
        });
        this.mRemoteIFClass = UILayerUtils.createBrowseButton((IGridLayoutPane)this.layout, (int)1, (String)"Class");
        this.mRemoteIFClass.addSelectionListener((SelectionListener)new ButtonEvAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IType type = JDTUtils.chooseEnclosingType((IPackageFragmentRoot[])EjbInterfacesPage.this.pkgRoots, null, (Shell)EjbInterfacesPage.this.shell, (IRunnableContext)EjbInterfacesPage.this.ctx, (int)4, (IJavaElement)EjbInterfacesPage.this.currentRemoteIF);
                if (type == null) {
                    return;
                }
                EjbInterfacesPage.this.eventHandler.remoteifChanged((IJavaElement)type, 0, EjbInterfacesPage.this.remoteifStatus);
                EjbInterfacesPage.this.setRemoteIFText(EjbInterfacesPage.this.ejbData.getRemoteIFName());
                EjbInterfacesPage.this.doStatusUpdate(EjbInterfacesPage.this.generateCurrentStatus());
            }
        });
    }

    private final void createHomeifnameW() {
        this.horizontalSpan = 1;
        Object[] LuT = UILayerUtils.createLabelAndTextfield((IGridLayoutPane)this.layout, (int)4, (int)this.horizontalSpan, (boolean)false, (String)"Home interface:");
        this.mHomeIFText = (Text)LuT[1];
        this.mHomeIFLabel = (Label)LuT[0];
        this.mHomeIFText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IType classC;
                String text = ((Text)e.getSource()).getText();
                if (text == null || text.equals("") || !JavaConventions.validateJavaTypeName((String)text).isOK()) {
                    EjbInterfacesPage.this.homeifStatus.setError("Home Interface: No valid JavaType");
                    EjbInterfacesPage.this.doStatusUpdate(EjbInterfacesPage.this.generateCurrentStatus());
                    return;
                }
                if (text.equals(EjbInterfacesPage.this.ejbData.getHomeIFName())) {
                    EjbInterfacesPage.this.homeifStatus.setOK();
                    EjbInterfacesPage.this.doStatusUpdate(EjbInterfacesPage.this.generateCurrentStatus());
                    return;
                }
                if (text.equals(EjbInterfacesPage.this.ejbData.getRemoteIFName()) || text.equals(EjbInterfacesPage.this.ejbData.getBeanclassName()) || text.equals(EjbInterfacesPage.this.ejbData.getLocalIFName()) || text.equals(EjbInterfacesPage.this.ejbData.getLocalHomeIFName())) {
                    EjbInterfacesPage.this.homeifStatus.setError("Home Interface: It's not possible to use same class for different ejb participants");
                    EjbInterfacesPage.this.doStatusUpdate(EjbInterfacesPage.this.generateCurrentStatus());
                    return;
                }
                if (EjbInterfacesPage.this.currentHomeIF != null && text.endsWith(EjbInterfacesPage.this.currentHomeIF.getElementName()) && text.startsWith(EjbInterfacesPage.this.currentHomeIF.getParent().getElementName())) {
                    EjbInterfacesPage.this.homeifStatus.setOK();
                    EjbInterfacesPage.this.doStatusUpdate(EjbInterfacesPage.this.generateCurrentStatus());
                    return;
                }
                if (text.lastIndexOf(".java") < 0) {
                    text = text + ".java";
                }
                if ((classC = JDTUtils.findJavaClass((String)text, (IJavaProject)EjbInterfacesPage.this.ejbData.getBeanPackage().getJavaProject(), (boolean)false, (boolean)true)) == null) {
                    EjbInterfacesPage.this.eventHandler.homeifChanged(text, EjbInterfacesPage.this.homeifStatus);
                } else {
                    EjbInterfacesPage.this.eventHandler.homeifChanged((IJavaElement)classC, 0, EjbInterfacesPage.this.homeifStatus);
                }
                EjbInterfacesPage.this.doStatusUpdate(EjbInterfacesPage.this.generateCurrentStatus());
            }
        });
        this.mHomeIFBrowse = UILayerUtils.createBrowseButton((IGridLayoutPane)this.layout, (int)1, (String)"Package");
        this.mHomeIFBrowse.addSelectionListener((SelectionListener)new ButtonEvAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IPackageFragment fragment = JDTUtils.choosePackageFromDialog((Shell)EjbInterfacesPage.this.getShell(), (IJavaProject)EjbInterfacesPage.this.ejbData.getBeanPackage().getJavaProject(), (IPackageFragment)EjbInterfacesPage.this.ejbData.getBeanPackage(), (boolean)true);
                if (fragment == null) {
                    return;
                }
                StringBuffer fqn = EjbInterfacesPage.this.createFQName(fragment, true);
                fqn.append("Home");
                EjbInterfacesPage.this.mHomeIFText.setText(fqn.toString());
                EjbInterfacesPage.this.homeifStatus.setOK();
                EjbInterfacesPage.this.doStatusUpdate(EjbInterfacesPage.this.generateCurrentStatus());
                EjbInterfacesPage.this.mHomeIFText.setFocus();
            }
        });
        this.mHomeIFClass = UILayerUtils.createBrowseButton((IGridLayoutPane)this.layout, (int)1, (String)"Class");
        this.mHomeIFClass.addSelectionListener((SelectionListener)new ButtonEvAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IType type = JDTUtils.chooseEnclosingType((IPackageFragmentRoot[])EjbInterfacesPage.this.pkgRoots, null, (Shell)EjbInterfacesPage.this.shell, (IRunnableContext)EjbInterfacesPage.this.ctx, (int)4, (IJavaElement)EjbInterfacesPage.this.currentHomeIF);
                if (type == null) {
                    return;
                }
                EjbInterfacesPage.this.eventHandler.homeifChanged((IJavaElement)type, 0, EjbInterfacesPage.this.homeifStatus);
                EjbInterfacesPage.this.setHomeIFText(EjbInterfacesPage.this.ejbData.getHomeIFName());
                EjbInterfacesPage.this.doStatusUpdate(EjbInterfacesPage.this.generateCurrentStatus());
            }
        });
    }

    private final void createLocalIfnameW() {
        this.horizontalSpan = 1;
        Object[] lAndT = UILayerUtils.createLabelAndTextfield((IGridLayoutPane)this.layout, (int)4, (int)this.horizontalSpan, (boolean)false, (String)"Local interface:");
        this.mLocalIFText = (Text)lAndT[1];
        this.mLocalIFLabel = (Label)lAndT[0];
        this.mLocalIFText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IType classC;
                String text = ((Text)e.getSource()).getText();
                if (text == null || text.equals("") || !JavaConventions.validateJavaTypeName((String)text).isOK()) {
                    EjbInterfacesPage.this.localifStatus.setError("Local Interface: No valid JavaType");
                    EjbInterfacesPage.this.doStatusUpdate(EjbInterfacesPage.this.generateCurrentStatus());
                    return;
                }
                if (text.equals(EjbInterfacesPage.this.ejbData.getLocalIFName())) {
                    EjbInterfacesPage.this.localifStatus.setOK();
                    EjbInterfacesPage.this.doStatusUpdate(EjbInterfacesPage.this.generateCurrentStatus());
                    return;
                }
                if (text.equals(EjbInterfacesPage.this.ejbData.getRemoteIFName()) || text.equals(EjbInterfacesPage.this.ejbData.getHomeIFName()) || text.equals(EjbInterfacesPage.this.ejbData.getBeanclassName()) || text.equals(EjbInterfacesPage.this.ejbData.getLocalHomeIFName())) {
                    EjbInterfacesPage.this.localifStatus.setError("Local Interfaces: It's not possible to use same class for different ejb participants");
                    EjbInterfacesPage.this.doStatusUpdate(EjbInterfacesPage.this.generateCurrentStatus());
                    return;
                }
                if (EjbInterfacesPage.this.currentLocalIF != null && text.endsWith(EjbInterfacesPage.this.currentLocalIF.getElementName()) && text.startsWith(EjbInterfacesPage.this.currentLocalIF.getParent().getElementName())) {
                    EjbInterfacesPage.this.localifStatus.setOK();
                    EjbInterfacesPage.this.doStatusUpdate(EjbInterfacesPage.this.generateCurrentStatus());
                    return;
                }
                if (text.lastIndexOf(".java") < 0) {
                    text = text + ".java";
                }
                if ((classC = JDTUtils.findJavaClass((String)text, (IJavaProject)EjbInterfacesPage.this.ejbData.getBeanPackage().getJavaProject(), (boolean)false, (boolean)true)) == null) {
                    EjbInterfacesPage.this.eventHandler.localifChanged(text, EjbInterfacesPage.this.localifStatus);
                } else {
                    EjbInterfacesPage.this.eventHandler.localifChanged((IJavaElement)classC, 0, EjbInterfacesPage.this.localifStatus);
                }
                EjbInterfacesPage.this.doStatusUpdate(EjbInterfacesPage.this.generateCurrentStatus());
            }
        });
        this.mLocalIFBrowse = UILayerUtils.createBrowseButton((IGridLayoutPane)this.layout, (int)1, (String)"Package");
        this.mLocalIFBrowse.addSelectionListener((SelectionListener)new ButtonEvAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IPackageFragment fragment = JDTUtils.choosePackageFromDialog((Shell)EjbInterfacesPage.this.getShell(), (IJavaProject)EjbInterfacesPage.this.ejbData.getBeanPackage().getJavaProject(), (IPackageFragment)EjbInterfacesPage.this.ejbData.getBeanPackage(), (boolean)true);
                if (fragment == null) {
                    return;
                }
                StringBuffer fqn = EjbInterfacesPage.this.createFQName(fragment, true);
                fqn.append("Local");
                EjbInterfacesPage.this.mLocalIFText.setText(fqn.toString());
                EjbInterfacesPage.this.doStatusUpdate(EjbInterfacesPage.this.generateCurrentStatus());
                EjbInterfacesPage.this.mLocalIFText.setFocus();
            }
        });
        this.mLocalIFClass = UILayerUtils.createBrowseButton((IGridLayoutPane)this.layout, (int)1, (String)"Class");
        this.mLocalIFClass.addSelectionListener((SelectionListener)new ButtonEvAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IType type = JDTUtils.chooseEnclosingType((IPackageFragmentRoot[])EjbInterfacesPage.this.pkgRoots, null, (Shell)EjbInterfacesPage.this.shell, (IRunnableContext)EjbInterfacesPage.this.ctx, (int)4, (IJavaElement)EjbInterfacesPage.this.currentLocalIF);
                if (type == null) {
                    return;
                }
                EjbInterfacesPage.this.eventHandler.localifChanged((IJavaElement)type, 0, EjbInterfacesPage.this.localifStatus);
                EjbInterfacesPage.this.setLocalIFText(EjbInterfacesPage.this.ejbData.getLocalIFName());
                EjbInterfacesPage.this.doStatusUpdate(EjbInterfacesPage.this.generateCurrentStatus());
            }
        });
    }

    private final void createLocalHomeifnameW() {
        this.horizontalSpan = 1;
        Object[] lAndT = UILayerUtils.createLabelAndTextfield((IGridLayoutPane)this.layout, (int)4, (int)this.horizontalSpan, (boolean)false, (String)"LocalHome interface:");
        this.mLocalHomeIFText = (Text)lAndT[1];
        this.mLocalHomeIFLabel = (Label)lAndT[0];
        this.mLocalHomeIFText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IType classC;
                String text = ((Text)e.getSource()).getText();
                if (text == null || text.equals("") || !JavaConventions.validateJavaTypeName((String)text).isOK()) {
                    EjbInterfacesPage.this.localHomeifStatus.setError("Local Homeinterface: No valid JavaType");
                    EjbInterfacesPage.this.doStatusUpdate(EjbInterfacesPage.this.generateCurrentStatus());
                    return;
                }
                if (text.equals(EjbInterfacesPage.this.ejbData.getLocalHomeIFName())) {
                    EjbInterfacesPage.this.localHomeifStatus.setOK();
                    EjbInterfacesPage.this.doStatusUpdate(EjbInterfacesPage.this.generateCurrentStatus());
                    return;
                }
                if (text.equals(EjbInterfacesPage.this.ejbData.getRemoteIFName()) || text.equals(EjbInterfacesPage.this.ejbData.getHomeIFName()) || text.equals(EjbInterfacesPage.this.ejbData.getLocalIFName()) || text.equals(EjbInterfacesPage.this.ejbData.getBeanclassName())) {
                    EjbInterfacesPage.this.localHomeifStatus.setError("Local Homeinterface: It's not possible to use same class for different ejb participants");
                    EjbInterfacesPage.this.doStatusUpdate(EjbInterfacesPage.this.generateCurrentStatus());
                    return;
                }
                if (EjbInterfacesPage.this.currentLocalHomeIF != null && text.endsWith(EjbInterfacesPage.this.currentLocalHomeIF.getElementName()) && text.startsWith(EjbInterfacesPage.this.currentLocalHomeIF.getParent().getElementName())) {
                    EjbInterfacesPage.this.localHomeifStatus.setOK();
                    EjbInterfacesPage.this.doStatusUpdate(EjbInterfacesPage.this.generateCurrentStatus());
                    return;
                }
                if (text.lastIndexOf(".java") < 0) {
                    text = text + ".java";
                }
                if ((classC = JDTUtils.findJavaClass((String)text, (IJavaProject)EjbInterfacesPage.this.ejbData.getBeanPackage().getJavaProject(), (boolean)false, (boolean)true)) == null) {
                    EjbInterfacesPage.this.eventHandler.localHomeifChanged(text, EjbInterfacesPage.this.localHomeifStatus);
                } else {
                    EjbInterfacesPage.this.eventHandler.localHomeifChanged((IJavaElement)classC, 0, EjbInterfacesPage.this.localHomeifStatus);
                }
                EjbInterfacesPage.this.doStatusUpdate(EjbInterfacesPage.this.generateCurrentStatus());
            }
        });
        this.mLocalHomeIFBrowse = UILayerUtils.createBrowseButton((IGridLayoutPane)this.layout, (int)1, (String)"Package");
        this.mLocalHomeIFBrowse.addSelectionListener((SelectionListener)new ButtonEvAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IPackageFragment fragment = JDTUtils.choosePackageFromDialog((Shell)EjbInterfacesPage.this.getShell(), (IJavaProject)EjbInterfacesPage.this.ejbData.getBeanPackage().getJavaProject(), (IPackageFragment)EjbInterfacesPage.this.ejbData.getBeanPackage(), (boolean)true);
                if (fragment == null) {
                    return;
                }
                StringBuffer fqn = EjbInterfacesPage.this.createFQName(fragment, true);
                fqn.append("LocalHome");
                EjbInterfacesPage.this.mLocalHomeIFText.setText(fqn.toString());
                EjbInterfacesPage.this.doStatusUpdate(EjbInterfacesPage.this.generateCurrentStatus());
                EjbInterfacesPage.this.mLocalHomeIFText.setFocus();
            }
        });
        this.mLocalHomeIFClass = UILayerUtils.createBrowseButton((IGridLayoutPane)this.layout, (int)1, (String)"Class");
        this.mLocalHomeIFClass.addSelectionListener((SelectionListener)new ButtonEvAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IType type = JDTUtils.chooseEnclosingType((IPackageFragmentRoot[])EjbInterfacesPage.this.pkgRoots, null, (Shell)EjbInterfacesPage.this.shell, (IRunnableContext)EjbInterfacesPage.this.ctx, (int)4, (IJavaElement)EjbInterfacesPage.this.getCurrentLocalHomeIF());
                if (type == null) {
                    return;
                }
                EjbInterfacesPage.this.eventHandler.localHomeifChanged((IJavaElement)type, 0, EjbInterfacesPage.this.localHomeifStatus);
                EjbInterfacesPage.this.setLocalHomeIFText(EjbInterfacesPage.this.ejbData.getLocalHomeIFName());
                EjbInterfacesPage.this.doStatusUpdate(EjbInterfacesPage.this.generateCurrentStatus());
            }
        });
    }

    private final void createComponentIFCheckbox() {
        boolean enabled = false;
        if (this.ejbData.getRemoteIFName() != null) {
            enabled = true;
        }
        this.mComponentIFCheckbox = this.layout.addCheckBox("Remote Interfaces", enabled);
        this.layout.addPlaceholder(3, 1);
        this.mComponentIFCheckbox.addSelectionListener((SelectionListener)new ButtonEvAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button checkbox = (Button)e.getSource();
                EjbInterfacesPage.this.eventHandler.componentCheckboxChanged(checkbox.getSelection());
                EjbInterfacesPage.this.doStatusUpdate(EjbInterfacesPage.this.createInterfacesSelectionStatus());
            }
        });
    }

    private final void createLocalIFCheckbox() {
        boolean enabled = false;
        if (this.ejbData.getLocalIFName() != null) {
            enabled = true;
        }
        this.mLocalIFCheckbox = this.layout.addCheckBox("Local Interfaces", enabled);
        this.layout.addPlaceholder(3, 1);
        this.mLocalIFCheckbox.addSelectionListener((SelectionListener)new ButtonEvAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button checkbox = (Button)e.getSource();
                EjbInterfacesPage.this.eventHandler.localCheckboxChanged(checkbox.getSelection());
                EjbInterfacesPage.this.doStatusUpdate(EjbInterfacesPage.this.createInterfacesSelectionStatus());
            }
        });
    }

    public IEjbMetaData getEjbData() {
        return this.ejbData;
    }

    public IJavaElement getCurrentBean() {
        return this.currentBean;
    }

    public IJavaElement getCurrentHomeIF() {
        return this.currentHomeIF;
    }

    public IJavaElement getCurrentLocalHomeIF() {
        return this.currentLocalHomeIF;
    }

    public IJavaElement getCurrentLocalIF() {
        return this.currentLocalIF;
    }

    public IJavaElement getCurrentRemoteIF() {
        return this.currentRemoteIF;
    }

    public void setCurrentBean(IJavaElement currentBean) {
        this.currentBean = currentBean;
    }

    public void setCurrentHomeIF(IJavaElement currentHomeIF) {
        this.currentHomeIF = currentHomeIF;
    }

    public void setCurrentLocalHomeIF(IJavaElement currentLocalHomeIF) {
        this.currentLocalHomeIF = currentLocalHomeIF;
    }

    public void setCurrentLocalIF(IJavaElement currentLocalIF) {
        this.currentLocalIF = currentLocalIF;
    }

    public void setCurrentRemoteIF(IJavaElement currentRemoteIF) {
        this.currentRemoteIF = currentRemoteIF;
    }

    public boolean isPageComplete() {
        if (this.pageComplete != null) {
            return this.pageComplete.isOK();
        }
        return false;
    }

    public Text getBeanClassTextField() {
        return this.mBeanClassText;
    }

    public Text getHomeIFTextField() {
        return this.mHomeIFText;
    }

    public Text getLocalHomeIFTextField() {
        return this.mLocalHomeIFText;
    }

    public Text getLocalIFTextField() {
        return this.mLocalIFText;
    }

    public Text getRemoteIFTextField() {
        return this.mRemoteIFText;
    }

    public void setBeanClassText(String beanClassText) {
        this.mBeanClassText.setText(beanClassText);
    }

    public void setHomeIFText(String homeIFText) {
        this.mHomeIFText.setText(homeIFText);
    }

    public void setLocalHomeIFText(String localHomeIFText) {
        this.mLocalHomeIFText.setText(localHomeIFText);
    }

    public void setLocalIFText(String localIFText) {
        this.mLocalIFText.setText(localIFText);
    }

    public void setRemoteIFText(String remoteIFText) {
        this.mRemoteIFText.setText(remoteIFText);
    }

    public StatusWrapper getHomeifStatus() {
        return this.homeifStatus;
    }

    public StatusWrapper getLocalHomeifStatus() {
        return this.localHomeifStatus;
    }

    public StatusWrapper getLocalifStatus() {
        return this.localifStatus;
    }

    public StatusWrapper getRemoteifStatus() {
        return this.remoteifStatus;
    }

    public Button getHomeIFBrowse() {
        return this.mHomeIFBrowse;
    }

    public Button getHomeIFClass() {
        return this.mHomeIFClass;
    }

    public Button getLocalHomeIFBrowse() {
        return this.mLocalHomeIFBrowse;
    }

    public Button getLocalHomeIFClass() {
        return this.mLocalHomeIFClass;
    }

    public Button getLocalIFBrowse() {
        return this.mLocalIFBrowse;
    }

    public Button getLocalIFClass() {
        return this.mLocalIFClass;
    }

    public Button getRemoteIFBrowse() {
        return this.mRemoteIFBrowse;
    }

    public Button getRemoteIFClass() {
        return this.mRemoteIFClass;
    }

    public IRunnableContext getCtx() {
        return this.ctx;
    }

    public Shell getShell() {
        return this.shell;
    }

    void doStatusUpdate(Status status) {
        this.statusCallback.updateStatus(status);
    }

    private Status createInterfacesSelectionStatus() {
        if (this.mComponentIFCheckbox.getSelection() || this.mLocalIFCheckbox.getSelection()) {
            return new Status(0, "com.tssap.j2ee.ui", 0, INTERFACES_SELECTION, null);
        }
        return new Status(4, "com.tssap.j2ee.ui", 4, "remote and/or local interfaces have to be specified", null);
    }

    private Status generateCurrentStatus() {
        Status status = null;
        boolean statusNotSet = true;
        if (!this.mComponentIFCheckbox.getSelection() && !this.mLocalIFCheckbox.getSelection()) {
            return new Status(4, "com.tssap.j2ee.ui", 4, "remote and/or local interfaces have to be specified", null);
        }
        if (this.beanclassStatus == null || this.homeifStatus == null || this.remoteifStatus == null || this.localHomeifStatus == null || this.localifStatus == null) {
            status = new Status(4, "com.tssap.j2ee.ui", 4, "page not completed", null);
        }
        if (!this.beanclassStatus.isOK()) {
            status = new Status(4, "com.tssap.j2ee.ui", 4, this.beanclassStatus.getMessage(), null);
            statusNotSet = false;
        } else if (!this.homeifStatus.isOK() && statusNotSet) {
            status = new Status(4, "com.tssap.j2ee.ui", 4, this.homeifStatus.getMessage(), null);
            statusNotSet = false;
        } else if (!this.remoteifStatus.isOK() && statusNotSet) {
            status = new Status(4, "com.tssap.j2ee.ui", 4, this.remoteifStatus.getMessage(), null);
            statusNotSet = false;
        } else if (!this.localifStatus.isOK() && statusNotSet) {
            status = new Status(4, "com.tssap.j2ee.ui", 4, this.localifStatus.getMessage(), null);
            statusNotSet = false;
        } else if (!this.localHomeifStatus.isOK() && statusNotSet) {
            status = new Status(4, "com.tssap.j2ee.ui", 4, this.localHomeifStatus.getMessage(), null);
            statusNotSet = false;
        } else {
            status = new Status(0, "com.tssap.j2ee.ui", 0, "page completed", null);
        }
        return status;
    }

    public void leavePage() {
        if (!this.mComponentIFCheckbox.getSelection()) {
            if (this.getEjbData().getRemoteIFName() != null && !this.getEjbData().getRemoteIFName().equals("")) {
                this.deleteOldInterfaces(this.getEjbData().getRemoteIFName());
            }
            this.getEjbData().setRemoteIFName(null);
            this.getEjbData().setRemoteIFPackage(null);
            if (this.getEjbData().getHomeIFName() != null && !this.getEjbData().getHomeIFName().equals("")) {
                this.deleteOldInterfaces(this.getEjbData().getHomeIFName());
            }
            this.getEjbData().setHomeIFName(null);
            this.getEjbData().setHomeIFPackage(null);
        } else {
            if (this.getEjbData().getRemoteIFName() == null || !this.getEjbData().getRemoteIFName().equals(this.getRemoteIFTextField().getText())) {
                this.getEjbData().setRemoteIFName(this.getRemoteIFTextField().getText());
            }
            if (this.getEjbData().getHomeIFName() == null || !this.getEjbData().getHomeIFName().equals(this.getHomeIFTextField().getText())) {
                this.getEjbData().setHomeIFName(this.getHomeIFTextField().getText());
            }
        }
        if (!this.mLocalIFCheckbox.getSelection()) {
            if (this.getEjbData().getLocalIFName() != null && !this.getEjbData().getLocalIFName().equals("")) {
                this.deleteOldInterfaces(this.getEjbData().getLocalIFName());
            }
            this.getEjbData().setLocalIFName(null);
            this.getEjbData().setLocalIFPackage(null);
            if (this.getEjbData().getLocalHomeIFName() != null && !this.getEjbData().getLocalHomeIFName().equals("")) {
                this.deleteOldInterfaces(this.getEjbData().getLocalHomeIFName());
            }
            this.getEjbData().setLocalHomeIFName(null);
            this.getEjbData().setLocalHomeIFPackage(null);
        } else {
            if (this.getEjbData().getLocalIFName() == null || !this.getEjbData().getLocalIFName().equals(this.getLocalIFTextField().getText())) {
                this.getEjbData().setLocalIFName(this.getLocalIFTextField().getText());
            }
            if (this.getEjbData().getLocalHomeIFName() == null || !this.getEjbData().getLocalHomeIFName().equals(this.getLocalHomeIFTextField().getText())) {
                this.getEjbData().setLocalHomeIFName(this.getLocalHomeIFTextField().getText());
            }
        }
    }

    private void deleteOldInterfaces(String fileName) {
        if (this.jPrj != null && MessageDialog.openQuestion((Shell)this.getShell(), (String)"delete old Interfaces", (String)("Do you want to delete former interface " + fileName))) {
            IFile file = null;
            try {
                IType type = this.jPrj.findType(fileName);
                if (type != null) {
                    file = (IFile)type.getUnderlyingResource();
                }
            }
            catch (JavaModelException e) {
                TRACER.error("", (Throwable)e);
            }
            if (file != null && file.exists()) {
                try {
                    file.delete(true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    String msg = "Can't delete " + fileName;
                    TRACER.error(msg, (Throwable)e);
                    MessageDialog.openError((Shell)this.getShell(), (String)"delete old Interfaces", (String)msg);
                }
            }
        }
    }

    public void initializeFields() {
        this.setBeanClassText(StringUtils.removeExtension((String)this.ejbData.getBeanclassName(), (boolean)true));
        if (this.ejbData.getRemoteIFName() != null) {
            this.setRemoteIFText(StringUtils.removeExtension((String)this.ejbData.getRemoteIFName(), (boolean)true));
        }
        if (this.ejbData.getHomeIFName() != null) {
            this.setHomeIFText(StringUtils.removeExtension((String)this.ejbData.getHomeIFName(), (boolean)true));
        }
        if (this.ejbData.getEjbCompliance() == 1) {
            if (this.ejbData.getLocalIFName() != null) {
                this.setLocalIFText(StringUtils.removeExtension((String)this.ejbData.getLocalIFName(), (boolean)true));
            }
            if (this.ejbData.getLocalHomeIFName() != null) {
                this.setLocalHomeIFText(StringUtils.removeExtension((String)this.ejbData.getLocalHomeIFName(), (boolean)true));
            }
        }
    }

    private String extractClassName(String fqClassName) {
        try {
            HashMap map = StringUtils.ClassWithPathString((String)this.ejbData.getBeanclassName(), (boolean)false);
            String className = (String)map.get(StringUtils.CLASSFILE);
            if (className != null) {
                return StringUtils.removeExtension((String)className, (boolean)true);
            }
        }
        catch (StringUtilException e) {
            TRACER.error("", (Throwable)e);
        }
        return null;
    }

    private StringBuffer createFQName(IPackageFragment fragment, boolean cutBeanPostfix) {
        StringBuffer fqn = new StringBuffer(fragment.getElementName());
        String beanName = this.extractClassName(this.ejbData.getBeanclassName());
        if (beanName != null) {
            if (cutBeanPostfix) {
                beanName = beanName.substring(0, beanName.lastIndexOf("Bean"));
            }
            if (!fqn.toString().equals("")) {
                fqn.append(".");
            }
            fqn.append(beanName);
        }
        return fqn;
    }

    public boolean hasRemoteInterfaces() {
        return this.mComponentIFCheckbox.getSelection();
    }

    public boolean hasLocalInterFaces() {
        return this.mLocalIFCheckbox.getSelection();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

