/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.ejb.components.methods;

import com.tssap.j2ee.model.IMethodWithUN;
import com.tssap.j2ee.model.ejb.ICMRField;
import com.tssap.j2ee.model.ejb.IPersistentField;
import com.tssap.j2ee.ui.UIPlugin;
import com.tssap.j2ee.ui.ejb.components.methods.MethodsInfrastructure;
import com.tssap.j2ee.ui.ejb.model.IBusinessMethod;
import com.tssap.util.ui.ILabel;
import com.tssap.util.ui.reuse.java.IParameterData;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class MethodsLabelProvider
extends LabelProvider
implements MethodsInfrastructure {
    private static final String ARRAY_BRACKETS = "[]";
    private static final String PARAMETER_SEPARATOR = ", ";
    private static final String BRACE_CLOSE = ")";
    private static final String BRACE_OPEN = "(";
    private static final String TYPE_QUALIFYING_SEPARATOR = ".";
    private static final boolean SHOW_PARAM_TYPES = true;
    private static final boolean SHOW_PARAM_TYPES_FULL_QUALIFIED = false;

    public Image getImage(Object element) {
        Image ret = null;
        if (element instanceof ILabel) {
            ret = ((ILabel)element).getImage();
        } else if (element instanceof IMethodWithUN) {
            IMethodWithUN method = (IMethodWithUN)element;
            int methodType = method.getMethodType();
            if (methodType == 2) {
                if (method instanceof IBusinessMethod) {
                    boolean local = ((IBusinessMethod)method).isPropagatedToLocalIF();
                    boolean remote = ((IBusinessMethod)method).isPropagatedToRemoteIF();
                    if (((IBusinessMethod)method).isParticipant()) {
                        if (((IBusinessMethod)method).getOwner() instanceof ICMRField) {
                            ret = UIPlugin.getImage((String)"Ejb Relationship Link");
                        } else if (((IBusinessMethod)method).getOwner() instanceof IPersistentField) {
                            ret = ((IPersistentField)((IBusinessMethod)method).getOwner()).isPKField() ? UIPlugin.getImage((String)"primaryKey") : (local && remote ? UIPlugin.getImage((String)"persFieldLocalremotePropagated") : (local ? UIPlugin.getImage((String)"persFieldLocalPropagated") : (remote ? UIPlugin.getImage((String)"persFieldRemotePropagated") : UIPlugin.getImage((String)"persistentField"))));
                        }
                    } else {
                        ret = local && remote ? UIPlugin.getImage((String)"localremotePropagated") : (local ? UIPlugin.getImage((String)"localPropagated") : (remote ? UIPlugin.getImage((String)"remotePropagated") : UIPlugin.getImage((String)"businessMethod")));
                    }
                } else {
                    ret = UIPlugin.getImage((String)"businessMethod");
                }
            } else {
                ret = methodType == 4 ? (method.getName().indexOf("ByPrimaryKey") >= 0 ? UIPlugin.getImage((String)"finderbyPKMethod") : UIPlugin.getImage((String)"finderMethod")) : (methodType == 3 ? UIPlugin.getImage((String)"createMethod") : (methodType == 1 ? UIPlugin.getImage((String)"homeMethod") : (methodType == 5 ? UIPlugin.getImage((String)"selectMethod") : UIPlugin.getImage((String)"defaultMethod"))));
            }
        }
        return ret;
    }

    public String getText(Object element) {
        String ret = null;
        if (element instanceof ILabel) {
            ret = ((ILabel)element).getName();
        } else if (element instanceof IMethodWithUN) {
            IMethodWithUN method = (IMethodWithUN)element;
            String methodName = method.getName();
            StringBuffer buffer = new StringBuffer();
            buffer.append(methodName);
            buffer.append(BRACE_OPEN);
            String[] paramTypes = method.getParameterTypes();
            IParameterData[] paramDatas = method.getParameters();
            int i = 0;
            while (i < paramTypes.length) {
                String fqTypeName = paramTypes[i];
                int lastDotIndex = fqTypeName.lastIndexOf(TYPE_QUALIFYING_SEPARATOR);
                String shortTypeName = lastDotIndex < 0 ? fqTypeName : fqTypeName.substring(lastDotIndex + 1);
                buffer.append(shortTypeName);
                int j = 1;
                while (j <= paramDatas[i].getArrayDimension() && j <= 10) {
                    buffer.append(ARRAY_BRACKETS);
                    ++j;
                }
                if (paramDatas[i].getArrayDimension() > 10) {
                    buffer.append("...");
                }
                if (i < paramTypes.length - 1) {
                    buffer.append(PARAMETER_SEPARATOR);
                }
                ++i;
            }
            buffer.append(BRACE_CLOSE);
            ret = buffer.toString();
        }
        return ret == null ? "<.?.>" : ret;
    }
}

