/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.ejb.components.methods;

import com.tssap.j2ee.model.IMethodWithUN;
import com.tssap.j2ee.model.J2eeProjectManager;
import com.tssap.j2ee.model.ejb.IBMP_PrimaryKey;
import com.tssap.j2ee.model.ejb.ICMP_PrimaryKey;
import com.tssap.j2ee.model.ejb.IPersistentField;
import com.tssap.j2ee.model.ejb.IPrimaryKey;
import com.tssap.j2ee.ui.ejb.components.EjbEditorTypeUtil;
import com.tssap.j2ee.ui.ejb.components.IEjbMetaData;
import com.tssap.j2ee.ui.ejb.model.util.ModelDataConverter;
import com.tssap.j2ee.util.core.StatusWrapper;
import com.tssap.j2ee.util.jdt.JDTUtils;
import com.tssap.util.core.IConstants;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.DefaultObjectEditorComponent;
import com.tssap.util.ui.reuse.IModifiedCallback;
import com.tssap.util.ui.reuse.ObjectEditorComponentUtil;
import com.tssap.util.ui.reuse.chooser.IChooser;
import com.tssap.util.ui.reuse.java.IMethodCallback;
import com.tssap.util.ui.reuse.java.IMethodComponent;
import com.tssap.util.ui.reuse.java.IMethodData;
import com.tssap.util.ui.reuse.java.IParameterData;
import com.tssap.util.ui.reuse.java.MethodComponent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;

class MethodEditorComponent
extends DefaultObjectEditorComponent
implements IMethodComponent,
IModifiedCallback {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$ejb$components$methods$MethodEditorComponent == null ? (class$com$tssap$j2ee$ui$ejb$components$methods$MethodEditorComponent = MethodEditorComponent.class$("com.tssap.j2ee.ui.ejb.components.methods.MethodEditorComponent")) : class$com$tssap$j2ee$ui$ejb$components$methods$MethodEditorComponent));
    private boolean neverEditable = false;
    private IEjbMetaData _ejbMetaData;
    private EjbEditorTypeUtil _ejbEditorTypeUtil;
    private MethodComponent methodComponent;
    private IChooser returnTypeChooser;
    private IChooser parameterTypeChooser;
    private boolean refreshingUI = false;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$ejb$components$methods$MethodEditorComponent;

    public MethodEditorComponent(IEjbMetaData ejbData, IMethodCallback methodCallback) {
        this(ejbData);
        if (methodCallback != null) {
            this.methodComponent.setMethodCallback(methodCallback);
        }
    }

    public MethodEditorComponent(IEjbMetaData ejbData) {
        super(null);
        this.setEjbMetaData(ejbData);
        this._ejbEditorTypeUtil = new EjbEditorTypeUtil(this._ejbMetaData);
        this.methodComponent = new MethodComponent(null);
        this.methodComponent.setAutoRefreshData(true);
    }

    public void initContainer(IGridLayoutPane userArea) {
        this.getMethodComponent().setReturnTypeChooser(this.getReturnTypeChooser());
        this.getMethodComponent().createPartControl(userArea);
        this.getMethodComponent().setModifiedCallback((IModifiedCallback)this);
    }

    private IMethodWithUN getMethod() {
        IMethodWithUN ret = null;
        if (this.getData() instanceof IMethodWithUN) {
            ret = (IMethodWithUN)this.getData();
        }
        return ret;
    }

    public void refreshDataFromUI() {
        if (!this.refreshingUI) {
            super.refreshDataFromUI();
            if (this.getMethodComponent() != null) {
                this.getMethodComponent().refreshDataFromUI();
                ModelDataConverter.syncToMethod(this.getMethodComponent().getMethodData(), this.getMethod());
            }
        }
    }

    public void refreshUIFromData() {
        this.refreshingUI = true;
        super.refreshUIFromData();
        if (this.getMethodComponent() != null) {
            ModelDataConverter.syncToMethodData(this.getMethod(), this.getMethodComponent().getMethodData());
            this.getMethodComponent().refreshUIFromData();
        }
        this.refreshingUI = false;
    }

    public void dataModified(boolean modified) {
        if (this.getModifiedCallback() != null) {
            this.refreshDataFromUI();
            this.getModifiedCallback().dataModified(modified);
        }
    }

    public String okToLeave() {
        String ret = super.okToLeave();
        if (ret == null && this.getMethodComponent() != null) {
            IStatus validationStatus = this.getMethodComponent().getValidationStatus();
            if (!validationStatus.isOK()) {
                int statusSeverity;
                String validationMsg = validationStatus.getMessage();
                ret = ObjectEditorComponentUtil.getMsgPrefixIndex((String)validationMsg) > ObjectEditorComponentUtil.CHANGE_MSG_PREFIXES.length ? ((statusSeverity = validationStatus.getSeverity()) == 2 ? "{$LEAVABLE_WARNING}" + validationMsg : (statusSeverity == 1 ? "{$INFO}" + validationMsg : "{$ERROR}" + validationMsg)) : validationMsg;
            } else {
                validationStatus = this.isReturnTypeValid().getStatusInfo();
                if (!validationStatus.isOK()) {
                    ret = validationStatus.getMessage();
                } else {
                    validationStatus = this.isParameterTypeValid().getStatusInfo();
                    if (!validationStatus.isOK()) {
                        ret = validationStatus.getMessage();
                    } else {
                        validationStatus = this.isContentValid().getStatusInfo();
                        if (!validationStatus.isOK()) {
                            ret = validationStatus.getMessage();
                        }
                    }
                }
            }
        }
        return ret;
    }

    private StatusWrapper isReturnTypeValid() {
        StatusWrapper status = new StatusWrapper();
        String fqReturnTypeName = this.getMethodData().getFullQualifiedTypeName();
        boolean isPrimitiveType = this._ejbEditorTypeUtil.isPrimitiveType(fqReturnTypeName);
        boolean classExists = false;
        if (!isPrimitiveType && !fqReturnTypeName.equals("void")) {
            status = this.createTypeExistanceStatus(status, fqReturnTypeName);
        }
        return status;
    }

    private StatusWrapper createTypeExistanceStatus(StatusWrapper status, String typeName) {
        boolean classExists = this._ejbEditorTypeUtil.checkForTypeExistance(typeName);
        if (!classExists) {
            if (this.getEjbMetaData().isWizardBean()) {
                this.checkForTypesInCache(status, typeName);
            } else {
                StringBuffer sb = new StringBuffer("Type ");
                sb.append(typeName);
                sb.append(" does not exist in the referenced projects!");
                status.setWarning("{$LEAVABLE_WARNING}" + sb.toString());
            }
        }
        return status;
    }

    private StatusWrapper isParameterTypeValid() {
        StatusWrapper status = new StatusWrapper();
        IParameterData[] paramData = this.getMethodData().getParameters();
        int i = 0;
        while (i < paramData.length) {
            String paramTypeName = paramData[i].getFullQualifiedTypeName();
            boolean isPrimitiveType = this._ejbEditorTypeUtil.isPrimitiveType(paramTypeName);
            boolean classExists = false;
            if (!isPrimitiveType && !(status = this.createTypeExistanceStatus(status, paramTypeName)).isOK()) {
                return status;
            }
            ++i;
        }
        return status;
    }

    private void checkForTypesInCache(StatusWrapper status, String typeName) {
        if (!(this.getEjbMetaData().getBeanclassName().equals(typeName) || this.getEjbMetaData().getPrimaryKey() != null && this.getEjbMetaData().getPrimaryKey().getPrimaryKeyClass() != null && this.getEjbMetaData().getPrimaryKey().getPrimaryKeyClass().getName().equals(typeName) || this.getEjbMetaData().getHomeIFName() != null && this.getEjbMetaData().getHomeIFName().equals(typeName) || this.getEjbMetaData().getRemoteIFName() != null && this.getEjbMetaData().getRemoteIFName().equals(typeName) || this.getEjbMetaData().getLocalHomeIFName() != null && this.getEjbMetaData().getLocalHomeIFName().equals(typeName) || this.getEjbMetaData().getLocalIFName() != null && this.getEjbMetaData().getLocalIFName().equals(typeName))) {
            StringBuffer sb = new StringBuffer("Type ");
            sb.append(typeName);
            sb.append(" does not exist in the referenced projects!");
            status.setWarning("{$LEAVABLE_WARNING}" + sb.toString());
        }
    }

    private MethodComponent getMethodComponent() {
        return this.methodComponent;
    }

    public IMethodData getMethodData() {
        return this.getMethodComponent().getMethodData();
    }

    public boolean isModifiersEditable() {
        return this.getMethodComponent().isModifiersEditable();
    }

    public boolean isModifiersVisible() {
        return this.getMethodComponent().isModifiersVisible();
    }

    public boolean isParametersEditable() {
        return this.getMethodComponent().isParametersEditable();
    }

    public boolean isParametersVisible() {
        return this.getMethodComponent().isParametersVisible();
    }

    public boolean isReturnTypeEditable() {
        return this.getMethodComponent().isReturnTypeEditable();
    }

    public boolean isReturnTypeVisible() {
        return this.getMethodComponent().isReturnTypeVisible();
    }

    public void setMethodData(IMethodData data) {
        this.getMethodComponent().setMethodData(data);
    }

    public void setModifiersEditable(boolean modifiersEditable) {
        this.getMethodComponent().setModifiersEditable(modifiersEditable);
    }

    public void setModifiersVisible(boolean modifiersVisible) {
        this.getMethodComponent().setModifiersVisible(modifiersVisible);
    }

    public void setParametersEditable(boolean parametersEditable) {
        this.getMethodComponent().setParametersEditable(parametersEditable);
    }

    public void setParametersVisible(boolean parametersVisible) {
        this.getMethodComponent().setParametersVisible(parametersVisible);
    }

    public void setReturnTypeEditable(boolean returnTypeEditable) {
        this.getMethodComponent().setReturnTypeEditable(returnTypeEditable);
    }

    public void setReturnTypeVisible(boolean returnTypeVisible) {
        this.getMethodComponent().setReturnTypeVisible(returnTypeVisible);
    }

    public boolean isNameEditable() {
        return this.getMethodComponent().isNameEditable();
    }

    public void setNameEditable(boolean nameEditable) {
        this.getMethodComponent().setNameEditable(nameEditable);
    }

    public void setEditable(boolean enabled) {
        if (this.getMethodComponent() != null) {
            this.getMethodComponent().setEditable(enabled);
        }
        super.setEditable(enabled);
    }

    public void setEnabled(boolean enabled) {
        if (this.getMethodComponent() != null) {
            this.getMethodComponent().setEnabled(enabled);
        }
    }

    public void setReturnTypeChooser(IChooser returnTypeChooser) {
        this.returnTypeChooser = returnTypeChooser;
        if (this.methodComponent != null) {
            this.methodComponent.setReturnTypeChooser(returnTypeChooser);
        }
    }

    public IChooser getReturnTypeChooser() {
        IChooser ret = this.returnTypeChooser;
        return ret;
    }

    public void setParameterTypeChooser(IChooser parameterTypeChooser) {
        this.parameterTypeChooser = parameterTypeChooser;
        if (this.methodComponent != null) {
            this.methodComponent.setParameterTypeChooser(parameterTypeChooser);
        }
    }

    public IChooser getParameterTypeChooser() {
        IChooser ret = this.parameterTypeChooser;
        return ret;
    }

    private StatusWrapper isContentValid() {
        IMethodData data = this.getMethodData();
        StatusWrapper status = new StatusWrapper();
        switch (this.getMethod().getMethodType()) {
            case 2: {
                if (data.getName().startsWith("ejb")) {
                    status.setError("Business method name must not start with 'ejb'. \n Please choose another name.");
                }
                return status;
            }
            case 3: {
                if (data.getName().startsWith("ejbCreate")) {
                    if (this.getEjbMetaData().getEjbType() == 2) {
                        String pkName = null;
                        if (this.getEjbMetaData() != null && this.getEjbMetaData().getPrimaryKey() != null) {
                            IPrimaryKey pk = this.getEjbMetaData().getPrimaryKey();
                            pkName = pk instanceof IBMP_PrimaryKey || pk instanceof ICMP_PrimaryKey && ((ICMP_PrimaryKey)pk).isCompoundKey() ? pk.getPrimaryKeyClass().getName() : (pk instanceof ICMP_PrimaryKey && ((ICMP_PrimaryKey)pk).isUnknownKey() ? "java.lang.Object" : ((ICMP_PrimaryKey)pk).getFields()[0].getType());
                        }
                        if (pkName != null && data.getFullQualifiedTypeName().equals(pkName)) {
                            return status;
                        }
                        status.setError("No valid returntype, must be primarykey class of ejb. \n Please correct in bean class source.");
                    } else {
                        if (data.getFullQualifiedTypeName().equals("void")) {
                            return status;
                        }
                        status.setError("No valid returntype, must be \"void\"");
                    }
                } else {
                    status.setError("Method name must start with \"ejbCreate\"");
                }
                return status;
            }
            case 4: {
                if (data.getName().startsWith("ejbFind") && !data.getName().equalsIgnoreCase("ejbFind")) {
                    String pkName = null;
                    if (this.getEjbMetaData() != null && this.getEjbMetaData().getPrimaryKey() != null) {
                        IPrimaryKey pk = this.getEjbMetaData().getPrimaryKey();
                        pkName = pk instanceof IBMP_PrimaryKey || pk instanceof ICMP_PrimaryKey && ((ICMP_PrimaryKey)pk).isCompoundKey() ? pk.getPrimaryKeyClass().getName() : (pk instanceof ICMP_PrimaryKey && ((ICMP_PrimaryKey)pk).isUnknownKey() ? "java.lang.Object" : ((ICMP_PrimaryKey)pk).getFields()[0].getType());
                    }
                    if (pkName != null && data.getFullQualifiedTypeName().equals(pkName) || data.getFullQualifiedTypeName().equals("java.util.Collection")) {
                        return status;
                    }
                    status.setError("No valid returntype, must be \"java.util.Collection\" or primarykey of ejb. \n Please correct in bean class source.");
                } else {
                    status.setError("Method name must start with \"ejbFind\" and have a suffix");
                }
                return status;
            }
            case 5: {
                if (data.getName().startsWith("ejbSelect") && !data.getName().equalsIgnoreCase("ejbSelect")) {
                    if (data.getFullQualifiedTypeName() != null && this.getEjbMetaData() != null) {
                        HashMap persistentFieldsHM = this.getEjbMetaData().getPersistentFields();
                        Collection persistentFieldsEntryColl = persistentFieldsHM.values();
                        IPersistentField[] persistentFields = persistentFieldsEntryColl.toArray(new IPersistentField[persistentFieldsEntryColl.size()]);
                        ArrayList<String> typenamesL = new ArrayList<String>();
                        int i = 0;
                        while (i < persistentFields.length) {
                            typenamesL.add(persistentFields[i].getType());
                            ++i;
                        }
                        String localInterfaceFq = this.getEjbMetaData().getLocalIFName();
                        String remoteInterfaceFq = this.getEjbMetaData().getRemoteIFName();
                        if (!(data.getFullQualifiedTypeName().equals(remoteInterfaceFq) || data.getFullQualifiedTypeName().equals(localInterfaceFq) || data.getFullQualifiedTypeName().equals("java.util.Collection") || data.getFullQualifiedTypeName().equals("java.util.Set") || typenamesL.contains(data.getFullQualifiedTypeName()))) {
                            status.setError("The return type is not valid.");
                        } else {
                            boolean simpleType = false;
                            int j = 0;
                            while (j < IConstants.PARAMETER_TYPES.length) {
                                if (data.getFullQualifiedTypeName().equals(IConstants.PARAMETER_TYPES[j])) {
                                    simpleType = true;
                                }
                                ++j;
                            }
                            if (!this.getEjbMetaData().isWizardBean() && simpleType) {
                                String ejbProjectName = this.getEjbMetaData().getEjbProjectName();
                                IType existingClass = JDTUtils.findJavaClass((String)data.getFullQualifiedTypeName(), (IJavaProject)(J2eeProjectManager.getEjbModule((String)ejbProjectName) != null ? J2eeProjectManager.getEjbModule((String)ejbProjectName).getJavaProject() : null), (boolean)false, (boolean)true);
                                if (existingClass == null) {
                                    status.setError("Class / Interface " + data.getFullQualifiedTypeName() + " does not exist");
                                }
                            }
                        }
                    }
                } else {
                    status.setError("Method name must start with \"ejbSelect\" and have a suffix.");
                }
                return status;
            }
            case 1: {
                if (!data.getName().startsWith("ejbHome") || data.getName().equalsIgnoreCase("ejbHome")) {
                    status.setError("Method name must start with \"ejbHome\" and must have a suffix.");
                } else if (data.getName().startsWith("ejbHomeCreate") || data.getName().startsWith("ejbHomeFind") || data.getName().startsWith("ejbHomeRemove")) {
                    status.setError("Protected method name! Please choose another name.");
                }
                return status;
            }
        }
        return status;
    }

    public IEjbMetaData getEjbMetaData() {
        return this._ejbMetaData;
    }

    public void setEjbMetaData(IEjbMetaData ejbMetaData) {
        this._ejbMetaData = ejbMetaData;
    }

    protected void updateEditableBehavior() {
        super.updateEditableBehavior();
        if (this.getMethodComponent() != null) {
            this.getMethodComponent().setEditable(this.isEditable());
        }
    }

    public boolean isNeverEditable() {
        return this.neverEditable;
    }

    public void setNeverEditable(boolean b) {
        this.neverEditable = b;
        this.updateEditableBehavior();
    }

    public boolean isEditable() {
        return super.isEditable() && !this.isNeverEditable();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

