/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.ejb.components.fields;

import com.tssap.j2ee.model.ejb.IPersistableField;
import com.tssap.j2ee.ui.core.TypeChooser;
import com.tssap.j2ee.ui.ejb.components.fields.FieldEditorComponent;
import com.tssap.j2ee.ui.ejb.components.fields.IPersistableFieldCallback;
import com.tssap.j2ee.ui.ejb.components.fields.IPersistableFieldData;
import com.tssap.j2ee.ui.ejb.components.fields.PersistableFieldData;
import com.tssap.j2ee.util.core.StatusWrapper;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.IModifiedCallback;
import com.tssap.util.ui.reuse.chooser.IChooser;
import com.tssap.util.ui.reuse.java.ITypeData;
import com.tssap.util.ui.reuse.java.JavaComponent;
import com.tssap.util.ui.reuse.java.TypeComponent2;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Text;

class PersistableFieldComponent
extends JavaComponent {
    private Text nameTextField;
    private TypeComponent2 typeComponent;
    private IPersistableFieldCallback persistableFieldCallback;
    private ListenerList listenerList = null;
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$ejb$components$fields$PersistableFieldComponent == null ? (class$com$tssap$j2ee$ui$ejb$components$fields$PersistableFieldComponent = PersistableFieldComponent.class$("com.tssap.j2ee.ui.ejb.components.fields.PersistableFieldComponent")) : class$com$tssap$j2ee$ui$ejb$components$fields$PersistableFieldComponent));
    static /* synthetic */ Class class$com$tssap$j2ee$ui$ejb$components$fields$PersistableFieldComponent;

    public PersistableFieldComponent() {
    }

    public PersistableFieldComponent(String title) {
        super(title);
    }

    public PersistableFieldComponent(IPersistableFieldData data) {
        this.setPersistableFieldData(data);
    }

    public PersistableFieldComponent(String title, IPersistableFieldData data) {
        this(title);
        this.setPersistableFieldData(data);
    }

    public void initContainer(IGridLayoutPane userArea) {
        IGridLayoutPane nameArea = userArea.addGridLayoutPane(2, false, userArea.createGridLayoutData(4, 2, true, false));
        nameArea.addTextLabel("Name", nameArea.createGridLayoutData(1, 2));
        this.nameTextField = nameArea.addTextField("", false, nameArea.createGridLayoutData(4, 2, true, false));
        this.typeComponent = new TypeComponent2("Type", (ITypeData)this.getPersistableFieldData());
        this.typeComponent.setTypeChooser((IChooser)new TypeChooser());
        this.typeComponent.createPartControl(userArea, true, false);
        this.decorateComponents();
    }

    protected void updateEditableBehavior() {
        super.updateEditableBehavior();
        boolean editable = this.isEditable();
        boolean isTextUnknown = false;
        IPersistableFieldData persistableFieldData = this.getPersistableFieldData();
        if (persistableFieldData != null && persistableFieldData.getName() != null) {
            isTextUnknown = persistableFieldData.getName().equals("ejb_pk");
        }
        if (this.typeComponent != null) {
            this.typeComponent.setEditable(editable && !isTextUnknown);
        }
        if (this.nameTextField != null) {
            this.nameTextField.setEditable(editable && !isTextUnknown);
        }
    }

    protected boolean showVoidAsPossibleType() {
        return false;
    }

    private void decorateComponents() {
        if (this.isAutoRefreshUI()) {
            this.refreshUIFromData();
        }
        if (this.nameTextField != null) {
            this.nameTextField.addModifyListener((ModifyListener)new FieldNameTextModifyListener());
            this.nameTextField.addModifyListener(this.getModifyAdapterSingleton());
        }
        if (this.typeComponent != null) {
            this.typeComponent.setAutoRefreshData(false);
            this.typeComponent.addModifyListener(this.getModifyAdapterSingleton());
            this.typeComponent.setModifiedCallback(this.getModifiedCallback());
        }
        this.setEnabled(this.isEnabled());
    }

    public void refreshDataFromUI() {
        if (!this.isRefreshingUI()) {
            super.refreshDataFromUI();
            IPersistableFieldData PersistableFieldData2 = this.getPersistableFieldData();
            if (PersistableFieldData2 != null) {
                if (this.nameTextField != null) {
                    String text = this.nameTextField.getText();
                    PersistableFieldData2.setName(text);
                }
                if (this.typeComponent != null) {
                    this.typeComponent.refreshDataFromUI();
                }
            }
        }
    }

    public void refreshUIFromData() {
        this.startRefreshingUI();
        super.refreshUIFromData();
        IPersistableFieldData persistableFieldData = this.getPersistableFieldData();
        if (persistableFieldData != null) {
            if (this.nameTextField != null) {
                this.nameTextField.setText(persistableFieldData.getName());
            }
            if (this.typeComponent != null) {
                this.typeComponent.setTypeData((ITypeData)persistableFieldData);
                this.typeComponent.refreshUIFromData();
            }
        }
        this.updateEditableBehavior();
        this.stopRefreshingUI();
    }

    public IPersistableFieldData getPersistableFieldData() {
        IPersistableFieldData ret = null;
        if (this.getData() == null) {
            this.setData(new PersistableFieldData());
        }
        if (this.getData() instanceof IPersistableFieldData) {
            ret = (IPersistableFieldData)this.getData();
        }
        return ret;
    }

    public void setPersistableFieldData(IPersistableFieldData data) {
        if (data instanceof IPersistableFieldData) {
            this.setData(data);
            if (this.isAutoRefreshUI()) {
                this.refreshUIFromData();
            }
        }
    }

    public String acceptData(Object data) {
        String ret = super.acceptData(data);
        if (ret == null && !(data instanceof IPersistableFieldData)) {
            ret = "this is not a Persistable field data";
        }
        return ret;
    }

    public void setModifiedCallback(IModifiedCallback callback) {
        super.setModifiedCallback(callback);
        if (this.typeComponent != null) {
            this.typeComponent.setModifiedCallback(callback);
        }
    }

    public IStatus getValidationStatus() {
        IStatus ret = super.getValidationStatus();
        if (ret.isOK() && this.nameTextField != null) {
            ret = this.nameTextField.getText() != null && !this.nameTextField.getText().equals("") && Character.isLowerCase(this.nameTextField.getText().charAt(0)) ? JavaConventions.validateFieldName((String)this.nameTextField.getText()) : new StatusWrapper(4, "cmp field name must start with lowercase letter").getStatusInfo();
            if (ret.isOK() && this.nameTextField.getText().equalsIgnoreCase("primaryKey")) {
                ret = new StatusWrapper(4, "primaryKey is a reserved fieldname").getStatusInfo();
            }
            if (ret.isOK() && this.getPersistableFieldCallback() != null && this.nameTextField != null) {
                String currentName = this.nameTextField.getText();
                IPersistableField[] persistableFields = this.getPersistableFieldCallback().getDisapprovedPersistableFields();
                int i = 0;
                while (i < persistableFields.length) {
                    if (currentName.equals(persistableFields[i].getName())) {
                        ret = new StatusWrapper(4, "Duplicate field definition.").getStatusInfo();
                    }
                    ++i;
                }
            }
        }
        if (ret.isOK() && this.typeComponent != null) {
            ret = this.typeComponent.getValidationStatus();
        }
        return ret;
    }

    public IPersistableFieldCallback getPersistableFieldCallback() {
        return this.persistableFieldCallback;
    }

    public void setPersistableFieldCallback(IPersistableFieldCallback callback) {
        this.persistableFieldCallback = callback;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.nameTextField != null) {
            this.nameTextField.setEnabled(enabled);
        }
        if (this.typeComponent != null) {
            this.typeComponent.setEnabled(enabled);
        }
    }

    public void addFieldNameModifiedListener(FieldEditorComponent.IFieldNameModifyListener fieldNameModifyListener) {
        if (this.listenerList == null) {
            this.listenerList = new ListenerList();
        }
        this.listenerList.add((Object)fieldNameModifyListener);
    }

    public void removeFieldNameModifiedListener(FieldEditorComponent.IFieldNameModifyListener fieldNameModifyListener) {
        if (this.listenerList != null && !this.listenerList.isEmpty()) {
            this.listenerList.remove((Object)fieldNameModifyListener);
        } else {
            tracer.error("removeFieldNameModifiedListener(IFieldNameModifyListener)", "ListenerList is empty or null");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class FieldNameTextModifyListener
    implements ModifyListener {
        FieldNameTextModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (!PersistableFieldComponent.super.isRefreshingUI()) {
                if (PersistableFieldComponent.this.listenerList != null && !PersistableFieldComponent.this.listenerList.isEmpty()) {
                    Object[] fieldNameModifyListeners = PersistableFieldComponent.this.listenerList.getListeners();
                    int i = 0;
                    while (i < fieldNameModifyListeners.length) {
                        if (fieldNameModifyListeners[i] instanceof FieldEditorComponent.IFieldNameModifyListener) {
                            ((FieldEditorComponent.IFieldNameModifyListener)fieldNameModifyListeners[i]).fieldNameModified();
                        }
                        ++i;
                    }
                } else {
                    tracer.error("modifyText(IFieldNameModifyListener)", "ListenerList is empty or null");
                }
            }
        }
    }
}

