/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.ejb.components.fields;

import com.tssap.j2ee.model.IMethodWithUN;
import com.tssap.j2ee.model.ejb.ICMP_PrimaryKey;
import com.tssap.j2ee.model.ejb.IPersistableField;
import com.tssap.j2ee.model.ejb.IPersistentField;
import com.tssap.j2ee.model.ejb.IPrimaryKey;
import com.tssap.j2ee.ui.ejb.components.EjbEditorTypeUtil;
import com.tssap.j2ee.ui.ejb.components.IEjbMetaData;
import com.tssap.j2ee.ui.ejb.components.fields.IPersistableFieldCallback;
import com.tssap.j2ee.ui.ejb.components.fields.PersistableFieldComponent;
import com.tssap.j2ee.ui.ejb.components.fields.PersistableFieldData;
import com.tssap.j2ee.ui.ejb.model.util.ModelDataConverter;
import com.tssap.j2ee.util.core.StatusWrapper;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.IModifiedCallback;
import com.tssap.util.ui.reuse.RefreshObjectEditorComponent;
import org.eclipse.core.runtime.IStatus;

class FieldEditorComponent
extends RefreshObjectEditorComponent
implements IModifiedCallback {
    private static final String TXT_ERR_NO_SIMPLETYPE_FOR_PK = "Primitive types are not allowed as primary key field type.";
    private static final String TXT_ERR_NO_ARR_FOR_PK = "You cannot assign an array type as primary key field type.";
    private boolean _neverEditable = false;
    private IPersistableFieldCallback _persistableFieldCallback;
    private static final Object[] EMPTY = new Object[0];
    private IPersistableField _field;
    private PersistableFieldComponent _persistentFieldComponent;
    private IEjbMetaData _ejbMetaData = null;
    private EjbEditorTypeUtil _ejbEditorTypeUtil;

    public FieldEditorComponent(IEjbMetaData ejbMetaData) {
        super(null);
        this._ejbMetaData = ejbMetaData;
        this._ejbEditorTypeUtil = new EjbEditorTypeUtil(ejbMetaData);
    }

    public FieldEditorComponent(IEjbMetaData ejbMetaData, IPersistableFieldCallback callback) {
        this(ejbMetaData);
        this._persistableFieldCallback = callback;
    }

    public void initContainer(IGridLayoutPane userArea) {
        this._persistentFieldComponent = new PersistableFieldComponent(new PersistableFieldData(""));
        this._persistentFieldComponent.setEnabled(this.isEnabled());
        this._persistentFieldComponent.createPartControl(userArea);
        this._persistentFieldComponent.setModifiedCallback(this);
        this._persistentFieldComponent.addFieldNameModifiedListener(new FieldNameModifyListener());
        if (this._persistableFieldCallback != null) {
            this._persistentFieldComponent.setPersistableFieldCallback(this._persistableFieldCallback);
        }
    }

    private IPersistableField getField() {
        IPersistableField ret = null;
        if (this.getData() instanceof IPersistableField) {
            ret = (IPersistableField)this.getData();
        }
        return ret;
    }

    public void refreshDataFromUI() {
        if (this.isRefreshingUI()) {
            return;
        }
        super.refreshDataFromUI();
        if (this.getField() != null && this._persistentFieldComponent != null) {
            int arrDim;
            this._persistentFieldComponent.refreshDataFromUI();
            ModelDataConverter.syncToField(this._persistentFieldComponent.getPersistableFieldData(), this.getField());
            String persFieldType = this.getField().getType();
            if (this.getField() instanceof IPersistentField && (arrDim = ((IPersistentField)this.getField()).getDimension()) > 0) {
                StringBuffer strgBuffer = new StringBuffer(this.getField().getType());
                int i = 0;
                while (i < arrDim) {
                    strgBuffer.append("[]");
                    ++i;
                }
                persFieldType = strgBuffer.toString();
            }
            if (this._ejbMetaData != null && this._ejbMetaData.isWizardBean() && this.okToLeave() == null && persFieldType != null && this._ejbMetaData.getPrimaryKey() instanceof ICMP_PrimaryKey && !((ICMP_PrimaryKey)this._ejbMetaData.getPrimaryKey()).isCompoundKey() && this._ejbMetaData.getPersistentField(this.getField().getName()).isPKField()) {
                this.updateEjbMethods(this._ejbMetaData, persFieldType);
            }
        }
    }

    protected void updateEditableBehavior() {
        super.updateEditableBehavior();
        if (this._persistentFieldComponent != null) {
            this._persistentFieldComponent.setEditable(this.isEditable());
        }
    }

    private void updateEjbMethods(IEjbMetaData ejbMetaData, String persFieldType) {
        if (ejbMetaData != null) {
            IMethodWithUN[] createMethods = ejbMetaData.getCreateMethods();
            IMethodWithUN[] finderMethods = ejbMetaData.getFinderMethods();
            if (createMethods != null) {
                int i = 0;
                while (i < createMethods.length) {
                    IMethodWithUN createMethod = createMethods[i];
                    if (persFieldType != null && !persFieldType.equals("")) {
                        this.updateCreateMethod(persFieldType, createMethod);
                    }
                    ++i;
                }
            }
            if (finderMethods != null) {
                int j = 0;
                while (j < finderMethods.length) {
                    IMethodWithUN findMethod = finderMethods[j];
                    if (persFieldType != null && !persFieldType.equals("")) {
                        this.updateFindMethod(persFieldType, findMethod);
                    }
                    ++j;
                }
            }
        }
    }

    private void updateFindMethod(String primaryKeyType, IMethodWithUN findMethod) {
        if (findMethod.getName().equalsIgnoreCase("ejbFindByPrimaryKey")) {
            if (!findMethod.getReturnType().equals(primaryKeyType)) {
                findMethod.setReturnType(primaryKeyType);
            }
            findMethod.setParameters(new String[]{primaryKeyType}, new String[]{"pK"});
        } else if (!findMethod.getReturnType().equals("java.util.Collection") && !findMethod.getReturnType().equals(primaryKeyType)) {
            findMethod.setReturnType(primaryKeyType);
        }
        if (!findMethod.isNew()) {
            findMethod.setState(2);
        }
    }

    private void updateCreateMethod(String primaryKeyType, IMethodWithUN method) {
        if (!method.getReturnType().equals(primaryKeyType)) {
            method.setReturnType(primaryKeyType);
            if (method.getName().equalsIgnoreCase("ejbCreateByPrimaryKey")) {
                method.setParameters(new String[]{primaryKeyType}, new String[]{"pK"});
            }
            if (!method.isNew()) {
                method.setState(2);
            }
        }
    }

    public void refreshUIFromData() {
        this.startRefreshingUI();
        super.refreshUIFromData();
        if (this.getField() != null && this._persistentFieldComponent != null) {
            ModelDataConverter.syncToFieldData(this.getField(), this._persistentFieldComponent.getPersistableFieldData());
            this._persistentFieldComponent.refreshUIFromData();
        }
        this.stopRefreshingUI();
    }

    public void dataModified(boolean modified) {
        if (this.getModifiedCallback() != null) {
            this.refreshDataFromUI();
            this.getModifiedCallback().dataModified(modified);
        }
    }

    public String okToLeave() {
        String ret = super.okToLeave();
        if (ret == null && this._persistentFieldComponent != null) {
            int statusSeverity;
            IStatus validationStatus = this._persistentFieldComponent.getValidationStatus();
            ret = !validationStatus.isOK() ? ((statusSeverity = validationStatus.getSeverity()) == 2 ? "{$LEAVABLE_WARNING}" + validationStatus.getMessage() : (statusSeverity == 1 ? "{$INFO}" + validationStatus.getMessage() : "{$ERROR}" + validationStatus.getMessage())) : this.isContentValid().getMessage();
        }
        return ret;
    }

    private StatusWrapper isContentValid() {
        StatusWrapper status = new StatusWrapper();
        status.setOK();
        IPrimaryKey pk = this._ejbMetaData.getPrimaryKey();
        boolean isPrimitiveType = this._ejbEditorTypeUtil.isPrimitiveType(this.getField().getType());
        boolean classExists = false;
        String typeName = this._persistentFieldComponent.getPersistableFieldData().getFullQualifiedTypeName();
        if (!isPrimitiveType) {
            classExists = this._ejbEditorTypeUtil.checkForTypeExistance(typeName);
        }
        if (typeName.equals("void")) {
            status.setError("Void is not allowed here.");
            return status;
        }
        if (!isPrimitiveType && !classExists) {
            if (this._ejbMetaData.isWizardBean()) {
                if (!(this._ejbMetaData.getBeanclassName().equals(typeName) || this._ejbMetaData.getPrimaryKey() != null && this._ejbMetaData.getPrimaryKey().getPrimaryKeyClass() != null && this._ejbMetaData.getPrimaryKey().getPrimaryKeyClass().getName().equals(typeName) || this._ejbMetaData.getHomeIFName() != null && this._ejbMetaData.getHomeIFName().equals(typeName) || this._ejbMetaData.getRemoteIFName() != null && this._ejbMetaData.getRemoteIFName().equals(typeName) || this._ejbMetaData.getLocalHomeIFName() != null && this._ejbMetaData.getLocalHomeIFName().equals(typeName) || this._ejbMetaData.getLocalIFName() != null && this._ejbMetaData.getLocalIFName().equals(typeName))) {
                    StringBuffer sb = new StringBuffer("Type ");
                    sb.append(typeName);
                    sb.append(" does not exist in the referenced projects!");
                    status.setInfo("{$LEAVABLE_WARNING}" + sb.toString());
                }
            } else {
                StringBuffer sb = new StringBuffer("Type ");
                sb.append(typeName);
                sb.append(" does not exist in the referenced projects!");
                status.setWarning("{$LEAVABLE_WARNING}" + sb.toString());
            }
            return status;
        }
        if (this.getField() instanceof IPersistentField && this._ejbMetaData.getPersistentField(this.getField().getName()).isPKField() && (!(pk instanceof ICMP_PrimaryKey) || !((ICMP_PrimaryKey)pk).isCompoundKey())) {
            if (this._persistentFieldComponent != null && this._persistentFieldComponent.getPersistableFieldData().getArrayDimension() > 0) {
                status.setError(TXT_ERR_NO_ARR_FOR_PK);
                return status;
            }
            if (isPrimitiveType) {
                status.setError(TXT_ERR_NO_SIMPLETYPE_FOR_PK);
            }
            return status;
        }
        return status;
    }

    public boolean isEditable() {
        return super.isEditable() && !this.isNeverEditable();
    }

    public boolean isNeverEditable() {
        return this._neverEditable;
    }

    public void setNeverEditable(boolean b) {
        this._neverEditable = b;
        this.updateEditableBehavior();
    }

    protected static interface IFieldNameModifyListener {
        public void fieldNameModified();
    }

    private class FieldNameModifyListener
    implements IFieldNameModifyListener {
        private FieldNameModifyListener() {
        }

        public void fieldNameModified() {
            FieldEditorComponent.this.refreshDataFromUI();
        }
    }
}

