/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.ejb.components.fields;

import com.tssap.j2ee.model.J2eeProjectManager;
import com.tssap.j2ee.model.ejb.IBMP_PrimaryKey;
import com.tssap.j2ee.model.ejb.IClassDataBean;
import com.tssap.j2ee.model.ejb.IEjbProject;
import com.tssap.j2ee.ui.core.GenericJavaTypeChooser;
import com.tssap.j2ee.ui.ejb.components.IEjbMetaData;
import com.tssap.j2ee.ui.ejb.components.fields.PrimaryKeyEditorComponent;
import com.tssap.j2ee.ui.ejb.model.EjbMetaDataFactory;
import com.tssap.j2ee.ui.ejb.model.util.ModelDataConverter;
import com.tssap.j2ee.util.core.StatusWrapper;
import com.tssap.util.core.IConstants;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.IModifiedCallback;
import com.tssap.util.ui.reuse.chooser.IChooser;
import com.tssap.util.ui.reuse.java.ITypeData;
import com.tssap.util.ui.reuse.java.TypeComponent2;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;

public class BmpPrimaryKeyEditorComponent
extends PrimaryKeyEditorComponent
implements IModifiedCallback {
    private static final String TXT_ENTER_PK_TYPE = "Please enter a primary key class type.";
    private static final String TXT_NO_PRIMITIVE_TYPES = "Primitive datatypes are not allowed as primary key class.";
    private static final String TXT_PACKAGE_MISSING = "Creating a class without defining a package could lead to problems!";
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$ejb$components$fields$BmpPrimaryKeyEditorComponent == null ? (class$com$tssap$j2ee$ui$ejb$components$fields$BmpPrimaryKeyEditorComponent = BmpPrimaryKeyEditorComponent.class$("com.tssap.j2ee.ui.ejb.components.fields.BmpPrimaryKeyEditorComponent")) : class$com$tssap$j2ee$ui$ejb$components$fields$BmpPrimaryKeyEditorComponent));
    private TypeComponent2 typeComponent = null;
    private IEjbProject currentEjbProject = null;
    private boolean classHasDefaultPackage = false;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$ejb$components$fields$BmpPrimaryKeyEditorComponent;

    public BmpPrimaryKeyEditorComponent(IEjbMetaData ejbMetaData) {
        super(ejbMetaData);
    }

    public BmpPrimaryKeyEditorComponent(String title) {
        super(title);
    }

    public void dataModified(boolean modified) {
        if (this.getModifiedCallback() != null) {
            this.getModifiedCallback().dataModified(modified);
        }
    }

    public void initContainer(IGridLayoutPane userArea) {
        ITypeData typeData = this.getTypeData();
        this.typeComponent = new TypeComponent2(typeData);
        this.typeComponent.setAutoRefreshData(true);
        this.typeComponent.setShowArrayCheckbox(false);
        String ejbProjectName = this.getEjbMetaData().getEjbProjectName();
        this.currentEjbProject = J2eeProjectManager.getEjbModule((String)ejbProjectName);
        this.typeComponent.setTypeChooser((IChooser)new GenericJavaTypeChooser(new IJavaProject[]{this.currentEjbProject.getJavaProject()}, 16, 2));
        this.typeComponent.createPartControl(userArea, true, false);
        this.typeComponent.getTypeNameSelector().setTextFieldReadOnly(true);
        this.setTypeComponent(this.typeComponent);
        this.decorateControls();
    }

    private ITypeData getTypeData() {
        ITypeData typeData = null;
        if (this.getBMP_PrimaryKey() != null) {
            IClassDataBean compoundKey = this.getBMP_PrimaryKey().getPrimaryKeyClass();
            typeData = ModelDataConverter.transformToTypeData(compoundKey);
        }
        return typeData;
    }

    private void decorateControls() {
        this.getTypeComponent().addModifyListener((ModifyListener)new TypeComponentListener());
    }

    public String okToLeave() {
        String message = this.getTypeComponent().okToLeave();
        StatusWrapper status = this.isContentValid();
        if (!status.getStatusInfo().isOK()) {
            message = status.getMessage();
        }
        if (!status.getStatusInfo().matches(2)) {
            return message;
        }
        return null;
    }

    private StatusWrapper isContentValid() {
        StatusWrapper status = new StatusWrapper();
        status.setOK();
        String typeName = this.getTypeComponent().getTypeData().getFullQualifiedTypeName();
        boolean primitiveType = false;
        int j = 0;
        while (j < IConstants.PARAMETER_TYPES.length && !primitiveType) {
            if (typeName.equals(IConstants.PARAMETER_TYPES[j])) {
                primitiveType = true;
            }
            ++j;
        }
        if (typeName != null && !typeName.equals("")) {
            if (primitiveType) {
                status.setError(TXT_NO_PRIMITIVE_TYPES);
            } else if (this.classHasDefaultPackage) {
                status.setError(TXT_PACKAGE_MISSING);
            }
        } else {
            status.setError(TXT_ENTER_PK_TYPE);
        }
        return status;
    }

    public void refreshDataFromUI() {
        if (this.isRefreshingUI()) {
            return;
        }
        IClassDataBean bmpKeyClassDataBean = null;
        this.getTypeComponent().refreshDataFromUI();
        ITypeData typeData = this.getTypeComponent().getTypeData();
        this.classHasDefaultPackage = typeData.getFullQualifiedTypeName().indexOf(".") == -1;
        String chosenType = typeData != null ? typeData.getFullQualifiedTypeName() : "";
        bmpKeyClassDataBean = EjbMetaDataFactory.createClassDataBean();
        bmpKeyClassDataBean.setName(chosenType);
        if (bmpKeyClassDataBean != null && bmpKeyClassDataBean.getName() != null) {
            this.setBmpPK(bmpKeyClassDataBean);
        }
        if (this.getEjbMetaData() != null && this.getEjbMetaData().isWizardBean()) {
            this.updateEjbMethods(this.getEjbMetaData(), null, bmpKeyClassDataBean.getName());
        }
    }

    private void setBmpPK(IClassDataBean bmpKeyClassDataBean) {
        if (this.getBMP_PrimaryKey() != null) {
            this.getBMP_PrimaryKey().setPrimaryKeyClass(bmpKeyClassDataBean);
        }
    }

    public void refreshUIFromData() {
        this.startRefreshingUI();
        if (this.getBMP_PrimaryKey() != null) {
            ITypeData currentTypeData = ModelDataConverter.transformToTypeData(this.getBMP_PrimaryKey().getPrimaryKeyClass());
            this.getTypeComponent().setTypeData(currentTypeData);
            this.getTypeComponent().refreshUIFromData();
        }
        this.stopRefreshingUI();
    }

    private IBMP_PrimaryKey getBMP_PrimaryKey() {
        IBMP_PrimaryKey key = null;
        if (this.getEjbMetaData() != null) {
            if (this.getEjbMetaData().getPrimaryKey() instanceof IBMP_PrimaryKey) {
                key = (IBMP_PrimaryKey)this.getEjbMetaData().getPrimaryKey();
            } else {
                tracer.error("getPrimaryKey()", "The Primary Key is not of type IBMP_PrimaryKey.");
            }
        } else {
            tracer.error("getPrimaryKey()", "getEjbMetaData() returns null. This must not occur.");
        }
        return key;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class TypeComponentListener
    implements ModifyListener {
        TypeComponentListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (!BmpPrimaryKeyEditorComponent.super.isRefreshingUI()) {
                BmpPrimaryKeyEditorComponent.this.refreshDataFromUI();
                BmpPrimaryKeyEditorComponent.this.dataModified(true);
            }
        }
    }
}

