/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.ejb.components.cmr;

import com.tssap.j2ee.model.J2eeProjectManager;
import com.tssap.j2ee.model.ejb.ICMRField;
import com.tssap.j2ee.model.ejb.IEjbModule;
import com.tssap.j2ee.model.ejb.IEjbProject;
import com.tssap.j2ee.model.ejb.IEjbRelation;
import com.tssap.j2ee.model.ejb.IEjbRelationRole;
import com.tssap.j2ee.model.ejb.IEnterpriseJavaBean;
import com.tssap.j2ee.model.ejb.IEntityBean;
import com.tssap.j2ee.model.ejb.IPersistableField;
import com.tssap.j2ee.ui.components.ICmrCallback;
import com.tssap.j2ee.ui.ejb.components.IEjbMetaData;
import com.tssap.j2ee.ui.ejb.components.IEjbMetaDataHolder;
import com.tssap.j2ee.ui.ejb.components.cmr.CmrEditorComponent;
import com.tssap.util.ui.reuse.IReuseable;
import com.tssap.util.ui.reuse.IReuseableManager;
import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.jdt.core.IType;

public class CmrReusableManager
implements IReuseableManager,
ICmrCallback {
    private IEjbMetaDataHolder ejbMetaDataHolder;
    private IEjbRelation lastRelation;

    public CmrReusableManager() {
    }

    public CmrReusableManager(IEjbMetaDataHolder ejbMetaDataHolder) {
        this.ejbMetaDataHolder = ejbMetaDataHolder;
    }

    public IReuseable getReusable(Object obj) {
        CmrEditorComponent ret = null;
        if (obj != null && obj instanceof IEjbRelation) {
            IEjbRelation ejbRelation = (IEjbRelation)obj;
            CmrEditorComponent newCmrEditorComp = new CmrEditorComponent(ejbRelation);
            newCmrEditorComp.setCmrCallback(this);
            ret = newCmrEditorComp;
            this.setLastRelation(ejbRelation);
        }
        return ret;
    }

    protected IEjbMetaData getEjbMetaData() {
        IEjbMetaData ret = null;
        if (this.ejbMetaDataHolder != null) {
            ret = this.ejbMetaDataHolder.getEjbMetaData();
        }
        return ret;
    }

    public String[] getAvailableCmpBeanNames(boolean localInterfaceRequired) {
        String[] ret = new String[]{};
        IEjbProject ejbProject = this.getCurrentEjbProject();
        IEnterpriseJavaBean[] entityBeans = ejbProject.getEnterpriseBeans(0);
        ArrayList<String> retList = new ArrayList<String>();
        int i = 0;
        while (i < entityBeans.length) {
            IEnterpriseJavaBean entityBean = entityBeans[i];
            if (entityBean instanceof IEntityBean && ((IEntityBean)entityBean).isCMP() && (!localInterfaceRequired || entityBean.getLocalInterfaceClass() != null)) {
                retList.add(entityBean.getDefaultEjbName());
            }
            ++i;
        }
        ret = retList.toArray(ret);
        return ret;
    }

    private IEjbProject getCurrentEjbProject() {
        String ejbProjectName = this.getEjbMetaData().getEjbProjectName();
        IEjbModule ejbProject = J2eeProjectManager.getEjbModule((String)ejbProjectName);
        return ejbProject;
    }

    public String getCurrentBeanName() {
        String ret = this.getEjbMetaData().getBeanclassName();
        return ret;
    }

    public String transformEjbNameToLocalInterfaceName(String ejbName) {
        IType localInterfaceClass;
        String ret = null;
        IEnterpriseJavaBean enterpriseBean = this.getCurrentEjbProject().getEnterpriseBean(ejbName);
        if (enterpriseBean != null && (localInterfaceClass = enterpriseBean.getLocalInterfaceClass()) != null) {
            ret = localInterfaceClass.getFullyQualifiedName();
        }
        return ret;
    }

    public String[] getDisapprovedFieldNames() {
        String[] ret = new String[]{};
        Vector<String> retVector = new Vector<String>();
        ICMRField lastField1 = null;
        ICMRField lastField2 = null;
        IEjbRelationRole lastRole1 = this.getLastRelation().getRole1();
        if (lastRole1 != null) {
            lastField1 = lastRole1.getCmrField();
        }
        IEjbRelationRole lastRole2 = this.getLastRelation().getRole2();
        if (lastRole1 != null) {
            lastField2 = lastRole2.getCmrField();
        }
        IPersistableField[] persistentFields = this.getEjbMetaData().getPersistentFields().values().toArray(new IPersistableField[0]);
        int i = 0;
        while (i < persistentFields.length) {
            retVector.add(persistentFields[i].getName());
            ++i;
        }
        IPersistableField[] cmrFields = this.getEjbMetaData().getCMRFields().values().toArray(new IPersistableField[0]);
        int i2 = 0;
        while (i2 < cmrFields.length) {
            if (!(lastField1 != null && lastField1.getName().equals(cmrFields[i2].getName()) || lastField2 != null && lastField2.getName().equals(cmrFields[i2].getName()))) {
                retVector.add(cmrFields[i2].getName());
            }
            ++i2;
        }
        ret = retVector.toArray(ret);
        return ret;
    }

    public String[] getDisapprovedFieldNamesOld() {
        String[] ret = new String[]{};
        Vector<String> retVector = new Vector<String>();
        if (this.getLastRelation() != null) {
            ICMRField lastField1 = null;
            ICMRField lastField2 = null;
            IEjbRelationRole lastRole1 = this.getLastRelation().getRole1();
            if (lastRole1 != null) {
                lastField1 = lastRole1.getCmrField();
            }
            IEjbRelationRole lastRole2 = this.getLastRelation().getRole2();
            if (lastRole1 != null) {
                lastField2 = lastRole2.getCmrField();
            }
            IPersistableField[] persistentFields = this.getEjbMetaData().getPersistentFields().values().toArray(new IPersistableField[0]);
            int i = 0;
            while (i < persistentFields.length) {
                if (!(lastField1 != null && lastField1.getName().equals(persistentFields[i].getName()) || lastField2 != null && lastField2.getName().equals(persistentFields[i].getName()))) {
                    retVector.add(persistentFields[i].getName());
                }
                ++i;
            }
            IPersistableField[] cmrFields = this.getEjbMetaData().getCMRFields().values().toArray(new IPersistableField[0]);
            int i2 = 0;
            while (i2 < cmrFields.length) {
                if (!(lastField1 != null && lastField1.getName().equals(cmrFields[i2].getName()) || lastField2 != null && lastField2.getName().equals(cmrFields[i2].getName()))) {
                    retVector.add(cmrFields[i2].getName());
                }
                ++i2;
            }
            ret = retVector.toArray(ret);
        }
        return ret;
    }

    protected void setLastRelation(IEjbRelation lastRelation) {
        this.lastRelation = lastRelation;
    }

    protected IEjbRelation getLastRelation() {
        return this.lastRelation;
    }
}

