/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.ejb.components.cmr;

import com.tssap.j2ee.model.ejb.IEjbRelation;
import com.tssap.j2ee.ui.UIPlugin;
import com.tssap.j2ee.ui.ejb.components.IEjbMetaData;
import com.tssap.j2ee.ui.ejb.components.cmr.CmrInfrastructure;
import com.tssap.j2ee.ui.ejb.components.cmr.CmrUtil;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class CmrLabelProvider
extends LabelProvider
implements CmrInfrastructure {
    private static final String RELATION_FOLDER_TEXT_PART_3 = " in Role ";
    private IEjbMetaData ejbMetaData;

    public CmrLabelProvider(IEjbMetaData ejbMetaData) {
        this.setEjbMetaData(ejbMetaData);
    }

    public String getText(Object element) {
        String ret = super.getText(element);
        if (element != null) {
            if (element.equals("Relationships")) {
                ret = "Relationships";
            } else if (element.equals("Relations with EJB in role 1") || element.equals("Relations with EJB in role 2")) {
                String part2 = CmrUtil.getEjbShortName(this.getEjbMetaData());
                String prefix = part2 + RELATION_FOLDER_TEXT_PART_3;
                ret = element.equals("Relations with EJB in role 1") ? prefix + "1" : prefix + "2";
            } else if (element instanceof IEjbRelation) {
                IEjbRelation ejbRelation = (IEjbRelation)element;
                ret = ejbRelation.getRelationName();
            }
        }
        return ret;
    }

    public Image getImage(Object element) {
        Image ret = super.getImage(element);
        if (element.equals("Relationships") || element.equals("Relations with EJB in role 1") || element.equals("Relations with EJB in role 2")) {
            ret = UIPlugin.getImage((String)"Folder");
        } else if (element instanceof IEjbRelation) {
            IEjbRelation relation = (IEjbRelation)element;
            boolean out = this.isOutgoingRelation(relation);
            boolean in = this.isOutgoingRelation(relation);
            ret = out && in ? UIPlugin.getImage((String)"Ejb Relationship Link") : (in ? UIPlugin.getImage((String)"Ejb Relationship Link") : UIPlugin.getImage((String)"Ejb Relationship Link"));
        }
        return ret;
    }

    protected void setEjbMetaData(IEjbMetaData ejbMetaData) {
        this.ejbMetaData = ejbMetaData;
    }

    protected IEjbMetaData getEjbMetaData() {
        return this.ejbMetaData;
    }

    protected boolean isOutgoingRelation(IEjbRelation relation) {
        boolean ret = CmrUtil.isOutgoingRelation(relation, this.getEjbMetaData());
        return ret;
    }

    protected boolean isIncomingRelation(IEjbRelation relation) {
        boolean ret = CmrUtil.isIncomingRelation(relation, this.getEjbMetaData());
        return ret;
    }
}

