/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.ejb.components.cmr;

import com.tssap.j2ee.model.ejb.IEjbRelation;
import com.tssap.j2ee.ui.components.CmrComponent;
import com.tssap.j2ee.ui.components.CmrData;
import com.tssap.j2ee.ui.components.ICmrCallback;
import com.tssap.j2ee.ui.components.ICmrData;
import com.tssap.j2ee.ui.components.ICmrRoleData;
import com.tssap.j2ee.ui.ejb.model.util.ModelDataConverter;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.DefaultObjectEditorComponent;
import com.tssap.util.ui.reuse.IModifiedCallback;
import org.eclipse.core.runtime.IStatus;

class CmrEditorComponent
extends DefaultObjectEditorComponent
implements IModifiedCallback {
    private static final Object[] EMPTY = new Object[0];
    private IEjbRelation ejbRelation;
    private CmrComponent cmrComponent;
    private boolean refreshingUI = false;
    private ICmrCallback cmrCallback;

    public CmrEditorComponent(IEjbRelation relation) {
        super(null);
        this.setEjbRelation(relation);
    }

    public void initContainer(IGridLayoutPane userArea) {
        this.cmrComponent = new CmrComponent((ICmrData)new CmrData());
        this.cmrComponent.setCmrCallback(this.getCmrCallback());
        this.cmrComponent.createPartControl(userArea);
        this.cmrComponent.setModifiedCallback((IModifiedCallback)this);
    }

    private void setEjbRelation(IEjbRelation relation) {
        this.ejbRelation = relation;
    }

    private IEjbRelation getEjbRelation() {
        return this.ejbRelation;
    }

    public void refreshDataFromUI() {
        if (this.refreshingUI || this.okToLeave() != null) {
            return;
        }
        super.refreshDataFromUI();
        if (this.getEjbRelation() != null && this.cmrComponent != null && this.cmrComponent.getCmrData() != null && this.getEjbRelation() != null) {
            this.cmrComponent.refreshDataFromUI();
            ModelDataConverter.syncToEjbRelation(this.cmrComponent.getCmrData(), this.getEjbRelation());
        }
    }

    public void refreshUIFromData() {
        this.refreshingUI = true;
        super.refreshUIFromData();
        if (this.getEjbRelation() != null && this.cmrComponent != null) {
            ICmrData data = ModelDataConverter.syncToCmrData(this.getEjbRelation(), this.cmrComponent.getCmrData());
            this.cmrComponent.refreshUIFromData();
            String currentBeanName = this.getCmrCallback().getCurrentBeanName();
            ICmrRoleData[] roles = data.getRoles();
            int i = 0;
            while (i < roles.length) {
                String beanName = roles[i].getBeanName();
                boolean beanNamesEqual = beanName != null && currentBeanName != null && beanName.equals(currentBeanName);
                boolean beanNameReadOnly = beanNamesEqual && roles[i] != null && roles[i].getCmrFieldName() != null && roles[i].getCmrFieldName().length() > 0;
                this.cmrComponent.setBeanNameEditable(i, !beanNameReadOnly);
                ++i;
            }
        }
        this.refreshingUI = false;
    }

    public void dataModified(boolean modified) {
        if (this.getModifiedCallback() != null) {
            this.getModifiedCallback().dataModified(modified);
        }
    }

    public String okToLeave() {
        IStatus validationStatus;
        String ret = super.okToLeave();
        if (ret == null && this.cmrComponent != null && !(validationStatus = this.cmrComponent.getValidationStatus()).isOK()) {
            ret = validationStatus.getMessage();
        }
        return ret;
    }

    public ICmrCallback getCmrCallback() {
        return this.cmrCallback;
    }

    public void setCmrCallback(ICmrCallback cmrCallback) {
        this.cmrCallback = cmrCallback;
    }

    protected void updateEditableBehavior() {
        super.updateEditableBehavior();
        if (this.cmrComponent != null) {
            this.cmrComponent.setEditable(this.isEditable());
        }
    }
}

