/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.ejb.components.cmr;

import com.tssap.j2ee.model.IChangeable;
import com.tssap.j2ee.model.ejb.ICMRField;
import com.tssap.j2ee.model.ejb.IEjbRelation;
import com.tssap.j2ee.model.ejb.IEjbRelationRole;
import com.tssap.j2ee.ui.ejb.components.IEjbMetaData;
import com.tssap.j2ee.ui.ejb.components.IEjbMetaDataHolder;
import com.tssap.j2ee.ui.ejb.components.cmr.CmrInfrastructure;
import com.tssap.j2ee.ui.ejb.model.EjbMetaDataFactory;
import com.tssap.util.Util;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.reuse.tree.IAddRemoveCallback;

public class CmrAddRemoveCallback
implements IAddRemoveCallback,
CmrInfrastructure {
    private static final String RELATION_NAME_PREFIX = "relation";
    private static final String DEFAULT_CMR_FIELD_NAME_PREFIX = "cmrField_";
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$ejb$components$cmr$CmrAddRemoveCallback == null ? (class$com$tssap$j2ee$ui$ejb$components$cmr$CmrAddRemoveCallback = CmrAddRemoveCallback.class$("com.tssap.j2ee.ui.ejb.components.cmr.CmrAddRemoveCallback")) : class$com$tssap$j2ee$ui$ejb$components$cmr$CmrAddRemoveCallback));
    private IEjbMetaDataHolder ejbMetaDataHolder;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$ejb$components$cmr$CmrAddRemoveCallback;

    public CmrAddRemoveCallback(IEjbMetaDataHolder holder) {
        this.setEjbMetaDataHolder(holder);
    }

    private IEjbMetaData getEjbMetaData() {
        IEjbMetaData ret = null;
        if (this.getEjbMetaDataHolder() != null) {
            ret = this.getEjbMetaDataHolder().getEjbMetaData();
        }
        return ret;
    }

    private void setEjbMetaDataHolder(IEjbMetaDataHolder ejbMetaDataHolder) {
        this.ejbMetaDataHolder = ejbMetaDataHolder;
    }

    private IEjbMetaDataHolder getEjbMetaDataHolder() {
        return this.ejbMetaDataHolder;
    }

    public Object addElement(Object currentSelection) {
        IEjbRelation ret = null;
        if (currentSelection != null) {
            String newRelationNamePrefix = RELATION_NAME_PREFIX;
            String[] oldRelationNames = this.getExistingRelationNames();
            String newRelationName = Util.createReallyNewName((String)newRelationNamePrefix, (String[])oldRelationNames);
            ICMRField cmrField = EjbMetaDataFactory.createCMRField(DEFAULT_CMR_FIELD_NAME_PREFIX + newRelationName, "");
            String currentBeanName = this.getEjbMetaData().getBeanclassName();
            IEjbRelationRole relationRole = EjbMetaDataFactory.createEjbRelationRole(1, cmrField, currentBeanName);
            if (currentSelection.equals("Relations with EJB in role 1") || currentSelection.equals("Relationships")) {
                ret = EjbMetaDataFactory.createEjbRelation(relationRole, EjbMetaDataFactory.createEjbRelationRole(), newRelationName, "description");
                this.getEjbMetaData().setEjbRelation(ret);
            } else if (currentSelection.equals("Relations with EJB in role 2")) {
                ret = EjbMetaDataFactory.createEjbRelation(EjbMetaDataFactory.createEjbRelationRole(), relationRole, newRelationName, "description");
                this.getEjbMetaData().setEjbRelation(ret);
            }
        }
        return ret;
    }

    private String[] getExistingRelationNames() {
        IEjbRelation[] relations = this.getEjbMetaData().getEjbRelations();
        String[] oldRelationNames = new String[relations.length];
        int i = 0;
        while (i < relations.length) {
            IEjbRelation relation = relations[i];
            oldRelationNames[i] = relation.getRelationName();
            ++i;
        }
        return oldRelationNames;
    }

    public boolean canAddElement(Object currentSelection) {
        boolean ret = false;
        if (currentSelection != null && (currentSelection.equals("Relations with EJB in role 1") || currentSelection.equals("Relationships") || currentSelection.equals("Relations with EJB in role 2"))) {
            boolean hasLocalHomeInterface;
            String localIFName = this.getEjbMetaData().getLocalIFName();
            boolean hasLocalInterface = localIFName != null && localIFName.length() > 0;
            String localHomeIfName = this.getEjbMetaData().getLocalHomeIFName();
            boolean bl = hasLocalHomeInterface = localHomeIfName != null && localHomeIfName.length() > 0;
            if (hasLocalInterface && hasLocalHomeInterface) {
                ret = true;
            }
        }
        return ret;
    }

    public boolean canRemoveElement(Object currentSelection) {
        boolean ret = false;
        if (currentSelection instanceof IEjbRelation) {
            ret = true;
        }
        return ret;
    }

    public boolean removeElement(Object currentSelection) {
        String ejbRelationName;
        IEjbRelation ejbRelation;
        boolean ret = false;
        if (currentSelection instanceof IEjbRelation && (ejbRelation = (IEjbRelation)currentSelection) != null && (ejbRelationName = ejbRelation.getRelationName()) != null && ejbRelationName.length() > 0) {
            if (ejbRelation instanceof IChangeable && !((IChangeable)ejbRelation).isNew()) {
                ((IChangeable)ejbRelation).setState(3);
            } else {
                this.getEjbMetaData().removeEjbRelation(ejbRelationName);
            }
            ret = true;
        }
        return ret;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

