/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.ejb.components;

import com.tssap.j2ee.ui.UIPlugin;
import com.tssap.j2ee.ui.ejb.components.EjbEditorComponent;
import com.tssap.j2ee.ui.ejb.components.IEjbMetaData;
import com.tssap.j2ee.ui.ejb.model.EJBConstants;
import com.tssap.util.action.predefined.OpenInEditorAction;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.EditableVisitor;
import com.tssap.util.ui.IControlVisitor;
import com.tssap.util.ui.SWTUtil;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class OverviewEditorComponent
extends EjbEditorComponent {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$ejb$components$OverviewEditorComponent == null ? (class$com$tssap$j2ee$ui$ejb$components$OverviewEditorComponent = OverviewEditorComponent.class$("com.tssap.j2ee.ui.ejb.components.OverviewEditorComponent")) : class$com$tssap$j2ee$ui$ejb$components$OverviewEditorComponent));
    private Text ejbNameTextField;
    private Text ejbComplianceTextField;
    private Text ejbPersistenceTextField;
    private Text ejbTransactionTypeTextField;
    private Button ejbReentrantCheckBox;
    private Text ejbTypeTextField;
    private Text beanClassTextField;
    private Button beanClassButton;
    private NavigateListener beanClassNavigateListener;
    private Text homeIFTextField;
    private Button homeIFButton;
    private NavigateListener homeIFNavigateListener;
    private Text localHomeIFTextField;
    private Button localHomeIFButton;
    private NavigateListener localHomeIFNavigateListener;
    private Text remoteIFTextField;
    private Button remoteIFButton;
    private NavigateListener remoteIFNavigateListener;
    private Text localIFTextField;
    private Button localIFButton;
    private NavigateListener localIFNavigateListener;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$ejb$components$OverviewEditorComponent;

    public OverviewEditorComponent() {
    }

    public OverviewEditorComponent(String title) {
        super(title);
    }

    public Control createControls(IGridLayoutPane glp) {
        IGridLayoutData glData = glp.createGridLayoutData(4, 2, true, false);
        IGridLayoutPane informationGlp = glp.addGridLayoutPane("Information", 2, glData);
        informationGlp.addTextLabel("Name");
        glData = glp.createGridLayoutData(4, 2, true, false);
        this.ejbNameTextField = informationGlp.addTextField(true, glData);
        informationGlp.addTextLabel("Type");
        glData = glp.createGridLayoutData(4, 2, true, false);
        this.ejbTypeTextField = informationGlp.addTextField(true, glData);
        informationGlp.addTextLabel("Compliance");
        glData = glp.createGridLayoutData(4, 2, true, false);
        this.ejbComplianceTextField = informationGlp.addTextField(true, glData);
        if (this.getNoticeable().getEjbMetaData().getEjbType() == 2) {
            informationGlp.addTextLabel("Persistence");
            glData = glp.createGridLayoutData(4, 2, true, false);
            this.ejbPersistenceTextField = informationGlp.addTextField(true, glData);
        } else {
            informationGlp.addTextLabel("Transaction Type");
            glData = glp.createGridLayoutData(4, 2, true, false);
            this.ejbTransactionTypeTextField = informationGlp.addTextField(true, glData);
        }
        glData = informationGlp.createGridLayoutData(false, false, 2, 1);
        this.ejbReentrantCheckBox = informationGlp.addCheckBox("reentrant", false, glData);
        this.ejbReentrantCheckBox.setEnabled(false);
        glData = glp.createGridLayoutData(true, false);
        IGridLayoutPane navigationGlp = glp.addGridLayoutPane("Classes and Interfaces", 2, glData);
        glData = glp.createGridLayoutData(4, 2, true, false);
        this.beanClassTextField = navigationGlp.addTextField(true, glData);
        glData = glp.createGridLayoutData(4, 2, true, false);
        this.beanClassButton = navigationGlp.addPushButton("Navigate to Bean Class", glData);
        this.beanClassNavigateListener = new NavigateListener();
        this.beanClassButton.addSelectionListener((SelectionListener)this.beanClassNavigateListener);
        glData = glp.createGridLayoutData(4, 2, true, false);
        this.remoteIFTextField = navigationGlp.addTextField(true, glData);
        glData = glp.createGridLayoutData(4, 2, true, false);
        this.remoteIFButton = navigationGlp.addPushButton("Navigate to Remote Interface", glData);
        this.remoteIFNavigateListener = new NavigateListener();
        this.remoteIFButton.addSelectionListener((SelectionListener)this.remoteIFNavigateListener);
        glData = glp.createGridLayoutData(4, 2, true, false);
        this.homeIFTextField = navigationGlp.addTextField(true, glData);
        glData = glp.createGridLayoutData(4, 2, true, false);
        this.homeIFButton = navigationGlp.addPushButton("Navigate to Home Interface", glData);
        this.homeIFNavigateListener = new NavigateListener();
        this.homeIFButton.addSelectionListener((SelectionListener)this.homeIFNavigateListener);
        glData = glp.createGridLayoutData(4, 2, true, false);
        this.localIFTextField = navigationGlp.addTextField(true, glData);
        glData = glp.createGridLayoutData(4, 2, true, false);
        this.localIFButton = navigationGlp.addPushButton("Navigate to Local Interface", glData);
        this.localIFNavigateListener = new NavigateListener();
        this.localIFButton.addSelectionListener((SelectionListener)this.localIFNavigateListener);
        glData = glp.createGridLayoutData(4, 2, true, false);
        this.localHomeIFTextField = navigationGlp.addTextField(true, glData);
        glData = glp.createGridLayoutData(4, 2, true, false);
        this.localHomeIFButton = navigationGlp.addPushButton("Navigate to Local Home Interface", glData);
        this.localHomeIFNavigateListener = new NavigateListener();
        this.localHomeIFButton.addSelectionListener((SelectionListener)this.localHomeIFNavigateListener);
        Composite ret = glp.getParent();
        return ret;
    }

    public void initControlsWithEjbMetaData(IEjbMetaData ejbMetaData) {
        this.ejbNameTextField.setText(ejbMetaData.getDefaultEjbName());
        this.ejbTypeTextField.setText(EJBConstants.BEANTYPEC.TYPES[ejbMetaData.getEjbType()]);
        this.ejbComplianceTextField.setText(EJBConstants.EJBCOMPLIANCE.LABELS[ejbMetaData.getEjbCompliance()]);
        if (this.ejbPersistenceTextField != null) {
            this.ejbPersistenceTextField.setText(EJBConstants.PERSISTENCETYPE.LABELS[ejbMetaData.getPersistenceType()]);
        }
        if (this.ejbTransactionTypeTextField != null) {
            this.ejbTransactionTypeTextField.setText(EJBConstants.TRANSACTIONTYPE.LABELS[ejbMetaData.getEjbTransactionType()]);
        }
        this.ejbReentrantCheckBox.setSelection(ejbMetaData.isReentrant());
        IProject ejbProject = UIPlugin.getWorkspace().getRoot().getProject(ejbMetaData.getEjbProjectName());
        String name = ejbMetaData.getBeanclassName();
        this.initNavigation(ejbProject, name, this.beanClassTextField, this.beanClassButton, this.beanClassNavigateListener);
        name = ejbMetaData.getHomeIFName();
        this.initNavigation(ejbProject, name, this.homeIFTextField, this.homeIFButton, this.homeIFNavigateListener);
        name = ejbMetaData.getRemoteIFName();
        this.initNavigation(ejbProject, name, this.remoteIFTextField, this.remoteIFButton, this.remoteIFNavigateListener);
        name = ejbMetaData.getLocalHomeIFName();
        this.initNavigation(ejbProject, name, this.localHomeIFTextField, this.localHomeIFButton, this.localHomeIFNavigateListener);
        name = ejbMetaData.getLocalIFName();
        this.initNavigation(ejbProject, name, this.localIFTextField, this.localIFButton, this.localIFNavigateListener);
    }

    private void initNavigation(IProject ejbProject, String name, Text textField, Button navButton, NavigateListener navListener) {
        if (name != null) {
            textField.setText(name);
            IFile file = null;
            IJavaProject javaProject = JavaCore.create((IProject)ejbProject);
            if (javaProject != null) {
                try {
                    IType type = javaProject.findType(name);
                    if (type != null) {
                        if (!type.isBinary()) {
                            IResource resource = type.getCompilationUnit().getResource();
                            if (resource instanceof IFile) {
                                file = (IFile)resource;
                            }
                        } else {
                            file = (IFile)type.getClassFile().getResource();
                        }
                    }
                }
                catch (JavaModelException e) {
                    tracer.error("", (Throwable)e);
                }
            }
            if (file != null) {
                navListener.setFile(file);
                navButton.setEnabled(true);
            }
        } else {
            textField.setText("");
            navButton.setEnabled(false);
        }
    }

    public void updateEjbMetaDataFromControls(IEjbMetaData ejbMetaData) {
    }

    public void decorateControls() {
    }

    protected void updateEditableBehavior() {
        super.updateEditableBehavior();
        if (this.getUserAreaGridLayoutPane() != null && this.getUserAreaGridLayoutPane().getComposite() != null) {
            SWTUtil.visitControl((Control)this.getUserAreaGridLayoutPane().getComposite(), (IControlVisitor)new EditableVisitor(this.isEditable()));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class NavigateListener
    implements SelectionListener {
        private IFile file;

        public NavigateListener() {
        }

        public NavigateListener(IFile file) {
            this();
            this.setFile(file);
        }

        public void widgetSelected(SelectionEvent e) {
            if (this.getFile() != null) {
                OpenInEditorAction.openInEditor((IFile)this.getFile(), (boolean)true);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public IFile getFile() {
            return this.file;
        }

        public void setFile(IFile file) {
            this.file = file;
        }
    }
}

