/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.ejb.components;

import com.tssap.j2ee.ui.ejb.components.EjbEditorComponent;
import com.tssap.j2ee.ui.ejb.components.IEjbMetaData;
import com.tssap.j2ee.ui.ejb.components.IEjbMetaDataHolder;
import com.tssap.j2ee.util.core.StatusWrapper;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.IModifiedCallback;
import com.tssap.util.ui.reuse.ObjectEditorComponentUtil;
import com.tssap.util.ui.reuse.tree.TreeSelector;
import com.tssap.util.ui.reuse.tree.TreeSelectorEditorComponent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public abstract class EjbEditorComponentWithTreeSelector
extends EjbEditorComponent
implements IModifiedCallback,
IEjbMetaDataHolder {
    protected static final StatusWrapper OK_STATUS = new StatusWrapper();
    private boolean DO_UPDATE = false;
    private TreeSelectorEditorComponent treeSelectorEditorComponent;

    public EjbEditorComponentWithTreeSelector() {
    }

    public EjbEditorComponentWithTreeSelector(String title) {
        super(title);
    }

    public void initControlsWithEjbMetaData(IEjbMetaData ejbMetaData) {
        if (this.getTreeSelectorEditorComponent() != null) {
            Object treeInput = this.getTreeSelectorEditorComponent().getTreeSelector().getTreeInput();
            if (this.DO_UPDATE) {
                this.doUpdate(ejbMetaData);
            }
            if (treeInput == null) {
                this.getTreeSelectorEditorComponent().getTreeSelector().setTreeInput((Object)ejbMetaData);
                this.getTreeSelectorEditorComponent().getTreeSelector().getTreeViewer().expandAll();
            } else {
                this.getTreeSelectorEditorComponent().refreshTree();
            }
        }
    }

    public void updateEjbMetaDataFromControls(IEjbMetaData ejbMetaData) {
        this.getTreeSelectorEditorComponent().aboutToLeave();
    }

    public Control createControls(IGridLayoutPane glp) {
        TreeSelector treeSelector = new TreeSelector(true);
        this.treeSelectorEditorComponent = new TreeSelectorEditorComponent(treeSelector);
        Control ret = treeSelector.createPartControl(glp);
        return ret;
    }

    public void decorateControls() {
        this.getTreeSelectorEditorComponent().setModifiedCallback((IModifiedCallback)this);
        this.getTreeSelectorEditorComponent().getTreeSelector().getTreeViewer().expandAll();
    }

    public void dataModified(boolean modified) {
        TreeViewer treeViewer = this.getTreeSelectorEditorComponent().getTreeSelector().getTreeViewer();
        Tree tree = treeViewer.getTree();
        TreeItem[] selection = tree.getSelection();
        int i = 0;
        while (i < selection.length) {
            Object selectionData = selection[i].getData();
            treeViewer.refresh(selectionData, true);
            ++i;
        }
        this.setDirty(true);
        if (this.getModifiedCallback() != null) {
            this.getModifiedCallback().dataModified(modified);
        }
    }

    public IEjbMetaData getEjbMetaData() {
        return this.getNoticeable().getEjbMetaData();
    }

    public TreeSelectorEditorComponent getTreeSelectorEditorComponent() {
        return this.treeSelectorEditorComponent;
    }

    public void update(IEjbMetaData metaData) {
        this.initControlsWithEjbMetaData(metaData);
    }

    protected abstract void doUpdate(IEjbMetaData var1);

    public StatusWrapper validateContent() {
        String problemText;
        StatusWrapper ret = OK_STATUS;
        if (this.getTreeSelectorEditorComponent() != null && (problemText = this.getTreeSelectorEditorComponent().okToLeave()) != null) {
            int msgPrefixIndex = ObjectEditorComponentUtil.getMsgPrefixIndex((String)problemText);
            if (msgPrefixIndex < ObjectEditorComponentUtil.CHANGE_MSG_PREFIXES.length) {
                problemText = ObjectEditorComponentUtil.removeMsgPrefix((String)problemText);
            }
            ret = msgPrefixIndex == 0 ? new StatusWrapper(1, problemText) : (msgPrefixIndex == 1 ? new StatusWrapper(2, problemText) : new StatusWrapper(4, problemText));
        }
        return ret;
    }

    protected void updateEditableBehavior() {
        super.updateEditableBehavior();
        if (this.getTreeSelectorEditorComponent() != null) {
            this.getTreeSelectorEditorComponent().setEditable(this.isEditable());
        }
    }
}

