/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.buildplugin.techdev.ejbassembly;

import com.sap.tc.buildplugin.api.BuildActionResult;
import com.sap.tc.buildplugin.api.BuildActionSeverity;
import com.sap.tc.buildplugin.api.IBuildAction;
import com.sap.tc.buildplugin.api.IBuildInfo;
import com.sap.tc.buildplugin.api.IDevelopmentComponentInfo;
import com.sap.tc.buildplugin.pputil.PPCollector;
import com.sap.tc.buildplugin.techdev.ant.util.DirsAndFiles;
import com.sap.tc.buildplugin.techdev.ant.util.FileCreator;
import com.sap.tc.buildtool.LogFile;
import com.sap.tc.logging.Location;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CreateBuildFileAction
implements IBuildAction {
    BuildActionResult result;
    BuildActionSeverity severity;
    File pluginRoot;
    DirsAndFiles daf;
    FileCreator fCreator;
    ArrayList jars = new ArrayList();
    int br = 0;
    String errMsg = "";
    int currentStep;
    private IBuildInfo buildInfo;
    Location loc = Location.getLocation((Class)(class$com$sap$tc$buildplugin$techdev$ejbassembly$CreateBuildFileAction == null ? (class$com$sap$tc$buildplugin$techdev$ejbassembly$CreateBuildFileAction = CreateBuildFileAction.class$("com.sap.tc.buildplugin.techdev.ejbassembly.CreateBuildFileAction")) : class$com$sap$tc$buildplugin$techdev$ejbassembly$CreateBuildFileAction));
    static /* synthetic */ Class class$com$sap$tc$buildplugin$techdev$ejbassembly$CreateBuildFileAction;

    CreateBuildFileAction(FileCreator fc, int step, IBuildInfo buildInfo) {
        this.fCreator = fc;
        this.daf = fc.getDaf();
        this.currentStep = step;
        this.buildInfo = buildInfo;
        this.result = new BuildActionResult();
        this.severity = new BuildActionSeverity();
        this.severity.setStopOnError();
    }

    public BuildActionResult execute() {
        IDevelopmentComponentInfo componentInfo = this.buildInfo.getDevelopmentComponentInfo();
        this.loc.infoT("EJB Assembly Plugin starts creating the build file");
        switch (this.currentStep) {
            case 1: {
                this.daf.setBuildFile("prebuild.xml");
                this.fCreator.setMacroName("prebuild.vm");
                break;
            }
            case 2: {
                this.daf.setBuildFile("build.xml");
                this.fCreator.setMacroName("build.vm");
                break;
            }
            case 3: {
                this.daf.setBuildFile("postbuild.xml");
                this.fCreator.setMacroName("postbuild.vm");
                break;
            }
            default: {
                this.daf.setBuildFile("build.xml");
                this.fCreator.setMacroName("build.vm");
            }
        }
        String prebuildDir = this.daf.getTempDir() + File.separator + "pre";
        this.fCreator.setStrContext("dc_prebuild_Dir", prebuildDir);
        File prebuildDirF = new File(prebuildDir);
        if (prebuildDirF.exists()) {
            this.fCreator.setStrContext("dc_prebuild_Dir_exist", "true");
        }
        this.fCreator.setStrContext("dc_name", this.daf.getDCName());
        this.fCreator.setStrContext("dc_root_Dir", this.daf.getRootDir());
        Map ppMap = this.daf.getPublicParts();
        if (ppMap != null) {
            PPCollector pp = new PPCollector(componentInfo);
            this.br = pp.addData(ppMap);
            this.errMsg = pp.getErrorMsg();
            this.fCreator.setListContext("dc_public_parts", pp.getList());
        }
        List sourceDirs = this.daf.getSourceDirs();
        this.fCreator.setListContext("dc_source_dirs", sourceDirs);
        int i = 0;
        while (i < sourceDirs.size()) {
            String sourceFolderName = (String)sourceDirs.get(i);
            if (sourceFolderName.equalsIgnoreCase("META-INF")) {
                this.fCreator.setStrContext("dc_meta_inf_dir", sourceFolderName);
            } else {
                this.loc.infoT("error: only META-INF beneath the root is allowed!");
            }
            ++i;
        }
        HashMap<String, String> classPath = new HashMap<String, String>();
        List dependDirs = this.daf.getDependDirs();
        if (dependDirs != null) {
            Iterator iterator = dependDirs.iterator();
            int no = 0;
            while (iterator.hasNext()) {
                classPath.put("dependDir_" + ++no, (String)iterator.next());
            }
        }
        this.fCreator.setHashMapContext("dc_depend_compileDirs", classPath);
        this.fCreator.setListContext("dc_depend_compileDirsWO", this.daf.getCompilationDirs());
        this.fCreator.setStrContext("dc_gen_publicDir", this.daf.getGenDirPublic());
        List assDep = this.daf.getAssemblyDirs();
        this.fCreator.setListContext("dc_depend_assemblyDirs", assDep);
        this.fCreator.setStrContext("dc_gen_tempDir", this.daf.getTempDir());
        this.fCreator.setStrContext("dc_client_api_file", this.daf.getDcFile());
        this.fCreator.setStrContext("dc_deployFile", this.daf.getDcFile());
        try {
            this.fCreator.setStrContext("compiler_executable_path", this.buildInfo.getCompilerExecutable());
        }
        catch (NoSuchMethodError ex) {
            String msg = "pluginhandler does not supply getCompilerExecutable";
            this.loc.traceThrowableT(300, msg, (Throwable)ex);
        }
        if (this.br != 2 && this.br != 3 && this.daf.checkAssDependencies() && this.daf.checkCompDependencies()) {
            this.fCreator.createBuildFile();
        } else {
            LogFile log = new LogFile();
            if (!this.daf.checkAssDependencies()) {
                this.errMsg = this.daf.getErrorMsgAss();
                this.br = 2;
            } else if (!this.daf.checkCompDependencies()) {
                this.errMsg = this.daf.getErrorMsgCompile();
                this.br = 2;
            }
            log.setErrorMessage(this.errMsg);
            log.writeLogFile(this.daf.getLogFile());
        }
        this.result.setBuildLogPath(this.daf.getLogFile());
        this.result.setBuildActionRC(this.br);
        return this.result;
    }

    public BuildActionResult getBuildActionResult() {
        return this.result;
    }

    public BuildActionSeverity getBuildActionSeverity() {
        return this.severity;
    }

    public void setBuildActionSeverity(BuildActionSeverity _severity) {
        this.severity = _severity;
    }

    public String getCaption() {
        return "Create Build file";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

