/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlj.runtime.profile.util;

import com.sap.sql.sqlj.framework.error.ErrorLog;
import com.sap.sql.sqlj.framework.error.Info;
import com.sap.sql.sqlj.framework.error.JSError;
import com.sap.sql.sqlj.framework.error.LogEntry;
import com.sap.sql.sqlj.framework.error.Position;
import com.sap.sql.sqlj.framework.error.Warning;
import com.sap.sql.sqlj.framework.ide.TranslationOptionsQuery;
import com.sap.sql.sqlj.framework.options.ConnectionFactory;
import com.sap.sql.sqlj.mesg.CustomizerHarnessErrors;
import com.sap.sql.sqlj.runtime.profile.util.ProfileCustomizer;
import com.sap.sql.sqlj.runtime.profile.util.ProfileIOContext;
import com.sap.tc.logging.Location;
import java.beans.BeanInfo;
import java.beans.Beans;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.Checksum;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import sqlj.runtime.profile.DefaultLoader;
import sqlj.runtime.profile.Loader;
import sqlj.runtime.profile.Profile;
import sun.misc.BASE64Encoder;

public class CustomizerHarness {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$sql$sqlj$runtime$profile$util$CustomizerHarness == null ? (class$com$sap$sql$sqlj$runtime$profile$util$CustomizerHarness = CustomizerHarness.class$("com.sap.sql.sqlj.runtime.profile.util.CustomizerHarness")) : class$com$sap$sql$sqlj$runtime$profile$util$CustomizerHarness));
    private ConnectionFactory m_connFact = new ConnectionFactory();
    private ProfileCustomizer m_customizer = null;
    private boolean m_help = false;
    private boolean m_backup = false;
    private String m_contextList = null;
    private Hashtable m_contextTable = new Hashtable();
    private String m_driverList = null;
    private Hashtable m_driverTable = new Hashtable();
    private String m_digests;
    private MessageDigest[] m_digestArray;
    private Connection m_conn = null;
    private static final String[] SHARED_OPTIONS = new String[]{"verbose"};
    static /* synthetic */ Class class$com$sap$sql$sqlj$runtime$profile$util$CustomizerHarness;

    public CustomizerHarness() {
        this.setDigests("SHA,MD5");
        this.setDriver(ConnectionFactory.DRIVER_DEFAULT);
    }

    public ProfileCustomizer getCustomizer() {
        return this.m_customizer;
    }

    public void setCustomizer(ProfileCustomizer customizer) {
        this.m_customizer = customizer;
    }

    public boolean getHelp() {
        return this.m_help;
    }

    public void setHelp(boolean help) {
        this.m_help = help;
    }

    public boolean getBackup() {
        return this.m_backup;
    }

    public void setBackup(boolean backup) {
        this.m_backup = backup;
    }

    public int customize(String filename, ErrorLog log) {
        int status;
        String oldFileName = log.getFileName();
        log.setFileName(filename);
        if (filename.endsWith(".jar")) {
            status = this.customizeJar(filename, log);
        } else if (filename.endsWith(".ser")) {
            status = this.customizeSer(filename, log);
        } else {
            throw new IllegalArgumentException(CustomizerHarnessErrors.bad_filename((String)filename));
        }
        this.logStatus(log, status);
        log.setFileName(oldFileName);
        return status;
    }

    public int customizeJar(String filename, ErrorLog log) {
        try {
            JarIOContext context = new JarIOContext(filename, this.getBackup(), log);
            return this.customizeJar(context);
        }
        catch (IOException e) {
            this.logError(log, e);
            return 5;
        }
    }

    /*
     * Loose catch block
     */
    public int customizeJar(ProfileIOContext jar) {
        int status;
        block8: {
            status = 5;
            JarProfiles profiles = new JarProfiles(jar, this.getDigestArray());
            status = this.customizeProfiles(profiles);
            profiles.close(status);
            Object var5_5 = null;
            try {
                jar.close(status);
            }
            catch (IOException e2) {
                this.logError(jar.getErrorLog(), e2);
                status = 5;
            }
            break block8;
            {
                catch (IOException e) {
                    this.logError(jar.getErrorLog(), e);
                    status = 5;
                    Object var5_6 = null;
                    try {
                        jar.close(status);
                    }
                    catch (IOException e2) {
                        this.logError(jar.getErrorLog(), e2);
                        status = 5;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                try {
                    jar.close(status);
                }
                catch (IOException e2) {
                    this.logError(jar.getErrorLog(), e2);
                    status = 5;
                }
                throw throwable;
            }
        }
        return status;
    }

    private void logError(ErrorLog log, Exception e) {
        log.addEntry((LogEntry)new JSError((Object)e.toString()));
    }

    public int customizeProfiles(Enumeration profiles) {
        int cumulativeStatus = 3;
        while (profiles.hasMoreElements()) {
            int currentStatus = this.customizeProfile((ProfileIOContext)profiles.nextElement());
            switch (currentStatus) {
                case 5: {
                    return 5;
                }
                case 4: {
                    cumulativeStatus = 4;
                    break;
                }
            }
        }
        return cumulativeStatus;
    }

    private void logStatus(ErrorLog log, int status) {
        switch (status) {
            case 4: {
                log.addEntry((LogEntry)new Info((Object)CustomizerHarnessErrors.customized()));
                break;
            }
            case 3: {
                log.addEntry((LogEntry)new Info((Object)CustomizerHarnessErrors.unchanged()));
                break;
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int customizeProfile(ProfileIOContext io) {
        log = io.getErrorLog();
        loader = io.getLoader();
        status = new Status(log);
        try {
            block17: {
                p = Profile.instantiate((Loader)loader, (InputStream)io.getInputStream());
                if (this.hasValidContext(p)) break block17;
                log.addEntry((LogEntry)new Info((Object)CustomizerHarnessErrors.ignoring_context((String)p.getContextName())));
                var6_7 = status.getStatus();
                var11_10 = null;
                ** GOTO lbl76
            }
            customized = false;
            if (customized && status.getStatus() != 5) {
                oos = new ObjectOutputStream(io.getOutputStream());
                try {
                    oos.writeObject(p);
                    var9_24 = null;
                }
                catch (Throwable var8_26) {
                    var9_25 = null;
                    oos.close();
                    throw var8_26;
                }
                oos.close();
                status.setStatus(4);
            }
            ** GOTO lbl82
        }
        catch (NoClassDefFoundError e) {
            CustomizerHarness.LOCATION.catching((Throwable)e);
            log.addEntry((LogEntry)new JSError((Object)e.toString()));
            var11_12 = null;
            try {
                io.close(status.getStatus());
                return status.getStatus();
            }
            catch (IOException e) {
                this.logError(log, e);
                return status.getStatus();
            }
        }
        catch (ClassNotFoundException e) {
            CustomizerHarness.LOCATION.catching((Throwable)e);
            this.logError(log, e);
            var11_13 = null;
            try {}
            catch (IOException e) {
                this.logError(log, e);
                return status.getStatus();
            }
            io.close(status.getStatus());
            return status.getStatus();
        }
        catch (IOException e) {
            CustomizerHarness.LOCATION.catching((Throwable)e);
            this.logError(log, e);
            var11_14 = null;
            try {}
            catch (IOException e) {
                this.logError(log, e);
                return status.getStatus();
            }
            io.close(status.getStatus());
            return status.getStatus();
        }
        {
            catch (Throwable var10_27) {
                var11_15 = null;
                ** try [egrp 3[TRYBLOCK] [5 : 246->260)] { 
lbl71:
                // 1 sources

                io.close(status.getStatus());
                throw var10_27;
lbl73:
                // 1 sources

                catch (IOException e) {
                    this.logError(log, e);
                }
                throw var10_27;
            }
lbl76:
            // 1 sources

            ** try [egrp 3[TRYBLOCK] [5 : 246->260)] { 
lbl77:
            // 1 sources

            io.close(status.getStatus());
            return var6_7;
lbl79:
            // 1 sources

            catch (IOException e) {
                this.logError(log, e);
            }
            return var6_7;
lbl82:
            // 1 sources

            var11_11 = null;
            try {}
            catch (IOException e) {}
            this.logError(log, e);
            return status.getStatus();
            io.close(status.getStatus());
            return status.getStatus();
        }
    }

    static File createUnique(String filename, String suffix) {
        String newName = filename + "." + suffix;
        File newFile = new File(newName);
        int i = 1;
        while (newFile.exists()) {
            newName = filename + "." + suffix + i;
            newFile = new File(newName);
            ++i;
        }
        return newFile;
    }

    static void createBackup(String filename, ErrorLog log) throws IOException {
        File file = new File(filename);
        File backup = CustomizerHarness.createUnique(filename, "bak");
        if (!file.renameTo(backup)) {
            throw new IOException(CustomizerHarnessErrors.cannot_create_backup());
        }
        log.addEntry((LogEntry)new Info((Object)CustomizerHarnessErrors.backup_created((String)backup.getPath())));
    }

    public int customizeSer(String filename, ErrorLog log) {
        return this.customizeProfile(new FileIOContext(filename, this.getBackup(), log, null));
    }

    public String getContext() {
        return this.m_contextList;
    }

    public void setContext(String context) {
        this.m_contextList = context;
        this.parseListString(context, this.m_contextTable);
    }

    public boolean hasValidContext(Profile profile) {
        return this.m_contextList == null || this.m_contextTable.containsKey(profile.getContextName());
    }

    private void parseListString(String list, Hashtable table) {
        String[] items = this.listToArray(list, ',');
        table.clear();
        int i = 0;
        while (i < items.length) {
            table.put(items[i], items[i]);
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    private String[] listToArray(String list, char separator) {
        Vector items = new Vector();
        if (list != null && list.trim().length() > 0) {
            int comma;
            while ((comma = list.indexOf(separator)) != -1) {
                void var4_4;
                String nextItem = list.substring(0, (int)var4_4);
                list = list.substring((int)(var4_4 + true));
                this.addListItem(nextItem, items);
            }
            this.addListItem(list, items);
        }
        int len = items.size();
        Object[] result = new String[len];
        items.copyInto(result);
        return result;
    }

    public String getDriver() {
        return this.m_driverList;
    }

    public void setDriver(String driver) {
        this.resetConnection();
        this.m_driverList = driver;
        this.parseListString(driver, this.m_driverTable);
        this.m_connFact.setDrivers(this.m_driverTable.keys());
    }

    public String getDigests() {
        return this.m_digests;
    }

    public void setDigests(String digests) {
        this.m_digests = digests;
        this.setDigestArray(this.listToArray(digests, ','));
    }

    private MessageDigest[] getDigestArray() {
        return this.m_digestArray;
    }

    private void setDigestArray(String[] digestNames) {
        this.m_digestArray = new MessageDigest[digestNames.length];
        int i = 0;
        while (i < digestNames.length) {
            try {
                this.m_digestArray[i] = MessageDigest.getInstance(digestNames[i]);
            }
            catch (NoSuchAlgorithmException e) {
                LOCATION.catching((Throwable)e);
                throw new IllegalArgumentException(CustomizerHarnessErrors.unknown_digest((String)digestNames[i]));
            }
            ++i;
        }
    }

    private void addListItem(String listItem, Vector v) {
        if ((listItem = listItem.trim()).length() == 0) {
            throw new IllegalArgumentException(CustomizerHarnessErrors.empty_list_item());
        }
        v.addElement(listItem);
    }

    public void setOptionsQuery(TranslationOptionsQuery qp) {
        this.m_connFact.setOptionsQuery(qp);
    }

    public TranslationOptionsQuery getOptionsQuery() {
        return this.m_connFact.getOptionsQuery();
    }

    public String getCatalogReader() {
        return this.m_connFact.getCatalogReader();
    }

    public void setCatalogReader(String catalogReader) {
        this.resetConnection();
        this.m_connFact.setCatalogReader(catalogReader);
    }

    public String getUser() {
        return this.m_connFact.getUser();
    }

    public void setUser(String user) {
        this.resetConnection();
        this.m_connFact.setUser(user);
    }

    public String getPassword() {
        return this.m_connFact.getPassword();
    }

    public void setPassword(String password) {
        this.resetConnection();
        this.m_connFact.setPassword(password);
    }

    private void resetConnection() {
        if (this.m_conn != null) {
            try {
                Connection conn = this.m_conn;
                this.m_conn = null;
                conn.close();
            }
            catch (SQLException e) {
                LOCATION.catching((Throwable)e);
            }
        }
    }

    public static boolean isValidFilename(String filename) {
        return filename.endsWith(".ser") || filename.endsWith(".jar");
    }

    private boolean checkCustomizer(ErrorLog log) {
        ProfileCustomizer customizer = this.getCustomizer();
        if (customizer == null) {
            log.addEntry((LogEntry)new JSError((Object)CustomizerHarnessErrors.no_customizer()));
            return false;
        }
        log.addEntry((LogEntry)new JSError((Object)CustomizerHarnessErrors.connection_not_accepted((String)this.getConnectString())));
        return false;
    }

    private String getConnectString() {
        return this.m_connFact.toString();
    }

    public static void main(String[] args) {
        System.exit(CustomizerHarness.mainStatus(args));
    }

    public static int mainStatus(String[] args) {
        PrintWriter err = new PrintWriter(System.out, true);
        Log log = new Log(err);
        Vector<String> customizerArgs = new Vector<String>();
        Vector<String> harnessArgs = new Vector<String>();
        Vector<String> files = new Vector<String>();
        int exitStatus = 0;
        int i = 0;
        while (i < args.length) {
            if (args[i].startsWith("-C")) {
                customizerArgs.addElement(args[i].substring(2));
            } else if (args[i].startsWith("-")) {
                harnessArgs.addElement(args[i].substring(1));
            } else if (CustomizerHarness.isValidFilename(args[i])) {
                files.addElement(args[i]);
            } else {
                log.addEntry((LogEntry)new JSError((Object)CustomizerHarnessErrors.invalid_option((String)args[i])));
            }
            ++i;
        }
        BeanEditor harnessEditor = null;
        BeanEditor customizerEditor = null;
        CustomizerHarness harness = new CustomizerHarness();
        ProfileCustomizer customizer = null;
        try {
            harnessEditor = new BeanEditor((ErrorLog)log, harness);
            int i2 = 0;
            while (i2 < harnessArgs.size()) {
                harnessEditor.setProperty((String)harnessArgs.elementAt(i2));
                ++i2;
            }
            customizer = harness.getCustomizer();
            if (customizer != null) {
                customizerEditor = new BeanEditor((ErrorLog)log, harness.getCustomizer());
                int i3 = 0;
                while (i3 < customizerArgs.size()) {
                    customizerEditor.setProperty((String)customizerArgs.elementAt(i3));
                    ++i3;
                }
                int i4 = 0;
                while (i4 < SHARED_OPTIONS.length) {
                    customizerEditor.setFrom(SHARED_OPTIONS[i4], harnessEditor);
                    ++i4;
                }
            }
        }
        catch (IntrospectionException e) {
            LOCATION.catching((Throwable)e);
            log.addEntry((LogEntry)new JSError((Object)CustomizerHarnessErrors.cannot_load_harness()));
        }
        if (harness.getHelp()) {
            CustomizerHarness.printUsage(err, false);
            CustomizerHarness.printOptionSyntax(err);
            if (harnessEditor != null) {
                CustomizerHarness.printHelp(harnessEditor.getPropertyInfo(), CustomizerHarnessErrors.general_options(), "  -", err);
            }
            if (customizer != null) {
                CustomizerHarness.printHelp(customizerEditor.getPropertyInfo(), CustomizerHarnessErrors.customizer_options(), "  -C", err);
            }
        } else if (files.size() == 0 || log.errorCount() > 0) {
            CustomizerHarness.printUsage(err, true);
            exitStatus = 1;
        } else {
            if (harness.checkCustomizer(log)) {
                int i5 = 0;
                while (i5 < files.size()) {
                    harness.customize((String)files.elementAt(i5), log);
                    ++i5;
                }
            }
            log.printSummary();
            if (log.errorCount() > 0) {
                exitStatus = 1;
            }
        }
        harness.resetConnection();
        return exitStatus;
    }

    private static void printUsage(PrintWriter out, boolean printHelpDesc) {
        String usage = CustomizerHarnessErrors.usage();
        String options = CustomizerHarnessErrors.options();
        String file = CustomizerHarnessErrors.file();
        out.println(usage + ": [" + options + "] " + file + ".ser " + file + ".jar ...");
        if (printHelpDesc) {
            out.println(CustomizerHarnessErrors.help_desc((String)"-help"));
        }
    }

    private static void printOptionSyntax(PrintWriter out) {
        out.println();
        out.println(CustomizerHarnessErrors.summary_format());
    }

    private static void printHelp(String[][] propInfo, String header, String optionPrefix, PrintWriter out) {
        if (propInfo.length == 0) {
            return;
        }
        out.println();
        if (header != null) {
            out.println(header);
        }
        int i = 0;
        while (i < propInfo.length) {
            if (propInfo[i] != null) {
                CustomizerHarness.printHelp(propInfo[i], optionPrefix, out);
            }
            ++i;
        }
    }

    private static void printHelp(String[] propInfo, String optionPrefix, PrintWriter out) {
        out.print(optionPrefix + propInfo[0]);
        if (propInfo[1] != null) {
            out.print(" : " + propInfo[1]);
        }
        if (propInfo[2] != null) {
            out.print(" = " + propInfo[2]);
        }
        out.println();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class BeanEditor {
        private Object m_bean;
        private Class m_beanClass;
        private BeanInfo m_info;
        private PropertyDescriptor[] m_props;
        private Hashtable m_propTable;
        private ErrorLog m_log;
        static /* synthetic */ Class class$java$lang$Object;

        public BeanEditor(ErrorLog log, ClassLoader loader, String beanName) throws IOException, ClassNotFoundException, IntrospectionException {
            this(log, Beans.instantiate(loader, beanName));
        }

        public BeanEditor(ErrorLog log, String beanName) throws IOException, ClassNotFoundException, IntrospectionException {
            this(log, null, beanName);
        }

        public BeanEditor(ErrorLog log, Object bean) throws IntrospectionException {
            this.m_log = log;
            this.m_bean = bean;
            this.m_beanClass = this.m_bean.getClass();
            this.m_info = Introspector.getBeanInfo(this.m_beanClass, class$java$lang$Object == null ? (class$java$lang$Object = BeanEditor.class$("java.lang.Object")) : class$java$lang$Object);
            this.m_props = this.m_info.getPropertyDescriptors();
            this.m_propTable = new Hashtable();
            int i = 0;
            while (i < this.m_props.length) {
                this.m_propTable.put(this.m_props[i].getName(), new Integer(i));
                ++i;
            }
        }

        public void setFrom(String name, BeanEditor otherEditor) {
            PropertyDescriptor thisProp = this.getProp(name);
            if (thisProp == null) {
                return;
            }
            PropertyDescriptor otherProp = otherEditor.getProp(name);
            if (otherProp == null) {
                return;
            }
            String[] otherPropInfo = otherEditor.getPropertyInfo(otherProp);
            this.setProperty(name, otherPropInfo[2]);
        }

        public boolean setProperty(String nameAndValue) {
            String name = nameAndValue;
            String value = "";
            int ind = nameAndValue.indexOf("=");
            if (ind != -1) {
                name = nameAndValue.substring(0, ind);
                value = nameAndValue.substring(ind + 1);
            }
            return this.setProperty(name, value);
        }

        private PropertyDescriptor getProp(String name) {
            Integer propNdx = (Integer)this.m_propTable.get(name);
            if (propNdx == null) {
                return null;
            }
            return this.m_props[propNdx];
        }

        public boolean setProperty(String name, String value) {
            PropertyEditor propEdit;
            PropertyDescriptor propDesc = this.getProp(name);
            if (propDesc == null) {
                this.m_log.addEntry((LogEntry)new JSError((Object)CustomizerHarnessErrors.invalid_option((String)name)));
                return false;
            }
            Class<?> propType = propDesc.getPropertyType();
            if (propType == Boolean.TYPE && value.equals("")) {
                value = "true";
            }
            if ((propEdit = this.getPropertyEditor(propDesc)) == null) {
                this.m_log.addEntry((LogEntry)new JSError((Object)CustomizerHarnessErrors.unknown_option_type((String)name)));
                return false;
            }
            Method writeMethod = propDesc.getWriteMethod();
            if (writeMethod == null) {
                this.m_log.addEntry((LogEntry)new JSError((Object)CustomizerHarnessErrors.option_read_only((String)name)));
                return false;
            }
            try {
                propEdit.setAsText(value);
                writeMethod.invoke(this.m_bean, propEdit.getValue());
                return true;
            }
            catch (IllegalArgumentException e) {
                LOCATION.catching((Throwable)e);
                this.m_log.addEntry((LogEntry)new JSError((Object)CustomizerHarnessErrors.invalid_option_value((String)(name + "=" + value))));
            }
            catch (IllegalAccessException e) {
                LOCATION.catching((Throwable)e);
                this.m_log.addEntry((LogEntry)new JSError((Object)CustomizerHarnessErrors.cannot_access_option((String)name)));
            }
            catch (InvocationTargetException e) {
                LOCATION.catching((Throwable)e);
                this.m_log.addEntry((LogEntry)new JSError((Object)(name + "=" + value + ": " + e.getTargetException())));
            }
            return false;
        }

        private PropertyEditor getPropertyEditor(PropertyDescriptor propDesc) {
            PropertyEditor propEdit = null;
            Class<?> propEditClass = propDesc.getPropertyEditorClass();
            if (propEditClass != null) {
                try {
                    propEdit = (PropertyEditor)propEditClass.newInstance();
                }
                catch (InstantiationException e) {
                    LOCATION.catching((Throwable)e);
                }
                catch (IllegalAccessException e) {
                    LOCATION.catching((Throwable)e);
                }
            } else {
                Class<?> type = propDesc.getPropertyType();
                propEdit = PropertyEditorManager.findEditor(type);
            }
            return propEdit;
        }

        public String[][] getPropertyInfo() {
            String[][] infoArr = new String[this.m_props.length][];
            int i = 0;
            while (i < this.m_props.length) {
                infoArr[i] = this.m_props[i].isHidden() ? null : this.getPropertyInfo(this.m_props[i]);
                ++i;
            }
            return infoArr;
        }

        public String[] getPropertyInfo(String propName) {
            PropertyDescriptor propDesc = this.getProp(propName);
            if (propDesc == null) {
                this.m_log.addEntry((LogEntry)new JSError((Object)CustomizerHarnessErrors.invalid_option((String)propName)));
                return null;
            }
            return this.getPropertyInfo(propDesc);
        }

        private String[] getPropertyInfo(PropertyDescriptor propDesc) {
            PropertyEditor propEdit;
            String desc;
            String name = propDesc.getName();
            if (name.equals(desc = propDesc.getShortDescription())) {
                desc = null;
            }
            String valueString = null;
            Method readMethod = propDesc.getReadMethod();
            if (readMethod != null && (propEdit = this.getPropertyEditor(propDesc)) != null) {
                try {
                    Object value = readMethod.invoke(this.m_bean, new Object[0]);
                    propEdit.setValue(value);
                    valueString = propEdit.getAsText();
                }
                catch (IllegalArgumentException e) {
                    LOCATION.catching((Throwable)e);
                }
                catch (IllegalAccessException e) {
                    LOCATION.catching((Throwable)e);
                }
                catch (InvocationTargetException e) {
                    LOCATION.catching((Throwable)e);
                    this.m_log.addEntry((LogEntry)new JSError((Object)(name + ": " + e.getTargetException())));
                }
            }
            return new String[]{name, desc, valueString};
        }

        public Object getAs(Class asClass) {
            return Beans.getInstanceOf(this.m_bean, asClass);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static class JarIOContext
    implements ProfileIOContext {
        private boolean m_createBackup;
        private String m_filename;
        private ErrorLog m_log;
        private Loader m_loader;
        private File m_outfile;

        public JarIOContext(String filename, boolean createBackup, ErrorLog log) throws IOException {
            this.m_filename = filename;
            this.m_createBackup = createBackup;
            this.m_log = log;
            this.m_loader = new DefaultLoader((ClassLoader)new JarFileClassLoader(new ZipFile(filename)));
        }

        public ErrorLog getErrorLog() {
            return this.m_log;
        }

        public Loader getLoader() {
            return this.m_loader;
        }

        public InputStream getInputStream() throws IOException {
            return new FileInputStream(this.m_filename);
        }

        public OutputStream getOutputStream() throws IOException {
            this.m_outfile = CustomizerHarness.createUnique(this.m_filename, "tmp");
            return new FileOutputStream(this.m_outfile);
        }

        public void close(int status) throws IOException {
            if (status == 4) {
                this.saveFile();
            } else {
                this.removeFile();
            }
        }

        private void saveFile() throws IOException {
            if (this.m_outfile != null) {
                if (this.m_createBackup) {
                    CustomizerHarness.createBackup(this.m_filename, this.getErrorLog());
                }
                if (!this.m_outfile.renameTo(new File(this.m_filename))) {
                    throw new IOException(CustomizerHarnessErrors.cannot_rename((File)this.m_outfile, (String)this.m_filename));
                }
            }
        }

        private void removeFile() throws IOException {
            if (this.m_outfile != null && !this.m_outfile.delete()) {
                throw new IOException(CustomizerHarnessErrors.cannot_delete((File)this.m_outfile));
            }
        }
    }

    private static class JarFileClassLoader
    extends ClassLoader {
        private ZipFile m_zip;
        private Hashtable m_classes = new Hashtable();

        public JarFileClassLoader(ZipFile zip) {
            this.m_zip = zip;
        }

        public synchronized Class loadClass(String className, boolean resolve) throws ClassNotFoundException {
            long size;
            Class<?> cls = (Class<?>)this.m_classes.get(className);
            if (cls != null) {
                return cls;
            }
            String filename = className.replace('.', '/') + ".class";
            ZipEntry entry = this.m_zip.getEntry(filename);
            if (entry != null && (size = entry.getSize()) != -1L && size <= Integer.MAX_VALUE) {
                byte[] classBytes = new byte[(int)size];
                try {
                    InputStream classStream = this.m_zip.getInputStream(entry);
                    classStream.read(classBytes);
                    cls = this.defineClass(className, classBytes, 0, classBytes.length);
                    if (resolve) {
                        this.resolveClass(cls);
                    }
                    this.m_classes.put(className, cls);
                    return cls;
                }
                catch (IOException e) {
                    LOCATION.catching((Throwable)e);
                }
            }
            return this.findSystemClass(className);
        }

        public InputStream getResourceAsStream(String name) {
            ZipEntry entry = this.m_zip.getEntry(name);
            if (entry != null) {
                try {
                    return this.m_zip.getInputStream(entry);
                }
                catch (IOException e) {
                    LOCATION.catching((Throwable)e);
                }
            }
            return ClassLoader.getSystemResourceAsStream(name);
        }
    }

    public static class FileIOContext
    implements ProfileIOContext {
        private boolean m_createBackup;
        private String m_filename;
        private ErrorLog m_log;
        private Loader m_loader;
        private ByteArrayOutputStream m_output = null;

        public FileIOContext(String filename, boolean createBackup, ErrorLog log, Loader loader) {
            this.m_filename = filename;
            this.m_createBackup = createBackup;
            this.m_loader = loader;
            this.m_log = log;
        }

        public ErrorLog getErrorLog() {
            return this.m_log;
        }

        public Loader getLoader() {
            return this.m_loader;
        }

        public InputStream getInputStream() throws IOException {
            return new FileInputStream(this.m_filename);
        }

        public OutputStream getOutputStream() throws IOException {
            this.m_output = new ByteArrayOutputStream(1024);
            return this.m_output;
        }

        public void close(int status) throws IOException {
            if (status == 4) {
                this.saveFile();
            }
        }

        private void saveFile() throws IOException {
            if (this.m_output != null) {
                if (this.m_createBackup) {
                    CustomizerHarness.createBackup(this.m_filename, this.getErrorLog());
                }
                FileOutputStream os = new FileOutputStream(this.m_filename);
                this.m_output.writeTo(os);
                ((OutputStream)os).close();
            }
        }
    }

    private static class Status {
        private int m_origErrorCount;
        private ErrorLog m_log;
        private int m_status = 3;

        public Status(ErrorLog log) {
            this.m_origErrorCount = log.errorCount();
            this.m_log = log;
        }

        public int getStatus() {
            if (this.m_log.errorCount() > this.m_origErrorCount) {
                return 5;
            }
            return this.m_status;
        }

        public void setStatus(int newStatus) {
            this.m_status = newStatus;
        }
    }

    private static class JarProfiles
    implements Enumeration {
        ProfileIOContext m_jarContext;
        ZipInputStream m_jarInput;
        ZipOutputStream m_jarOutput;
        private static final int BUFFER_LEN = 1024;
        byte[] m_dataBuffer = new byte[1024];
        ZipEntry m_entry;
        private String m_origFilename;
        private ManifestData m_manifest;
        private ZipEntry m_manifestEntry;
        private MessageDigest[] m_digests;

        JarProfiles(ProfileIOContext jar, MessageDigest[] digests) throws IOException {
            this.m_manifest = this.readManifest(jar);
            this.m_jarContext = jar;
            this.m_jarInput = new ZipInputStream(jar.getInputStream());
            try {
                this.m_jarOutput = new ZipOutputStream(jar.getOutputStream());
            }
            catch (IOException e) {
                this.m_jarInput.close();
                throw e;
            }
            this.m_origFilename = jar.getErrorLog().getFileName();
            this.m_digests = digests;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private ManifestData readManifest(ProfileIOContext jar) throws IOException {
            block10: {
                ManifestData manifestData;
                block9: {
                    ZipInputStream input = new ZipInputStream(jar.getInputStream());
                    try {
                        block7: {
                            try {
                                while (true) {
                                    void var3_3;
                                    ZipEntry entry;
                                    if ((entry = input.getNextEntry()) == null) {
                                        break block7;
                                    }
                                    if (ManifestData.isManifest((ZipEntry)var3_3)) {
                                        manifestData = new ManifestData(input);
                                        Object var6_5 = null;
                                        break;
                                    }
                                    input.closeEntry();
                                }
                            }
                            catch (Throwable throwable) {
                                Object var6_7 = null;
                                input.close();
                                throw throwable;
                            }
                            input.close();
                            Object var8_8 = null;
                            break block9;
                        }
                        Object var6_6 = null;
                        input.close();
                        break block10;
                    }
                    catch (Throwable throwable) {
                        Object var8_10 = null;
                        jar.close(3);
                        throw throwable;
                    }
                }
                jar.close(3);
                return manifestData;
            }
            Object var8_9 = null;
            jar.close(3);
            throw new IOException(CustomizerHarnessErrors.no_manifest());
        }

        void close(int status) throws IOException {
            try {
                if (status == 4) {
                    ProfileIOContext ctx = this.getContextForEntry(this.m_manifestEntry);
                    this.m_manifest.toStream(ctx.getOutputStream());
                    ctx.close(4);
                }
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.m_jarContext.getErrorLog().setFileName(this.m_origFilename);
                this.m_jarInput.close();
                this.m_jarOutput.close();
                throw throwable;
            }
            this.m_jarContext.getErrorLog().setFileName(this.m_origFilename);
            this.m_jarInput.close();
            this.m_jarOutput.close();
        }

        public boolean hasMoreElements() {
            try {
                while ((this.m_entry = this.m_jarInput.getNextEntry()) != null) {
                    if (this.isProfile(this.m_entry)) {
                        return true;
                    }
                    if (ManifestData.isManifest(this.m_entry)) {
                        this.m_manifestEntry = this.m_entry;
                        continue;
                    }
                    this.copyZipEntry(this.m_entry);
                }
            }
            catch (IOException e) {
                LOCATION.catching((Throwable)e);
                this.m_jarContext.getErrorLog().addEntry((LogEntry)new JSError((Object)e.toString()));
            }
            return false;
        }

        private boolean isProfile(ZipEntry entry) {
            return this.m_manifest.isProfile(entry.getName());
        }

        /*
         * WARNING - void declaration
         */
        private void copyZipEntry(ZipEntry entry) throws IOException {
            int size;
            this.m_jarOutput.putNextEntry(entry);
            while ((size = this.m_jarInput.read(this.m_dataBuffer, 0, 1024)) != -1) {
                void var2_2;
                this.m_jarOutput.write(this.m_dataBuffer, 0, (int)var2_2);
            }
            this.m_jarOutput.closeEntry();
            this.m_jarInput.closeEntry();
        }

        private ZipEntry createNewEntry(ZipEntry oldEntry) {
            ZipEntry newEntry = new ZipEntry(oldEntry.getName());
            newEntry.setComment(oldEntry.getComment());
            newEntry.setExtra(oldEntry.getExtra());
            newEntry.setMethod(oldEntry.getMethod());
            return newEntry;
        }

        public Object nextElement() {
            return this.getContextForEntry(this.m_entry);
        }

        private ProfileIOContext getContextForEntry(ZipEntry entry) {
            this.m_jarContext.getErrorLog().setFileName(entry.getName());
            return new JarEntryIOContext(entry);
        }

        int getEntrySize(ZipEntry entry) throws IOException {
            long size = entry.getSize();
            if (size == -1L) {
                size = 1024L;
            } else if (size > Integer.MAX_VALUE) {
                throw new IOException(CustomizerHarnessErrors.file_too_big());
            }
            return (int)size;
        }

        private class JarEntryIOContext
        implements ProfileIOContext {
            private ByteArrayOutputStream m_savedInput;
            private ByteArrayOutputStream m_savedOutput;
            private Checksum m_outputChecksum = null;
            private DigestOutputStream[] m_digestStreams;
            private ZipEntry m_entry;

            public JarEntryIOContext(ZipEntry entry) {
                this.m_entry = entry;
            }

            private ZipEntry getEntry() {
                return this.m_entry;
            }

            public InputStream getInputStream() throws IOException {
                this.m_savedInput = new ByteArrayOutputStream(JarProfiles.this.getEntrySize(this.getEntry()));
                return new FilterInputStream(this, JarProfiles.this.m_jarInput){
                    private final /* synthetic */ JarEntryIOContext this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void close() throws IOException {
                        JarEntryIOContext.access$100((JarEntryIOContext)this.this$1).m_jarInput.closeEntry();
                    }

                    public int read() throws IOException {
                        int b = ((InflaterInputStream)JarEntryIOContext.access$100((JarEntryIOContext)this.this$1).m_jarInput).read();
                        if (b != -1) {
                            JarEntryIOContext.access$200(this.this$1).write(b);
                        }
                        return b;
                    }

                    public int read(byte[] b) throws IOException {
                        int size = JarEntryIOContext.access$100((JarEntryIOContext)this.this$1).m_jarInput.read(b);
                        if (size != -1) {
                            JarEntryIOContext.access$200(this.this$1).write(b, 0, size);
                        }
                        return size;
                    }

                    public int read(byte[] b, int off, int len) throws IOException {
                        int size = JarEntryIOContext.access$100((JarEntryIOContext)this.this$1).m_jarInput.read(b, off, len);
                        if (size != -1) {
                            JarEntryIOContext.access$200(this.this$1).write(b, off, size);
                        }
                        return size;
                    }
                };
            }

            public OutputStream getOutputStream() throws IOException {
                this.m_savedOutput = new ByteArrayOutputStream(JarProfiles.this.getEntrySize(this.getEntry()));
                this.m_outputChecksum = new CRC32();
                FilterOutputStream os = new CheckedOutputStream(this.m_savedOutput, this.m_outputChecksum);
                this.m_digestStreams = new DigestOutputStream[JarProfiles.this.m_digests.length];
                int i = 0;
                while (i < JarProfiles.this.m_digests.length) {
                    JarProfiles.this.m_digests[i].reset();
                    this.m_digestStreams[i] = new DigestOutputStream(os, JarProfiles.this.m_digests[i]);
                    os = this.m_digestStreams[i];
                    ++i;
                }
                return os;
            }

            public ErrorLog getErrorLog() {
                return JarProfiles.this.m_jarContext.getErrorLog();
            }

            public Loader getLoader() {
                return JarProfiles.this.m_jarContext.getLoader();
            }

            public void close(int status) throws IOException {
                switch (status) {
                    case 4: {
                        ZipEntry entry = JarProfiles.this.createNewEntry(this.getEntry());
                        entry.setCrc(this.m_outputChecksum.getValue());
                        entry.setSize(this.m_savedOutput.size());
                        JarProfiles.this.m_jarOutput.putNextEntry(entry);
                        this.m_savedOutput.writeTo(JarProfiles.this.m_jarOutput);
                        JarProfiles.this.m_jarOutput.closeEntry();
                        String name = entry.getName();
                        if (!JarProfiles.this.m_manifest.isProfile(name)) break;
                        JarProfiles.this.m_manifest.clearDigests(name);
                        int i = 0;
                        while (i < JarProfiles.this.m_digests.length) {
                            JarProfiles.this.m_manifest.addDigest(name, this.m_digestStreams[i].getMessageDigest());
                            ++i;
                        }
                        break;
                    }
                    case 3: {
                        JarProfiles.this.m_jarOutput.putNextEntry(this.getEntry());
                        this.m_savedInput.writeTo(JarProfiles.this.m_jarOutput);
                        JarProfiles.this.m_jarOutput.closeEntry();
                        break;
                    }
                }
            }

            static /* synthetic */ JarProfiles access$100(JarEntryIOContext x0) {
                return x0.JarProfiles.this;
            }

            static /* synthetic */ ByteArrayOutputStream access$200(JarEntryIOContext x0) {
                return x0.m_savedInput;
            }
        }
    }

    private static class ManifestData {
        private Hashtable m_profiles = new Hashtable();
        private Vector m_attributes = new Vector();
        private InputStreamReader m_stream;
        private int m_nextChar;
        private static final String MANIFEST_ENCODING = "UTF8";
        private static final int CR = 13;
        private static final int LF = 10;
        private int eofCount = 0;

        public ManifestData(InputStream manifest) throws IOException {
            this.m_stream = new InputStreamReader(manifest, MANIFEST_ENCODING);
            this.m_nextChar = -1;
            this.readManifest();
            this.m_stream = null;
            this.findProfiles();
        }

        private void findProfiles() {
            Enumeration files = this.m_attributes.elements();
            while (files.hasMoreElements()) {
                String filename;
                Section attrTable = (Section)files.nextElement();
                if (!attrTable.isProfile() || this.m_profiles.get(filename = attrTable.getName()) != null) continue;
                this.m_profiles.put(filename, attrTable);
            }
        }

        private void readManifest() throws IOException {
            if (this.readSection(this.m_attributes) == null) {
                this.raise_invalid_manifest();
            }
            this.checkRequired((Section)this.m_attributes.elementAt(0));
            while (this.readSection(this.m_attributes) != null) {
            }
        }

        private void checkRequired(Section section) throws IOException {
            String version = section.getRequiredVersion();
            if (version != null && !version.equals("1.0")) {
                this.raise_invalid_manifest();
            }
        }

        private String readSection(Vector attributes) throws IOException {
            Section sectionTable = new Section();
            String name = this.readHeader(sectionTable);
            if (name != null) {
                attributes.addElement(sectionTable);
                while (this.readHeader(sectionTable) != null) {
                }
                if (!this.readEOL()) {
                    this.raise_invalid_manifest();
                }
                while (this.readEOL()) {
                }
            }
            return name;
        }

        private String readHeader(Section table) throws IOException {
            String key = this.readKey();
            if (key == null) {
                return null;
            }
            StringBuffer value = new StringBuffer();
            if (!this.readContinuation(value)) {
                this.raise_invalid_manifest();
            }
            while (this.readContinuation(value)) {
            }
            table.put(key, value.toString());
            return key;
        }

        private boolean readContinuation(StringBuffer buf) throws IOException {
            if (!this.isSpace(this.peekNextChar())) {
                return false;
            }
            this.getNextChar();
            while (!this.readEOL()) {
                this.getNextChar(buf);
            }
            return true;
        }

        private boolean readEOL() throws IOException {
            boolean isEOL = false;
            int ch = this.peekNextChar();
            if (ch == 13) {
                this.getNextChar();
                isEOL = true;
                ch = this.peekNextChar();
            }
            if (ch == 10) {
                this.getNextChar();
                isEOL = true;
            }
            return isEOL;
        }

        private boolean isSpace(int ch) {
            return ch == 32 || ch == 9;
        }

        private String readKey() throws IOException {
            StringBuffer key = new StringBuffer();
            if (!this.readAlphaNum(key)) {
                return null;
            }
            while (this.readHeaderChar(key)) {
            }
            if (this.getNextChar() != 58) {
                this.raise_invalid_manifest();
            }
            return key.toString();
        }

        private void raise_invalid_manifest() throws IOException {
            throw new IOException(CustomizerHarnessErrors.invalid_manifest_syntax());
        }

        private boolean readAlphaNum(StringBuffer buf) throws IOException {
            int ch = this.peekNextChar();
            if (ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122 || ch >= 48 && ch <= 57) {
                this.getNextChar(buf);
                return true;
            }
            return false;
        }

        private boolean readHeaderChar(StringBuffer buf) throws IOException {
            if (this.readAlphaNum(buf)) {
                return true;
            }
            int ch = this.peekNextChar();
            if (ch == 45 || ch == 95) {
                this.getNextChar(buf);
                return true;
            }
            return false;
        }

        private int peekNextChar() throws IOException {
            if (this.m_nextChar == -1) {
                this.m_nextChar = this.read();
            }
            return this.m_nextChar;
        }

        private int read() throws IOException {
            int ch = this.m_stream.read();
            if (ch == -1 && this.eofCount++ < 2) {
                return 10;
            }
            return ch;
        }

        private int getNextChar() throws IOException {
            int ch;
            if (this.m_nextChar != -1) {
                ch = this.m_nextChar;
                this.m_nextChar = -1;
            } else {
                ch = this.read();
            }
            return ch;
        }

        private void getNextChar(StringBuffer buf) throws IOException {
            buf.append((char)this.getNextChar());
        }

        public boolean isProfile(String filename) {
            return this.m_profiles.containsKey(filename);
        }

        public void clearDigests(String filename) throws IOException {
            this.getProfile(filename).clearDigests();
        }

        public void addDigest(String filename, MessageDigest digest) throws IOException {
            this.getProfile(filename).addDigest(digest);
        }

        private Section getProfile(String filename) throws IOException {
            Section section = (Section)this.m_profiles.get(filename);
            if (section == null) {
                throw new IOException(CustomizerHarnessErrors.invalid_profile_name((String)filename));
            }
            return section;
        }

        public void toStream(OutputStream os) throws IOException {
            OutputStreamWriter w = new OutputStreamWriter(os, MANIFEST_ENCODING);
            PrintWriter out = new PrintWriter(new LineBreakFilter(w, 72));
            int size = this.m_attributes.size();
            int i = 0;
            while (i < size) {
                ((Section)this.m_attributes.elementAt(i)).toStream(out);
                ++i;
            }
            out.flush();
        }

        public static boolean isManifest(ZipEntry entry) {
            String name = entry.getName();
            if (name.startsWith("/")) {
                name = name.substring(1);
            }
            return name.equalsIgnoreCase("META-INF/MANIFEST.MF");
        }

        private static class LineBreakFilter
        extends FilterWriter {
            private int m_numBytesInLine = 0;
            private int m_bytesPerLine;
            private static final String CONTINUATION = "\n ";
            private static final int CONTINUATION_LEN = 2;

            public LineBreakFilter(Writer os, int bytesPerLine) {
                super(os);
                this.m_bytesPerLine = bytesPerLine;
            }

            public void write(int c) throws IOException {
                if (c == 10 || c == 13) {
                    this.m_numBytesInLine = 0;
                    super.write(c);
                } else {
                    if (this.m_numBytesInLine >= this.m_bytesPerLine) {
                        super.write(CONTINUATION, 0, 2);
                        this.m_numBytesInLine = this.numBytesForChar(32);
                    }
                    this.m_numBytesInLine += this.numBytesForChar(c);
                    super.write(c);
                }
            }

            public void write(char[] cbuf, int off, int len) throws IOException {
                int i = 0;
                while (i < len) {
                    this.write(cbuf[i + off]);
                    ++i;
                }
            }

            public void write(String str, int off, int len) throws IOException {
                int i = 0;
                while (i < len) {
                    this.write(str.charAt(i + off));
                    ++i;
                }
            }

            private int numBytesForChar(int ch) {
                if (ch < 128) {
                    return 1;
                }
                if (ch < 2048) {
                    return 2;
                }
                return 3;
            }
        }

        private static class Section {
            private BASE64Encoder m_encoder = new BASE64Encoder();
            private Vector m_keys = new Vector();
            private Vector m_origKeys = new Vector();
            private Vector m_values = new Vector();
            private static final String ALGORITHM_KEY = "DIGEST-ALGORITHMS";

            public void put(String key, String value) {
                String upKey = key.toUpperCase();
                int ndx = this.m_keys.indexOf(upKey);
                if (ndx == -1) {
                    this.m_keys.addElement(upKey);
                    this.m_origKeys.addElement(key);
                    this.m_values.addElement(value);
                } else {
                    this.m_values.setElementAt(value, ndx);
                }
            }

            private String get(String key) {
                int ndx = this.m_keys.indexOf(key);
                if (ndx == -1) {
                    return null;
                }
                return (String)this.m_values.elementAt(ndx);
            }

            private String remove(String key) {
                int ndx = this.m_keys.indexOf(key);
                if (ndx == -1) {
                    return null;
                }
                this.m_keys.removeElementAt(ndx);
                this.m_origKeys.removeElementAt(ndx);
                String result = (String)this.m_values.elementAt(ndx);
                this.m_values.removeElementAt(ndx);
                return result;
            }

            public boolean isProfile() {
                String value = this.get("SQLJPROFILE");
                return value != null && value.equalsIgnoreCase("TRUE") && this.getName() != null;
            }

            public String getDigestAlgorithms() {
                return this.get(ALGORITHM_KEY);
            }

            public String getName() {
                return this.get("NAME");
            }

            public String getRequiredVersion() {
                return this.get("REQUIRED-VERSION");
            }

            public void toStream(PrintWriter out) {
                int size = this.m_keys.size();
                int i = 0;
                while (i < size) {
                    out.print(this.m_origKeys.elementAt(i));
                    out.print(": ");
                    out.println(this.m_values.elementAt(i));
                    ++i;
                }
                out.println();
            }

            public void clearDigests() {
                String algorithms = this.getDigestAlgorithms();
                if (algorithms == null) {
                    return;
                }
                int startIndex = 0;
                int endIndex = 0;
                int len = algorithms.length();
                while (endIndex != -1 && startIndex < len) {
                    endIndex = algorithms.indexOf(32, startIndex + 1);
                    String nextAlgorithm = endIndex == -1 ? algorithms.substring(startIndex) : algorithms.substring(startIndex, endIndex);
                    this.remove(nextAlgorithm + "-DIGEST");
                    startIndex = endIndex + 1;
                }
                this.remove(ALGORITHM_KEY);
            }

            public void addDigest(MessageDigest digest) {
                String algorithms = this.getDigestAlgorithms();
                String algorithm = digest.getAlgorithm();
                algorithms = algorithms == null ? algorithm : algorithms + " " + algorithm;
                this.put("Digest-Algorithms", algorithms);
                this.put(algorithm + "-Digest", this.m_encoder.encode(digest.digest()));
            }
        }
    }

    public static class Log
    implements ErrorLog {
        private PrintWriter m_out;
        private int m_numWarnings = 0;
        private int m_numErrors = 0;
        private String m_filename = null;

        public Log(PrintWriter out) {
            this.m_out = out;
        }

        public void addEntryOffset(LogEntry entry, int offset) {
            this.addEntry(entry);
            if (offset > 0) {
                Position p = entry.getPosition();
                entry.setRegion(p.startLine() + offset - 1, p.startCol(), p.startLine() + offset - 1, p.endCol());
            }
        }

        public void addEntry(LogEntry entry) {
            entry.setFileName(this.m_filename);
            if (entry instanceof JSError) {
                this.incErrorCount();
            } else if (entry instanceof Warning) {
                this.incWarningCount();
            }
            this.m_out.println(entry);
        }

        public void addEntry(LogEntry entry, int line, int col) {
            entry.setPosition(new Position(line, col));
            this.addEntry(entry);
        }

        public void addEntryRegion(LogEntry entry, int startline, int startcol, int endline, int endcol) {
            entry.setRegion(startline, startcol, endline, endcol);
            this.addEntry(entry);
        }

        public int errorCount() {
            return this.m_numErrors;
        }

        public void incErrorCount() {
            ++this.m_numErrors;
        }

        public int warningCount() {
            return this.m_numWarnings;
        }

        public void incWarningCount() {
            ++this.m_numWarnings;
        }

        public void setFileName(String s) {
            this.m_filename = s;
        }

        public String getFileName() {
            return this.m_filename;
        }

        public Position getDefaultRegion() {
            return null;
        }

        public void printSummary() {
            this.m_out.print(CustomizerHarnessErrors.error_count((int)this.errorCount()));
            if (this.errorCount() > 0 && this.warningCount() > 0) {
                this.m_out.print(", ");
            }
            this.m_out.print(CustomizerHarnessErrors.warning_count((int)this.warningCount()));
            if (this.errorCount() > 0 || this.warningCount() > 0) {
                this.m_out.println();
            }
        }
    }
}

