/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlj.runtime.profile.ref;

import com.sap.sql.sqlj.runtime.profile.ref.BatchContextImpl;
import com.sap.sql.sqlj.runtime.profile.ref.RTResultSetJDBC;
import com.sap.sql.tree.SQLStatement;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import sqlj.runtime.AsciiStream;
import sqlj.runtime.BinaryStream;
import sqlj.runtime.CharacterStream;
import sqlj.runtime.UnicodeStream;
import sqlj.runtime.profile.BatchContext;
import sqlj.runtime.profile.EntryInfo;
import sqlj.runtime.profile.RTResultSet;
import sqlj.runtime.profile.RTStatement;

public class RTStatementJDBCBase {
    protected PreparedStatement preparedStmt;
    private boolean m_executeComplete = false;
    private RTResultSetJDBC m_openResultSet = null;
    private boolean m_isClosed = false;
    private SQLStatement sqlStmt = null;
    private BatchContextImpl m_batchContext;
    private boolean executeViaBatch;
    private EntryInfo m_entryInfo;

    public RTStatementJDBCBase(PreparedStatement preparedStmt) {
        this.preparedStmt = preparedStmt;
        this.executeViaBatch = false;
    }

    public RTStatementJDBCBase(PreparedStatement preparedStmt, SQLStatement sqlStmt, boolean doExecuteViaBatch) {
        this.preparedStmt = preparedStmt;
        this.sqlStmt = sqlStmt;
        this.executeViaBatch = doExecuteViaBatch;
    }

    public SQLStatement getSqlStatement() {
        return this.sqlStmt;
    }

    public PreparedStatement getJDBCPreparedStatement() {
        return this.preparedStmt;
    }

    public int getMaxFieldSize() throws SQLException {
        return this.preparedStmt.getMaxFieldSize();
    }

    public void setMaxFieldSize(int max) throws SQLException {
        this.preparedStmt.setMaxFieldSize(max);
    }

    public int getMaxRows() throws SQLException {
        return this.preparedStmt.getMaxRows();
    }

    public int getFetchSize() throws SQLException {
        return this.preparedStmt.getFetchSize();
    }

    public void setMaxRows(int max) throws SQLException {
        this.preparedStmt.setMaxRows(max);
    }

    public void setFetchSize(int rows) throws SQLException {
        this.preparedStmt.setFetchSize(rows);
    }

    public void setFetchDirection(int direction) throws SQLException {
        switch (direction) {
            case 4: {
                this.preparedStmt.setFetchDirection(1000);
                break;
            }
            case 5: {
                this.preparedStmt.setFetchDirection(1001);
                break;
            }
            case 6: {
                this.preparedStmt.setFetchDirection(1002);
                break;
            }
            default: {
                throw new SQLException("invalid fetch direction: " + direction);
            }
        }
    }

    public int getQueryTimeout() throws SQLException {
        return this.preparedStmt.getQueryTimeout();
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        this.preparedStmt.setQueryTimeout(seconds);
    }

    public void cancel() throws SQLException {
        this.preparedStmt.cancel();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.preparedStmt.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.preparedStmt.clearWarnings();
    }

    public ResultSet getResultSet() throws SQLException {
        if (this.m_openResultSet != null) {
            this.m_openResultSet.close();
            this.m_openResultSet = null;
        }
        return this.preparedStmt.getResultSet();
    }

    public int getUpdateCount() throws SQLException {
        return this.preparedStmt.getUpdateCount();
    }

    public boolean getMoreResults() throws SQLException {
        return this.preparedStmt.getMoreResults();
    }

    public RTResultSet executeRTQuery() throws SQLException {
        RTResultSetJDBC result;
        this.m_openResultSet = result = new RTResultSetJDBC(this.preparedStmt.executeQuery(), this);
        return result;
    }

    public int executeUpdate() throws SQLException {
        if (this.m_batchContext != null) {
            this.preparedStmt.addBatch();
            return 0;
        }
        return this.preparedStmt.executeUpdate();
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.preparedStmt.setBoolean(parameterIndex, x);
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.preparedStmt.setByte(parameterIndex, x);
    }

    public void setRef(int parameterIndex, Ref x) throws SQLException {
        this.preparedStmt.setRef(parameterIndex, x);
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        this.preparedStmt.setShort(parameterIndex, x);
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        this.preparedStmt.setInt(parameterIndex, x);
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        this.preparedStmt.setLong(parameterIndex, x);
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.preparedStmt.setFloat(parameterIndex, x);
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.preparedStmt.setDouble(parameterIndex, x);
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.preparedStmt.setBigDecimal(parameterIndex, x);
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        this.preparedStmt.setString(parameterIndex, x);
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.preparedStmt.setBytes(parameterIndex, x);
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.preparedStmt.setDate(parameterIndex, x);
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.preparedStmt.setTime(parameterIndex, x);
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.preparedStmt.setTimestamp(parameterIndex, x);
    }

    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.preparedStmt.setBlob(parameterIndex, x);
    }

    public void setCharacterStreamWrapper(int paramIndex, CharacterStream x) throws SQLException {
        if (x == null) {
            this.preparedStmt.setNull(paramIndex, -1);
        } else {
            this.preparedStmt.setCharacterStream(paramIndex, x.getReader(), x.getLength());
        }
    }

    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.preparedStmt.setClob(parameterIndex, x);
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.preparedStmt.setObject(parameterIndex, x);
    }

    public boolean execute() throws SQLException {
        if (this.m_batchContext != null) {
            this.preparedStmt.addBatch();
            return false;
        }
        return this.preparedStmt.execute();
    }

    public void executeComplete() throws SQLException {
        this.m_executeComplete = true;
        this.checkClose();
    }

    void notifyClosed(RTResultSetJDBC resultSet) throws SQLException {
        this.m_openResultSet = null;
        this.checkClose();
    }

    private void checkClose() throws SQLException {
        if (!this.m_isClosed && this.m_executeComplete && this.m_openResultSet == null) {
            this.m_isClosed = true;
            if (this.m_batchContext == null) {
                this.preparedStmt.close();
            }
        }
    }

    public void setBooleanWrapper(int paramIndex, Boolean x) throws SQLException {
        if (x == null) {
            this.preparedStmt.setNull(paramIndex, -7);
        } else {
            this.preparedStmt.setBoolean(paramIndex, x);
        }
    }

    public void setByteWrapper(int paramIndex, Byte x) throws SQLException {
        if (x == null) {
            this.preparedStmt.setNull(paramIndex, -6);
        } else {
            this.preparedStmt.setByte(paramIndex, x);
        }
    }

    public void setShortWrapper(int paramIndex, Short x) throws SQLException {
        if (x == null) {
            this.preparedStmt.setNull(paramIndex, 5);
        } else {
            this.preparedStmt.setShort(paramIndex, x);
        }
    }

    public void setIntWrapper(int paramIndex, Integer x) throws SQLException {
        if (x == null) {
            this.preparedStmt.setNull(paramIndex, 4);
        } else {
            this.preparedStmt.setInt(paramIndex, x);
        }
    }

    public void setLongWrapper(int paramIndex, Long x) throws SQLException {
        if (x == null) {
            this.preparedStmt.setNull(paramIndex, -5);
        } else {
            this.preparedStmt.setLong(paramIndex, x);
        }
    }

    public void setFloatWrapper(int paramIndex, Float x) throws SQLException {
        if (x == null) {
            this.preparedStmt.setNull(paramIndex, 6);
        } else {
            this.preparedStmt.setFloat(paramIndex, x.floatValue());
        }
    }

    public void setDoubleWrapper(int paramIndex, Double x) throws SQLException {
        if (x == null) {
            this.preparedStmt.setNull(paramIndex, 8);
        } else {
            this.preparedStmt.setDouble(paramIndex, x);
        }
    }

    public void setAsciiStreamWrapper(int paramIndex, AsciiStream x) throws SQLException {
        if (x == null) {
            this.preparedStmt.setNull(paramIndex, -1);
        } else {
            this.preparedStmt.setAsciiStream(paramIndex, x.getInputStream(), x.getLength());
        }
    }

    public void setBinaryStreamWrapper(int paramIndex, BinaryStream x) throws SQLException {
        if (x == null) {
            this.preparedStmt.setNull(paramIndex, -4);
        } else {
            this.preparedStmt.setBinaryStream(paramIndex, x.getInputStream(), x.getLength());
        }
    }

    public void setUnicodeStreamWrapper(int paramIndex, UnicodeStream x) throws SQLException {
        if (x == null) {
            this.preparedStmt.setNull(paramIndex, -1);
        } else {
            this.preparedStmt.setUnicodeStream(paramIndex, x.getInputStream(), x.getLength());
        }
    }

    public void setBatchContext(BatchContextImpl batch) {
        this.m_batchContext = batch;
    }

    public BatchContext getBatchContext() throws SQLException {
        if (this.m_batchContext == null) {
            this.m_batchContext = new BatchContextImpl((RTStatement)this);
        }
        return this.m_batchContext;
    }

    public boolean isBatchCompatible() throws SQLException {
        return true;
    }

    public boolean isBatchable() throws SQLException {
        if (this.executeViaBatch) {
            switch (this.sqlStmt.getStatementType()) {
                case 4: 
                case 8: 
                case 16: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public void setEntryInfo(EntryInfo entry) {
        this.m_entryInfo = entry;
    }

    public EntryInfo getEntryInfoObject() {
        return this.m_entryInfo;
    }
}

