/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlj.runtime.profile.ref;

import com.sap.sql.sqlj.runtime.profile.ref.ProfileRefErrors;
import com.sap.sql.sqlj.runtime.profile.ref.RTStatementJDBCBase;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import sqlj.runtime.AsciiStream;
import sqlj.runtime.BinaryStream;
import sqlj.runtime.CharacterStream;
import sqlj.runtime.SQLNullException;
import sqlj.runtime.UnicodeStream;
import sqlj.runtime.profile.RTResultSet;

public class RTResultSetJDBC
implements RTResultSet {
    protected ResultSet rs;
    private boolean m_isClosed = false;
    private boolean m_isValidRow = false;
    private RTStatementJDBCBase m_parent = null;

    public RTResultSetJDBC(ResultSet rs) {
        this.rs = rs;
    }

    RTResultSetJDBC(ResultSet rs, RTStatementJDBCBase parent) {
        this.rs = rs;
        this.m_parent = parent;
    }

    public ResultSet getJDBCResultSet() {
        return this.rs;
    }

    public boolean next() throws SQLException {
        this.m_isValidRow = this.rs.next();
        return this.m_isValidRow;
    }

    public String getCursorName() throws SQLException {
        return this.rs.getCursorName();
    }

    public int findColumn(String columnName) throws SQLException {
        return this.rs.findColumn(columnName);
    }

    public String getString(int columnIndex) throws SQLException {
        return this.rs.getString(columnIndex);
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        return this.rs.getBytes(columnIndex);
    }

    public Date getDate(int columnIndex) throws SQLException {
        return this.rs.getDate(columnIndex);
    }

    public Ref getRef(int columnIndex) throws SQLException {
        return this.rs.getRef(columnIndex);
    }

    public int getFetchSize() throws SQLException {
        return this.rs.getFetchSize();
    }

    public void setFetchSize(int fetchSize) throws SQLException {
        this.rs.setFetchSize(fetchSize);
    }

    public Time getTime(int columnIndex) throws SQLException {
        return this.rs.getTime(columnIndex);
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.rs.getTimestamp(columnIndex);
    }

    public Blob getBlob(int columnIndex) throws SQLException {
        return this.rs.getBlob(columnIndex);
    }

    public CharacterStream getCharacterStreamWrapper(int columnIndex) throws SQLException {
        Reader reader = this.rs.getCharacterStream(columnIndex);
        return reader == null || this.rs.wasNull() ? null : new CharacterStream(reader);
    }

    public Clob getClob(int columnIndex) throws SQLException {
        return this.rs.getClob(columnIndex);
    }

    public boolean getBooleanNoNull(int columnIndex) throws SQLException {
        boolean result = this.rs.getBoolean(columnIndex);
        if (this.rs.wasNull()) {
            throw new SQLNullException();
        }
        return result;
    }

    public byte getByteNoNull(int columnIndex) throws SQLException {
        byte result = this.rs.getByte(columnIndex);
        if (this.rs.wasNull()) {
            throw new SQLNullException();
        }
        return result;
    }

    public short getShortNoNull(int columnIndex) throws SQLException {
        short result = this.rs.getShort(columnIndex);
        if (this.rs.wasNull()) {
            throw new SQLNullException();
        }
        return result;
    }

    public int getIntNoNull(int columnIndex) throws SQLException {
        int result = this.rs.getInt(columnIndex);
        if (this.rs.wasNull()) {
            throw new SQLNullException();
        }
        return result;
    }

    public long getLongNoNull(int columnIndex) throws SQLException {
        long result = this.rs.getLong(columnIndex);
        if (this.rs.wasNull()) {
            throw new SQLNullException();
        }
        return result;
    }

    public float getFloatNoNull(int columnIndex) throws SQLException {
        float result = this.rs.getFloat(columnIndex);
        if (this.rs.wasNull()) {
            throw new SQLNullException();
        }
        return result;
    }

    public double getDoubleNoNull(int columnIndex) throws SQLException {
        double result = this.rs.getDouble(columnIndex);
        if (this.rs.wasNull()) {
            throw new SQLNullException();
        }
        return result;
    }

    public Boolean getBooleanWrapper(int columnIndex) throws SQLException {
        boolean tmp = this.rs.getBoolean(columnIndex);
        return this.rs.wasNull() ? null : new Boolean(tmp);
    }

    public Byte getByteWrapper(int columnIndex) throws SQLException {
        byte tmp = this.rs.getByte(columnIndex);
        return this.rs.wasNull() ? null : new Byte(tmp);
    }

    public Short getShortWrapper(int columnIndex) throws SQLException {
        short tmp = this.rs.getShort(columnIndex);
        return this.rs.wasNull() ? null : new Short(tmp);
    }

    public Integer getIntWrapper(int columnIndex) throws SQLException {
        int tmp = this.rs.getInt(columnIndex);
        return this.rs.wasNull() ? null : new Integer(tmp);
    }

    public Long getLongWrapper(int columnIndex) throws SQLException {
        long tmp = this.rs.getLong(columnIndex);
        return this.rs.wasNull() ? null : new Long(tmp);
    }

    public Float getFloatWrapper(int columnIndex) throws SQLException {
        float tmp = this.rs.getFloat(columnIndex);
        return this.rs.wasNull() ? null : new Float(tmp);
    }

    public Double getDoubleWrapper(int columnIndex) throws SQLException {
        double tmp = this.rs.getDouble(columnIndex);
        return this.rs.wasNull() ? null : new Double(tmp);
    }

    public AsciiStream getAsciiStreamWrapper(int columnIndex) throws SQLException {
        InputStream is = this.rs.getAsciiStream(columnIndex);
        return is == null || this.rs.wasNull() ? null : new AsciiStream(is);
    }

    public BinaryStream getBinaryStreamWrapper(int columnIndex) throws SQLException {
        InputStream is = this.rs.getBinaryStream(columnIndex);
        return is == null || this.rs.wasNull() ? null : new BinaryStream(is);
    }

    public UnicodeStream getUnicodeStreamWrapper(int columnIndex) throws SQLException {
        InputStream is = this.rs.getBinaryStream(columnIndex);
        return is == null || this.rs.wasNull() ? null : new UnicodeStream(is);
    }

    public Object getObject(int columnIndex, Class objectType) throws SQLException {
        Object result = this.rs.getObject(columnIndex);
        if (result == null) {
            return result;
        }
        if (!objectType.isAssignableFrom(result.getClass())) {
            ProfileRefErrors.raise_INCOMPATIBLE_TYPE(objectType, result.getClass());
        }
        return result;
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return this.rs.getBigDecimal(columnIndex);
    }

    public int getColumnCount() throws SQLException {
        return this.rs.getMetaData().getColumnCount();
    }

    public boolean isValidRow() throws SQLException {
        return this.m_isValidRow;
    }

    public boolean isClosed() throws SQLException {
        return this.m_isClosed;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void close() throws SQLException {
        if (this.m_isClosed) return;
        try {
            this.m_isClosed = true;
            this.rs.close();
            Object var2_1 = null;
            if (this.m_parent == null) return;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (this.m_parent == null) throw throwable;
            this.m_parent.notifyClosed(this);
            throw throwable;
        }
        this.m_parent.notifyClosed(this);
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.rs.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.rs.clearWarnings();
    }
}

