/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlj.runtime.profile.ref;

import com.sap.sql.sqlj.runtime.profile.ref.DynamicProfile;
import com.sap.sql.sqlj.runtime.profile.ref.DynamicProfileWrapper;
import com.sap.sql.sqlj.runtime.profile.ref.LocalStatement;
import com.sap.sql.sqlj.runtime.profile.ref.ProfileRefErrors;
import com.sap.sql.sqlj.runtime.profile.ref.RTStatementWrapper;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;
import sqlj.runtime.AsciiStream;
import sqlj.runtime.BinaryStream;
import sqlj.runtime.CharacterStream;
import sqlj.runtime.ForUpdate;
import sqlj.runtime.UnicodeStream;
import sqlj.runtime.profile.BatchContext;
import sqlj.runtime.profile.EntryInfo;
import sqlj.runtime.profile.RTStatement;

public class PositionedProfile
extends DynamicProfileWrapper {
    static final int EMPTY = 0;
    static final int BOOLEAN = 1;
    static final int BYTE = 2;
    static final int SHORT = 3;
    static final int INT = 4;
    static final int LONG = 5;
    static final int FLOAT = 6;
    static final int DOUBLE = 7;
    static final int BIGDECIMAL = 8;
    static final int STRING = 9;
    static final int BYTES = 10;
    static final int DATE = 11;
    static final int TIME = 12;
    static final int TIMESTAMP = 13;
    static final int OBJECT = 14;
    static final int ASCII = 16;
    static final int BINARY = 17;
    static final int UNICODE = 18;
    static final int CHARACTER = 19;
    static final int BOOLEAN_WRAP = 21;
    static final int BYTE_WRAP = 22;
    static final int SHORT_WRAP = 23;
    static final int INT_WRAP = 24;
    static final int LONG_WRAP = 25;
    static final int FLOAT_WRAP = 26;
    static final int DOUBLE_WRAP = 27;
    static final int BLOB = 28;
    static final int CLOB = 29;

    public PositionedProfile(DynamicProfile profile) {
        super(profile);
    }

    public RTStatement getStatement(int ndx, BatchContext batch, Map typeMap) throws SQLException {
        EntryInfo entryInfo = this.getProfileData().getEntryInfo(ndx);
        switch (entryInfo.getRole()) {
            case 6: {
                if (entryInfo.getStatementType() != 2) {
                    ProfileRefErrors.raise_EXPECTED_PREPARED_STATEMENT(entryInfo.getSQLString());
                }
                if (entryInfo.getExecuteType() != 8) {
                    ProfileRefErrors.raise_EXPECTED_EXECUTE_UPDATE(entryInfo.getSQLString());
                }
                int cursorParamNum = (Integer)entryInfo.getDescriptor();
                int cursorMarkerNdx = entryInfo.getParamInfo(cursorParamNum).getMarkerIndex();
                return new PositionedStatement(entryInfo.getSQLString(), cursorMarkerNdx, cursorParamNum, entryInfo.getParamCount());
            }
        }
        return this.baseProfile.getStatement(ndx, batch, typeMap);
    }

    public class PositionedStatement
    extends RTStatementWrapper {
        private int m_cursorMarkerNdx;
        private int m_cursorParamNum;
        private String m_origSqlText;
        private ForUpdate m_cursor = null;
        private Object[] m_params;
        private int[] m_paramTypes;
        private int m_numParams;
        private RTStatement m_dummyStmt = this.stmt;

        public PositionedStatement(String sqlText, int cursorMarkerIndex, int cursorParamNum, int numParams) {
            super(new LocalStatement());
            this.m_origSqlText = sqlText;
            this.m_cursorMarkerNdx = cursorMarkerIndex;
            this.m_cursorParamNum = cursorParamNum;
            this.m_numParams = numParams;
            this.m_params = new Object[this.m_numParams];
            this.m_paramTypes = new int[this.m_numParams];
            int i = 0;
            while (i < this.m_numParams) {
                this.m_params[i] = null;
                this.m_paramTypes[i] = 0;
                ++i;
            }
        }

        public void executeComplete() throws SQLException {
            super.executeComplete();
            this.stmt = this.m_dummyStmt;
        }

        public void setBoolean(int parameterIndex, boolean x) throws SQLException {
            this.m_paramTypes[parameterIndex - 1] = 1;
            this.m_params[parameterIndex - 1] = new Boolean(x);
        }

        public void setBooleanWrapper(int parameterIndex, Boolean x) throws SQLException {
            this.m_paramTypes[parameterIndex - 1] = 21;
            this.m_params[parameterIndex - 1] = x;
        }

        public void setByte(int parameterIndex, byte x) throws SQLException {
            this.m_paramTypes[parameterIndex - 1] = 2;
            this.m_params[parameterIndex - 1] = new Byte(x);
        }

        public void setByteWrapper(int parameterIndex, Byte x) throws SQLException {
            this.m_paramTypes[parameterIndex - 1] = 22;
            this.m_params[parameterIndex - 1] = x;
        }

        public void setShort(int parameterIndex, short x) throws SQLException {
            this.m_paramTypes[parameterIndex - 1] = 3;
            this.m_params[parameterIndex - 1] = new Short(x);
        }

        public void setShortWrapper(int parameterIndex, Short x) throws SQLException {
            this.m_paramTypes[parameterIndex - 1] = 23;
            this.m_params[parameterIndex - 1] = x;
        }

        public void setInt(int parameterIndex, int x) throws SQLException {
            this.m_paramTypes[parameterIndex - 1] = 4;
            this.m_params[parameterIndex - 1] = new Integer(x);
        }

        public void setIntWrapper(int parameterIndex, Integer x) throws SQLException {
            this.m_paramTypes[parameterIndex - 1] = 24;
            this.m_params[parameterIndex - 1] = x;
        }

        public void setLong(int parameterIndex, long x) throws SQLException {
            this.m_paramTypes[parameterIndex - 1] = 5;
            this.m_params[parameterIndex - 1] = new Long(x);
        }

        public void setLongWrapper(int parameterIndex, Long x) throws SQLException {
            this.m_paramTypes[parameterIndex - 1] = 25;
            this.m_params[parameterIndex - 1] = x;
        }

        public void setFloat(int parameterIndex, float x) throws SQLException {
            this.m_paramTypes[parameterIndex - 1] = 6;
            this.m_params[parameterIndex - 1] = new Float(x);
        }

        public void setFloatWrapper(int parameterIndex, Float x) throws SQLException {
            this.m_paramTypes[parameterIndex - 1] = 26;
            this.m_params[parameterIndex - 1] = x;
        }

        public void setDouble(int parameterIndex, double x) throws SQLException {
            this.m_paramTypes[parameterIndex - 1] = 7;
            this.m_params[parameterIndex - 1] = new Double(x);
        }

        public void setDoubleWrapper(int parameterIndex, Double x) throws SQLException {
            this.m_paramTypes[parameterIndex - 1] = 27;
            this.m_params[parameterIndex - 1] = x;
        }

        public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
            this.m_paramTypes[parameterIndex - 1] = 8;
            this.m_params[parameterIndex - 1] = x;
        }

        public void setString(int parameterIndex, String x) throws SQLException {
            this.m_paramTypes[parameterIndex - 1] = 9;
            this.m_params[parameterIndex - 1] = x;
        }

        public void setBytes(int parameterIndex, byte[] x) throws SQLException {
            this.m_paramTypes[parameterIndex - 1] = 10;
            this.m_params[parameterIndex - 1] = x;
        }

        public void setDate(int parameterIndex, Date x) throws SQLException {
            this.m_paramTypes[parameterIndex - 1] = 11;
            this.m_params[parameterIndex - 1] = x;
        }

        public void setTime(int parameterIndex, Time x) throws SQLException {
            this.m_paramTypes[parameterIndex - 1] = 12;
            this.m_params[parameterIndex - 1] = x;
        }

        public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
            this.m_paramTypes[parameterIndex - 1] = 13;
            this.m_params[parameterIndex - 1] = x;
        }

        public void setBlob(int parameterIndex, Clob x) throws SQLException {
            this.m_paramTypes[parameterIndex - 1] = 28;
            this.m_params[parameterIndex - 1] = x;
        }

        public void setClob(int parameterIndex, Clob x) throws SQLException {
            this.m_paramTypes[parameterIndex - 1] = 29;
            this.m_params[parameterIndex - 1] = x;
        }

        public void setAsciiStreamWrapper(int parameterIndex, AsciiStream x) throws SQLException {
            this.m_paramTypes[parameterIndex - 1] = 16;
            this.m_params[parameterIndex - 1] = x;
        }

        public void setCharacterStreamWrapper(int parameterIndex, CharacterStream x) throws SQLException {
            this.m_paramTypes[parameterIndex - 1] = 19;
            this.m_params[parameterIndex - 1] = x;
        }

        public void setBinaryStreamWrapper(int parameterIndex, BinaryStream x) throws SQLException {
            this.m_paramTypes[parameterIndex - 1] = 17;
            this.m_params[parameterIndex - 1] = x;
        }

        public void setUnicodeStreamWrapper(int parameterIndex, UnicodeStream x) throws SQLException {
            this.m_paramTypes[parameterIndex - 1] = 18;
            this.m_params[parameterIndex - 1] = x;
        }

        public void setObject(int ndx, Object obj) throws SQLException {
            if (ndx == this.m_cursorParamNum) {
                if (obj instanceof ForUpdate) {
                    this.m_cursor = (ForUpdate)obj;
                } else {
                    ProfileRefErrors.raise_EXPECTED_FOR_UPDATE(ndx, obj.getClass().getName());
                }
            } else {
                this.m_paramTypes[ndx - 1] = 14;
                this.m_params[ndx - 1] = obj;
            }
        }

        public int executeUpdate() throws SQLException {
            this.createStatement();
            return this.stmt.executeUpdate();
        }

        private void createStatement() throws SQLException {
            this.stmt.executeComplete();
            String sqlText = this.m_origSqlText.substring(0, this.m_cursorMarkerNdx) + " " + this.m_cursor.getCursorName() + " " + this.m_origSqlText.substring(this.m_cursorMarkerNdx + 1);
            this.stmt = PositionedProfile.this.baseDynamicProfile.prepareStatement(sqlText);
            if (this.m_dummyStmt.getMaxFieldSize() != 0) {
                this.stmt.setMaxFieldSize(this.m_dummyStmt.getMaxFieldSize());
            }
            if (this.m_dummyStmt.getMaxRows() != 0) {
                this.stmt.setMaxRows(this.m_dummyStmt.getMaxRows());
            }
            if (this.m_dummyStmt.getQueryTimeout() != 0) {
                this.stmt.setQueryTimeout(this.m_dummyStmt.getQueryTimeout());
            }
            int i = 0;
            while (i < this.m_numParams) {
                switch (this.m_paramTypes[i]) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        this.stmt.setBoolean(i + 1, ((Boolean)this.m_params[i]).booleanValue());
                        break;
                    }
                    case 21: {
                        this.stmt.setBooleanWrapper(i + 1, (Boolean)this.m_params[i]);
                        break;
                    }
                    case 2: {
                        this.stmt.setByte(i + 1, ((Byte)this.m_params[i]).byteValue());
                        break;
                    }
                    case 3: {
                        this.stmt.setShort(i + 1, ((Short)this.m_params[i]).shortValue());
                        break;
                    }
                    case 4: {
                        this.stmt.setInt(i + 1, ((Integer)this.m_params[i]).intValue());
                        break;
                    }
                    case 5: {
                        this.stmt.setLong(i + 1, ((Long)this.m_params[i]).longValue());
                        break;
                    }
                    case 6: {
                        this.stmt.setFloat(i + 1, ((Float)this.m_params[i]).floatValue());
                        break;
                    }
                    case 7: {
                        this.stmt.setDouble(i + 1, ((Double)this.m_params[i]).doubleValue());
                        break;
                    }
                    case 22: {
                        this.stmt.setByteWrapper(i + 1, (Byte)this.m_params[i]);
                        break;
                    }
                    case 23: {
                        this.stmt.setShortWrapper(i + 1, (Short)this.m_params[i]);
                        break;
                    }
                    case 24: {
                        this.stmt.setIntWrapper(i + 1, (Integer)this.m_params[i]);
                        break;
                    }
                    case 25: {
                        this.stmt.setLongWrapper(i + 1, (Long)this.m_params[i]);
                        break;
                    }
                    case 26: {
                        this.stmt.setFloatWrapper(i + 1, (Float)this.m_params[i]);
                        break;
                    }
                    case 27: {
                        this.stmt.setDoubleWrapper(i + 1, (Double)this.m_params[i]);
                        break;
                    }
                    case 8: {
                        this.stmt.setBigDecimal(i + 1, (BigDecimal)this.m_params[i]);
                        break;
                    }
                    case 9: {
                        this.stmt.setString(i + 1, (String)this.m_params[i]);
                        break;
                    }
                    case 10: {
                        this.stmt.setBytes(i + 1, (byte[])this.m_params[i]);
                        break;
                    }
                    case 11: {
                        this.stmt.setDate(i + 1, (Date)this.m_params[i]);
                        break;
                    }
                    case 12: {
                        this.stmt.setTime(i + 1, (Time)this.m_params[i]);
                        break;
                    }
                    case 13: {
                        this.stmt.setTimestamp(i + 1, (Timestamp)this.m_params[i]);
                        break;
                    }
                    case 14: {
                        this.stmt.setObject(i + 1, this.m_params[i]);
                        break;
                    }
                    case 16: {
                        this.stmt.setAsciiStreamWrapper(i + 1, (AsciiStream)this.m_params[i]);
                        break;
                    }
                    case 17: {
                        this.stmt.setBinaryStreamWrapper(i + 1, (BinaryStream)this.m_params[i]);
                        break;
                    }
                    case 18: {
                        this.stmt.setUnicodeStreamWrapper(i + 1, (UnicodeStream)this.m_params[i]);
                        break;
                    }
                    case 19: {
                        this.stmt.setCharacterStreamWrapper(i + 1, (CharacterStream)this.m_params[i]);
                        break;
                    }
                    case 28: {
                        this.stmt.setBlob(i + 1, (Blob)this.m_params[i]);
                    }
                    case 29: {
                        this.stmt.setClob(i + 1, (Clob)this.m_params[i]);
                    }
                }
                ++i;
            }
        }
    }
}

