/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlj.runtime.profile.ref;

import com.sap.sql.sqlj.runtime.profile.ref.DynamicProfile;
import com.sap.sql.sqlj.runtime.profile.ref.RTCallableStatement;
import com.sap.sql.sqlj.runtime.profile.ref.RTStatementJDBCCallable;
import com.sap.sql.sqlj.runtime.profile.ref.RTStatementJDBCPrepared;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import sqlj.runtime.profile.BatchContext;
import sqlj.runtime.profile.EntryInfo;
import sqlj.runtime.profile.ProfileData;
import sqlj.runtime.profile.RTStatement;

public class JDBCProfile
implements DynamicProfile {
    private ProfileData profileData;
    private Connection conn;

    public JDBCProfile(Connection conn, ProfileData profileData) {
        this.profileData = profileData;
        this.conn = conn;
    }

    public ProfileData getProfileData() {
        return this.profileData;
    }

    public Connection getConnection() {
        return this.conn;
    }

    private RTStatement getStatement(int ndx) throws SQLException {
        EntryInfo entry = this.profileData.getEntryInfo(ndx);
        if (entry.getStatementType() == 2) {
            return this.prepareStatement(this.getSQLString(ndx));
        }
        return this.prepareCall(this.getSQLString(ndx));
    }

    public RTStatement getStatement(int ndx, Map typeMap) throws SQLException {
        return this.getStatement(ndx);
    }

    public RTStatement getStatement(int ndx, BatchContext batch, Map typeMap) throws SQLException {
        return this.getStatement(ndx);
    }

    protected String getSQLString(int ndx) throws SQLException {
        return this.profileData.getEntryInfo(ndx).getSQLString();
    }

    public RTCallableStatement prepareCall(String sql) throws SQLException {
        return new RTStatementJDBCCallable(this.conn.prepareCall(sql));
    }

    public RTStatement prepareStatement(String sql) throws SQLException {
        return new RTStatementJDBCPrepared(this.conn.prepareStatement(sql));
    }

    public void close() throws SQLException {
    }
}

