/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.togetherxj.gsd.code.ui;

import com.togethersoft.togetherxj.gsd.code.CodeGenerator;
import com.togethersoft.togetherxj.gsd.code.MessageBodyGenerator;
import com.togethersoft.togetherxj.gsd.code.MessageCollector;
import com.togethersoft.togetherxj.gsd.code.ui.RefactoringMessages;
import com.togethersoft.togetherxj.gsd.core.sda.SdaDiagram;
import com.tssap.selena.model.util.Assert;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.CompositeChange;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.textmanipulation.SimpleTextEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.TextEdit;

public class GenerateRefactoring
extends Refactoring {
    private SdaDiagram myDiagram;
    private CodeGenerator myGenerator;

    public GenerateRefactoring(SdaDiagram sdaDiagram) {
        this.myDiagram = sdaDiagram;
    }

    public SdaDiagram getDiagram() {
        return this.myDiagram;
    }

    public RefactoringStatus checkActivation(IProgressMonitor iProgressMonitor) throws JavaModelException {
        this.myGenerator = new CodeGenerator();
        return new RefactoringStatus();
    }

    public RefactoringStatus checkInput(IProgressMonitor iProgressMonitor) throws JavaModelException {
        return this.myGenerator.checkDiagram(this.myDiagram, iProgressMonitor);
    }

    public IChange createChange(IProgressMonitor iProgressMonitor) throws JavaModelException {
        try {
            CompositeChange compositeChange = new CompositeChange(this.getCompositeChangeName());
            this.myGenerator.processDiagram(this.myDiagram);
            Iterator iterator = this.myGenerator.getSortedCompilationUnits();
            while (iterator.hasNext()) {
                ICompilationUnit iCompilationUnit = (ICompilationUnit)iterator.next();
                CompilationUnitChange compilationUnitChange = new CompilationUnitChange(this.getCUnitChangeName(iCompilationUnit), iCompilationUnit);
                Iterator iterator2 = this.myGenerator.getGenerators(iCompilationUnit);
                while (iterator2.hasNext()) {
                    this.addMethodToChange(compilationUnitChange, (MessageBodyGenerator)((Object)iterator2.next()));
                }
                compositeChange.add((IChange)compilationUnitChange);
            }
            return compositeChange;
        }
        catch (CoreException coreException) {
            throw new JavaModelException(coreException);
        }
    }

    public String getName() {
        return "$GenerateRefactoring.getName()$";
    }

    private String getCUnitChangeName(ICompilationUnit iCompilationUnit) {
        return "$GenerateRefactoring.CUnitChangeName: " + iCompilationUnit.getElementName() + "$";
    }

    private String getCompositeChangeName() {
        return "$GenerateRefactoring.getCompositeChangeName()$";
    }

    private String getTextEditName(MessageBodyGenerator messageBodyGenerator) {
        return RefactoringMessages.getTextEditName(messageBodyGenerator.getMessage());
    }

    private void addMethodToChange(CompilationUnitChange compilationUnitChange, MessageBodyGenerator messageBodyGenerator) throws JavaModelException {
        String string = messageBodyGenerator.computeSource();
        IMethod iMethod = messageBodyGenerator.getMethodForRefactoring();
        Assert.isLegal((boolean)MessageCollector.isMethodSourceAccessible(iMethod), (String)"Should be checked in MessageCollector");
        ISourceRange iSourceRange = iMethod.getNameRange();
        ISourceRange iSourceRange2 = iMethod.getSourceRange();
        String string2 = iMethod.getSource();
        int n = iSourceRange.getOffset() - iSourceRange2.getOffset() + iSourceRange.getLength();
        int n2 = string2.lastIndexOf(125);
        int n3 = string2.indexOf(123, n) + "{".length();
        SimpleTextEdit simpleTextEdit = SimpleTextEdit.createReplace((int)(iSourceRange2.getOffset() + n3), (int)(n2 - n3), (String)string);
        compilationUnitChange.addTextEdit(this.getTextEditName(messageBodyGenerator), (TextEdit)simpleTextEdit);
    }
}

