/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.togetherxj.gsd.code.blocks;

import com.togethersoft.togetherxj.gsd.code.CodeGeneratorContext;
import com.togethersoft.togetherxj.gsd.code.Messages;
import com.togethersoft.togetherxj.gsd.code.ToDo;
import com.togethersoft.togetherxj.gsd.code.blocks.CodeImplementorBase;
import com.togethersoft.togetherxj.gsd.code.blocks.SDAElementToString;
import com.togethersoft.togetherxj.gsd.core.sda.SdaElement;
import com.togethersoft.togetherxj.gsd.core.sda.SdaMessage;
import com.togethersoft.togetherxj.gsd.core.sda.SdaObject;
import com.tssap.selena.model.util.Assert;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;

public class MessageCallImplementor
extends CodeImplementorBase {
    private static final String STATIC_PREFIX = "<static>";
    private static final String UNKNOWN_SUPPLIER = "unknownSupplier";
    private CodeGeneratorContext myParentContext;

    public MessageCallImplementor(SdaMessage sdaMessage, CodeGeneratorContext codeGeneratorContext, RefactoringStatus refactoringStatus) {
        super((SdaElement)sdaMessage, refactoringStatus);
        this.myParentContext = codeGeneratorContext;
        this.checkFatalError(SDAElementToString.getMessageNumber(sdaMessage) != null, Messages.getString("MessageCallImplementor.fatal"));
        this.checkError(MessageCallImplementor.isValidJavaName(sdaMessage) && MessageCallImplementor.isValidTargetType(sdaMessage), Messages.getString("MessageCallImplementor.invalid_message", (SdaElement)sdaMessage));
    }

    private String getCommentLine() {
        SdaMessage sdaMessage = this.getMessage();
        SdaObject sdaObject = sdaMessage.getTarget();
        return Messages.getString("MessageCallImplementor.comment_line", new Object[]{SDAElementToString.getMessageNumber(sdaMessage), sdaMessage.getTarget().getName(), MessageCallImplementor.getTargetTypeName(sdaMessage)});
    }

    private String getCodeLine() {
        String string = this.getLeftSide();
        String string2 = this.getRightSide();
        return string.length() != 0 ? string + " = " + string2 + ";" : string2 + ";";
    }

    private String getLeftSide() {
        SdaMessage sdaMessage = this.getMessage();
        SdaObject sdaObject = sdaMessage.getTarget();
        if (sdaMessage.isCreation()) {
            return this.getDeclaration(sdaMessage) + this.myParentContext.addDeclaredName(sdaObject);
        }
        ToDo.todo(this.getClass(), "how to use return value");
        String string = sdaMessage.getReturn();
        return string == null ? "" : string.trim();
    }

    private String getDeclaration(SdaMessage sdaMessage) {
        SdaObject sdaObject = sdaMessage.getTarget();
        return this.myParentContext.isNameDeclared(sdaObject) ? "" : MessageCallImplementor.getTargetTypeName(sdaMessage) + " ";
    }

    private String getRightSide() {
        SdaMessage sdaMessage = this.getMessage();
        if (sdaMessage.isCreation()) {
            return this.getCreationString() + this.getParameters();
        }
        return this.getSupplierName() + "." + MessageCallImplementor.getMethodName(sdaMessage) + this.getParameters();
    }

    private String getSupplierName() {
        SdaMessage sdaMessage = this.getMessage();
        Assert.isLegal((!sdaMessage.isCreation() ? 1 : 0) != 0);
        SdaObject sdaObject = sdaMessage.getTarget();
        if (this.isStaticCall(sdaObject)) {
            return MessageCallImplementor.getTargetTypeName(sdaMessage);
        }
        if (sdaMessage.isToSuper()) {
            return "super";
        }
        if (sdaObject.equals(sdaMessage.getSource())) {
            return "this";
        }
        String string = this.myParentContext.getName(sdaObject);
        if (string != null) {
            return string;
        }
        return sdaObject.getName();
    }

    private String getCreationString() {
        SdaMessage sdaMessage = this.getMessage();
        Assert.isLegal((boolean)sdaMessage.isCreation());
        if (sdaMessage.isToSuper()) {
            return "super";
        }
        return "new " + MessageCallImplementor.getTargetTypeName(sdaMessage);
    }

    public String getBeforeLine() {
        return this.getCommentLine();
    }

    public String getAfterLine() {
        SdaMessage sdaMessage = this.getMessage();
        return MessageCallImplementor.isValidJavaName(sdaMessage) && MessageCallImplementor.isValidTargetType(sdaMessage) ? this.getCodeLine() : this.getPureTextMessageCall();
    }

    private String getPureTextMessageCall() {
        return Messages.getString("MessageCallImplementor.pure_text_message");
    }

    private SdaMessage getMessage() {
        return (SdaMessage)this.getSDAElement();
    }

    private static boolean isValidTargetType(SdaMessage sdaMessage) {
        return sdaMessage.getTarget() != null && sdaMessage.getTarget().getType() != null;
    }

    private static String getTargetTypeName(SdaMessage sdaMessage) {
        if (!MessageCallImplementor.isValidTargetType(sdaMessage)) {
            return Messages.getString("MessageCallImplementor.invalid_message_target_type");
        }
        IType iType = sdaMessage.getTarget().getType();
        return MessageCallImplementor.shouldUseQualifiedName(sdaMessage, iType) ? iType.getFullyQualifiedName() : iType.getElementName();
    }

    private static boolean shouldUseQualifiedName(SdaMessage sdaMessage, IType iType) {
        IPackageFragment iPackageFragment = (IPackageFragment)iType.getAncestor(4);
        if (iPackageFragment == null) {
            return true;
        }
        if ("java.lang".equals(iPackageFragment.getElementName())) {
            return false;
        }
        IMethod iMethod = sdaMessage.getMethod();
        if (iMethod == null) {
            return true;
        }
        IPackageFragment iPackageFragment2 = (IPackageFragment)iMethod.getAncestor(4);
        if (iPackageFragment2 == null) {
            return true;
        }
        return !iPackageFragment.getElementName().equals(iPackageFragment2.getElementName());
    }

    private static boolean isValidJavaName(SdaMessage sdaMessage) {
        if (sdaMessage.isCreation()) {
            return true;
        }
        if (sdaMessage.getMethod() != null) {
            return true;
        }
        String string = sdaMessage.getName();
        return string != null && JavaConventions.validateMethodName((String)string).getSeverity() < 4;
    }

    private static String getMethodName(SdaMessage sdaMessage) {
        Assert.isLegal((!sdaMessage.isCreation() ? 1 : 0) != 0);
        IMethod iMethod = sdaMessage.getMethod();
        if (iMethod != null) {
            return iMethod.getElementName();
        }
        return sdaMessage.getName();
    }

    private String getParameters() {
        SdaMessage sdaMessage = this.getMessage();
        String string = sdaMessage.getArguments();
        return string == null ? "()" : "(" + string + ")";
    }

    private static boolean hasReturnValue(SdaMessage sdaMessage) {
        try {
            return sdaMessage.isCreation() || !"V".equals(sdaMessage.getMethod().getReturnType());
        }
        catch (JavaModelException javaModelException) {
            javaModelException.printStackTrace();
            return false;
        }
    }

    public boolean isStaticCall(SdaObject sdaObject) {
        return sdaObject.getName().startsWith(STATIC_PREFIX);
    }
}

