/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.togetherxj.gsd.code.blocks;

import com.togethersoft.togetherxj.gsd.code.ICodeImplementor;
import com.togethersoft.togetherxj.gsd.core.sda.SdaElement;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;

public abstract class CodeImplementorBase
implements ICodeImplementor {
    private static final String UNDEFINED = "/***/undefined/***/";
    private List myChildren;
    private SdaElement mySDAElement;
    private RefactoringStatus myPreconditionStatus;

    public CodeImplementorBase(SdaElement sdaElement, RefactoringStatus refactoringStatus) {
        this.mySDAElement = sdaElement;
        this.myPreconditionStatus = refactoringStatus;
    }

    public abstract String getBeforeLine();

    public abstract String getAfterLine();

    public List getCodeLines(int n) {
        LinkedList<String> linkedList = null;
        String string = this.getBeforeLine();
        String string2 = this.getAfterLine();
        if (string != null || string2 != null || this.myChildren != null) {
            linkedList = new LinkedList<String>();
            if (string != null) {
                linkedList.add(CodeImplementorBase.getTabs(n) + string);
            }
            if (this.myChildren != null) {
                Iterator iterator = this.myChildren.iterator();
                while (iterator.hasNext()) {
                    ICodeImplementor iCodeImplementor = (ICodeImplementor)iterator.next();
                    List list = iCodeImplementor.getCodeLines(this.shouldIncreaseTabsForChildren() ? n + 1 : n);
                    if (list.isEmpty()) continue;
                    linkedList.addAll(list);
                }
            }
            if (string2 != null) {
                linkedList.add(CodeImplementorBase.getTabs(n) + string2);
            }
        }
        return linkedList == null ? Collections.EMPTY_LIST : linkedList;
    }

    protected boolean shouldIncreaseTabsForChildren() {
        return true;
    }

    public void addCodeImplementor(ICodeImplementor iCodeImplementor) {
        if (this.myChildren == null) {
            this.myChildren = new LinkedList();
        }
        this.myChildren.add(iCodeImplementor);
    }

    public SdaElement getSDAElement() {
        return this.mySDAElement;
    }

    public static final String getTabs(int n) {
        StringBuffer stringBuffer = new StringBuffer(n + 1);
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append('\t');
            ++n2;
        }
        return stringBuffer.toString();
    }

    public RefactoringStatus getPreconditionStatus() {
        return this.myPreconditionStatus;
    }

    protected final void checkError(boolean bl, String string) {
        if (!bl) {
            this.getPreconditionStatus().addError(string);
        }
    }

    protected final void checkFatalError(boolean bl, String string) {
        if (!bl) {
            this.getPreconditionStatus().addFatalError(string);
        }
    }

    protected final void checkWarning(boolean bl, String string) {
        if (!bl) {
            this.getPreconditionStatus().addWarning(string);
        }
    }

    protected static final boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    protected static String safeTrim(String string) {
        return CodeImplementorBase.isEmpty(string) ? UNDEFINED : string.trim();
    }
}

