/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.togetherxj.gsd.code;

import com.togethersoft.togetherxj.gsd.code.ui.RefactoringMessages;
import com.togethersoft.togetherxj.gsd.core.sda.SdaMessage;
import com.togethersoft.togetherxj.gsd.core.sda.SdaVisitor;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;

public class MessageCollector
extends SdaVisitor {
    private HashMap myValidMessages = new HashMap();
    private HashMap myProblemMessages = new HashMap();

    public MessageCollector() {
        this.myValidMessages = new HashMap();
        this.myProblemMessages = new HashMap();
    }

    public boolean visit(SdaMessage sdaMessage) {
        IMethod iMethod = sdaMessage.getMethod();
        if (iMethod == null) {
            this.myProblemMessages.put(sdaMessage, RefactoringMessages.getUnknownMethodWarning(sdaMessage));
            return false;
        }
        if (iMethod.isBinary()) {
            this.myProblemMessages.put(sdaMessage, RefactoringMessages.getBinaryMethodWarning(sdaMessage, iMethod));
            return false;
        }
        if (iMethod.isReadOnly() || iMethod.getResource() == null || iMethod.getResource().isReadOnly()) {
            this.myProblemMessages.put(sdaMessage, RefactoringMessages.getReadOnlyMethodWarning(sdaMessage, iMethod));
            return false;
        }
        if (!MessageCollector.isMethodSourceAccessible(iMethod)) {
            this.myProblemMessages.put(sdaMessage, RefactoringMessages.getEmptySourceWarning(sdaMessage));
            return false;
        }
        if (this.myValidMessages.containsKey(iMethod)) {
            return false;
        }
        this.myValidMessages.put(iMethod, sdaMessage);
        return true;
    }

    public SdaMessage[] getValidMessages() {
        return this.myValidMessages.values().toArray(new SdaMessage[this.myValidMessages.size()]);
    }

    public Map getProblemMessages() {
        return new HashMap(this.myProblemMessages);
    }

    public static boolean isMethodSourceAccessible(IMethod iMethod) {
        try {
            ISourceRange iSourceRange = iMethod.getNameRange();
            ISourceRange iSourceRange2 = iMethod.getSourceRange();
            String string = iMethod.getSource();
            return string != null && iSourceRange2.getOffset() <= iSourceRange.getOffset() && iSourceRange2.getLength() == string.length() && string.indexOf(123) >= 0 && string.indexOf(125) >= 0;
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }
}

