/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.togetherxj.gsd.code;

import com.togethersoft.togetherxj.gsd.code.CodeGeneratorContext;
import com.togethersoft.togetherxj.gsd.code.ICodeImplementor;
import com.togethersoft.togetherxj.gsd.code.Messages;
import com.togethersoft.togetherxj.gsd.code.ToDo;
import com.togethersoft.togetherxj.gsd.code.blocks.CatchBlockImplementor;
import com.togethersoft.togetherxj.gsd.code.blocks.DoBlockImplementor;
import com.togethersoft.togetherxj.gsd.code.blocks.ElseBlockImplementor;
import com.togethersoft.togetherxj.gsd.code.blocks.ElseIfBlockImplementor;
import com.togethersoft.togetherxj.gsd.code.blocks.FinallyBlockImplementor;
import com.togethersoft.togetherxj.gsd.code.blocks.ForBlockImplementor;
import com.togethersoft.togetherxj.gsd.code.blocks.IfBlockImplementor;
import com.togethersoft.togetherxj.gsd.code.blocks.MessageBodyImplementor;
import com.togethersoft.togetherxj.gsd.code.blocks.MessageCallImplementor;
import com.togethersoft.togetherxj.gsd.code.blocks.SwitchBlockImplementor;
import com.togethersoft.togetherxj.gsd.code.blocks.TryBlockImplementor;
import com.togethersoft.togetherxj.gsd.code.blocks.WhileBlockImplementor;
import com.togethersoft.togetherxj.gsd.core.sda.SdaCatchBlock;
import com.togethersoft.togetherxj.gsd.core.sda.SdaDoBlock;
import com.togethersoft.togetherxj.gsd.core.sda.SdaElement;
import com.togethersoft.togetherxj.gsd.core.sda.SdaElseBlock;
import com.togethersoft.togetherxj.gsd.core.sda.SdaElseIfBlock;
import com.togethersoft.togetherxj.gsd.core.sda.SdaExpressionPart;
import com.togethersoft.togetherxj.gsd.core.sda.SdaFinallyBlock;
import com.togethersoft.togetherxj.gsd.core.sda.SdaForBlock;
import com.togethersoft.togetherxj.gsd.core.sda.SdaIfBlock;
import com.togethersoft.togetherxj.gsd.core.sda.SdaMessage;
import com.togethersoft.togetherxj.gsd.core.sda.SdaSwitchBlock;
import com.togethersoft.togetherxj.gsd.core.sda.SdaTryBlock;
import com.togethersoft.togetherxj.gsd.core.sda.SdaVisitor;
import com.togethersoft.togetherxj.gsd.core.sda.SdaWhileBlock;
import com.tssap.selena.model.util.Assert;
import java.util.Iterator;
import java.util.Stack;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;

public class MessageBodyGenerator
extends SdaVisitor {
    private CodeGeneratorContext myContext;
    private SdaMessage myMessage;
    private Stack myBlockImplementors;
    private ICodeImplementor myBodyImplementor;
    private RefactoringStatus myCommonPreconditionStatus;
    private static final String EOL = System.getProperty("line.separator");
    static /* synthetic */ Class class$com$togethersoft$togetherxj$gsd$code$MessageBodyGenerator;

    public MessageBodyGenerator(SdaMessage sdaMessage, RefactoringStatus refactoringStatus) {
        this.myMessage = sdaMessage;
        this.myContext = this.createInitialContext(this.myMessage);
        this.myBlockImplementors = new Stack();
        this.myBodyImplementor = null;
        this.myCommonPreconditionStatus = refactoringStatus;
    }

    public IMethod getMethodForRefactoring() {
        return this.myMessage.getMethod();
    }

    public SdaMessage getMessage() {
        return this.myMessage;
    }

    public String computeSource() {
        Assert.isLegal((boolean)this.myBlockImplementors.isEmpty());
        Assert.isLegal((this.myBodyImplementor != null ? 1 : 0) != 0);
        StringBuffer stringBuffer = new StringBuffer(200).append(EOL);
        int n = this.getInitialIabsLevel();
        Iterator iterator = this.myBodyImplementor.getCodeLines(n).iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next()).append(EOL);
        }
        return stringBuffer.toString();
    }

    private CodeGeneratorContext createInitialContext(SdaMessage sdaMessage) {
        ToDo.todo(class$com$togethersoft$togetherxj$gsd$code$MessageBodyGenerator == null ? (class$com$togethersoft$togetherxj$gsd$code$MessageBodyGenerator = MessageBodyGenerator.class$("com.togethersoft.togetherxj.gsd.code.MessageBodyGenerator")) : class$com$togethersoft$togetherxj$gsd$code$MessageBodyGenerator, "fill static and instance fields");
        return new CodeGeneratorContext(sdaMessage);
    }

    public boolean visit(SdaMessage sdaMessage) {
        if (sdaMessage.equals(this.myMessage)) {
            this.myBodyImplementor = new MessageBodyImplementor(sdaMessage, this.myCommonPreconditionStatus);
            this.attachCodeImplementor(this.myBodyImplementor);
            Iterator iterator = sdaMessage.getChildrenList().iterator();
            while (iterator.hasNext()) {
                SdaElement sdaElement = (SdaElement)iterator.next();
                sdaElement.accept((SdaVisitor)this);
            }
        } else {
            this.attachCodeImplementor(new MessageCallImplementor(sdaMessage, this.myContext, this.myCommonPreconditionStatus));
        }
        return false;
    }

    public boolean visit(SdaExpressionPart sdaExpressionPart) {
        return false;
    }

    public boolean visit(SdaCatchBlock sdaCatchBlock) {
        CatchBlockImplementor catchBlockImplementor = new CatchBlockImplementor(sdaCatchBlock, this.myCommonPreconditionStatus);
        this.attachCodeImplementor(catchBlockImplementor);
        return true;
    }

    public boolean visit(SdaDoBlock sdaDoBlock) {
        DoBlockImplementor doBlockImplementor = new DoBlockImplementor(sdaDoBlock, this.myCommonPreconditionStatus);
        this.attachCodeImplementor(doBlockImplementor);
        return true;
    }

    public boolean visit(SdaElseBlock sdaElseBlock) {
        ElseBlockImplementor elseBlockImplementor = new ElseBlockImplementor(sdaElseBlock, this.myCommonPreconditionStatus);
        this.attachCodeImplementor(elseBlockImplementor);
        return true;
    }

    public boolean visit(SdaElseIfBlock sdaElseIfBlock) {
        ElseIfBlockImplementor elseIfBlockImplementor = new ElseIfBlockImplementor(sdaElseIfBlock, this.myCommonPreconditionStatus);
        this.attachCodeImplementor(elseIfBlockImplementor);
        return true;
    }

    public boolean visit(SdaFinallyBlock sdaFinallyBlock) {
        FinallyBlockImplementor finallyBlockImplementor = new FinallyBlockImplementor(sdaFinallyBlock, this.myCommonPreconditionStatus);
        this.attachCodeImplementor(finallyBlockImplementor);
        return true;
    }

    public boolean visit(SdaForBlock sdaForBlock) {
        ForBlockImplementor forBlockImplementor = new ForBlockImplementor(sdaForBlock, this.myCommonPreconditionStatus);
        this.attachCodeImplementor(forBlockImplementor);
        return true;
    }

    public boolean visit(SdaIfBlock sdaIfBlock) {
        IfBlockImplementor ifBlockImplementor = new IfBlockImplementor(sdaIfBlock, this.myCommonPreconditionStatus);
        this.attachCodeImplementor(ifBlockImplementor);
        return true;
    }

    public boolean visit(SdaSwitchBlock sdaSwitchBlock) {
        SwitchBlockImplementor switchBlockImplementor = new SwitchBlockImplementor(sdaSwitchBlock, this.myCommonPreconditionStatus);
        this.attachCodeImplementor(switchBlockImplementor);
        return true;
    }

    public boolean visit(SdaTryBlock sdaTryBlock) {
        TryBlockImplementor tryBlockImplementor = new TryBlockImplementor(sdaTryBlock, this.myCommonPreconditionStatus);
        this.attachCodeImplementor(tryBlockImplementor);
        return true;
    }

    public boolean visit(SdaWhileBlock sdaWhileBlock) {
        WhileBlockImplementor whileBlockImplementor = new WhileBlockImplementor(sdaWhileBlock, this.myCommonPreconditionStatus);
        this.attachCodeImplementor(whileBlockImplementor);
        return true;
    }

    public void endVisit(SdaExpressionPart sdaExpressionPart) {
    }

    public void endVisit(SdaCatchBlock sdaCatchBlock) {
        this.commonEndVisit((SdaElement)sdaCatchBlock);
    }

    public void endVisit(SdaDoBlock sdaDoBlock) {
        this.commonEndVisit((SdaElement)sdaDoBlock);
    }

    public void endVisit(SdaElseBlock sdaElseBlock) {
        this.commonEndVisit((SdaElement)sdaElseBlock);
    }

    public void endVisit(SdaElseIfBlock sdaElseIfBlock) {
        this.commonEndVisit((SdaElement)sdaElseIfBlock);
    }

    public void endVisit(SdaFinallyBlock sdaFinallyBlock) {
        this.commonEndVisit((SdaElement)sdaFinallyBlock);
    }

    public void endVisit(SdaForBlock sdaForBlock) {
        this.commonEndVisit((SdaElement)sdaForBlock);
    }

    public void endVisit(SdaIfBlock sdaIfBlock) {
        this.commonEndVisit((SdaElement)sdaIfBlock);
    }

    public void endVisit(SdaSwitchBlock sdaSwitchBlock) {
        this.commonEndVisit((SdaElement)sdaSwitchBlock);
    }

    public void endVisit(SdaTryBlock sdaTryBlock) {
        this.commonEndVisit((SdaElement)sdaTryBlock);
    }

    public void endVisit(SdaWhileBlock sdaWhileBlock) {
        this.commonEndVisit((SdaElement)sdaWhileBlock);
    }

    public void endVisit(SdaMessage sdaMessage) {
        this.commonEndVisit((SdaElement)sdaMessage);
    }

    private void attachCodeImplementor(ICodeImplementor iCodeImplementor) {
        if (!this.myBlockImplementors.isEmpty()) {
            ICodeImplementor iCodeImplementor2 = (ICodeImplementor)this.myBlockImplementors.peek();
            iCodeImplementor2.addCodeImplementor(iCodeImplementor);
        }
        this.myBlockImplementors.push(iCodeImplementor);
    }

    private void commonEndVisit(SdaElement sdaElement) {
        Assert.isLegal((!this.myBlockImplementors.isEmpty() ? 1 : 0) != 0);
        ICodeImplementor iCodeImplementor = (ICodeImplementor)this.myBlockImplementors.pop();
    }

    private int getInitialIabsLevel() {
        IMethod iMethod = this.myMessage.getMethod();
        int n = 0;
        while (iMethod != null) {
            if (iMethod.getElementType() == 5) {
                return n;
            }
            ++n;
            iMethod = iMethod.getParent();
        }
        ToDo.todo(((Object)((Object)this)).getClass(), "provide 1 as default value");
        return 3;
    }

    private void checkMethodSourceAccessible() {
        IMethod iMethod = this.getMethodForRefactoring();
        try {
            ISourceRange iSourceRange = iMethod.getNameRange();
            ISourceRange iSourceRange2 = iMethod.getSourceRange();
            String string = iMethod.getSource();
            if (string == null || iSourceRange2.getOffset() > iSourceRange.getOffset() || iSourceRange2.getLength() == string.length()) {
                this.myCommonPreconditionStatus.addFatalError(Messages.getString("MessageBodyGenerator.body_not_accessible", (SdaElement)this.myMessage));
                return;
            }
            if (string.indexOf(123) < 0 || string.indexOf(125) < 0) {
                this.myCommonPreconditionStatus.addFatalError(Messages.getString("MessageBodyGenerator.body_is_empty", (SdaElement)this.myMessage));
            }
        }
        catch (JavaModelException javaModelException) {
            this.myCommonPreconditionStatus.addFatalError(Messages.getString("MessageBodyGenerator.body_not_accessible", (SdaElement)this.myMessage));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

