/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.togetherxj.gsd.code;

import com.togethersoft.togetherxj.gsd.code.blocks.VariableNameFactory;
import com.togethersoft.togetherxj.gsd.core.sda.SdaMessage;
import com.togethersoft.togetherxj.gsd.core.sda.SdaObject;
import com.tssap.selena.model.util.Assert;
import java.util.AbstractList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;

public class CodeGeneratorContext {
    private SdaMessage myInitialMessage;
    private Stack myDeclaredNameMaps;

    public CodeGeneratorContext(SdaMessage sdaMessage) {
        this.myInitialMessage = sdaMessage;
        this.myDeclaredNameMaps = new Stack();
        this.initGlobalNames();
    }

    public String getName(SdaObject sdaObject) {
        if (this.myDeclaredNameMaps.isEmpty()) {
            return null;
        }
        String string = null;
        int n = this.myDeclaredNameMaps.size();
        while (string == null && n > 0) {
            HashMap hashMap = (HashMap)this.myDeclaredNameMaps.elementAt(n - 1);
            string = (String)hashMap.get(sdaObject);
            --n;
        }
        return string;
    }

    public boolean isNameDeclared(SdaObject sdaObject) {
        return this.getName(sdaObject) != null;
    }

    public String addDeclaredName(SdaObject sdaObject) {
        Assert.isLegal((!this.myDeclaredNameMaps.isEmpty() ? 1 : 0) != 0);
        String string = this.getName(sdaObject);
        if (string != null) {
            return string;
        }
        String string2 = this.findNotUsedName(VariableNameFactory.getInstance().getVariableNameBase(sdaObject), true);
        Map map = (Map)this.myDeclaredNameMaps.peek();
        map.put(sdaObject, string2);
        return string2;
    }

    private String findNotUsedName(String string, boolean bl) {
        Object object;
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = ((AbstractList)this.myDeclaredNameMaps).iterator();
        while (iterator.hasNext()) {
            Map map = (Map)iterator.next();
            object = map.values().iterator();
            while (object.hasNext()) {
                String string2 = (String)object.next();
                if (!string2.startsWith(string)) continue;
                hashSet.add(string2);
            }
        }
        int n = bl ? 0 : 1;
        while (true) {
            Object object2 = object = n == 0 ? string : string + n;
            if (!hashSet.contains(object)) {
                return object;
            }
            ++n;
        }
    }

    public void blockStarted() {
        HashMap hashMap = new HashMap();
        this.myDeclaredNameMaps.push(hashMap);
    }

    public void blockFinished() {
        Assert.isLegal((!this.myDeclaredNameMaps.isEmpty() ? 1 : 0) != 0);
        HashMap hashMap = (HashMap)this.myDeclaredNameMaps.pop();
        hashMap.clear();
    }

    private void initGlobalNames() {
        HashMap hashMap = new HashMap();
        this.myDeclaredNameMaps.add(hashMap);
    }
}

